/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.Selectable;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.axes.CartesianInteractive;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolPropsTable;
import org.opensourcephysics.tools.DataToolStatsTable;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DataToolTab
extends JPanel
implements Tool,
PropertyChangeListener {
    static Color[] colors = new Color[]{Color.green.darker(), Color.red, Color.cyan.darker(), Color.yellow.darker(), Color.blue};
    protected static String helpName = "data_tool_help.html";
    protected DataTool dataTool;
    protected Data owner;
    protected DatasetManager dataManager = new DatasetManager();
    protected JSplitPane[] splitPanes;
    protected DataToolPlotter plot;
    protected DataToolTable dataTable;
    protected DataToolStatsTable statsTable;
    protected DataToolPropsTable propsTable;
    protected JScrollPane statsScroller;
    protected JScrollPane propsScroller;
    protected JToolBar toolbar;
    protected JCheckBox statsCheckbox;
    protected JCheckBox bottomPaneCheckbox;
    protected JCheckBox propsCheckbox;
    protected DatasetCurveFitter curveFitter;
    protected JButton dataBuilderButton;
    protected JButton newColumnButton;
    protected JButton refreshDataButton;
    protected JCheckBox valueCheckbox;
    protected JCheckBox slopeCheckbox;
    protected JCheckBox areaCheckbox;
    protected Action bottomPaneAction;
    protected Action propsAndStatsAction;
    protected String fileName;
    protected JButton helpButton;
    protected int colorIndex;
    protected boolean tabChanged;
    protected boolean userEditable;
    protected UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    protected FunctionTool dataBuilder;
    protected int fontLevel = FontSizer.getLevel();
    protected JobManager jobManager = new JobManager(this);
    protected JLabel statusLabel;
    protected CartesianInteractive plotAxes;
    protected boolean positionVisible = false;
    protected boolean slopeVisible = false;
    protected boolean areaVisible = false;
    protected JPopupMenu varPopup;
    protected boolean isHorzVarPopup;
    protected Action setVarAction;

    public DataToolTab(Data data) {
        this.dataTable = new DataToolTable(this);
        this.createGUI();
        String string = ToolsRes.getString("DataToolTab.DefaultName");
        if (data != null) {
            try {
                Method method = data.getClass().getMethod("getName", new Class[0]);
                String string2 = (String)method.invoke((Object)data, new Object[0]);
                if (string2 != null && !string2.equals("")) {
                    string = string2;
                }
            }
            catch (Exception exception) {}
        }
        this.setName(string);
        this.addData(data);
        this.tabChanged(false);
    }

    public boolean addData(Data data) {
        if (data == null) {
            return false;
        }
        boolean bl = false;
        ArrayList<Dataset> arrayList = data.getDatasets();
        if (arrayList != null && arrayList.size() > 0) {
            Dataset dataset = arrayList.get(0);
            int n = dataset.getXPoints().length;
            double[] dArray = DataTool.getRowArray(n);
            if (this.dataManager.getDatasets().isEmpty()) {
                this.owner = data;
                for (final Dataset dataset2 : arrayList) {
                    Object object;
                    if (dataset2 == null) continue;
                    double[] dArray2 = dataset2.getXPoints();
                    double[] dArray3 = dataset2.getYPoints();
                    XMLControlElement xMLControlElement = new XMLControlElement(dataset2);
                    if (this.dataManager.getDatasets().isEmpty()) {
                        object = new HighlightableDataset();
                        xMLControlElement.loadObject(object, true, true);
                        ((Dataset)object).clear();
                        if (!dataset2.getXColumnName().equals(DataTable.rowName)) {
                            ((Dataset)object).setXYColumnNames(DataTable.rowName, dataset2.getXColumnName());
                            ((Dataset)object).append(dArray, dArray2);
                            ((Dataset)object).setID(-((Dataset)object).getID());
                        } else {
                            ((Dataset)object).setXYColumnNames(DataTable.rowName, dataset2.getYColumnName());
                            ((Dataset)object).append(dArray, dArray3);
                        }
                        ((Dataset)object).setXColumnVisible(false);
                        this.dataManager.addDataset((Dataset)object);
                    }
                    if (this.isDuplicateColumn(dataset2.getXColumnName(), dArray2) && !this.isDuplicateColumn(dataset2.getYColumnName(), dArray3)) {
                        object = new HighlightableDataset();
                        xMLControlElement.loadObject(object, true, true);
                        ((Dataset)object).setXYColumnNames(DataTable.rowName, dataset2.getYColumnName());
                        ((Dataset)object).clear();
                        ((Dataset)object).append(dArray, dArray3);
                        ((Dataset)object).setXColumnVisible(false);
                        this.dataManager.addDataset((Dataset)object);
                        continue;
                    }
                    if (this.isDuplicateColumn(dataset2.getXColumnName(), dArray2) || this.isDuplicateColumn(dataset2.getYColumnName(), dataset2.getYPoints())) continue;
                    if (this.dataTool != null) {
                        object = new Runnable(){

                            public synchronized void run() {
                                DataToolTab dataToolTab = DataTool.createTab(dataset2, dataset2.getName());
                                DataToolTab.this.dataTool.addTab(dataToolTab);
                            }
                        };
                        SwingUtilities.invokeLater((Runnable)object);
                        continue;
                    }
                    object = ToolsRes.getString("DataToolTab.Dialog.NoMatch.Message");
                    object = String.valueOf(object) + "\"" + dataset2.getXColumnName() + "\", \"";
                    object = String.valueOf(object) + dataset2.getXColumnName() + "\"";
                    JOptionPane.showMessageDialog(this, object);
                    return false;
                }
                bl = true;
            } else {
                for (Dataset dataset3 : arrayList) {
                    String string = null;
                    if (this.isDuplicateColumn(dataset3.getXColumnName(), dataset3.getXPoints()) && !this.isDuplicateColumn(dataset3.getYColumnName(), dataset3.getYPoints())) {
                        string = "y";
                    } else if (this.isDuplicateColumn(dataset3.getYColumnName(), dataset3.getYPoints()) && !this.isDuplicateColumn(dataset3.getXColumnName(), dataset3.getXPoints())) {
                        string = "x";
                    }
                    if (string == null) continue;
                    HighlightableDataset highlightableDataset = new HighlightableDataset();
                    XMLControlElement xMLControlElement = new XMLControlElement(dataset3);
                    xMLControlElement.loadObject(highlightableDataset, true, true);
                    double[] dArray4 = string.equals("x") ? dataset3.getXPoints() : dataset3.getYPoints();
                    highlightableDataset.setXColumnVisible(false);
                    ((Dataset)highlightableDataset).clear();
                    ((Dataset)highlightableDataset).append(dArray, dArray4);
                    String string2 = string.equals("x") ? dataset3.getXColumnName() : dataset3.getYColumnName();
                    string2 = this.getUniqueYColumnName(highlightableDataset, string2, false);
                    highlightableDataset.setXYColumnNames(DataTable.rowName, string2);
                    if (string.equals("x")) {
                        highlightableDataset.setID(-highlightableDataset.getID());
                    }
                    this.dataManager.addDataset(highlightableDataset);
                    this.dataTable.getWorkingData(string2);
                    bl = true;
                }
            }
            this.dataTable.refreshTable();
            this.statsTable.refreshStatistics();
            this.refreshGUI();
            this.refreshPlot();
        }
        if (bl) {
            this.tabChanged(true);
            this.varPopup = null;
        }
        return bl;
    }

    public void setXYColumns(String string, String string2) {
        this.dataTable.setWorkingColumns(string, string2);
    }

    public void setConnected(String string, boolean bl) {
        DataToolTable.WorkingDataset workingDataset = this.dataTable.workingMap.get(string);
        if (workingDataset != null) {
            workingDataset.setConnected(bl);
        }
    }

    public void setMarkersVisible(String string, boolean bl) {
        DataToolTable.WorkingDataset workingDataset = this.dataTable.workingMap.get(string);
        if (workingDataset != null) {
            workingDataset.setMarkersVisible(bl);
        }
    }

    public void setName(String string) {
        string = this.replaceSpacesWithUnderscores(string);
        super.setName(string);
        this.curveFitter.setDataSourceName(string);
    }

    public void setUserEditable(boolean bl) {
        if (this.userEditable == bl) {
            return;
        }
        this.userEditable = bl;
        this.refreshGUI();
    }

    public FunctionTool getDataBuilder() {
        if (this.dataTool != null) {
            return this.dataTool.getDataBuilder();
        }
        if (this.dataBuilder == null) {
            this.dataBuilder = new FunctionTool(this);
            this.dataBuilder.setFontLevel(this.fontLevel);
            this.dataBuilder.setHelpPath("data_builder_help.html");
            this.dataBuilder.addPropertyChangeListener("function", this);
            this.dataBuilder.setTitle(ToolsRes.getString("DataTool.DataBuilder.Title"));
        }
        this.refreshDataBuilder();
        return this.dataBuilder;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("function")) {
            String string2;
            this.tabChanged(true);
            this.dataTable.refreshTable();
            this.statsTable.refreshStatistics();
            if (propertyChangeEvent.getNewValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getNewValue().toString();
                this.dataTable.getWorkingData(string2);
            }
            if (propertyChangeEvent.getOldValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getOldValue().toString();
                this.dataTable.removeWorkingData(string2);
            }
            if (propertyChangeEvent.getNewValue() instanceof String) {
                string2 = propertyChangeEvent.getNewValue().toString();
                if (propertyChangeEvent.getOldValue() instanceof String) {
                    String string3 = propertyChangeEvent.getOldValue().toString();
                    this.columnNameChanged(string3, string2);
                } else {
                    this.dataTable.getWorkingData(string2);
                }
            }
            this.refreshPlot();
            this.varPopup = null;
        }
    }

    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || xMLControlElement.getObjectClass() == Object.class) {
            return;
        }
        this.jobManager.log(job, tool);
        if (Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            Data data = (Data)xMLControlElement.loadObject(null, true, true);
            if (this.isOwnedBy(data)) {
                this.reloadData(data);
                this.jobManager.associate(job, this.dataManager);
                this.refreshGUI();
            } else if (this.addData(data)) {
                this.jobManager.associate(job, this.dataManager);
                this.refreshGUI();
            }
        } else if (DataToolTab.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            xMLControlElement.loadObject(this);
            this.refreshGUI();
        }
    }

    protected String replaceSpacesWithUnderscores(String string) {
        string.trim();
        int n = string.indexOf(" ");
        while (n > -1) {
            string = String.valueOf(string.substring(0, n)) + "_" + string.substring(n + 1);
            n = string.indexOf(" ");
        }
        return string;
    }

    protected void refreshDataBuilder() {
        if (this.dataTool != null) {
            this.dataTool.refreshDataBuilder();
            return;
        }
        if (this.dataBuilder == null) {
            return;
        }
        if (this.dataBuilder.getPanel(this.getName()) == null) {
            DataFunctionPanel object = new DataFunctionPanel(this.dataManager);
            this.dataBuilder.addPanel(this.getName(), object);
        }
        for (String string : this.dataBuilder.panels.keySet()) {
            if (string.equals(this.getName())) continue;
            this.dataBuilder.removePanel(string);
        }
    }

    protected void setFontLevel(int n) {
        this.fontLevel = n;
        this.plot.setFontLevel(n);
        FontSizer.setFonts(this.statsTable, n);
        FontSizer.setFonts(this.propsTable, n);
        this.curveFitter.setFontLevel(n);
        double d = FontSizer.getFactor(n);
        this.plot.getAxes().resizeFonts(d, this.plot);
        FontSizer.setFonts(this.plot.getPopupMenu(), n);
        if (this.propsTable.styleDialog != null) {
            FontSizer.setFonts(this.propsTable.styleDialog, n);
            this.propsTable.styleDialog.pack();
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.setFontLevel(this.fontLevel);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                DataToolTab.this.bottomPaneAction.actionPerformed(null);
                DataToolTab.this.propsAndStatsAction.actionPerformed(null);
                DataToolTab.this.propsTable.refreshTable();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void tabChanged(boolean bl) {
        this.tabChanged = bl;
    }

    protected DataToolTable.WorkingDataset getWorkingData() {
        this.dataTable.getSelectedData();
        return this.dataTable.workingData;
    }

    protected Data getOwner() {
        return this.owner;
    }

    protected String getUniqueYColumnName(Dataset dataset, String string, boolean bl) {
        int n;
        if (string == null) {
            return null;
        }
        string = string.replaceAll(" ", "");
        if (bl) {
            n = 0;
            int n2 = 2;
            while (n < n2) {
                ++n;
                if (this.isDuplicateName(dataset, string)) {
                    string = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Message"), ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Title"), 2);
                }
                if (string == null || string.equals("")) {
                    return null;
                }
                if (this.isReservedName(string)) {
                    string = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("DataToolTab.Dialog.ReservedName.Message"), ToolsRes.getString("DataToolTab.Dialog.ReservedName.Title"), 2);
                }
                if (string != null && !string.equals("")) continue;
                return null;
            }
        }
        n = 0;
        try {
            Double.parseDouble(string);
            string = ToolsRes.getString("DataToolTab.NewColumn.Name");
        }
        catch (NumberFormatException numberFormatException) {}
        String string2 = string;
        while (this.isDuplicateName(dataset, string2) || this.isReservedName(string2)) {
            string2 = String.valueOf(string) + "_" + ++n;
        }
        return string2;
    }

    protected boolean isDuplicateName(Dataset dataset, String string) {
        if (this.dataManager.getDatasets().isEmpty()) {
            return false;
        }
        if (this.dataManager.getDataset(0).getXColumnName().equals(string)) {
            return true;
        }
        string = TeXParser.removeSubscripting(string);
        for (Dataset dataset2 : this.dataManager.getDatasets()) {
            String string2;
            if (dataset2 == dataset || !(string2 = TeXParser.removeSubscripting(dataset2.getYColumnName())).equals(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isReservedName(String string) {
        String[] stringArray = FunctionTool.parserNames;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        stringArray = UserFunction.dummyVars;
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected void columnNameChanged(String string, String string2) {
        Object object;
        this.tabChanged(true);
        this.varPopup = null;
        String string3 = this.dataTable.getFormatPattern(string);
        this.dataTable.removeWorkingData(string);
        this.dataTable.getWorkingData(string2);
        this.dataTable.setFormatPattern(string2, string3);
        if (this.propsTable.styleDialog != null && this.propsTable.styleDialog.isVisible() && this.propsTable.styleDialog.getName().equals(string)) {
            this.propsTable.styleDialog.setName(string2);
            object = ToolsRes.getString("DataToolPropsTable.Dialog.Title");
            String string4 = TeXParser.removeSubscripting(string2);
            this.propsTable.styleDialog.setTitle(String.valueOf(object) + " \"" + string4 + "\"");
        }
        this.statsTable.refreshStatistics();
        object = this.getWorkingData();
        if (object == null) {
            return;
        }
        this.refreshPlot();
    }

    protected boolean reloadData(Data data) {
        Object object;
        ArrayList<Dataset> arrayList = this.dataManager.getDatasets();
        if (arrayList != null && !arrayList.isEmpty()) {
            for (Dataset object2 : arrayList) {
                Dataset dataset = this.getMatchingID(object2, data);
                if (dataset == null || dataset == object2) continue;
                object2.clear();
                object2.setName(dataset.getName());
                object = DataTool.getRowArray(dataset.getIndex());
                if (dataset.getXColumnName().equals(object2.getYColumnName())) {
                    object2.append((double[])object, dataset.getXPoints());
                    continue;
                }
                object2.append((double[])object, dataset.getYPoints());
            }
        }
        arrayList = data.getDatasets();
        boolean bl = false;
        if (arrayList != null) {
            for (Dataset dataset : arrayList) {
                DataToolTab dataToolTab;
                object = this.getMatchingID(dataset, this.dataManager);
                if (object != null) continue;
                DataToolTab dataToolTab2 = dataToolTab = this.dataTool == null ? null : this.dataTool.getTab(dataset);
                if (dataToolTab != null && dataToolTab != this) {
                    this.dataTool.update(dataset);
                    continue;
                }
                boolean bl2 = bl = this.addData(dataset) || bl;
            }
        }
        for (Dataset dataset : this.dataManager.getDatasets()) {
            if (dataset instanceof DataFunction) {
                ((DataFunction)dataset).refreshFunctionData();
                continue;
            }
            this.pad(dataset);
        }
        this.dataTable.trimEmptyRows(0);
        this.refreshPlot();
        this.dataTable.refreshTable();
        this.statsTable.refreshStatistics();
        if (bl) {
            this.varPopup = null;
        }
        return bl;
    }

    protected void pad(Dataset dataset) {
        int n = this.dataTable.getRowCount();
        if (dataset instanceof DataFunction) {
            return;
        }
        double[] dArray = dataset.getYPoints();
        if (n > dArray.length) {
            double[] dArray2 = new double[n];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            int n2 = dArray.length;
            while (n2 < n) {
                dArray2[n2] = Double.NaN;
                ++n2;
            }
            double[] dArray3 = DataTool.getRowArray(n);
            dataset.clear();
            dataset.append(dArray3, dArray2);
        }
    }

    protected Dataset createDataset() {
        this.colorIndex %= colors.length;
        Color color = colors[this.colorIndex++];
        Color color2 = color.darker();
        HighlightableDataset highlightableDataset = new HighlightableDataset(color, color2, false);
        int n = Math.max(1, this.dataTable.getRowCount());
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = n2;
            dArray2[n2] = Double.NaN;
            ++n2;
        }
        ((Dataset)highlightableDataset).append(dArray, dArray2);
        highlightableDataset.setXColumnVisible(false);
        return highlightableDataset;
    }

    protected Dataset copy(Dataset dataset, Dataset dataset2, boolean bl) {
        Object object;
        Object object2;
        if (dataset2 == null) {
            dataset2 = new Dataset();
        }
        if (bl) {
            dataset2.clear();
            object2 = dataset.getXPoints();
            object = dataset.getYPoints();
            dataset2.append((double[])object2, (double[])object);
            dataset2.setID(dataset.getID());
        }
        dataset2.setName(dataset.getName());
        dataset2.setXYColumnNames(dataset.getXColumnName(), dataset.getYColumnName());
        dataset2.setMarkerShape(dataset.getMarkerShape());
        dataset2.setMarkerSize(dataset.getMarkerSize());
        object2 = dataset.getFillColor();
        object = dataset.getEdgeColor();
        dataset2.setMarkerColor((Color)object2, (Color)object);
        dataset2.setLineColor(dataset.getLineColor());
        dataset2.setConnected(dataset.isConnected());
        return dataset2;
    }

    protected String saveTableDataToFile() {
        String string = this.getName();
        OSPLog.finest("saving tabe data from " + string);
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        jFileChooser.setSelectedFile(new File(String.valueOf(string) + ".txt"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            string2 = XML.getRelativePath(string2);
            String string3 = this.getSelectedTableData();
            return DataTool.write(string3, string2);
        }
        return null;
    }

    protected void copyTableDataToClipboard() {
        OSPLog.finest("copying table data from " + this.getName());
        DataTool.copy(this.getSelectedTableData());
    }

    protected String getSelectedTableData() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getName() != null) {
            stringBuffer.append(String.valueOf(this.getName()) + "\n");
        }
        if (this.dataTable.getColumnCount() == 1 || this.dataTable.getRowCount() == 0) {
            return stringBuffer.toString();
        }
        this.dataTable.clearSelectionIfEmptyEndRow();
        int[] nArray = this.dataTable.getSelectedRows();
        if (nArray.length == 0) {
            this.dataTable.selectAll();
            nArray = this.dataTable.getSelectedRows();
        }
        int[] nArray2 = this.dataTable.getSelectedColumns();
        int n3 = 0;
        while (n3 < nArray2.length) {
            n2 = nArray2[n3];
            n = this.dataTable.convertColumnIndexToModel(n2);
            if (!this.dataTable.isRowNumberVisible() || n != 0) {
                stringBuffer.append(this.dataTable.getColumnName(n2));
                stringBuffer.append("\t");
            }
            ++n3;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append("\n");
        DateFormat dateFormat = DateFormat.getInstance();
        n2 = 0;
        while (n2 < nArray.length) {
            n = 0;
            while (n < nArray2.length) {
                int n4 = nArray2[n];
                int n5 = this.dataTable.convertColumnIndexToModel(n4);
                if (!this.dataTable.isRowNumberVisible() || n5 != 0) {
                    Object object = this.dataTable.getValueAt(nArray[n2], n4);
                    if (object != null) {
                        if (object instanceof Date) {
                            object = dateFormat.format(object);
                        }
                        stringBuffer.append(object);
                    }
                    stringBuffer.append("\t");
                }
                ++n;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void createGUI() {
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataToolTab.this.refreshGUI();
            }
        });
        this.setLayout(new BorderLayout());
        this.splitPanes = new JSplitPane[3];
        this.splitPanes[0] = new JSplitPane(1);
        this.splitPanes[0].setResizeWeight(1.0);
        this.splitPanes[0].setOneTouchExpandable(true);
        this.splitPanes[1] = new JSplitPane(0);
        this.splitPanes[1].setResizeWeight(1.0);
        this.splitPanes[1].setDividerSize(0);
        this.splitPanes[2] = new JSplitPane(0);
        this.splitPanes[2].setDividerSize(0);
        this.splitPanes[2].setEnabled(false);
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (DataToolTab.this.getSize().width > 0) {
                    DataToolTab.this.init();
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DataToolTab.this.bottomPaneAction.actionPerformed(null);
            }
        });
        this.dataTable.setRowNumberVisible(true);
        JScrollPane jScrollPane = new JScrollPane(this.dataTable);
        this.dataTable.refreshTable();
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                DataToolTable.WorkingDataset workingDataset = DataToolTab.this.dataTable.workingData;
                DataToolTable.WorkingDataset workingDataset2 = DataToolTab.this.getWorkingData();
                if (workingDataset2 != workingDataset) {
                    DataToolTab.this.tabChanged(true);
                    String string = workingDataset2.getXColumnName();
                    if (DataToolTab.this.curveFitter.fitBuilder != null) {
                        Iterator<String> iterator = DataToolTab.this.curveFitter.fitBuilder.getPanelNames().iterator();
                        while (iterator.hasNext()) {
                            FunctionPanel functionPanel = DataToolTab.this.curveFitter.fitBuilder.getPanel(iterator.next().toString());
                            UserFunctionEditor userFunctionEditor = (UserFunctionEditor)functionPanel.getFunctionEditor();
                            userFunctionEditor.setDefaultVariables(new String[]{string});
                            userFunctionEditor.repaint();
                        }
                    }
                }
                if (workingDataset2 == null || workingDataset2 == workingDataset) {
                    return;
                }
                DataToolTab.this.plot.selectionBox.setSize(0, 0);
                DataToolTab.this.refreshPlot();
            }
        });
        ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                try {
                    DataToolTab.this.curveFitter.setData(DataToolTab.this.dataTable.getSelectedData());
                }
                catch (Exception exception) {}
            }
        });
        this.bottomPaneAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.bottomPaneCheckbox == null) {
                    return;
                }
                DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[2].getDividerSize());
                DataToolTab.this.splitPanes[1].setDividerLocation(1.0);
                DataToolTab.this.splitPanes[1].remove(DataToolTab.this.curveFitter);
                DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                boolean bl = DataToolTab.this.bottomPaneCheckbox.isSelected();
                DataToolTab.this.splitPanes[1].setEnabled(bl);
                if (bl) {
                    DataToolTab.this.splitPanes[1].setBottomComponent(DataToolTab.this.curveFitter);
                    DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[0].getDividerSize());
                    DataToolTab.this.splitPanes[1].setDividerLocation(-1);
                    DataToolTab.this.plot.addDrawable(DataToolTab.this.curveFitter.getDrawer());
                }
                if (actionEvent != null) {
                    DataToolTab.this.refreshPlot();
                }
            }
        };
        this.bottomPaneCheckbox = new JCheckBox();
        this.bottomPaneCheckbox.setSelected(false);
        this.bottomPaneCheckbox.setOpaque(false);
        this.bottomPaneCheckbox.addActionListener(this.bottomPaneAction);
        this.newColumnButton = DataTool.createButton("");
        this.newColumnButton.addActionListener(new ActionListener(){

            public void actionPerformed(final ActionEvent actionEvent) {
                Dataset dataset = DataToolTab.this.createDataset();
                String string = ToolsRes.getString("DataToolTab.NewColumn.Name");
                string = DataToolTab.this.getUniqueYColumnName(dataset, string, false);
                Object object = JOptionPane.showInputDialog(DataToolTab.this, ToolsRes.getString("DataToolTab.Dialog.NameColumn.Message"), ToolsRes.getString("DataToolTab.Dialog.NameColumn.Title"), 3, null, null, string);
                if (object == null) {
                    return;
                }
                String string2 = DataToolTab.this.getUniqueYColumnName(dataset, object.toString(), true);
                if (string2 == null) {
                    return;
                }
                if (string2.equals("")) {
                    String string3 = ToolsRes.getString("DataToolTab.NewColumn.Name");
                    string2 = DataToolTab.this.getUniqueYColumnName(dataset, string3, false);
                }
                OSPLog.finer("adding new column \"" + string2 + "\"");
                dataset.setXYColumnNames(DataTable.rowName, string2);
                DataToolTab.this.addData(dataset);
                DataToolTab.this.dataTable.refreshTable();
                DataToolTab.this.refreshPlot();
                DataToolTab.this.refreshGUI();
                int n = DataToolTab.this.dataTable.getColumnCount() - 1;
                DataToolTable dataToolTable = DataToolTab.this.dataTable;
                dataToolTable.getClass();
                DataToolTable.TableEdit tableEdit = dataToolTable.new DataToolTable.TableEdit(1, string2, new Integer(n), dataset);
                DataToolTab.this.undoSupport.postEdit(tableEdit);
                DataToolTab.this.dataTable.refreshUndoItems();
                Runnable runnable = new Runnable(){

                    public synchronized void run() {
                        int n = (this).DataToolTab.this.dataTable.getColumnCount() - 1;
                        (this).DataToolTab.this.dataTable.changeSelection(0, n, false, false);
                        (this).DataToolTab.this.dataTable.editCellAt(0, n, actionEvent);
                        (this).DataToolTab.this.dataTable.editor.field.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.dataBuilderButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
        this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
        this.dataBuilderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.getDataBuilder().setSelectedPanel(DataToolTab.this.getName());
                DataToolTab.this.getDataBuilder().setVisible(true);
            }
        });
        this.refreshDataButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
        this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
        this.refreshDataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.dataManager.setName(DataToolTab.this.getName());
                DataToolTab.this.jobManager.sendReplies(DataToolTab.this.dataManager);
            }
        });
        this.helpButton = DataTool.createButton(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.dataTool != null) {
                    DataTool.showHelp(DataTool.helpName);
                } else {
                    DataTool.showHelp(helpName);
                }
            }
        });
        this.valueCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Position"));
        this.valueCheckbox.setSelected(false);
        this.valueCheckbox.setOpaque(false);
        this.valueCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Position.Tooltip"));
        this.valueCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.positionVisible = DataToolTab.this.valueCheckbox.isSelected();
                DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                DataToolTab.this.plot.repaint();
            }
        });
        this.slopeCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Slope"));
        this.slopeCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Slope.Tooltip"));
        this.slopeCheckbox.setSelected(false);
        this.slopeCheckbox.setOpaque(false);
        this.slopeCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.slopeVisible = DataToolTab.this.slopeCheckbox.isSelected();
                DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                DataToolTab.this.plot.repaint();
            }
        });
        this.areaCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Area"));
        this.areaCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Area.Tooltip"));
        this.areaCheckbox.setSelected(false);
        this.areaCheckbox.setOpaque(false);
        this.areaCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.plot.setAreaVisible(DataToolTab.this.areaCheckbox.isSelected());
            }
        });
        this.propsAndStatsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                boolean bl = DataToolTab.this.statsCheckbox.isSelected();
                boolean bl2 = DataToolTab.this.propsCheckbox.isSelected();
                if (bl) {
                    DataToolTab.this.statsTable.refreshStatistics();
                }
                int n2 = DataToolTab.this.statsTable.getPreferredSize().height;
                int n3 = DataToolTab.this.propsTable.getPreferredSize().height;
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                int n4 = n = lookAndFeel.getClass().getName().indexOf("Nimbus") > -1 ? 8 : 4;
                if (bl && bl2) {
                    Box box = Box.createVerticalBox();
                    box.add(DataToolTab.this.statsScroller);
                    box.add(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setTopComponent(box);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n2 + n3 + 2 * n);
                } else if (bl) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.statsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n2 + n);
                } else if (bl2) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n3 + n);
                } else {
                    DataToolTab.this.splitPanes[2].setDividerLocation(0);
                }
            }
        };
        this.statsCheckbox = new JCheckBox(ToolsRes.getString("Checkbox.Statistics.Label"), false);
        this.statsCheckbox.setOpaque(false);
        this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.statsCheckbox.addActionListener(this.propsAndStatsAction);
        this.propsCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"), true);
        this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
        this.propsCheckbox.setOpaque(false);
        this.propsCheckbox.addActionListener(this.propsAndStatsAction);
        this.plot = new DataToolPlotter(this.getWorkingData());
        this.plotAxes = new DataToolAxes(this.plot);
        this.plot.setAxes(this.plotAxes);
        if (this.getWorkingData() != null) {
            this.plot.addDrawable(this.getWorkingData());
            this.plot.setTitle(this.getWorkingData().getName());
        }
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            Set<Integer> rowsInside = new HashSet<Integer>();
            Set<Integer> recent = new HashSet<Integer>();
            boolean boxActive;
            Interactive ia;

            public void mousePressed(MouseEvent mouseEvent) {
                this.ia = DataToolTab.this.plot.getInteractive();
                if (this.ia instanceof HighlightableDataset) {
                    HighlightableDataset highlightableDataset = (HighlightableDataset)this.ia;
                    int n = highlightableDataset.getHitIndex();
                    ListSelectionModel listSelectionModel = DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                    int n2 = DataToolTab.this.dataTable.getXColumn();
                    listSelectionModel.setSelectionInterval(n2, n2);
                    n2 = DataToolTab.this.dataTable.getYColumn();
                    listSelectionModel.addSelectionInterval(n2, n2);
                    if (!mouseEvent.isControlDown()) {
                        DataToolTab.this.dataTable.setSelectedModelRows(new int[]{n});
                    } else {
                        int[] nArray = DataToolTab.this.dataTable.getSelectedModelRows();
                        boolean bl = true;
                        int[] nArray2 = nArray;
                        int n3 = nArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int n5 = nArray2[n4];
                            if (n5 == n) {
                                bl = false;
                            }
                            ++n4;
                        }
                        int[] nArray3 = new int[bl ? nArray.length + 1 : nArray.length - 1];
                        if (bl) {
                            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                            nArray3[nArray.length] = n;
                        } else {
                            n4 = 0;
                            int[] nArray4 = nArray;
                            int n6 = nArray.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                n3 = nArray4[n7];
                                if (n3 != n) {
                                    nArray3[n4] = n3;
                                    ++n4;
                                }
                                ++n7;
                            }
                        }
                        DataToolTab.this.dataTable.setSelectedModelRows(nArray3);
                    }
                    DataToolTab.this.dataTable.getSelectedData();
                    DataToolTab.this.plot.repaint();
                    this.boxActive = false;
                    return;
                }
                if (this.ia != null) {
                    this.boxActive = false;
                    return;
                }
                boolean bl = this.boxActive = !OSPRuntime.isPopupTrigger(mouseEvent);
                if (this.boxActive) {
                    if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                        DataToolTab.this.dataTable.clearSelection();
                    }
                    this.rowsInside.clear();
                    int[] nArray = DataToolTab.this.dataTable.getSelectedModelRows();
                    int n = nArray.length;
                    int n8 = 0;
                    while (n8 < n) {
                        int n9 = nArray[n8];
                        this.rowsInside.add(new Integer(n9));
                        ++n8;
                    }
                    this.recent.clear();
                    Point point = mouseEvent.getPoint();
                    DataToolTab.this.plot.selectionBox.xstart = point.x;
                    DataToolTab.this.plot.selectionBox.ystart = point.y;
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!this.boxActive) {
                    return;
                }
                HighlightableDataset highlightableDataset = DataToolTab.this.getWorkingData();
                if (highlightableDataset == null) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                DataToolTab.this.plot.selectionBox.visible = true;
                DataToolTab.this.plot.selectionBox.setSize(point.x - DataToolTab.this.plot.selectionBox.xstart, point.y - DataToolTab.this.plot.selectionBox.ystart);
                double[] dArray = highlightableDataset.getXPoints();
                double[] dArray2 = highlightableDataset.getYPoints();
                int n = 0;
                while (n < dArray.length) {
                    double d = DataToolTab.this.plot.xToPix(dArray[n]);
                    double d2 = DataToolTab.this.plot.yToPix(dArray2[n]);
                    Integer n2 = DataToolTab.this.dataTable.workingRows.get(new Integer(n));
                    int n3 = n2;
                    if (DataToolTab.this.plot.selectionBox.contains(d, d2)) {
                        if (!this.rowsInside.contains(n2) && !this.recent.contains(n2)) {
                            if (this.rowsInside.isEmpty()) {
                                ListSelectionModel listSelectionModel = DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                                int n4 = DataToolTab.this.dataTable.getXColumn();
                                listSelectionModel.setSelectionInterval(n4, n4);
                                n4 = DataToolTab.this.dataTable.getYColumn();
                                listSelectionModel.addSelectionInterval(n4, n4);
                            }
                            this.rowsInside.add(n2);
                            this.recent.add(n2);
                            DataToolTab.this.dataTable.getSelectionModel().addSelectionInterval(n3, n3);
                        }
                    } else if (this.rowsInside.contains(n2) && this.recent.contains(n2)) {
                        DataToolTab.this.dataTable.getSelectionModel().removeSelectionInterval(n3, n3);
                        this.rowsInside.remove(n2);
                        this.recent.remove(n2);
                        DataToolTab.this.dataTable.getSelectionModel().removeSelectionInterval(n3, n3);
                        if (this.rowsInside.isEmpty()) {
                            DataToolTab.this.dataTable.getColumnModel().getSelectionModel().removeSelectionInterval(0, DataToolTab.this.dataTable.getColumnCount() - 1);
                        }
                    }
                    ++n;
                }
                highlightableDataset = DataToolTab.this.dataTable.getSelectedData();
                DataToolTab.this.plot.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DataToolTab.this.plot.selectionBox.visible = false;
                if (this.ia != null) {
                    if (this.ia instanceof Selectable) {
                        DataToolTab.this.plot.setMouseCursor(((Selectable)this.ia).getPreferredCursor());
                    } else {
                        DataToolTab.this.plot.setMouseCursor(Cursor.getPredefinedCursor(12));
                    }
                }
                DataToolTab.this.plot.repaint();
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                DataToolTable.WorkingDataset workingDataset = null;
                DataToolTab.this.plot.value = Double.NaN;
                DataToolTab.this.plot.slope = Double.NaN;
                double[] dArray = null;
                double[] dArray2 = null;
                int n = -1;
                if (DataToolTab.this.positionVisible || DataToolTab.this.slopeVisible || DataToolTab.this.areaVisible) {
                    workingDataset = DataToolTab.this.dataTable.workingData;
                    if (workingDataset == null) {
                        return;
                    }
                    if (workingDataset.getIndex() > 0) {
                        double d = DataToolTab.this.plot.pixToX(mouseEvent.getX());
                        n = DataToolTab.this.plot.findIndexNearestX(d, workingDataset);
                    }
                    dArray = workingDataset.getXPoints();
                    dArray2 = workingDataset.getYPoints();
                }
                if (DataToolTab.this.positionVisible && n > -1) {
                    DataToolTab.this.plot.value = dArray2[n];
                    DataToolTab.this.plot.crossbars.x = dArray[n];
                    DataToolTab.this.plot.crossbars.y = dArray2[n];
                    DataToolTab.this.plot.xVar = workingDataset.getXColumnName();
                    DataToolTab.this.plot.yVar = workingDataset.getYColumnName();
                }
                if (DataToolTab.this.slopeVisible && n > 0 && n < workingDataset.getIndex() - 1) {
                    DataToolTab.this.plot.slopeLine.x = dArray[n];
                    DataToolTab.this.plot.slopeLine.y = dArray2[n];
                    DataToolTab.this.plot.slope = (dArray2[n + 1] - dArray2[n - 1]) / (dArray[n + 1] - dArray[n - 1]);
                }
                if (DataToolTab.this.positionVisible || DataToolTab.this.slopeVisible || DataToolTab.this.areaVisible) {
                    DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                }
                DataToolTab.this.plot.repaint();
            }
        };
        this.plot.addMouseListener(mouseInputAdapter);
        this.plot.addMouseMotionListener(mouseInputAdapter);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setBorder(BorderFactory.createEtchedBorder());
        this.toolbar.add(this.propsCheckbox);
        this.toolbar.add(this.bottomPaneCheckbox);
        this.toolbar.add(this.statsCheckbox);
        this.toolbar.add(this.valueCheckbox);
        this.toolbar.add(this.slopeCheckbox);
        this.toolbar.add(this.areaCheckbox);
        this.toolbar.add(Box.createGlue());
        this.toolbar.add(this.newColumnButton);
        this.toolbar.add(this.dataBuilderButton);
        this.toolbar.add(this.refreshDataButton);
        this.toolbar.add(this.helpButton);
        this.curveFitter = new DatasetCurveFitter(this.getWorkingData());
        this.curveFitter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("changed")) {
                    DataToolTab.this.tabChanged(true);
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("drawer") && DataToolTab.this.bottomPaneCheckbox != null && DataToolTab.this.bottomPaneCheckbox.isSelected()) {
                    DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                    DataToolTab.this.plot.addDrawable((FunctionDrawer)propertyChangeEvent.getNewValue());
                }
                DataToolTab.this.plot.repaint();
            }
        });
        this.statsTable = new DataToolStatsTable(this.dataTable);
        this.statsScroller = new JScrollPane(this.statsTable){

            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.statsTable.getPreferredSize();
                return dimension;
            }
        };
        this.propsTable = new DataToolPropsTable(this.dataTable);
        this.propsTable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("display")) {
                    DataToolTab.this.refreshPlot();
                }
            }
        });
        this.propsScroller = new JScrollPane(this.propsTable){

            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.propsTable.getPreferredSize();
                return dimension;
            }
        };
        this.statusLabel = new JLabel(" ", 10);
        this.statusLabel.setFont(new JTextField().getFont());
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.splitPanes[0], "Center");
        this.add((Component)this.statusLabel, "South");
        this.splitPanes[0].setLeftComponent(this.splitPanes[1]);
        this.splitPanes[0].setRightComponent(this.splitPanes[2]);
        this.splitPanes[1].setTopComponent(this.plot);
        this.splitPanes[1].setBottomComponent(this.curveFitter);
        this.splitPanes[2].setBottomComponent(jScrollPane);
        this.splitPanes[0].setDividerLocation(0);
        this.curveFitter.splitPane.setDividerLocation(0);
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
    }

    protected void refreshGUI() {
        boolean bl = this.tabChanged;
        this.newColumnButton.setText(ToolsRes.getString("DataToolTab.Button.NewColumn.Text"));
        this.newColumnButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.NewColumn.Tooltip"));
        this.dataBuilderButton.setText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
        this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
        this.dataBuilderButton.setEnabled(this.owner != null);
        this.refreshDataButton.setText(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
        this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
        this.statsCheckbox.setText(ToolsRes.getString("Checkbox.Statistics.Label"));
        this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.bottomPaneCheckbox.setText(ToolsRes.getString("Checkbox.Fits.Label"));
        this.bottomPaneCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Fits.ToolTip"));
        this.propsCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"));
        this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
        this.valueCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Position"));
        this.valueCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Position.Tooltip"));
        this.slopeCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Slope"));
        this.slopeCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Slope.Tooltip"));
        this.areaCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Area"));
        this.areaCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Area.Tooltip"));
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.toolbar.remove(this.newColumnButton);
        if (this.userEditable) {
            int n = this.toolbar.getComponentIndex(this.helpButton);
            this.toolbar.add((Component)this.newColumnButton, n);
            this.toolbar.validate();
        }
        this.toolbar.remove(this.refreshDataButton);
        Collection<Tool> collection = this.jobManager.getTools(this.dataManager);
        for (Tool tool : collection) {
            if (!(tool instanceof DataRefreshTool)) continue;
            int n = this.toolbar.getComponentIndex(this.helpButton);
            this.toolbar.add((Component)this.refreshDataButton, n);
            this.toolbar.validate();
            break;
        }
        this.curveFitter.refreshGUI();
        this.statsTable.refreshGUI();
        this.propsTable.refreshGUI();
        this.refreshStatusBar();
        this.tabChanged = bl;
    }

    private void init() {
        if (this.splitPanes[0].getDividerLocation() < 10) {
            this.splitPanes[0].setDividerLocation(0.7);
            this.curveFitter.splitPane.setDividerLocation(1.0);
        }
        this.splitPanes[1].setDividerLocation(1.0);
        this.propsAndStatsAction.actionPerformed(null);
        int n = 0;
        while (n < this.dataTable.getColumnCount()) {
            String string = this.dataTable.getColumnName(n);
            this.dataTable.getWorkingData(string);
            ++n;
        }
        this.refreshPlot();
        this.refreshGUI();
    }

    private void buildVarPopup() {
        if (this.setVarAction == null) {
            this.setVarAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getActionCommand();
                    String string2 = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.plot.yVar : DataToolTab.this.plot.xVar;
                    int n = DataToolTab.this.dataTable.convertColumnIndexToView(0);
                    int n2 = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.dataTable.getXColumn() : DataToolTab.this.dataTable.getYColumn();
                    TableModel tableModel = DataToolTab.this.dataTable.getModel();
                    int n3 = 0;
                    while (n3 < tableModel.getColumnCount()) {
                        if (string.equals(DataToolTab.this.dataTable.getColumnName(n3))) {
                            if (n3 == n2) {
                                return;
                            }
                            DataToolTab.this.dataTable.getColumnModel().moveColumn(n3, n2);
                            break;
                        }
                        ++n3;
                    }
                    if (!string.equals(string2)) {
                        n2 = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.dataTable.getYColumn() : DataToolTab.this.dataTable.getXColumn();
                        n3 = 0;
                        while (n3 < tableModel.getColumnCount()) {
                            if (string2.equals(DataToolTab.this.dataTable.getColumnName(n3))) {
                                DataToolTab.this.dataTable.getColumnModel().moveColumn(n3, n2);
                                break;
                            }
                            ++n3;
                        }
                    }
                    n2 = DataToolTab.this.dataTable.convertColumnIndexToView(0);
                    DataToolTab.this.dataTable.getColumnModel().moveColumn(n2, n);
                }
            };
        }
        this.varPopup = new JPopupMenu();
        Font font = new JTextField().getFont();
        for (Dataset dataset : this.dataManager.getDatasets()) {
            String string = TeXParser.removeSubscripting(dataset.getYColumnName());
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setActionCommand(dataset.getYColumnName());
            jMenuItem.addActionListener(this.setVarAction);
            jMenuItem.setFont(font);
            this.varPopup.add(jMenuItem);
        }
    }

    private Dataset getMatchingID(Dataset dataset, Data data) {
        ArrayList<Dataset> arrayList = data.getDatasets();
        if (arrayList == null) {
            return null;
        }
        for (Dataset dataset2 : arrayList) {
            int n = dataset2.getID();
            if (dataset2.getYColumnName().equals(dataset.getYColumnName()) && dataset.getID() == n) {
                return dataset2;
            }
            if (!dataset2.getXColumnName().equals(dataset.getYColumnName()) || dataset.getID() != -n) continue;
            return dataset2;
        }
        return null;
    }

    protected boolean isDuplicateColumn(String string, double[] dArray) {
        if (string.equals(this.dataTable.getModel().getColumnName(0))) {
            return true;
        }
        for (Dataset dataset : this.dataManager.getDatasets()) {
            double[] dArray2 = dataset.getYPoints();
            if (!string.equals(dataset.getYColumnName()) || !this.isDuplicate(dArray, dataset.getYPoints())) continue;
            if (dArray.length > dArray2.length) {
                dataset.clear();
                dataset.append(dArray, dArray);
            }
            return true;
        }
        return false;
    }

    private boolean isDuplicate(double[] dArray, double[] dArray2) {
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            if (!(Double.isNaN(dArray[n2]) && Double.isNaN(dArray2[n2]) || dArray[n2] == dArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isOwnedBy(Data data) {
        String string = null;
        try {
            Method method = data.getClass().getMethod("getName", new Class[0]);
            string = (String)method.invoke((Object)data, new Object[0]);
        }
        catch (Exception exception) {}
        if (string != null && this.replaceSpacesWithUnderscores(string).equals(this.getName())) {
            return true;
        }
        return this.owner != null && data == this.owner;
    }

    protected void refreshPlot() {
        this.curveFitter.setData(this.dataTable.getSelectedData());
        this.plot.removeDrawables(Dataset.class);
        DataToolTable.WorkingDataset workingDataset = this.getWorkingData();
        this.valueCheckbox.setEnabled(workingDataset != null && workingDataset.getIndex() > 0);
        if (!this.valueCheckbox.isEnabled()) {
            this.valueCheckbox.setSelected(false);
            this.positionVisible = false;
        }
        this.slopeCheckbox.setEnabled(workingDataset != null && workingDataset.getIndex() > 2);
        if (!this.slopeCheckbox.isEnabled()) {
            this.slopeCheckbox.setSelected(false);
            this.slopeVisible = false;
        }
        this.areaCheckbox.setEnabled(workingDataset != null && workingDataset.getIndex() > 1);
        if (!this.areaCheckbox.isEnabled()) {
            this.areaCheckbox.setSelected(false);
            this.areaVisible = false;
        }
        if (workingDataset != null) {
            Object object2;
            int n = this.dataTable.convertColumnIndexToView(0);
            String string = this.dataTable.getColumnName(n == 0 ? 1 : 0);
            HashMap<String, DataToolTable.WorkingDataset> hashMap = this.dataTable.workingMap;
            for (Object object2 : hashMap.values()) {
                ((DataToolTable.WorkingDataset)object2).setXSource(workingDataset.getXSource());
                String string2 = ((Dataset)object2).getYColumnName();
                if (object2 == workingDataset || string2.equals(string) || !((DataToolTable.WorkingDataset)object2).isMarkersVisible() && !((Dataset)object2).isConnected()) continue;
                ((HighlightableDataset)object2).clearHighlights();
                if (!((DataToolTable.WorkingDataset)object2).isMarkersVisible()) {
                    ((DataToolTable.WorkingDataset)object2).setMarkerShape(0);
                }
                this.plot.addDrawable((Drawable)object2);
            }
            this.plot.addDrawable(workingDataset);
            if (this.areaVisible) {
                this.plot.limits[0].x = Math.max(this.plot.limits[0].x, workingDataset.getXMin());
                this.plot.limits[0].x = Math.min(this.plot.limits[0].x, workingDataset.getXMax());
                this.plot.limits[1].x = Math.max(this.plot.limits[1].x, workingDataset.getXMin());
                this.plot.limits[1].x = Math.min(this.plot.limits[1].x, workingDataset.getXMax());
            }
            workingDataset.restoreHighlights();
            if (this.bottomPaneCheckbox != null && this.bottomPaneCheckbox.isSelected()) {
                this.plot.removeDrawable(this.curveFitter.getDrawer());
                this.plot.addDrawable(this.curveFitter.getDrawer());
            }
            this.plot.setTitle(workingDataset.getName());
            this.plot.setAxisLabels(workingDataset.getColumnName(0), workingDataset.getColumnName(1));
            String string3 = TeXParser.removeSubscripting(workingDataset.getColumnName(1));
            object2 = TeXParser.removeSubscripting(workingDataset.getColumnName(0));
            this.curveFitter.eqnField.setText(String.valueOf(string3) + " = " + this.curveFitter.fit.getExpression((String)object2));
        } else {
            this.plot.setTitle("");
            this.plot.setAxisLabels("x", "y");
            this.plot.setXLabel("");
            this.plot.setYLabel("");
        }
        if (this.dataTool != null) {
            this.dataTool.refreshTabTitles();
        }
        if (this.areaVisible) {
            this.plot.refreshArea(workingDataset);
        }
        this.repaint();
    }

    protected void refreshStatusBar() {
        if (this.dataManager.getDatasets().size() < 2) {
            this.statusLabel.setText(this.userEditable ? ToolsRes.getString("DataToolTab.StatusBar.Text.CreateColumns") : ToolsRes.getString("DataToolTab.StatusBar.Text.PasteColumns"));
        } else {
            this.statusLabel.setText(ToolsRes.getString("DataToolTab.StatusBar.Text.DragColumns"));
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class DataToolAxes
    extends CartesianInteractive {
        DataToolAxes(PlottingPanel plottingPanel) {
            super(plottingPanel);
        }

        protected boolean hasHorzVariablesPopup() {
            return DataToolTab.this.dataTable.workingData != null;
        }

        protected JPopupMenu getHorzVariablesPopup() {
            if (DataToolTab.this.varPopup == null) {
                DataToolTab.this.buildVarPopup();
            }
            DataToolTab.this.isHorzVarPopup = true;
            FontSizer.setFonts(DataToolTab.this.varPopup, DataToolTab.this.fontLevel);
            Component[] componentArray = DataToolTab.this.varPopup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                JMenuItem jMenuItem = (JMenuItem)component;
                if (this.xLine.getText().equals(jMenuItem.getActionCommand())) {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(1));
                } else {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(0));
                }
                ++n2;
            }
            return DataToolTab.this.varPopup;
        }

        protected boolean hasVertVariablesPopup() {
            return DataToolTab.this.dataTable.workingData != null;
        }

        protected JPopupMenu getVertVariablesPopup() {
            if (DataToolTab.this.varPopup == null) {
                DataToolTab.this.buildVarPopup();
            }
            DataToolTab.this.isHorzVarPopup = false;
            FontSizer.setFonts(DataToolTab.this.varPopup, DataToolTab.this.fontLevel);
            Component[] componentArray = DataToolTab.this.varPopup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                JMenuItem jMenuItem = (JMenuItem)component;
                if (this.yLine.getText().equals(jMenuItem.getActionCommand())) {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(1));
                } else {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(0));
                }
                ++n2;
            }
            return DataToolTab.this.varPopup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DataToolPlotter
    extends PlottingPanel {
        SelectionBox selectionBox;
        Crossbars crossbars;
        SlopeLine slopeLine;
        Dataset areaDataset;
        LimitLine[] limits;
        double value;
        double slope;
        double area;
        DecimalFormat sciFormat;
        DecimalFormat fixedFormat;
        String xVar;
        String yVar;
        String message;

        DataToolPlotter(Dataset dataset) {
            super(dataset == null ? "x" : dataset.getColumnName(0), dataset == null ? "y" : dataset.getColumnName(1), "");
            this.limits = new LimitLine[2];
            this.value = Double.NaN;
            this.slope = Double.NaN;
            this.sciFormat = new DecimalFormat("0.00E0");
            this.fixedFormat = new DecimalFormat("0.00");
            this.setAntialiasShapeOn(true);
            this.selectionBox = new SelectionBox();
            this.crossbars = new Crossbars();
            this.slopeLine = new SlopeLine();
            this.limits[0] = new LimitLine();
            this.limits[1] = new LimitLine();
            this.addDrawable(this.limits[0]);
            this.addDrawable(this.limits[1]);
            this.addDrawable(this.selectionBox);
        }

        @Override
        protected void paintDrawableList(Graphics graphics, ArrayList<Drawable> arrayList) {
            super.paintDrawableList(graphics, arrayList);
            if (arrayList.contains(DataToolTab.this.curveFitter.getDrawer())) {
                double[] dArray = DataToolTab.this.curveFitter.getDrawer().getYRange();
                if (dArray[0] >= this.getYMax() || dArray[1] <= this.getYMin()) {
                    this.setMessage(ToolsRes.getString("DataToolTab.Plot.Message.FitNotVisible"));
                } else {
                    this.setMessage(this.message);
                }
            } else {
                this.setMessage(this.message);
            }
            this.slopeLine.draw(graphics);
            this.crossbars.draw(graphics);
        }

        void setAreaVisible(boolean bl) {
            DataToolTab.this.areaVisible = bl;
            if (this.areaDataset == null) {
                this.areaDataset = new Dataset();
                this.areaDataset.setMarkerShape(5);
                this.areaDataset.setConnected(false);
                this.areaDataset.setMarkerColor(new Color(102, 102, 102, 51));
                DataToolTable.WorkingDataset workingDataset = DataToolTab.this.dataTable.workingData;
                if (workingDataset != null && workingDataset.getIndex() > 1) {
                    this.limits[0].x = workingDataset.getXMin();
                    this.limits[1].x = workingDataset.getXMax();
                }
            }
            DataToolTab.this.refreshPlot();
            this.setMessage(this.createMessage());
        }

        void refreshArea(Dataset dataset) {
            if (!DataToolTab.this.areaVisible) {
                return;
            }
            this.area = 0.0;
            if (dataset == null) {
                DataToolTab.this.areaVisible = false;
                this.setMessage(this.createMessage());
                return;
            }
            double[] dArray = dataset.getXPoints();
            double[] dArray2 = dataset.getYPoints();
            this.areaDataset.clear();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            int n = 0;
            while (n < dArray.length) {
                double d = Math.min(this.limits[0].x, this.limits[1].x);
                double d2 = Math.max(this.limits[0].x, this.limits[1].x);
                if (dArray[n] >= d && dArray[n] <= d2) {
                    arrayList.add(new Double(dArray[n]));
                    arrayList2.add(new Double(dArray2[n]));
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                dArray = new double[arrayList.size()];
                dArray2 = new double[arrayList.size()];
                n = 0;
                while (n < dArray.length) {
                    dArray[n] = (Double)arrayList.get(n);
                    dArray2[n] = (Double)arrayList2.get(n);
                    ++n;
                }
                this.areaDataset.append(dArray[0], 0.0);
                this.areaDataset.append(dArray, dArray2);
                this.areaDataset.append(dArray[dArray.length - 1], 0.0);
                n = dArray.length;
                if (n > 1) {
                    DataToolTab.this.plot.addDrawable(this.areaDataset);
                    this.area = dArray2[0] * (dArray[1] - dArray[0]);
                    this.area += dArray2[n - 1] * (dArray[n - 1] - dArray[n - 2]);
                    int n2 = 1;
                    while (n2 < n - 1) {
                        this.area += dArray2[n2] * (dArray[n2 + 1] - dArray[n2 - 1]);
                        ++n2;
                    }
                    this.area /= 2.0;
                }
            }
            this.setMessage(this.createMessage());
        }

        protected int findIndexNearestX(double d, Dataset dataset) {
            if (dataset == null) {
                return -1;
            }
            int n = dataset.getIndex() - 1;
            if (n == -1) {
                return -1;
            }
            d = Math.max(DataToolTab.this.plot.getXMin(), d);
            d = Math.min(DataToolTab.this.plot.getXMax(), d);
            double[] dArray = dataset.getXPoints();
            Arrays.sort(dArray);
            if (d < dArray[0]) {
                return 0;
            }
            if (d >= dArray[n]) {
                return n;
            }
            int n2 = 1;
            while (n2 < dArray.length) {
                if (d >= dArray[n2 - 1] && d < dArray[n2]) {
                    d = dArray[n2 - 1] < DataToolTab.this.plot.getXMin() ? dArray[n2] : (dArray[n2] > DataToolTab.this.plot.getXMax() ? dArray[n2 - 1] : (Math.abs(d - dArray[n2 - 1]) < Math.abs(d - dArray[n2]) ? dArray[n2 - 1] : dArray[n2]));
                    double[] dArray2 = dataset.getXPoints();
                    int n3 = 0;
                    while (n3 < dArray2.length) {
                        if (dArray2[n3] == d) {
                            return n3;
                        }
                        ++n3;
                    }
                    return -1;
                }
                ++n2;
            }
            return -1;
        }

        String createMessage() {
            StringBuffer stringBuffer = new StringBuffer();
            if (DataToolTab.this.positionVisible && !Double.isNaN(this.value)) {
                stringBuffer.append(String.valueOf(TeXParser.removeSubscripting(this.xVar)) + "=");
                stringBuffer.append(this.format(DataToolTab.this.plot.crossbars.x, this.getXMax() - this.getXMin()));
                stringBuffer.append("  ");
                stringBuffer.append(String.valueOf(TeXParser.removeSubscripting(this.yVar)) + "=");
                stringBuffer.append(this.format(DataToolTab.this.plot.crossbars.y, this.getYMax() - this.getYMin()));
            }
            if (DataToolTab.this.slopeVisible && !Double.isNaN(this.slope)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(ToolsRes.getString("DataToolPlotter.Message.Slope"));
                stringBuffer.append(this.format(DataToolTab.this.plot.slope, 0.0));
            }
            if (DataToolTab.this.areaVisible) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(ToolsRes.getString("DataToolPlotter.Message.Area"));
                stringBuffer.append(this.format(DataToolTab.this.plot.area, 0.0));
            }
            this.message = stringBuffer.toString();
            return this.message;
        }

        String format(double d, double d2) {
            double d3 = Math.min(1.0, d2) / 1000.0;
            if (Math.abs(d) < d3) {
                d = 0.0;
            }
            if (d2 < 1.0 && d != 0.0) {
                return this.sciFormat.format(d);
            }
            return Math.abs(d) <= 10.0 ? this.fixedFormat.format(d) : this.sciFormat.format(d);
        }

        void setAxisLabels(String string, String string2) {
            this.setXLabel(string);
            this.setYLabel(string2);
            this.xVar = TeXParser.removeSubscripting(string);
            this.yVar = TeXParser.removeSubscripting(string2);
            String string3 = String.valueOf(this.xVar) + "=";
            String string4 = "  " + this.yVar + "=";
            this.coordinateStrBuilder.setCoordinateLabels(string3, string4);
        }

        @Override
        protected void setFontLevel(int n) {
            super.setFontLevel(n);
        }

        class Crossbars {
            double x;
            double y;
            Color color = new Color(0, 0, 0);

            Crossbars() {
            }

            public void draw(Graphics graphics) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.positionVisible || Double.isNaN(DataToolPlotter.this.value)) {
                    return;
                }
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                graphics.drawLine(DataToolPlotter.this.getLeftGutter(), DataToolPlotter.this.yToPix(this.y), DataToolPlotter.this.getWidth() - DataToolPlotter.this.getRightGutter() - 1, DataToolPlotter.this.yToPix(this.y));
                graphics.drawLine(DataToolPlotter.this.xToPix(this.x), DataToolPlotter.this.getTopGutter(), DataToolPlotter.this.xToPix(this.x), DataToolPlotter.this.getHeight() - DataToolPlotter.this.getBottomGutter() - 1);
                graphics.setColor(color);
            }
        }

        class LimitLine
        extends Line2D.Double
        implements Selectable {
            double x;
            Stroke stroke = new BasicStroke(1.0f);
            Rectangle hitRect = new Rectangle();
            Color color = new Color(51, 51, 51);
            Cursor move;

            LimitLine() {
            }

            public void draw(DrawingPanel drawingPanel, Graphics graphics) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible) {
                    return;
                }
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                int n = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getTopGutter();
                int n2 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBounds().height - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBottomGutter();
                int n3 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.xToPix(this.x);
                this.setLine(n3 + 1, n, n3 + 1, n2);
                ((Graphics2D)graphics).fill(this.stroke.createStrokedShape(this));
                graphics.setColor(color);
                this.hitRect.setBounds(n3 - 2, n, 6, n2 - n - 20);
            }

            public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible && this.hitRect.contains(n, n2)) {
                    return this;
                }
                return null;
            }

            public Cursor getPreferredCursor() {
                if (this.move == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/limitcursor.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.move = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Move Integration Limit");
                }
                return this.move;
            }

            public void setXY(double d, double d2) {
                this.setX(d);
            }

            public void setX(double d) {
                DataToolTable.WorkingDataset workingDataset = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                int n = DataToolPlotter.this.findIndexNearestX(d, workingDataset);
                this.x = n == -1 ? d : workingDataset.getXPoints()[n];
                DataToolPlotter.this.refreshArea(workingDataset);
                DataToolPlotter.this.createMessage();
                ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setMessage(DataToolPlotter.this.message);
            }

            public boolean isMeasured() {
                return ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible;
            }

            public double getXMin() {
                DataToolTable.WorkingDataset workingDataset = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                double d = 0.0;
                double d2 = 0.0;
                if (workingDataset != null && workingDataset.getIndex() > 1) {
                    d = Math.abs(workingDataset.getXMax() - workingDataset.getXMin());
                    d2 = Math.min(workingDataset.getXMax(), workingDataset.getXMin());
                } else {
                    d = Math.abs(DataToolPlotter.this.limits[0].x - DataToolPlotter.this.limits[1].x);
                    d2 = Math.min(DataToolPlotter.this.limits[0].x, DataToolPlotter.this.limits[1].x);
                }
                return d2 - 0.02 * d;
            }

            public double getXMax() {
                DataToolTable.WorkingDataset workingDataset = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                double d = 0.0;
                double d2 = 0.0;
                if (workingDataset != null && workingDataset.getIndex() > 1) {
                    d = Math.abs(workingDataset.getXMax() - workingDataset.getXMin());
                    d2 = Math.max(workingDataset.getXMax(), workingDataset.getXMin());
                } else {
                    d = Math.abs(DataToolPlotter.this.limits[0].x - DataToolPlotter.this.limits[1].x);
                    d2 = Math.max(DataToolPlotter.this.limits[0].x, DataToolPlotter.this.limits[1].x);
                }
                return d2 + 0.02 * d;
            }

            public double getYMin() {
                return (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMin() + ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMax()) / 2.0;
            }

            public double getYMax() {
                return (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMin() + ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMax()) / 2.0;
            }

            public void setY(double d) {
            }

            public double getX() {
                return this.x;
            }

            public double getY() {
                return 0.0;
            }

            public void setSelected(boolean bl) {
            }

            public boolean isSelected() {
                return false;
            }

            public void toggleSelected() {
            }

            public boolean isEnabled() {
                return true;
            }

            public void setEnabled(boolean bl) {
            }
        }

        class SelectionBox
        extends Rectangle
        implements Drawable {
            boolean visible = true;
            int xstart;
            int ystart;
            Color color = new Color(0, 255, 0, 127);

            SelectionBox() {
            }

            public void setSize(int n, int n2) {
                int n3 = Math.min(0, n);
                int n4 = Math.min(0, n2);
                n = Math.abs(n);
                n2 = Math.abs(n2);
                super.setLocation(this.xstart + n3, this.ystart + n4);
                super.setSize(n, n2);
            }

            public void draw(DrawingPanel drawingPanel, Graphics graphics) {
                if (this.visible) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setColor(this.color);
                    graphics2D.draw(this);
                }
            }
        }

        class SlopeLine
        extends Line2D.Double {
            double x;
            double y;
            Stroke stroke = new BasicStroke(1.5f);
            int length = 30;
            Color color = new Color(0, 0, 0);

            SlopeLine() {
            }

            public void draw(Graphics graphics) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.slopeVisible || Double.isNaN(DataToolPlotter.this.slope)) {
                    return;
                }
                double d = 1.0 * DataToolPlotter.this.getXPixPerUnit();
                double d2 = DataToolPlotter.this.slope * DataToolPlotter.this.getYPixPerUnit();
                double d3 = Math.sqrt(d * d + d2 * d2);
                double d4 = d2 / d3;
                double d5 = d / d3;
                int n = DataToolPlotter.this.xToPix(this.x);
                int n2 = DataToolPlotter.this.yToPix(this.y);
                this.setLine((double)n - (double)this.length * d5 + 1.0, (double)n2 + (double)this.length * d4 + 1.0, (double)n + (double)this.length * d5 + 1.0, (double)n2 - (double)this.length * d4 + 1.0);
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                ((Graphics2D)graphics).fill(this.stroke.createStrokedShape(this));
                graphics.setColor(color);
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        /*
         * WARNING - void declaration
         */
        public void saveObject(XMLControl xMLControl, Object object) {
            String[] stringArray;
            Object object2;
            DataToolTab dataToolTab = (DataToolTab)object;
            xMLControl.setValue("name", dataToolTab.getName());
            DatasetManager datasetManager = new DatasetManager();
            ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
            for (Dataset object32 : dataToolTab.dataManager.getDatasets()) {
                if (object32 instanceof DataFunction) {
                    arrayList.add(object32);
                    continue;
                }
                datasetManager.addDataset(object32);
            }
            xMLControl.setValue("data", datasetManager);
            if (!arrayList.isEmpty()) {
                object2 = arrayList.toArray(new DataFunction[0]);
                xMLControl.setValue("data_functions", object2);
            }
            if (dataToolTab.curveFitter.fitBuilder != null) {
                object2 = new ArrayList<FunctionPanel>(dataToolTab.curveFitter.fitBuilder.panels.values());
                xMLControl.setValue("fits", object2);
            }
            xMLControl.setValue("selected_fit", dataToolTab.curveFitter.getSelectedFitName());
            xMLControl.setValue("autofit", dataToolTab.curveFitter.autofitCheckBox.isSelected());
            if (!dataToolTab.curveFitter.autofitCheckBox.isSelected()) {
                void var7_10;
                object2 = new double[dataToolTab.curveFitter.paramModel.getRowCount()];
                boolean n = false;
                while (var7_10 < ((DataFunction[])object2).length) {
                    stringArray = (String[])dataToolTab.curveFitter.paramModel.getValueAt((int)var7_10, 1);
                    object2[var7_10] = (DataFunction)stringArray.doubleValue();
                    ++var7_10;
                }
                xMLControl.setValue("fit_parameters", object2);
            }
            xMLControl.setValue("fit_color", dataToolTab.curveFitter.color);
            xMLControl.setValue("fit_visible", dataToolTab.bottomPaneCheckbox.isSelected());
            xMLControl.setValue("props_visible", dataToolTab.propsCheckbox.isSelected());
            xMLControl.setValue("stats_visible", dataToolTab.statsCheckbox.isSelected());
            int n = dataToolTab.splitPanes[0].getDividerLocation();
            xMLControl.setValue("split_pane", n);
            n = dataToolTab.curveFitter.splitPane.getDividerLocation();
            xMLControl.setValue("fit_split_pane", n);
            int[] nArray = dataToolTab.dataTable.getModelColumnOrder();
            xMLControl.setValue("column_order", nArray);
            stringArray = dataToolTab.dataTable.getHiddenMarkers();
            xMLControl.setValue("hidden_markers", stringArray);
            Collection<String> collection = dataToolTab.dataTable.getPatternColumns();
            if (!collection.isEmpty()) {
                ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
                for (String string : collection) {
                    String string2 = dataToolTab.dataTable.getFormatPattern(string);
                    arrayList2.add(new String[]{string, string2});
                }
                xMLControl.setValue("format_patterns", arrayList2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            DatasetManager datasetManager = (DatasetManager)xMLControl.getObject("data");
            return new DataToolTab(datasetManager);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Runnable runnable2;
            String[] stringArray;
            Serializable serializable;
            XMLControl[] xMLControlArray;
            Object object22;
            final DataToolTab dataToolTab = (DataToolTab)object;
            dataToolTab.setName(xMLControl.getString("name"));
            for (Object object22 : xMLControl.getPropertyContent()) {
                if (!object22.getPropertyName().equals("data_functions")) continue;
                xMLControlArray = object22.getChildControls();
                int n = 0;
                while (n < xMLControlArray.length) {
                    DataFunction dataFunction = new DataFunction(dataToolTab.dataManager);
                    xMLControlArray[n].loadObject(dataFunction);
                    dataFunction.setXColumnVisible(false);
                    dataToolTab.dataManager.addDataset(dataFunction);
                    ++n;
                }
                serializable = dataToolTab.dataManager.getDatasets();
                int n2 = 0;
                while (n2 < ((ArrayList)serializable).size()) {
                    if (((ArrayList)serializable).get(n2) instanceof DataFunction) {
                        ((DataFunction)((ArrayList)serializable).get(n2)).refreshFunctionData();
                    }
                    ++n2;
                }
                dataToolTab.dataTable.refreshTable();
                break;
            }
            object22 = (ArrayList)xMLControl.getObject("fits");
            if (object22 != null) {
                xMLControlArray = ((ArrayList)object22).iterator();
                while (xMLControlArray.hasNext()) {
                    serializable = (FitFunctionPanel)xMLControlArray.next();
                    dataToolTab.curveFitter.addUserFit((FitFunctionPanel)serializable);
                }
            }
            xMLControlArray = xMLControl.getString("selected_fit");
            dataToolTab.curveFitter.fitDropDown.setSelectedItem(xMLControlArray);
            boolean bl = xMLControl.getBoolean("autofit");
            dataToolTab.curveFitter.autofitCheckBox.setSelected(bl);
            double[] dArray = (double[])xMLControl.getObject("fit_parameters");
            if (dArray != null) {
                int n = 0;
                while (n < dArray.length) {
                    dataToolTab.curveFitter.setParameterValue(n, dArray[n]);
                    ++n;
                }
            }
            Color color = (Color)xMLControl.getObject("fit_color");
            dataToolTab.curveFitter.setColor(color);
            boolean bl2 = xMLControl.getBoolean("fit_visible");
            dataToolTab.bottomPaneCheckbox.setSelected(bl2);
            bl2 = xMLControl.getBoolean("props_visible");
            dataToolTab.propsCheckbox.setSelected(bl2);
            bl2 = xMLControl.getBoolean("stats_visible");
            dataToolTab.statsCheckbox.setSelected(bl2);
            final int n = xMLControl.getInt("split_pane");
            final int n3 = xMLControl.getInt("fit_split_pane");
            int[] nArray = (int[])xMLControl.getObject("column_order");
            dataToolTab.dataTable.setModelColumnOrder(nArray);
            if (nArray == null && (stringArray = (String[])xMLControl.getObject("working_columns")) != null) {
                dataToolTab.dataTable.setWorkingColumns(stringArray[0], stringArray[1]);
            }
            stringArray = (String[])xMLControl.getObject("hidden_markers");
            dataToolTab.dataTable.hideMarkers(stringArray);
            ArrayList arrayList = (ArrayList)xMLControl.getObject("format_patterns");
            if (arrayList != null) {
                for (Runnable runnable2 : arrayList) {
                    dataToolTab.dataTable.setFormatPattern(runnable2[0], runnable2[1]);
                }
            }
            runnable2 = new Runnable(){

                public synchronized void run() {
                    dataToolTab.bottomPaneAction.actionPerformed(null);
                    dataToolTab.propsAndStatsAction.actionPerformed(null);
                    dataToolTab.splitPanes[0].setDividerLocation(n);
                    dataToolTab.curveFitter.splitPane.setDividerLocation(n3);
                    dataToolTab.dataTable.refreshTable();
                    dataToolTab.propsTable.refreshTable();
                    dataToolTab.tabChanged(false);
                }
            };
            SwingUtilities.invokeLater(runnable2);
            return object;
        }
    }
}

