/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.simple3d.MessagesPanel;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.ImplementingPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDrawingPanel3D
extends JPanel
implements ImplementingPanel,
Printable,
ActionListener {
    private boolean fastRedraw = false;
    private ArrayList<Object3D> list3D = new ArrayList();
    private Object3D.Comparator3D comparator = new Object3D.Comparator3D();
    private boolean needResize = true;
    private boolean needsToRecompute = true;
    private volatile boolean dirtyImage = true;
    private volatile BufferedImage offscreenImage;
    private BufferedImage workingImage = this.offscreenImage = new BufferedImage(1, 1, 1);
    private Timer updateTimer = new Timer(100, this);
    private Rectangle viewRect = null;
    private DrawingPanel3D panel3D;
    private MessagesPanel messagesPanel;

    public SimpleDrawingPanel3D(DrawingPanel3D drawingPanel3D) {
        this.panel3D = drawingPanel3D;
        super.setBackground(this.panel3D.getVisualizationHints().getBackgroundColor());
        this.messagesPanel = new MessagesPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.messagesPanel, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SimpleDrawingPanel3D.this.needResize = true;
                SimpleDrawingPanel3D.this.dirtyImage = true;
            }
        });
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void forceRefresh() {
        this.needsToRecompute = true;
        this.dirtyImage = true;
    }

    @Override
    public void update() {
        this.dirtyImage = true;
        this.updatePanel();
    }

    @Override
    public void setFastRedraw(boolean bl) {
        this.fastRedraw = bl;
    }

    @Override
    public void cameraChanged(int n) {
    }

    @Override
    public void setMessage(String string) {
        this.messagesPanel.setMessage(string);
    }

    @Override
    public void setMessage(String string, int n) {
        this.messagesPanel.setMessage(string, n);
    }

    @Override
    public BufferedImage render(BufferedImage bufferedImage) {
        Graphics graphics = bufferedImage.getGraphics();
        this.paintEverything(graphics, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
        Rectangle rectangle = this.viewRect;
        if (rectangle != null) {
            Rectangle rectangle2 = new Rectangle(0, 0, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
            this.messagesPanel.setBounds(rectangle2);
            this.messagesPanel.render(graphics);
            this.messagesPanel.setBounds(rectangle);
        } else {
            this.messagesPanel.render(graphics);
        }
        graphics.dispose();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage render() {
        if (!this.isShowing() || this.isIconified()) {
            this.needsToRecompute = true;
            return null;
        }
        BufferedImage bufferedImage = this.checkImageSize(this.workingImage);
        Object object = bufferedImage;
        synchronized (object) {
            if (this.needResize) {
                this.panel3D.computeConstants(bufferedImage.getWidth(), bufferedImage.getHeight());
                this.needResize = false;
            }
            this.render(bufferedImage);
            this.workingImage = this.offscreenImage;
            this.offscreenImage = bufferedImage;
            this.dirtyImage = false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.paintImmediately(this.getVisibleRect());
        } else {
            object = new Runnable(){

                public void run() {
                    SimpleDrawingPanel3D.this.paintImmediately(SimpleDrawingPanel3D.this.getVisibleRect());
                }
            };
            try {
                SwingUtilities.invokeAndWait((Runnable)object);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        object = this.panel3D.getVideoTool();
        if (object != null && this.offscreenImage != null && object.isRecording()) {
            object.addFrame(this.offscreenImage);
        }
        return bufferedImage;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dirtyImage || this.needsUpdate()) {
            this.render();
        }
    }

    @Override
    public void setIgnoreRepaint(boolean bl) {
        this.messagesPanel.setIgnoreRepaint(bl);
        super.setIgnoreRepaint(bl);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.viewRect = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JViewport) {
                this.viewRect = ((JViewport)container).getViewRect();
                this.messagesPanel.setBounds(this.viewRect);
                break;
            }
            container = container.getParent();
        }
        int n = (this.getWidth() - this.offscreenImage.getWidth()) / 2;
        int n2 = (this.getHeight() - this.offscreenImage.getHeight()) / 2;
        graphics.drawImage(this.offscreenImage, n, n2, null);
        if (this.dirtyImage || this.needsUpdate()) {
            this.updatePanel();
        }
    }

    @Override
    public void invalidate() {
        this.needResize = true;
        super.invalidate();
    }

    private void updatePanel() {
        if (this.getIgnoreRepaint()) {
            return;
        }
        this.updateTimer.setRepeats(false);
        this.updateTimer.setCoalesce(true);
        this.updateTimer.start();
    }

    private final boolean needsUpdate() {
        for (Element element : this.panel3D.getElements()) {
            if (!element.hasChanged()) continue;
            return true;
        }
        return false;
    }

    private BufferedImage checkImageSize(BufferedImage bufferedImage) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n <= 2 || n2 <= 2) {
            return new BufferedImage(1, 1, 1);
        }
        if (bufferedImage == null || n != bufferedImage.getWidth() || n2 != bufferedImage.getHeight()) {
            return this.getGraphicsConfiguration().createCompatibleImage(n, n2);
        }
        return bufferedImage;
    }

    private boolean isIconified() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof Frame) {
            return (((Frame)container).getExtendedState() & 1) == 1;
        }
        return false;
    }

    private synchronized void paintEverything(Graphics graphics, int n, int n2) {
        if (this.needsToRecompute || n != this.getWidth() || n2 != this.getHeight()) {
            this.panel3D.computeConstants(n, n2);
        }
        List<Element> list = this.panel3D.getElements();
        list.addAll(this.panel3D.getDecoration().getElementList());
        graphics.setColor(this.panel3D.getVisualizationHints().getBackgroundColor());
        graphics.fillRect(0, 0, n, n2);
        this.paintDrawableList(graphics, list);
    }

    private void paintDrawableList(Graphics graphics, List<Element> list) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.fastRedraw || !this.panel3D.getVisualizationHints().isRemoveHiddenLines()) {
            for (Element element : list) {
                if (!element.isVisible()) continue;
                element.processChanges(0);
                ((SimpleElement)element.getImplementingObject()).drawQuickly(graphics2D);
            }
            return;
        }
        this.list3D.clear();
        for (Element object3DArray2 : list) {
            if (!object3DArray2.isVisible()) continue;
            ImplementingObject n3 = object3DArray2.getImplementingObject();
            if (!(n3 instanceof SimpleElement)) {
                return;
            }
            object3DArray2.processChanges(0);
            object = ((SimpleElement)n3).getObjects3D();
            if (object == null) continue;
            int n = 0;
            int n2 = ((Object3D[])object).length;
            while (n < n2) {
                if (!Double.isNaN(((Object3D)object[n]).getDistance())) {
                    this.list3D.add((Object3D)object[n]);
                }
                ++n;
            }
        }
        if (this.list3D.size() <= 0) {
            return;
        }
        Object3D[] object3DArray = this.list3D.toArray(new Object3D[0]);
        Arrays.sort(object3DArray, this.comparator);
        int n = 0;
        int n3 = object3DArray.length;
        while (n < n3) {
            object = object3DArray[n];
            ((Object3D)object).getSimpleElement().draw(graphics2D, ((Object3D)object).getIndex());
            ++n;
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        if (graphics == null) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableWidth() / (double)this.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.getHeight();
        double d3 = Math.min(d, d2);
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.scale(d3, d3);
        this.paintEverything(graphics2D, this.getWidth(), this.getHeight());
        return 0;
    }

    @Override
    public void visualizationChanged(int n) {
    }
}

