/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.DelayedAction;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;

public abstract class Animation
implements Runnable {
    private static final ThreadGroup sEJSThreadGroup = new ThreadGroup("EJS thread group");
    public static int MAXIMUM_FPS = 25;
    public static final int MINIMUM_FPS = 1;
    public static final int MINIMUM_DELAY = 10;
    private volatile Thread animationThread = null;
    private volatile boolean mustUpdateWhenIdle = false;
    private List<DelayedAction> methodList = new ArrayList<DelayedAction>();
    private Set<String> variablesToApply = new HashSet<String>();
    private volatile boolean invokingDelayedActions = false;
    private boolean autoplay = false;
    protected volatile boolean isPlaying = false;
    protected boolean abortSPDLoop = false;
    protected boolean updateView = true;
    private int stepsPerDisplay = 1;
    private long delay = 10L;
    protected String resetFile = null;
    protected Model model = null;
    protected View view = null;
    protected Animation master = null;
    protected ArrayList<Model> slaveList = new ArrayList();
    private double initialRealTime = Double.NaN;

    public static ThreadGroup getThreadGroup() {
        return sEJSThreadGroup;
    }

    public final Model getModel() {
        return this.model;
    }

    public final void setModel(Model model) {
        this.model = model;
        LauncherApplet launcherApplet = this.model._getApplet();
        if (launcherApplet != null) {
            String string = launcherApplet.getParameter("initialStateFromURL");
            if (string != null) {
                this.resetFile = string.trim();
                if (!this.resetFile.startsWith("http://")) {
                    if (this.resetFile.startsWith("./")) {
                        this.resetFile = this.resetFile.substring(2);
                    }
                    this.resetFile = launcherApplet.getCodeBase() + this.resetFile;
                }
                this.resetFile = "url:" + this.resetFile;
            } else {
                string = launcherApplet.getParameter("initialState");
                if (string != null) {
                    this.resetFile = string.trim();
                }
            }
        }
    }

    public final View getView() {
        return this.view;
    }

    public final void setView(View view) {
        this.view = view;
    }

    public final void setFPS(int n) {
        this.delay = n <= 1 ? 1000L : (n >= MAXIMUM_FPS ? 10L : Math.max((long)(1000.0 / (double)n), 10L));
    }

    public final void setDelay(int n) {
        this.delay = Math.max((long)n, 0L);
    }

    public final int getDelay() {
        return (int)this.delay;
    }

    public final void setStepsPerDisplay(int n) {
        if (n >= 1) {
            this.stepsPerDisplay = n;
        }
    }

    public final void setUpdateView(boolean bl) {
        this.updateView = bl;
    }

    public final void setAutoplay(boolean bl) {
        this.autoplay = bl;
    }

    public final boolean isPlaying() {
        return this.isPlaying && this.animationThread != null;
    }

    public final boolean isPaused() {
        return !this.isPlaying();
    }

    public void resetRealTime() {
        this.initialRealTime = 1000.0 * this.getModel()._getRealTime() - (double)System.currentTimeMillis();
    }

    public synchronized void play() {
        if (this.master != null) {
            this.getTopMaster().play();
            return;
        }
        if (this.animationThread != null) {
            return;
        }
        this.animationThread = this.model._isApplet() ? new Thread(this) : new Thread(sEJSThreadGroup, this);
        this.animationThread.setPriority(1);
        this.animationThread.setDaemon(true);
        this.initialRealTime = 1000.0 * this.getModel()._getRealTime() - (double)System.currentTimeMillis();
        this.animationThread.start();
        this.isPlaying = true;
        for (Model model : this.slaveList) {
            model._getSimulation().isPlaying = true;
        }
    }

    public synchronized void pause() {
        if (this.master != null) {
            this.getTopMaster().pause();
            return;
        }
        if (this.animationThread == null) {
            return;
        }
        Thread thread = this.animationThread;
        this.animationThread = null;
        this.isPlaying = false;
        this.abortSPDLoop = true;
        for (Model model : this.slaveList) {
            model._getSimulation().isPlaying = false;
            model._getSimulation().abortSPDLoop = true;
        }
        if (Thread.currentThread() == thread) {
            return;
        }
        try {
            thread.interrupt();
            thread.join(100L);
        }
        catch (Exception exception) {}
    }

    public void run() {
        while (this.animationThread == Thread.currentThread()) {
            long l = System.currentTimeMillis();
            this.step();
            for (Model model : this.slaveList) {
                model._getSimulation().step();
            }
            if (this.applyVariablesWhenIdle() || this.checkMethodsInvokedByView()) {
                this.model._automaticResetSolvers();
                this.update();
            } else if (this.mustUpdateWhenIdle) {
                this.update();
            }
            long l2 = Double.isNaN(this.initialRealTime) ? this.delay - (System.currentTimeMillis() - l) : (long)(1000.0 * this.getModel()._getRealTime() - (double)System.currentTimeMillis() - this.initialRealTime);
            if (l2 < 10L) {
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.applyVariablesWhenIdle() || this.checkMethodsInvokedByView()) {
            this.model._automaticResetSolvers();
            this.update();
        } else if (this.mustUpdateWhenIdle) {
            this.update();
        }
    }

    public void onExit() {
        this.animationThread = null;
        this.isPlaying = false;
        this.abortSPDLoop = true;
        this.checkMethodsInvokedByView();
        if (this.model._isApplet()) {
            this.view.onExit();
            this.model._freeMemory();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Animation.this.view.onExit();
                    Animation.this.model._freeMemory();
                }
            });
        }
    }

    protected abstract void userDefinedReset();

    protected abstract void userDefinedViewUpdate();

    protected abstract void resetDescriptionPages();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        this.resetDescriptionPages();
        this.pause();
        if (this.model != null) {
            this.model._resetModel();
        }
        if (this.view != null) {
            this.view.setUpdateSimulation(false);
            this.view.reset();
            this.view.initialize();
        }
        if (this.model != null) {
            this.model._initializeModel();
            this.model._updateModel();
            this.userDefinedReset();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
                this.view.finalUpdate();
                this.userDefinedViewUpdate();
            } else {
                this.view.collectData();
            }
            this.view.setUpdateSimulation(true);
        }
        System.gc();
        ArrayList<Model> arrayList = this.slaveList;
        synchronized (arrayList) {
            this.killAllSimulations();
        }
        if (this.autoplay) {
            this.play();
        }
    }

    public void initialize() {
        if (this.view != null) {
            this.view.read();
            this.view.initialize();
        }
        if (this.model != null) {
            this.model._initializeModel();
            this.model._updateModel();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
                this.view.finalUpdate();
                this.userDefinedViewUpdate();
            } else {
                this.view.collectData();
            }
        }
    }

    public void apply() {
        this.view.read();
        this.update();
    }

    public final void applyAll() {
        this.view.read();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(String string) {
        if (this.invokingDelayedActions || this.isPaused()) {
            this.view.read(string);
            this.model._automaticResetSolvers();
        } else {
            this.view.blockVariable(string);
            Set<String> set = this.variablesToApply;
            synchronized (set) {
                this.variablesToApply.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyVariablesWhenIdle() {
        HashSet<String> hashSet;
        Set<String> object2 = this.variablesToApply;
        synchronized (object2) {
            block5: {
                if (!this.variablesToApply.isEmpty()) break block5;
                return false;
            }
            hashSet = new HashSet<String>(this.variablesToApply);
            this.variablesToApply.clear();
        }
        this.invokingDelayedActions = true;
        for (String string : hashSet) {
            this.view.read(string);
        }
        this.invokingDelayedActions = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMethodsInvokedByView() {
        ArrayList<DelayedAction> arrayList;
        List<DelayedAction> object2 = this.methodList;
        synchronized (object2) {
            block5: {
                if (!this.methodList.isEmpty()) break block5;
                return false;
            }
            arrayList = new ArrayList<DelayedAction>(this.methodList);
            this.methodList.clear();
        }
        this.invokingDelayedActions = true;
        for (DelayedAction delayedAction : arrayList) {
            delayedAction.performAction();
        }
        this.invokingDelayedActions = false;
        return true;
    }

    public void update() {
        if (this.model != null) {
            this.model._updateModel();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
            } else {
                this.view.collectData();
            }
        }
        this.mustUpdateWhenIdle = false;
        if (this.applyVariablesWhenIdle() || this.checkMethodsInvokedByView()) {
            this.model._automaticResetSolvers();
            if (this.model != null) {
                this.model._updateModel();
            }
            if (this.updateView) {
                this.view.update();
            } else {
                this.view.collectData();
            }
        }
        if (this.updateView) {
            this.view.finalUpdate();
        }
    }

    public final void updateWhenIdle() {
        if (this.invokingDelayedActions || this.isPaused()) {
            this.update();
        } else {
            this.mustUpdateWhenIdle = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeMethodWhenIdle(DelayedAction delayedAction) {
        if (this.invokingDelayedActions || this.isPaused()) {
            delayedAction.performAction();
            this.model._automaticResetSolvers();
        } else {
            List<DelayedAction> list = this.methodList;
            synchronized (list) {
                this.methodList.add(delayedAction);
            }
        }
    }

    public void step() {
        this.abortSPDLoop = false;
        if (this.stepsPerDisplay > 1) {
            int n = 1;
            while (n < this.stepsPerDisplay) {
                if (this.abortSPDLoop) {
                    this.update();
                    if (this.updateView) {
                        this.userDefinedViewUpdate();
                    }
                    return;
                }
                this.model._stepModel();
                this.model._updateModel();
                this.view.collectData();
                ++n;
            }
        }
        this.model._stepModel();
        this.update();
        if (this.updateView) {
            this.userDefinedViewUpdate();
        }
    }

    public void updateAfterModelAction() {
        if (this.master != null) {
            this.getTopMaster().updateAfterModelAction();
            return;
        }
        this.update();
        for (Model model : this.slaveList) {
            model._getSimulation().update();
        }
    }

    public final Model runSimulation() {
        return this.runSimulation(null);
    }

    public final Model runSimulation(String string) {
        try {
            Animation animation;
            Class<?> clazz = string == null ? this.getModel().getClass() : Class.forName(string);
            Model model = (Model)clazz.newInstance();
            model._getSimulation().master = animation = this.getTopMaster();
            model._getSimulation().isPlaying = this.isPlaying;
            model._getSimulation().update();
            animation.slaveList.add(model);
            return model;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final void freeSimulation(Model model) {
        if (model == null) {
            return;
        }
        try {
            Animation animation = this.getTopMaster();
            animation.slaveList.remove(model);
            model._getSimulation().master = null;
            if (model._getView() instanceof EjsControl) {
                ((EjsControl)((Object)model._getView())).undoReparenting();
            }
            if (animation.isPlaying) {
                model._getSimulation().play();
            } else {
                model._getSimulation().isPlaying = false;
            }
            model._getSimulation().update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void killSimulation(Model model) {
        if (model == null) {
            return;
        }
        this.freeSimulation(model);
        model._getSimulation().pause();
        if (model._getView() instanceof EjsControl) {
            ((EjsControl)((Object)model._getView())).dispose();
        }
    }

    public final synchronized void killAllSimulations() {
        ArrayList<Model> arrayList = this.slaveList;
        this.slaveList = new ArrayList();
        for (Model model : arrayList) {
            model._getSimulation().pause();
            model._getSimulation().master = null;
            if (!(model._getView() instanceof EjsControl)) continue;
            ((EjsControl)((Object)model._getView())).undoReparenting();
            ((EjsControl)((Object)model._getView())).dispose();
        }
    }

    public final Model getTopSimulation() {
        return this.getTopMaster().getModel();
    }

    private final Animation getTopMaster() {
        if (this.master == null) {
            return this;
        }
        Animation animation = this.master;
        while (animation.master != null) {
            animation = animation.master;
        }
        return animation;
    }
}

