/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.Polynomial;

public class PolynomialLeastSquareFit
extends Polynomial {
    double[][] systemMatrix;
    double[] systemConstants;

    public PolynomialLeastSquareFit(double[] dArray, double[] dArray2, int n) {
        super(new double[n + 1]);
        int n2 = n + 1;
        this.systemMatrix = new double[n2][n2];
        this.systemConstants = new double[n2];
        this.fitData(dArray, dArray2);
    }

    public PolynomialLeastSquareFit(double[] dArray) {
        super(dArray);
        int n = dArray.length;
        this.systemMatrix = new double[n][n];
        this.systemConstants = new double[n];
    }

    public void fitData(double[] dArray, double[] dArray2) {
        int n;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of equal length.");
        }
        if (dArray.length < this.degree() + 1) {
            return;
        }
        int n2 = 0;
        while (n2 < this.systemConstants.length) {
            this.systemConstants[n2] = 0.0;
            n = 0;
            while (n < this.systemConstants.length) {
                this.systemMatrix[n2][n] = 0.0;
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        n = dArray.length;
        while (n2 < n) {
            double d = 1.0;
            int n3 = 0;
            while (n3 < this.systemConstants.length) {
                int n4 = n3;
                this.systemConstants[n4] = this.systemConstants[n4] + d * dArray2[n2];
                double d2 = d;
                int n5 = 0;
                while (n5 <= n3) {
                    double[] dArray3 = this.systemMatrix[n3];
                    int n6 = n5++;
                    dArray3[n6] = dArray3[n6] + d2;
                    d2 *= dArray[n2];
                }
                d *= dArray[n2];
                ++n3;
            }
            ++n2;
        }
        this.computeCoefficients();
    }

    protected void computeCoefficients() {
        int n = 0;
        while (n < this.systemConstants.length) {
            int n2 = n + 1;
            while (n2 < this.systemConstants.length) {
                this.systemMatrix[n][n2] = this.systemMatrix[n2][n];
                ++n2;
            }
            ++n;
        }
        LUPDecomposition lUPDecomposition = new LUPDecomposition(this.systemMatrix);
        double[][] dArray = lUPDecomposition.inverseMatrixComponents();
        LUPDecomposition.symmetrizeComponents(dArray);
        this.coefficients = lUPDecomposition.solve(this.systemConstants);
    }
}

