/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.opensourcephysics.controls.ConsoleFormatter;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.LoggerOutputStream;
import org.opensourcephysics.controls.MessageFrame;
import org.opensourcephysics.controls.OSPLogHandler;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSPLog
extends JFrame {
    private static OSPLog OSPLOG;
    private static JFileChooser chooser;
    protected static Style black;
    protected static Style red;
    protected static Style blue;
    protected static Style green;
    protected static Style magenta;
    protected static Style gray;
    protected static final Color DARK_GREEN;
    protected static final Color DARK_BLUE;
    protected static final Color DARK_RED;
    public static final Level[] levels;
    private static Level defaultLevel;
    public static final int OUT_OF_MEMORY_ERROR = 1;
    protected static boolean logConsole;
    private Logger logger;
    private Handler fileHandler;
    private OSPLogHandler logHandler;
    private JTextPane textPane;
    private String logFileName;
    private String tempFileName;
    private JPanel logPanel;
    private JPopupMenu popup;
    private ButtonGroup popupGroup;
    private ButtonGroup menubarGroup;
    private String pkgName;
    private String bundleName;
    private JMenuItem logToFileItem;
    private boolean hasPermission = true;
    private static LogRecord[] messageStorage;
    private static int messageIndex;
    static String eol;
    static String logdir;
    static String slash;

    static {
        DARK_GREEN = new Color(0, 128, 0);
        DARK_BLUE = new Color(0, 0, 128);
        DARK_RED = new Color(128, 0, 0);
        levels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, ConsoleLevel.ERR_CONSOLE, ConsoleLevel.OUT_CONSOLE, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
        defaultLevel = ConsoleLevel.OUT_CONSOLE;
        logConsole = true;
        messageStorage = new LogRecord[128];
        messageIndex = 0;
        eol = "\n";
        logdir = ".";
        slash = "/";
        try {
            eol = System.getProperty("line.separator", eol);
            logdir = System.getProperty("user.home", logdir);
            slash = System.getProperty("file.separator", "/");
        }
        catch (Exception exception) {}
    }

    public static OSPLog getOSPLog() {
        if (OSPLOG == null && !OSPRuntime.appletMode && OSPRuntime.applet == null) {
            OSPLOG = new OSPLog("org.opensourcephysics", null);
            try {
                System.setOut(new PrintStream(new LoggerOutputStream(ConsoleLevel.OUT_CONSOLE, System.out)));
                System.setErr(new PrintStream(new LoggerOutputStream(ConsoleLevel.ERR_CONSOLE, System.err)));
            }
            catch (SecurityException securityException) {}
            OSPLog.setLevel(defaultLevel);
        }
        return OSPLOG;
    }

    public void setLogDir(String string) {
        logdir = string;
    }

    public String getLogDir() {
        return logdir;
    }

    public static boolean isLogVisible() {
        if ((OSPRuntime.appletMode || OSPRuntime.applet != null) && MessageFrame.APPLET_MESSAGEFRAME != null) {
            return MessageFrame.APPLET_MESSAGEFRAME.isVisible();
        }
        if (OSPLOG != null) {
            return OSPLOG.isVisible();
        }
        return false;
    }

    @Override
    public void setVisible(boolean bl) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.showLog(bl);
        } else {
            super.setVisible(bl);
        }
    }

    @Override
    public boolean isVisible() {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            return MessageFrame.isLogVisible();
        }
        return super.isVisible();
    }

    public static JFrame showLog() {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            return MessageFrame.showLog(true);
        }
        OSPLog.getOSPLog().setVisible(true);
        Logger logger = OSPLOG.getLogger();
        int n = 0;
        int n2 = messageStorage.length;
        while (n < n2) {
            LogRecord logRecord = messageStorage[(n + messageIndex) % n2];
            if (logRecord != null) {
                logger.log(logRecord);
            }
            ++n;
        }
        messageIndex = 0;
        return OSPLog.getOSPLog();
    }

    public static void showLogInvokeLater() {
        Runnable runnable = new Runnable(){

            public void run() {
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public static void setLevel(Level level) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.setLevel(level);
        } else {
            try {
                OSPLog.getOSPLog().getLogger().setLevel(level);
            }
            catch (Exception exception) {}
            if (OSPLog.getOSPLog() == null || OSPLog.getOSPLog().menubarGroup == null) {
                return;
            }
            int n = 0;
            while (n < 2) {
                Enumeration<AbstractButton> enumeration = OSPLog.getOSPLog().menubarGroup.getElements();
                if (n == 1) {
                    enumeration = OSPLog.getOSPLog().popupGroup.getElements();
                }
                while (enumeration.hasMoreElements()) {
                    JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
                    if (!OSPLog.getOSPLog().getLogger().getLevel().toString().equals(jMenuItem.getActionCommand())) continue;
                    jMenuItem.setSelected(true);
                    break;
                }
                ++n;
            }
        }
    }

    public static Level parseLevel(String string) {
        int n = 0;
        while (n < levels.length) {
            if (levels[n].getName().equals(string)) {
                return levels[n];
            }
            ++n;
        }
        return null;
    }

    public static void severe(String string) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.severe(string);
        } else {
            OSPLog.log(Level.SEVERE, string);
        }
    }

    public static void warning(String string) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.warning(string);
        } else {
            OSPLog.log(Level.WARNING, string);
        }
    }

    public static void info(String string) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.info(string);
        } else {
            OSPLog.log(Level.INFO, string);
        }
    }

    public static void config(String string) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.config(string);
        } else {
            OSPLog.log(Level.CONFIG, string);
        }
    }

    public static void fine(String string) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.fine(string);
        } else {
            OSPLog.log(Level.FINE, string);
        }
    }

    public static void clearLog() {
        messageIndex = 0;
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.clear();
        } else {
            OSPLOG.clear();
        }
    }

    public static void finer(String string) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.finer(string);
        } else {
            OSPLog.log(Level.FINER, string);
        }
    }

    public static void finest(String string) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            MessageFrame.finest(string);
        } else {
            OSPLog.log(Level.FINEST, string);
        }
    }

    public static void setConsoleMessagesLogged(boolean bl) {
        logConsole = bl;
    }

    public static boolean isConsoleMessagesLogged() {
        return logConsole;
    }

    public OSPLog(Package package_) {
        this(package_.getName(), (String)null);
    }

    public OSPLog(Package package_, String string) {
        this(package_.getName(), string);
    }

    public OSPLog(Class<?> clazz) {
        this(clazz, null);
    }

    public OSPLog(Class<?> clazz, String string) {
        this(clazz.getPackage().getName(), string);
    }

    public JPanel getLogPanel() {
        return this.logPanel;
    }

    public void clear() {
        this.textPane.setText(null);
    }

    public String saveLog(String string) {
        if (string == null || string.trim().equals("")) {
            return this.saveLogAs();
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(this.textPane.getText());
            bufferedWriter.flush();
            bufferedWriter.close();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String saveLogAs() {
        int n = OSPLog.getChooser().showSaveDialog(null);
        if (n == 0) {
            int n2;
            File file = OSPLog.getChooser().getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
                return null;
            }
            String string = XML.getRelativePath(file.getAbsolutePath());
            return this.saveLog(string);
        }
        return null;
    }

    public String saveXML(String string) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            this.logger.log(Level.FINE, "Cannot save XML file when running as an applet.");
            return null;
        }
        if (string == null || string.trim().equals("")) {
            return this.saveXMLAs();
        }
        String string2 = this.read(this.tempFileName);
        Handler handler = this.getFileHandler();
        String string3 = handler.getFormatter().getTail(handler);
        string2 = String.valueOf(string2) + string3;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(string2);
            bufferedWriter.flush();
            bufferedWriter.close();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String saveXMLAs() {
        int n = OSPLog.getChooser().showSaveDialog(null);
        if (n == 0) {
            int n2;
            File file = OSPLog.getChooser().getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
                return null;
            }
            this.logFileName = XML.getRelativePath(file.getAbsolutePath());
            return this.saveXML(this.logFileName);
        }
        return null;
    }

    public String open() {
        int n = OSPLog.getChooser().showOpenDialog(null);
        if (n == 0) {
            File file = OSPLog.getChooser().getSelectedFile();
            String string = XML.getRelativePath(file.getAbsolutePath());
            return this.open(string);
        }
        return null;
    }

    public String open(String string) {
        this.textPane.setText(this.read(string));
        return string;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogToFile(boolean bl) {
        if (OSPRuntime.appletMode || OSPRuntime.applet != null) {
            this.logger.log(Level.FINE, "Cannot log to file when running as an applet.");
            return;
        }
        if (bl) {
            this.logToFileItem.setSelected(true);
            this.logger.addHandler(this.getFileHandler());
        } else {
            this.logToFileItem.setSelected(false);
            this.logger.removeHandler(this.fileHandler);
        }
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    protected void createGUI() {
        this.logPanel = new JPanel(new BorderLayout());
        this.logPanel.setPreferredSize(new Dimension(480, 240));
        this.setContentPane(this.logPanel);
        this.textPane = new JTextPane(){

            public void paintComponent(Graphics graphics) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    RenderingHints renderingHints = graphics2D.getRenderingHints();
                    renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(graphics);
            }
        };
        this.textPane.setEditable(false);
        this.textPane.setAutoscrolls(true);
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setWheelScrollingEnabled(true);
        this.logPanel.add((Component)jScrollPane, "Center");
        black = StyleContext.getDefaultStyleContext().getStyle("default");
        red = this.textPane.addStyle("red", black);
        StyleConstants.setForeground(red, DARK_RED);
        blue = this.textPane.addStyle("blue", black);
        StyleConstants.setForeground(blue, DARK_BLUE);
        green = this.textPane.addStyle("green", black);
        StyleConstants.setForeground(green, DARK_GREEN);
        magenta = this.textPane.addStyle("magenta", black);
        StyleConstants.setForeground(magenta, Color.MAGENTA);
        gray = this.textPane.addStyle("gray", black);
        StyleConstants.setForeground(gray, Color.GRAY);
        this.createLogger();
        this.createMenus();
        this.pack();
        this.textPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    if (OSPRuntime.isPopupTrigger(mouseEvent) && OSPLog.this.popup != null) {
                        OSPLog.this.popup.show(OSPLog.this.textPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Error in mouse action.");
                    System.err.println(exception.toString());
                    exception.printStackTrace();
                }
            }
        });
    }

    protected Logger createLogger() {
        if (this.bundleName != null) {
            try {
                this.logger = Logger.getLogger(this.pkgName, this.bundleName);
            }
            catch (Exception exception) {
                this.logger = Logger.getLogger(this.pkgName);
            }
        } else {
            this.logger = Logger.getLogger(this.pkgName);
        }
        try {
            this.logger.setLevel(defaultLevel);
            this.logHandler = new OSPLogHandler(this.textPane, this);
            this.logHandler.setFormatter(new ConsoleFormatter());
            this.logHandler.setLevel(Level.ALL);
            OSPRuntime.class.getClass();
            this.logger.setUseParentHandlers(false);
            this.logger.addHandler(this.logHandler);
        }
        catch (SecurityException securityException) {
            this.hasPermission = false;
        }
        return this.logger;
    }

    protected synchronized Handler getFileHandler() {
        if (this.fileHandler != null) {
            return this.fileHandler;
        }
        try {
            int n = this.pkgName.lastIndexOf(".");
            if (n > -1) {
                this.pkgName = this.pkgName.substring(n + 1);
            }
            this.tempFileName = logdir.endsWith(slash) ? String.valueOf(logdir) + this.pkgName + ".log" : String.valueOf(logdir) + slash + this.pkgName + ".log";
            this.fileHandler = new FileHandler(this.tempFileName);
            this.fileHandler.setFormatter(new XMLFormatter());
            this.fileHandler.setLevel(Level.ALL);
            this.logger.addHandler(this.fileHandler);
            this.logger.log(Level.INFO, "Logging to file enabled. File = " + this.tempFileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.fileHandler;
    }

    protected void createMenus() {
        Serializable serializable;
        if (!this.hasPermission) {
            return;
        }
        this.popup = new JPopupMenu();
        JMenu jMenu = new JMenu(ControlsRes.getString("OSPLog.Level_menu"));
        this.popup.add(jMenu);
        this.popupGroup = new ButtonGroup();
        int n = 0;
        while (n < levels.length) {
            serializable = new JRadioButtonMenuItem(levels[n].getName());
            jMenu.add((Component)serializable, 0);
            this.popupGroup.add((AbstractButton)serializable);
            if (this.logger.getLevel().toString().equals(levels[n])) {
                ((AbstractButton)serializable).setSelected(true);
            }
            ((AbstractButton)serializable).setActionCommand(levels[n].getName());
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OSPLog.this.logger.setLevel(Level.parse(actionEvent.getActionCommand()));
                    Enumeration<AbstractButton> enumeration = OSPLog.this.menubarGroup.getElements();
                    while (enumeration.hasMoreElements()) {
                        JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
                        if (!OSPLog.this.logger.getLevel().toString().equals(jMenuItem.getActionCommand())) continue;
                        jMenuItem.setSelected(true);
                        break;
                    }
                }
            });
            ++n;
        }
        this.popup.addSeparator();
        AbstractAction abstractAction = new AbstractAction(ControlsRes.getString("OSPLog.Open_popup")){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPLog.this.open();
            }
        };
        abstractAction.setEnabled(!OSPRuntime.appletMode && OSPRuntime.applet == null);
        this.popup.add(abstractAction);
        serializable = new AbstractAction(ControlsRes.getString("OSPLog.SaveAs_popup")){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPLog.this.saveLogAs();
            }
        };
        serializable.setEnabled(!OSPRuntime.appletMode && OSPRuntime.applet == null);
        this.popup.add((Action)((Object)serializable));
        this.popup.addSeparator();
        AbstractAction abstractAction2 = new AbstractAction(ControlsRes.getString("OSPLog.Clear_popup")){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPLog.this.clear();
            }
        };
        this.popup.add(abstractAction2);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenu = new JMenu(ControlsRes.getString("OSPLog.File_menu"));
        jMenuBar.add(jMenu);
        jMenu.add(abstractAction);
        jMenu.add((Action)((Object)serializable));
        jMenu = new JMenu(ControlsRes.getString("OSPLog.Edit_menu"));
        jMenuBar.add(jMenu);
        jMenu.add(abstractAction2);
        jMenu = new JMenu(ControlsRes.getString("OSPLog.Level_menu"));
        jMenuBar.add(jMenu);
        this.menubarGroup = new ButtonGroup();
        int n2 = 0;
        while (n2 < levels.length) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(levels[n2].getName());
            jMenu.add((Component)jRadioButtonMenuItem, 0);
            this.menubarGroup.add(jRadioButtonMenuItem);
            if (this.logger.getLevel().toString().equals(levels[n2])) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.setActionCommand(levels[n2].getName());
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OSPLog.this.logger.setLevel(Level.parse(actionEvent.getActionCommand()));
                    Enumeration<AbstractButton> enumeration = OSPLog.this.popupGroup.getElements();
                    while (enumeration.hasMoreElements()) {
                        JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
                        if (!OSPLog.this.logger.getLevel().toString().equals(jMenuItem.getActionCommand())) continue;
                        jMenuItem.setSelected(true);
                        break;
                    }
                }
            });
            ++n2;
        }
        JMenu jMenu2 = new JMenu(ControlsRes.getString("OSPLog.Options_menu"));
        jMenuBar.add(jMenu2);
        this.logToFileItem = new JCheckBoxMenuItem(ControlsRes.getString("OSPLog.LogToFile_check_box"));
        this.logToFileItem.setSelected(false);
        this.logToFileItem.setEnabled(!OSPRuntime.appletMode && OSPRuntime.applet == null);
        this.logToFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                OSPLog.this.setLogToFile(jCheckBoxMenuItem.isSelected());
            }
        });
        jMenu2.add(this.logToFileItem);
    }

    protected static JFileChooser getChooser() {
        if (chooser == null) {
            chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        }
        return chooser;
    }

    protected String read(String string) {
        File file = new File(string);
        StringBuffer stringBuffer = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            stringBuffer = new StringBuffer();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuffer.append(String.valueOf(string2) + XML.NEW_LINE);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.logger.warning(iOException.toString());
        }
        return stringBuffer.toString();
    }

    private OSPLog(String string, String string2) {
        super(ControlsRes.getString("OSPLog.DefaultTitle"));
        this.setName("LogTool");
        this.bundleName = string2;
        this.pkgName = string;
        ConsoleLevel.class.getName();
        this.createGUI();
        this.setDefaultCloseOperation(1);
    }

    private static void log(Level level, String string) {
        LogRecord logRecord = new LogRecord(level, string);
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = 0;
        while (n < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string2 = stackTraceElement.getClassName();
            if (!string2.equals("org.opensourcephysics.controls.OSPLog")) {
                logRecord.setSourceClassName(string2);
                logRecord.setSourceMethodName(stackTraceElement.getMethodName());
                break;
            }
            ++n;
        }
        if (OSPLOG != null) {
            OSPLOG.getLogger().log(logRecord);
        } else {
            OSPLog.messageStorage[OSPLog.messageIndex] = logRecord;
            ++messageIndex;
            messageIndex %= messageStorage.length;
        }
    }
}

