/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.HashMap;
import java.util.Map;

public class TeXParser {
    public static Map<String, String> charMap = new HashMap<String, String>();

    static {
        charMap.put("\\Alpha", "\u0391");
        charMap.put("\\Beta", "\u0392");
        charMap.put("\\Gamma", "\u0393");
        charMap.put("\\Delta", "\u0394");
        charMap.put("\\Epsilon", "\u0395");
        charMap.put("\\Zeta", "\u0396");
        charMap.put("\\Eta", "\u0397");
        charMap.put("\\Theta", "\u0398");
        charMap.put("\\Iota", "\u0399");
        charMap.put("\\Kappa", "\u039a");
        charMap.put("\\Lambda", "\u039b");
        charMap.put("\\Mu", "\u039c");
        charMap.put("\\Nu", "\u039d");
        charMap.put("\\Xi", "\u039e");
        charMap.put("\\Omicron", "\u039f");
        charMap.put("\\Pi", "\u03a0");
        charMap.put("\\Rho", "\u03a1");
        charMap.put("\\Sigma", "\u03a3");
        charMap.put("\\Tau", "\u03a4");
        charMap.put("\\Upsilon", "\u03a5");
        charMap.put("\\upsih", "\u03d2");
        charMap.put("\\Phi", "\u03a6");
        charMap.put("\\Chi", "\u03a7");
        charMap.put("\\Psi", "\u03a8");
        charMap.put("\\Omega", "\u03a9");
        charMap.put("\\alpha", "\u03b1");
        charMap.put("\\beta", "\u03b2");
        charMap.put("\\gamma", "\u03b3");
        charMap.put("\\delta", "\u03b4");
        charMap.put("\\epsilon", "\u03b5");
        charMap.put("\\zeta", "\u03b6");
        charMap.put("\\eta", "\u03b7");
        charMap.put("\\theta", "\u03b8");
        charMap.put("\\thetasym", "\u03d1");
        charMap.put("\\iota", "\u03b9");
        charMap.put("\\kappa", "\u03ba");
        charMap.put("\\lamda", "\u03bb");
        charMap.put("\\lambda", "\u03bb");
        charMap.put("\\mu", "\u03bc");
        charMap.put("\\micro", "\u03bc");
        charMap.put("\\nu", "\u03bd");
        charMap.put("\\xi", "\u03be");
        charMap.put("\\omicron", "\u03bf");
        charMap.put("\\pi", "\u03c0");
        charMap.put("\\piv", "\u03d6");
        charMap.put("\\rho", "\u03c1");
        charMap.put("\\sigmaf", "\u03c2");
        charMap.put("\\sigma", "\u03c3");
        charMap.put("\\tau", "\u03c4");
        charMap.put("\\upsilon", "\u03c5");
        charMap.put("\\phi", "\u03c6");
        charMap.put("\\chi", "\u03c7");
        charMap.put("\\psi", "\u03c8");
        charMap.put("\\omega", "\u03c9");
        charMap.put("\\degree", "\u00b0");
        charMap.put("\\sqr", "\u00b2");
        charMap.put("\\pm", "\u00b1");
        charMap.put("\\neq", "\u2260");
        charMap.put("\\leq", "\u2264");
        charMap.put("\\geq", "\u00f7");
        charMap.put("\\div", "\u00f7");
        charMap.put("\\perp", "\u27c2");
        charMap.put("\\parallel", "\u2225");
    }

    public static String parseTeX(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\\$");
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            if (bl && (string2 = charMap.get(stringArray[n].trim())) != null) {
                stringArray[n] = string2;
            }
            bl = !bl;
            ++n;
        }
        String string3 = "";
        int n2 = 0;
        while (n2 < stringArray.length) {
            string3 = String.valueOf(string3) + stringArray[n2];
            ++n2;
        }
        return string3;
    }

    public static String removeSubscripting(String string) {
        if (string == null) {
            return null;
        }
        return String.valueOf(TeXParser.removeSubscript(string)) + TeXParser.getSubscript(string);
    }

    public static String removeSubscript(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("_");
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getSubscript(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = "";
        int n2 = string.indexOf("_");
        if (n2 > 0 && (string2 = string.substring(n2 + 1)).startsWith("{") && (n = string2.indexOf("}")) > 0) {
            string2 = string2.substring(1, n);
        }
        return string2;
    }

    public static String addSubscript(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        if ((string2 = string2.trim()).startsWith("{")) {
            int n = string2.indexOf("}");
            if (n == -1) {
                n = string2.length();
            }
            string2 = string2.substring(1, n).trim();
        }
        if (string2.equals("")) {
            return string;
        }
        String string3 = TeXParser.getSubscript(string);
        if (string3 != null) {
            string2 = String.valueOf(string3) + string2;
        }
        return String.valueOf(TeXParser.removeSubscript(string)) + "_{" + string2 + "}";
    }
}

