/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRefreshTool
implements Tool {
    private static Map<Data, DataRefreshTool> tools = new HashMap<Data, DataRefreshTool>();
    private Data data;

    public static DataRefreshTool getTool(Data data) {
        DataRefreshTool dataRefreshTool = tools.get(data);
        if (dataRefreshTool == null) {
            dataRefreshTool = new DataRefreshTool(data);
            tools.put(data, dataRefreshTool);
        }
        return dataRefreshTool;
    }

    private DataRefreshTool(Data data) {
        this.data = data;
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
        Object object2;
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || tool == null || !Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            return;
        }
        Data data = (Data)xMLControlElement.loadObject(null, true, true);
        if (data.getID() == this.data.getID()) {
            xMLControlElement = new XMLControlElement(this.data);
            job.setXML(xMLControlElement.toXML());
            tool.send(job, this);
            return;
        }
        for (Data object22 : DataTool.getSelfContainedData(this.data)) {
            if (data.getID() != object22.getID()) continue;
            xMLControlElement = new XMLControlElement(object22);
            job.setXML(xMLControlElement.toXML());
            tool.send(job, this);
            return;
        }
        ArrayList<Dataset> arrayList = DataTool.getDatasets(this.data);
        for (Object object2 : arrayList) {
            if (data.getID() != ((Dataset)object2).getID()) continue;
            xMLControlElement = new XMLControlElement(object2);
            job.setXML(xMLControlElement.toXML());
            tool.send(job, this);
            return;
        }
        object2 = new DatasetManager();
        ((DatasetManager)object2).setName(data.getName());
        HashMap hashMap = new HashMap();
        for (Dataset dataset : DataTool.getDatasets(data)) {
            Dataset dataset2;
            if (dataset == null || (dataset2 = this.getMatch(dataset.getID(), arrayList)) == null) continue;
            Dataset dataset3 = (Dataset)hashMap.get(dataset2.getID());
            if (dataset3 == null) {
                dataset3 = DataTool.copyDataset(dataset2, null, true);
                dataset3.setXColumnVisible(dataset2.getXColumnName().equals(dataset.getYColumnName()));
                dataset3.setYColumnVisible(dataset2.getYColumnName().equals(dataset.getYColumnName()));
                ((DatasetManager)object2).addDataset(dataset3);
                hashMap.put(dataset2.getID(), dataset3);
                continue;
            }
            if (dataset2.getXColumnName().equals(dataset.getYColumnName())) {
                dataset3.setXColumnVisible(true);
            }
            if (!dataset2.getYColumnName().equals(dataset.getYColumnName())) continue;
            dataset3.setYColumnVisible(true);
        }
        if (!((DatasetManager)object2).getDatasets().isEmpty()) {
            xMLControlElement = new XMLControlElement(object2);
            job.setXML(xMLControlElement.toXML());
            tool.send(job, this);
        }
    }

    private Dataset getMatch(int n, ArrayList<Dataset> arrayList) {
        for (Dataset dataset : arrayList) {
            if (dataset == null || n != dataset.getID()) continue;
            return dataset;
        }
        return null;
    }
}

