/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class DataRaster
implements Measurable {
    public DrawingPanel primaryDrawingPanel = null;
    Color backgroundColor;
    ArrayList<ImageData> imageDatasets = new ArrayList();
    boolean visible = true;
    protected double xmin = -1.0;
    protected double xmax = 1.0;
    protected double ymin = -1.0;
    protected double ymax = 1.0;
    protected int alpha = 255;
    protected BufferedImage image;
    protected int maxPoints = 196607;
    double xppu = 0.0;
    double yppu = 0.0;

    public DataRaster(DrawingPanel drawingPanel, double d, double d2, double d3, double d4) {
        this.primaryDrawingPanel = drawingPanel;
        if (this.primaryDrawingPanel != null) {
            this.primaryDrawingPanel.setPixelScale();
        }
        this.xmin = Math.min(d, d2);
        this.xmax = Math.max(d, d2);
        this.ymin = Math.min(d3, d4);
        this.ymax = Math.max(d3, d4);
        this.image = new BufferedImage(1, 1, 2);
        this.backgroundColor = new Color(this.image.getRGB(0, 0));
    }

    public void append(int n, double d, double d2) {
        this.checkIndex(n).append(d, d2);
    }

    public void setColor(int n, Color color) {
        this.checkIndex(n).setColor(color);
    }

    public void clear() {
        int n = 0;
        int n2 = this.imageDatasets.size();
        while (n < n2) {
            this.imageDatasets.get(n).clear();
            ++n;
        }
        this.render();
    }

    public void clear(int n) {
        if (n < this.imageDatasets.size()) {
            this.imageDatasets.get(n).clear();
            this.render();
        }
    }

    protected ImageData checkIndex(int n) {
        int n2 = this.imageDatasets.size() - 1;
        while (n2 < n) {
            ImageData imageData = new ImageData(DisplayColors.getLineColor(n));
            this.imageDatasets.add(imageData);
            ++n2;
        }
        return this.imageDatasets.get(n);
    }

    public synchronized BufferedImage render() {
        if (this.primaryDrawingPanel == null) {
            return null;
        }
        int n = this.primaryDrawingPanel.xToPix(this.xmax) - this.primaryDrawingPanel.xToPix(this.xmin);
        int n2 = this.primaryDrawingPanel.yToPix(this.ymin) - this.primaryDrawingPanel.yToPix(this.ymax);
        n = Math.min(n, this.primaryDrawingPanel.getWidth());
        n2 = Math.min(n2, this.primaryDrawingPanel.getHeight());
        if (Math.abs(n) == 0 || Math.abs(n2) == 0) {
            return null;
        }
        this.image = new BufferedImage(Math.abs(n), Math.abs(n2), 2);
        this.backgroundColor = new Color(this.image.getRGB(0, 0));
        int n3 = 0;
        int n4 = this.imageDatasets.size();
        while (n3 < n4) {
            this.imageDatasets.get(n3).render();
            ++n3;
        }
        return this.image;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.primaryDrawingPanel != drawingPanel) {
            return;
        }
        int n = drawingPanel.xToPix(this.xmax) - drawingPanel.xToPix(this.xmin);
        int n2 = drawingPanel.yToPix(this.ymin) - drawingPanel.yToPix(this.ymax);
        n = Math.min(n, drawingPanel.getWidth());
        n2 = Math.min(n2, drawingPanel.getHeight());
        if (n == 0 || n == 0) {
            return;
        }
        if (Math.abs(n) != this.image.getWidth() || Math.abs(n2) != this.image.getHeight() || this.xppu != this.primaryDrawingPanel.getXPixPerUnit() || this.yppu != this.primaryDrawingPanel.getYPixPerUnit()) {
            this.render();
        }
        double d = Math.max(this.primaryDrawingPanel.getXMin(), this.xmin);
        double d2 = Math.min(this.primaryDrawingPanel.getYMax(), this.ymax);
        if (this.image != null && this.image.getWidth() > 1) {
            graphics.drawImage(this.image, drawingPanel.xToPix(d), drawingPanel.yToPix(d2), drawingPanel);
        }
    }

    public boolean isMeasured() {
        return true;
    }

    public void setXMin(double d) {
        this.xmin = d;
    }

    public void setXMax(double d) {
        this.xmax = d;
    }

    public void setYMin(double d) {
        this.ymin = d;
    }

    public void setYMax(double d) {
        this.ymax = d;
    }

    public void setMinMax(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double getWidth() {
        return this.image.getRaster().getWidth();
    }

    public double getHeight() {
        return this.image.getRaster().getHeight();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    int xToPix(int n) {
        return (int)((double)this.image.getRaster().getWidth() * ((double)n - this.xmin) / (this.xmax - this.xmin));
    }

    int yToPix(int n) {
        return (int)((double)this.image.getRaster().getHeight() * (this.ymax - (double)n) / (this.ymax - this.ymin));
    }

    public Color getPixColor(int n, int n2) {
        return new Color(this.image.getRGB(n, n2));
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    class ImageData {
        private int[] color;
        float[][] data;
        int nextPoint = 0;

        ImageData(Color color) {
            this.setColor(color);
            this.data = new float[2][64];
        }

        void setColor(Color color) {
            this.color = new int[4];
            this.color[0] = color.getRed();
            this.color[1] = color.getGreen();
            this.color[2] = color.getBlue();
            this.color[3] = DataRaster.this.alpha;
        }

        private synchronized void increaseCapacity(int n) {
            n = Math.min(n, DataRaster.this.maxPoints);
            float[][] fArray = new float[2][n];
            int n2 = Math.min(this.nextPoint, 3 * n / 4);
            System.arraycopy(this.data[0], this.nextPoint - n2, fArray[0], 0, n2);
            System.arraycopy(this.data[1], this.nextPoint - n2, fArray[1], 0, n2);
            this.nextPoint = n2;
            this.data = fArray;
        }

        synchronized void clear() {
            this.data = new float[2][64];
            this.nextPoint = 0;
        }

        void append(double d, double d2) {
            if (Double.isNaN(d) || Double.isInfinite(d) || Double.isNaN(d2) || Double.isInfinite(d2)) {
                return;
            }
            if (this.nextPoint >= this.data[0].length) {
                this.increaseCapacity(this.data[0].length * 2);
            }
            this.data[0][this.nextPoint] = (float)d;
            this.data[1][this.nextPoint] = (float)d2;
            ++this.nextPoint;
            WritableRaster writableRaster = DataRaster.this.image.getRaster();
            if (writableRaster.getWidth() < 2) {
                return;
            }
            double d3 = Math.max(DataRaster.this.primaryDrawingPanel.getXMin(), DataRaster.this.xmin);
            double d4 = Math.min(DataRaster.this.primaryDrawingPanel.getYMax(), DataRaster.this.ymax);
            int n = (int)(DataRaster.this.primaryDrawingPanel.getXPixPerUnit() * (d - d3) + 0.5);
            int n2 = (int)(DataRaster.this.primaryDrawingPanel.getYPixPerUnit() * (d4 - d2) + 0.5);
            if (n < 0 || n2 < 0 || n >= writableRaster.getWidth() || n2 >= writableRaster.getHeight()) {
                return;
            }
            try {
                writableRaster.setPixel(n, n2, this.color);
            }
            catch (Exception exception) {
                System.out.println("Error setting raster in ImageData append.");
            }
        }

        void render() {
            WritableRaster writableRaster = DataRaster.this.image.getRaster();
            double d = Math.max(DataRaster.this.primaryDrawingPanel.getXMin(), DataRaster.this.xmin);
            double d2 = Math.min(DataRaster.this.primaryDrawingPanel.getYMax(), DataRaster.this.ymax);
            DataRaster.this.xppu = DataRaster.this.primaryDrawingPanel.getXPixPerUnit();
            DataRaster.this.yppu = DataRaster.this.primaryDrawingPanel.getYPixPerUnit();
            int n = 0;
            while (n < this.nextPoint) {
                int n2 = (int)(DataRaster.this.xppu * ((double)this.data[0][n] - d) + 0.5);
                int n3 = (int)(DataRaster.this.yppu * (d2 - (double)this.data[1][n]) + 0.5);
                if (n2 >= 0 && n3 >= 0 && n2 < writableRaster.getWidth() && n3 < writableRaster.getHeight()) {
                    try {
                        writableRaster.setPixel(n2, n3, this.color);
                    }
                    catch (Exception exception) {
                        System.out.println("Error setting raster in ImageData render.");
                    }
                }
                ++n;
            }
        }
    }
}

