/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlComboBox
extends ControlSwingElement {
    private static final int COMBOBOX_ADDED = 6;
    private static final int VARIABLE = 0;
    private static final int VALUE = 1;
    private static final int COMBO_FOREGROUND1 = 12;
    protected JComboBox combo;
    private Component editorComponent;
    private String optionsString;
    private StringValue internalValue;
    private boolean defaultValueSet;
    private boolean defaultEditable;
    private boolean doNotUpdate = false;
    private String defaultValue;
    private Color defaultColor;
    private Color editingColor;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.combo = new JComboBox();
        this.defaultEditable = this.combo.isEditable();
        this.combo.addActionListener(new MyActionListener());
        this.editorComponent = this.combo.getEditor().getEditorComponent();
        this.editorComponent.addKeyListener(new MyKeyListener());
        this.defaultValue = "";
        this.defaultValueSet = false;
        this.internalValue = new StringValue(this.defaultValue);
        this.decideColors(this.editorComponent.getBackground());
        return this.combo;
    }

    @Override
    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.internalValue.value = this.defaultValue;
            this.variableChanged(0, this.internalValue);
            this.invokeActions();
        }
    }

    private void setTheValue(String string) {
        if (this.internalValue.value != null && this.internalValue.value.equals(string)) {
            return;
        }
        this.doNotUpdate = true;
        this.internalValue.value = string;
        this.combo.setSelectedItem(this.internalValue.value);
        this.setColor(this.defaultColor);
        this.variableChanged(0, this.internalValue);
        this.invokeActions();
        this.doNotUpdate = false;
    }

    private void setTheOptions(String string) {
        if (string == null) {
            if (this.optionsString != null) {
                this.combo.removeAllItems();
                this.optionsString = null;
            }
            return;
        }
        if (string.equals(this.optionsString)) {
            return;
        }
        this.doNotUpdate = true;
        this.combo.removeAllItems();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            this.combo.addItem(TeXParser.parseTeX(stringTokenizer.nextToken()));
        }
        this.optionsString = string;
        this.doNotUpdate = false;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("editBackground");
            infoList.add("action");
            infoList.add("options");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("options")) {
            return "String PREVIOUS TRANSLATABLE";
        }
        if (string.equals("variable")) {
            return "String VARIABLE_EXPECTED";
        }
        if (string.equals("value")) {
            return "String CONSTANT TRANSLATABLE";
        }
        if (string.equals("editable")) {
            return "boolean";
        }
        if (string.equals("editBackground")) {
            return "Color|Object";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setTheValue(value.getString());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = value.getString();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                this.combo.setEditable(value.getBoolean());
                break;
            }
            case 3: {
                if (value.getObject() instanceof Color) {
                    this.editorComponent.setBackground((Color)value.getObject());
                }
                this.decideColors(this.editorComponent.getBackground());
                break;
            }
            case 4: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 5: {
                this.setTheOptions(value.getString());
                break;
            }
            default: {
                super.setValue(n - 6, value);
                break;
            }
            case 12: {
                super.setValue(6, value);
                if (!(value.getObject() instanceof Color)) break;
                this.editorComponent.setForeground((Color)value.getObject());
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.combo.setEditable(this.defaultEditable);
                break;
            }
            case 3: {
                this.editorComponent.setBackground(Color.white);
                this.decideColors(this.editorComponent.getBackground());
                break;
            }
            case 4: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 5: {
                this.setTheOptions(null);
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
                break;
            }
            case 12: {
                super.setDefaultValue(6);
                this.editorComponent.setForeground(Color.black);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "" + this.defaultEditable;
            }
            case 3: {
                return "WHITE";
            }
            case 4: {
                return "<no_action>";
            }
            case 5: {
                return "<none>";
            }
            default: {
                return super.getDefaultValueString(n - 6);
            }
            case 12: 
        }
        return super.getDefaultValueString(6);
    }

    private void setColor(Color color) {
        if (this.combo.isEditable()) {
            this.editorComponent.setBackground(color);
        }
    }

    private void decideColors(Color color) {
        if (color == null) {
            return;
        }
        this.defaultColor = color;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
    }

    private void acceptValue() {
        if (this.doNotUpdate) {
            return;
        }
        this.internalValue.value = (String)this.combo.getSelectedItem();
        this.variableChanged(0, this.internalValue);
        this.invokeActions();
        if (this.isUnderEjs && this.internalValue.value != null) {
            this.setFieldListValueWithAlternative(0, 1, this.internalValue);
        }
        this.setColor(this.defaultColor);
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlComboBox.this.acceptValue();
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 0);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 1);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 2);
        }

        private void processKeyEvent(KeyEvent keyEvent, int n) {
            if (!ControlComboBox.this.combo.isEditable()) {
                return;
            }
            if (keyEvent.getKeyChar() != '\n') {
                ControlComboBox.this.setColor(ControlComboBox.this.editingColor);
            }
            if (keyEvent.getKeyCode() == 27) {
                ControlComboBox.this.setValue(0, ControlComboBox.this.internalValue);
            }
        }
    }
}

