/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlTextField
extends ControlSwingElement {
    static final int TEXTFIELD_ADDED = 5;
    protected static final int VARIABLE = 0;
    protected static final int VALUE = 1;
    private static final int FIELD_BACKGROUND = 12;
    private static final int FIELD_FOREGROUND = 11;
    protected boolean inputError = false;
    protected JTextField textfield;
    protected StringValue internalValue;
    protected boolean defaultValueSet;
    protected String defaultValue;
    protected boolean foregroundSet;
    protected Color defaultColor;
    protected Color editingColor;
    protected Color errorColor;
    protected int defaultColumns;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.textfield = new JTextField();
        this.textfield.setText("");
        this.defaultValue = this.textfield.getText();
        this.defaultColumns = this.textfield.getColumns();
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new MyKeyListener());
        this.defaultValueSet = false;
        this.internalValue = new StringValue(this.defaultValue);
        this.textfield.setBackground(Color.WHITE);
        this.textfield.setForeground(Color.BLACK);
        this.foregroundSet = false;
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    protected int getVariableIndex() {
        return 0;
    }

    protected int getValueIndex() {
        return 1;
    }

    @Override
    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(String string) {
        if (this.internalValue.value != null && this.internalValue.value.equals(string)) {
            return;
        }
        this.internalValue.value = string;
        this.textfield.setText(this.internalValue.value);
        if (this.inputError) {
            this.setColor(this.errorColor);
        } else {
            this.setColor(this.defaultColor);
        }
    }

    protected void setInternalValue(String string) {
        this.internalValue.value = string;
        this.variableChanged(this.getVariableIndex(), this.internalValue);
        this.invokeActions();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("action");
            infoList.add("columns");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "String VARIABLE_EXPECTED";
        }
        if (string.equals("value")) {
            return "String CONSTANT TRANSLATABLE";
        }
        if (string.equals("editable")) {
            return "boolean";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("columns")) {
            return "int";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setTheValue(value.getString());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = value.getString();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                if (value.getBoolean()) {
                    this.textfield.setEditable(true);
                    if (this.foregroundSet) break;
                    this.textfield.setForeground(Color.BLACK);
                    break;
                }
                this.textfield.setEditable(false);
                if (this.foregroundSet) break;
                this.textfield.setForeground(Color.GRAY);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 4: {
                if (value.getInteger() == this.textfield.getColumns()) break;
                this.textfield.setColumns(value.getInteger());
                if (this.textfield.getParent() == null) break;
                this.textfield.getParent().validate();
                break;
            }
            default: {
                super.setValue(n - 5, value);
                break;
            }
            case 12: {
                super.setValue(7, value);
                this.decideColors(this.getVisual().getBackground());
                this.setColor(this.defaultColor);
                break;
            }
            case 11: {
                super.setValue(6, value);
                this.foregroundSet = true;
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.textfield.setEditable(true);
                if (this.foregroundSet) break;
                this.textfield.setForeground(Color.BLACK);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 4: {
                this.textfield.setColumns(this.defaultColumns);
                if (this.textfield.getParent() == null) break;
                this.textfield.getParent().validate();
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
                break;
            }
            case 12: {
                super.setDefaultValue(7);
                this.decideColors(this.getVisual().getBackground());
                this.setColor(this.defaultColor);
                break;
            }
            case 11: {
                super.setDefaultValue(6);
                this.foregroundSet = false;
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return "<none>";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "<no_action>";
            }
            case 4: {
                return Integer.toString(this.defaultColumns);
            }
            default: {
                return super.getDefaultValueString(n - 5);
            }
            case 12: {
                return "WHITE";
            }
            case 11: 
        }
        return "BLACK/GRAY";
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }

    protected final void setColor(Color color) {
        this.textfield.setBackground(color);
    }

    protected void decideColors(Color color) {
        if (color == null) {
            return;
        }
        this.defaultColor = color;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }

    private void acceptValue() {
        this.setInternalValue(this.textfield.getText());
        if (this.isUnderEjs) {
            this.setFieldListValueWithAlternative(this.getVariableIndex(), this.getValueIndex(), this.internalValue);
        }
        if (this.inputError) {
            this.setColor(this.errorColor);
        } else {
            this.setColor(this.defaultColor);
        }
    }

    protected class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ControlTextField.this.textfield.isEditable()) {
                ControlTextField.this.acceptValue();
            }
        }
    }

    protected class MyKeyListener
    implements KeyListener {
        protected MyKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 0);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 1);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 2);
        }

        private void processKeyEvent(KeyEvent keyEvent, int n) {
            if (!ControlTextField.this.textfield.isEditable()) {
                return;
            }
            if (keyEvent.getKeyChar() != '\n') {
                ControlTextField.this.setColor(ControlTextField.this.editingColor);
            }
            if (keyEvent.getKeyCode() == 27) {
                ControlTextField.this.textfield.setText(ControlTextField.this.internalValue.value);
                ControlTextField.this.setColor(ControlTextField.this.defaultColor);
            }
        }
    }
}

