/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.AbstractExplicitRKSolverInterpolator;

public class EulerRichardson
extends AbstractExplicitRKSolverInterpolator {
    private double[] rate2;
    private double[] K2;

    public EulerRichardson(ODE oDE) {
        this.ode = oDE;
    }

    protected int getNumberOfEvaluations() {
        return 2;
    }

    protected void allocateOtherArrays() {
        this.rate2 = new double[this.dimension];
        this.K2 = new double[this.dimension];
    }

    protected void computeOneStep() {
        super.computeOneStep();
        System.arraycopy(this.rate2, 0, this.K2, 0, this.dimension);
    }

    protected double[] computeIntermediateStep(double d, double[] dArray) {
        int n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * this.initialRate[n] / 2.0;
            ++n;
        }
        this.ode.getRate(dArray, this.rate2);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * this.rate2[n];
            ++n;
        }
        return dArray;
    }

    public double[] interpolate(double d, boolean bl, double[] dArray) {
        double d2 = d - this.initialTime;
        double d3 = d2 * d2 / this.stepSize;
        double d4 = d2 - d3;
        int n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d4 * this.initialRate[n] + d3 * this.K2[n];
            ++n;
        }
        return dArray;
    }
}

