/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.DataTableModel;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.SortDecorator;
import org.opensourcephysics.display.TeXParser;

public class DataTable
extends JTable
implements ActionListener {
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    static final String NO_PATTERN = DisplayRes.getString("DataTable.FormatDialog.NoFormat");
    public static String rowName = DisplayRes.getString("DataTable.Header.Row");
    private final SortDecorator decorator;
    protected HashMap<String, PrecisionRenderer> precisionRenderersByColumnName = new HashMap();
    protected HashMap<String, UnitRenderer> unitRenderersByColumnName = new HashMap();
    DataTableModel dataTableModel;
    protected RowNumberRenderer rowNumberRenderer;
    int maximumFractionDigits = 3;
    int refreshDelay = 0;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    protected int labelColumnWidth = 40;
    protected int minimumDataColumnWidth = 24;
    protected NumberFormatDialog formatDialog;
    protected int clickCountToSort = 1;

    public DataTable() {
        this(new DefaultDataTableModel());
    }

    public DataTable(DataTableModel dataTableModel) {
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setModel(dataTableModel);
        this.setColumnSelectionAllowed(true);
        this.setGridColor(Color.blue);
        this.setSelectionBackground(LIGHT_BLUE);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setForeground(Color.blue);
        HeaderRenderer headerRenderer = new HeaderRenderer(this.getTableHeader().getDefaultRenderer());
        this.getTableHeader().setDefaultRenderer(headerRenderer);
        this.setSelectionForeground(Color.red);
        this.setColumnModel(new DataTableColumnModel());
        this.setSelectionMode(1);
        this.setColumnSelectionAllowed(true);
        this.decorator = new SortDecorator(this.getModel());
        this.setModel(this.decorator);
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!(OSPRuntime.isPopupTrigger(mouseEvent) || mouseEvent.isControlDown() || mouseEvent.isShiftDown() || mouseEvent.getClickCount() != DataTable.this.clickCountToSort)) {
                    TableColumnModel tableColumnModel = DataTable.this.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    int n2 = DataTable.this.convertColumnIndexToModel(n);
                    DataTable.this.decorator.sort(n2);
                }
            }
        });
    }

    public void setMaximumFractionDigits(String string, int n) {
        this.precisionRenderersByColumnName.put(string, new PrecisionRenderer(n));
    }

    public void setFormatPattern(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            this.precisionRenderersByColumnName.remove(string);
        } else {
            this.precisionRenderersByColumnName.put(string, new PrecisionRenderer(string2));
        }
    }

    public void setUnits(String string, String string2, String string3) {
        if (string2 == null) {
            this.unitRenderersByColumnName.remove(string);
        } else {
            TableCellRenderer tableCellRenderer = this.getDefaultRenderer(Double.class);
            for (String object2 : this.precisionRenderersByColumnName.keySet()) {
                if (!object2.equals(string)) continue;
                tableCellRenderer = this.precisionRenderersByColumnName.get(string);
            }
            UnitRenderer unitRenderer = new UnitRenderer(tableCellRenderer, string2, string3);
            this.unitRenderersByColumnName.put(string, unitRenderer);
        }
    }

    public String getFormatPattern(String string) {
        PrecisionRenderer precisionRenderer = this.precisionRenderersByColumnName.get(string);
        return precisionRenderer == null ? "" : precisionRenderer.pattern;
    }

    public String[] getFormattedColumnNames() {
        return this.precisionRenderersByColumnName.keySet().toArray(new String[0]);
    }

    public Object getFormattedValueAt(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        if (object == null) {
            return null;
        }
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, 0, 0);
        if (component instanceof JLabel) {
            int n3;
            String string;
            String string2 = ((JLabel)component).getText().trim();
            if (tableCellRenderer instanceof UnitRenderer && !"".equals(string = ((UnitRenderer)tableCellRenderer).units) && (n3 = string2.lastIndexOf(string)) > -1) {
                string2 = string2.substring(0, n3);
            }
            return string2;
        }
        return object;
    }

    public NumberFormatDialog getFormatDialog(String[] stringArray, String[] stringArray2) {
        if (this.formatDialog == null) {
            this.formatDialog = new NumberFormatDialog();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.formatDialog.getBounds().width) / 2;
            int n2 = (dimension.height - this.formatDialog.getBounds().height) / 2;
            this.formatDialog.setLocation(n, n2);
        }
        this.formatDialog.setColumns(stringArray, stringArray2);
        return this.formatDialog;
    }

    public void sort(int n) {
        this.decorator.sort(n);
    }

    public int getSortedColumn() {
        return this.decorator.getSortedColumn();
    }

    public void setMaximumFractionDigits(int n) {
        this.maximumFractionDigits = n;
        this.setDefaultRenderer(Double.class, new PrecisionRenderer(n));
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setRowNumberVisible(boolean bl) {
        if (this.dataTableModel.isRowNumberVisible() != bl) {
            if (bl && this.rowNumberRenderer == null) {
                this.rowNumberRenderer = new RowNumberRenderer(this);
            }
            this.dataTableModel.setRowNumberVisible(bl);
        }
    }

    public void setModel(DataTableModel dataTableModel) {
        super.setModel(dataTableModel);
        this.dataTableModel = dataTableModel;
    }

    public void setStride(TableModel tableModel, int n) {
        this.dataTableModel.setStride(tableModel, n);
    }

    public void setColumnVisible(TableModel tableModel, int n, boolean bl) {
        this.dataTableModel.setColumnVisible(tableModel, n, bl);
    }

    public boolean isRowNumberVisible() {
        return this.dataTableModel.isRowNumberVisible();
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer;
        UnitRenderer unitRenderer;
        block7: {
            int n3 = this.convertColumnIndexToModel(n2);
            if (n3 == 0 && this.dataTableModel.isRowNumberVisible()) {
                return this.rowNumberRenderer;
            }
            unitRenderer = null;
            tableCellRenderer = null;
            try {
                TableColumn tableColumn = this.getColumnModel().getColumn(n2);
                for (String string : this.unitRenderersByColumnName.keySet()) {
                    if (!tableColumn.getHeaderValue().equals(string)) continue;
                    unitRenderer = this.unitRenderersByColumnName.get(string);
                    break;
                }
                tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer != null) break block7;
                for (String string : this.precisionRenderersByColumnName.keySet()) {
                    if (!tableColumn.getHeaderValue().equals(string)) continue;
                    tableCellRenderer = this.precisionRenderersByColumnName.get(string);
                    break;
                }
            }
            catch (Exception exception) {}
        }
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
        }
        if (unitRenderer != null) {
            unitRenderer.setBaseRenderer(tableCellRenderer);
            return unitRenderer;
        }
        return tableCellRenderer;
    }

    public TableCellRenderer getPrecisionRenderer(String string) {
        return this.precisionRenderersByColumnName.get(string);
    }

    public void setRefreshDelay(int n) {
        if (n > 0) {
            this.refreshTimer.setDelay(n);
            this.refreshTimer.setInitialDelay(n);
        } else if (n <= 0) {
            this.refreshTimer.stop();
        }
        this.refreshDelay = n;
    }

    public void refreshTable() {
        if (this.refreshDelay > 0) {
            this.refreshTimer.start();
        } else {
            Runnable runnable = new Runnable(){

                public synchronized void run() {
                    DataTable.this.tableChanged(new TableModelEvent(DataTable.this.dataTableModel, -1));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tableChanged(new TableModelEvent(this.dataTableModel, -1));
    }

    public void add(TableModel tableModel) {
        this.dataTableModel.add(tableModel);
    }

    public void remove(TableModel tableModel) {
        this.dataTableModel.remove(tableModel);
    }

    public void clear() {
        this.dataTableModel.clear();
    }

    private class DataTableColumnModel
    extends DefaultTableColumnModel {
        private DataTableColumnModel() {
        }

        public TableColumn getColumn(int n) {
            TableColumn tableColumn;
            try {
                tableColumn = super.getColumn(n);
            }
            catch (Exception exception) {
                return new TableColumn();
            }
            String string = (String)tableColumn.getHeaderValue();
            if (string == null) {
                return tableColumn;
            }
            if (string.equals(rowName) && tableColumn.getModelIndex() == 0) {
                tableColumn.setMaxWidth(DataTable.this.labelColumnWidth);
                tableColumn.setMinWidth(DataTable.this.labelColumnWidth);
                tableColumn.setResizable(false);
            } else {
                tableColumn.setMinWidth(DataTable.this.minimumDataColumnWidth);
            }
            return tableColumn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataTableElement {
        TableModel tableModel;
        boolean[] columnVisibilities;
        int stride = 1;

        public DataTableElement(TableModel tableModel) {
            this.tableModel = tableModel;
        }

        public void setStride(int n) {
            this.stride = n;
        }

        public void setColumnVisible(int n, boolean bl) {
            this.ensureCapacity(n + 1);
            this.columnVisibilities[n] = bl;
        }

        public int getStride() {
            return this.stride;
        }

        public boolean[] getColumnVisibilities() {
            return this.columnVisibilities;
        }

        public int getColumnCount() {
            int n = 0;
            int n2 = this.tableModel.getColumnCount();
            this.ensureCapacity(n2);
            int n3 = 0;
            while (n3 < n2) {
                boolean bl = this.columnVisibilities[n3];
                if (bl) {
                    ++n;
                }
                ++n3;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            return this.tableModel.getValueAt(n, n2);
        }

        public String getColumnName(int n) {
            return this.tableModel.getColumnName(n);
        }

        public Class<?> getColumnClass(int n) {
            return this.tableModel.getColumnClass(n);
        }

        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        private void ensureCapacity(int n) {
            if (this.columnVisibilities == null) {
                this.columnVisibilities = new boolean[n * 3 / 2 + 1];
                Arrays.fill(this.columnVisibilities, true);
            } else if (this.columnVisibilities.length < n) {
                boolean[] blArray = this.columnVisibilities;
                this.columnVisibilities = new boolean[n * 3 / 2 + 1];
                System.arraycopy(blArray, 0, this.columnVisibilities, 0, blArray.length);
                Arrays.fill(this.columnVisibilities, blArray.length, this.columnVisibilities.length, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DefaultDataTableModel
    implements DataTableModel {
        ArrayList<DataTableElement> dataTableElements = new ArrayList();
        boolean rowNumberVisible = false;

        protected DefaultDataTableModel() {
        }

        @Override
        public void setColumnVisible(TableModel tableModel, int n, boolean bl) {
            DataTableElement dataTableElement = this.findElementContaining(tableModel);
            dataTableElement.setColumnVisible(n, bl);
        }

        @Override
        public void setStride(TableModel tableModel, int n) {
            DataTableElement dataTableElement = this.findElementContaining(tableModel);
            dataTableElement.setStride(n);
        }

        @Override
        public void setRowNumberVisible(boolean bl) {
            this.rowNumberVisible = bl;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        @Override
        public boolean isRowNumberVisible() {
            return this.rowNumberVisible;
        }

        @Override
        public String getColumnName(int n) {
            if (this.dataTableElements.size() == 0 && !this.rowNumberVisible) {
                return null;
            }
            if (this.rowNumberVisible && n == 0) {
                return rowName;
            }
            ModelFilterResult modelFilterResult = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, n);
            DataTableElement dataTableElement = modelFilterResult.tableElement;
            String string = dataTableElement.getColumnName(modelFilterResult.column);
            return string;
        }

        @Override
        public int getRowCount() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.dataTableElements.size()) {
                DataTableElement dataTableElement = this.dataTableElements.get(n2);
                int n3 = dataTableElement.getStride();
                n = Math.max(n, (dataTableElement.getRowCount() + n3 - 1) / n3);
                ++n2;
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.dataTableElements.size()) {
                DataTableElement dataTableElement = this.dataTableElements.get(n2);
                n += dataTableElement.getColumnCount();
                ++n2;
            }
            if (this.rowNumberVisible) {
                ++n;
            }
            return n;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.dataTableElements.size() == 0) {
                return null;
            }
            if (this.rowNumberVisible && n2 == 0) {
                return new Integer(n);
            }
            ModelFilterResult modelFilterResult = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, n2);
            DataTableElement dataTableElement = modelFilterResult.tableElement;
            int n3 = dataTableElement.getStride();
            if ((n *= n3) >= dataTableElement.getRowCount()) {
                return null;
            }
            return dataTableElement.getValueAt(n, modelFilterResult.column);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (this.rowNumberVisible && n == 0) {
                return Integer.class;
            }
            if (n == 0 && this.rowNumberVisible) {
                --n;
            }
            ModelFilterResult modelFilterResult = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, n);
            DataTableElement dataTableElement = modelFilterResult.tableElement;
            return dataTableElement.getColumnClass(modelFilterResult.column);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void remove(TableModel tableModel) {
            DataTableElement dataTableElement = this.findElementContaining(tableModel);
            this.dataTableElements.remove(dataTableElement);
        }

        @Override
        public void clear() {
            this.dataTableElements.clear();
        }

        @Override
        public void add(TableModel tableModel) {
            this.dataTableElements.add(new DataTableElement(tableModel));
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        private DataTableElement findElementContaining(TableModel tableModel) {
            int n = 0;
            while (n < this.dataTableElements.size()) {
                DataTableElement dataTableElement = this.dataTableElements.get(n);
                if (dataTableElement.tableModel == tableModel) {
                    return dataTableElement;
                }
                ++n;
            }
            return null;
        }
    }

    class HeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        DrawingPanel panel = new DrawingPanel();
        DrawableTextLine textLine = new DrawableTextLine("", 0.0, -6.0);

        public HeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.renderer = tableCellRenderer;
            this.textLine.setJustification(0);
            this.panel.addDrawable(this.textLine);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(component instanceof JComponent)) {
                return component;
            }
            String string = object == null ? "" : object.toString();
            this.textLine.setText(string);
            JComponent jComponent = (JComponent)component;
            Dimension dimension = jComponent.getPreferredSize();
            ++dimension.height;
            this.panel.setPreferredSize(dimension);
            Border border = jComponent.getBorder();
            if (border instanceof EmptyBorder) {
                border = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
            }
            this.panel.setBorder(border);
            int n3 = DataTable.this.decorator.getSortedColumn();
            Font font = jComponent.getFont();
            this.textLine.setFont(n3 != DataTable.this.convertColumnIndexToModel(n2) ? font : font.deriveFont(1));
            this.textLine.setColor(jComponent.getForeground());
            this.textLine.setBackground(jComponent.getBackground());
            this.panel.setBackground(jComponent.getBackground());
            return this.panel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelFilterResult {
        DataTableElement tableElement;
        int column;

        public ModelFilterResult(DataTableElement dataTableElement, int n) {
            this.tableElement = dataTableElement;
            this.column = n;
        }

        public static ModelFilterResult find(boolean bl, ArrayList<DataTableElement> arrayList, int n) {
            if (bl) {
                --n;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < arrayList.size()) {
                DataTableElement dataTableElement = arrayList.get(n3);
                int n4 = dataTableElement.getColumnCount();
                if ((n2 += n4) > n) {
                    int n5 = n4 + n - n2;
                    boolean[] blArray = dataTableElement.getColumnVisibilities();
                    int n6 = 0;
                    while (n6 < n) {
                        if (!blArray[n6]) {
                            ++n5;
                        }
                        ++n6;
                    }
                    return new ModelFilterResult(dataTableElement, n5);
                }
                ++n3;
            }
            return null;
        }
    }

    public class NumberFormatDialog
    extends JDialog {
        JButton closeButton;
        JButton cancelButton;
        JButton helpButton;
        JButton applyButton;
        JLabel patternLabel;
        JLabel sampleLabel;
        JTextField patternField;
        JTextField sampleField;
        DecimalFormat sampleFormat;
        String[] displayedNames;
        Map<String, String> realNames;
        Map<String, String> prevPatterns;
        JList columnList;
        JScrollPane columnScroller;

        NumberFormatDialog() {
            super(JOptionPane.getFrameForComponent(DataTable.this), true);
            this.realNames = new HashMap<String, String>();
            this.prevPatterns = new HashMap<String, String>();
            this.setLayout(new BorderLayout());
            this.setTitle(DisplayRes.getString("DataTable.NumberFormat.Dialog.Title"));
            this.sampleFormat = (DecimalFormat)NumberFormat.getNumberInstance();
            this.closeButton = new JButton(DisplayRes.getString("Dialog.Button.Close.Text"));
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NumberFormatDialog.this.setVisible(false);
                }
            });
            this.applyButton = new JButton(DisplayRes.getString("Dialog.Button.Apply.Text"));
            this.applyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NumberFormatDialog.this.patternField.getAction().actionPerformed(actionEvent);
                }
            });
            this.cancelButton = new JButton(DisplayRes.getString("GUIUtils.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String[] stringArray = NumberFormatDialog.this.displayedNames;
                    int n = NumberFormatDialog.this.displayedNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        String string2 = NumberFormatDialog.this.realNames.get(string);
                        DataTable.this.setFormatPattern(string2, NumberFormatDialog.this.prevPatterns.get(string2));
                        ++n2;
                    }
                    DataTable.this.refreshTable();
                    NumberFormatDialog.this.setVisible(false);
                }
            });
            this.helpButton = new JButton(DisplayRes.getString("GUIUtils.Help"));
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "      ";
                    String string2 = System.getProperty("line.separator", "/n");
                    JOptionPane.showMessageDialog(((NumberFormatDialog)NumberFormatDialog.this).DataTable.this.formatDialog, String.valueOf(DisplayRes.getString("DataTable.NumberFormat.Help.Message1")) + string2 + string2 + string + DisplayRes.getString("DataTable.NumberFormat.Help.Message2") + string2 + string + DisplayRes.getString("DataTable.NumberFormat.Help.Message3") + string2 + string + DisplayRes.getString("DataTable.NumberFormat.Help.Message4") + string2 + string + DisplayRes.getString("DataTable.NumberFormat.Help.Message5") + string2 + string2 + DisplayRes.getString("DataTable.NumberFormat.Help.Message6") + " PI.", DisplayRes.getString("DataTable.NumberFormat.Help.Title"), 1);
                }
            });
            this.patternLabel = new JLabel(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Format"));
            this.sampleLabel = new JLabel(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Sample"));
            this.patternField = new JTextField(6);
            this.patternField.setAction(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = NumberFormatDialog.this.patternField.getText();
                    if (string.indexOf(NO_PATTERN) > -1) {
                        string = "";
                    }
                    int n = 1;
                    while (n < 10) {
                        string = string.replaceAll(String.valueOf(n), "0");
                        ++n;
                    }
                    n = string.indexOf("0e0");
                    if (n > -1) {
                        string = String.valueOf(string.substring(0, n)) + "0E0" + string.substring(n + 3);
                    }
                    try {
                        Object[] objectArray;
                        NumberFormatDialog.this.showNumberFormatAndSample(string);
                        Object[] objectArray2 = objectArray = NumberFormatDialog.this.columnList.getSelectedValues();
                        int n2 = objectArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            Object object = objectArray2[n3];
                            String string2 = NumberFormatDialog.this.realNames.get(object.toString());
                            DataTable.this.setFormatPattern(string2, string);
                            ++n3;
                        }
                        DataTable.this.refreshTable();
                    }
                    catch (RuntimeException runtimeException) {
                        NumberFormatDialog.this.patternField.setBackground(new Color(255, 153, 153));
                        NumberFormatDialog.this.patternField.setText(string);
                        return;
                    }
                }
            });
            this.patternField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        NumberFormatDialog.this.patternField.setBackground(Color.white);
                    } else {
                        NumberFormatDialog.this.patternField.setBackground(Color.yellow);
                        Runnable runnable = new Runnable(){

                            public void run() {
                                String string = (this).NumberFormatDialog.this.patternField.getText();
                                if (string.indexOf(NO_PATTERN) > -1) {
                                    string = "";
                                }
                                int n = 1;
                                while (n < 10) {
                                    string = string.replaceAll(String.valueOf(n), "0");
                                    ++n;
                                }
                                n = string.indexOf("0e0");
                                if (n > -1) {
                                    string = String.valueOf(string.substring(0, n)) + "0E0" + string.substring(n + 3);
                                }
                                if (string.equals("") || string.equals(NO_PATTERN)) {
                                    TableCellRenderer tableCellRenderer = DataTable.this.getDefaultRenderer(Double.class);
                                    Component component = tableCellRenderer.getTableCellRendererComponent(DataTable.this, Math.PI, false, false, 0, 0);
                                    if (component instanceof JLabel) {
                                        String string2 = ((JLabel)component).getText();
                                        (this).NumberFormatDialog.this.sampleField.setText(string2);
                                    }
                                } else {
                                    try {
                                        (this).NumberFormatDialog.this.sampleFormat.applyPattern(string);
                                        (this).NumberFormatDialog.this.sampleField.setText((this).NumberFormatDialog.this.sampleFormat.format(Math.PI));
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            });
            this.patternField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    NumberFormatDialog.this.patternField.setBackground(Color.white);
                    NumberFormatDialog.this.patternField.getAction().actionPerformed(null);
                }
            });
            this.sampleField = new JTextField(6);
            this.sampleField.setEditable(false);
            this.columnScroller = new JScrollPane();
            this.columnScroller.setPreferredSize(new Dimension(160, 120));
            JPanel jPanel = new JPanel(new GridLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.patternLabel);
            jPanel2.add(this.patternField);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(this.sampleLabel);
            jPanel3.add(this.sampleField);
            jPanel.add(jPanel3);
            this.add((Component)jPanel, "North");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(DisplayRes.getString("DataTable.FormatDialog.ApplyTo.Title")));
            jPanel4.add((Component)this.columnScroller, "Center");
            this.add((Component)jPanel4, "Center");
            JPanel jPanel5 = new JPanel();
            jPanel5.add(this.helpButton);
            jPanel5.add(this.applyButton);
            jPanel5.add(this.closeButton);
            jPanel5.add(this.cancelButton);
            this.add((Component)jPanel5, "South");
            this.pack();
        }

        private void showNumberFormatAndSample(int[] nArray) {
            if (nArray == null || nArray.length == 0) {
                this.showNumberFormatAndSample("");
            } else if (nArray.length == 1) {
                String string = this.realNames.get(this.displayedNames[nArray[0]]);
                String string2 = DataTable.this.getFormatPattern(string);
                this.showNumberFormatAndSample(string2);
            } else {
                String string = this.realNames.get(this.displayedNames[nArray[0]]);
                String string3 = DataTable.this.getFormatPattern(string);
                int n = 1;
                while (n < nArray.length) {
                    string = this.realNames.get(this.displayedNames[nArray[n]]);
                    if (!string3.equals(DataTable.this.getFormatPattern(string))) {
                        string3 = null;
                        break;
                    }
                    ++n;
                }
                this.showNumberFormatAndSample(string3);
            }
        }

        private void showNumberFormatAndSample(String string) {
            if (string == null) {
                this.sampleField.setText("");
                this.patternField.setText("");
                return;
            }
            if (string.equals("") || string.equals(NO_PATTERN)) {
                TableCellRenderer tableCellRenderer = DataTable.this.getDefaultRenderer(Double.class);
                Component component = tableCellRenderer.getTableCellRendererComponent(DataTable.this, Math.PI, false, false, 0, 0);
                if (component instanceof JLabel) {
                    String string2 = ((JLabel)component).getText();
                    this.sampleField.setText(string2);
                }
                this.patternField.setText(NO_PATTERN);
            } else {
                this.sampleFormat.applyPattern(string);
                this.sampleField.setText(this.sampleFormat.format(Math.PI));
                this.patternField.setText(string);
            }
        }

        void setColumns(String[] stringArray, String[] stringArray2) {
            int n;
            this.displayedNames = new String[stringArray.length];
            this.realNames.clear();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = TeXParser.removeSubscripting(stringArray[n2]);
                this.displayedNames[n2] = "   " + string + " ";
                this.realNames.put(this.displayedNames[n2], stringArray[n2]);
                if (stringArray2 != null) {
                    n = 0;
                    while (n < stringArray2.length) {
                        if (stringArray2[n] != null && stringArray2[n].equals(stringArray[n2])) {
                            stringArray2[n] = this.displayedNames[n2];
                        }
                        ++n;
                    }
                }
                ++n2;
            }
            this.prevPatterns.clear();
            String[] stringArray3 = stringArray;
            n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String string = stringArray3[n3];
                this.prevPatterns.put(string, DataTable.this.getFormatPattern(string));
                ++n3;
            }
            this.columnList = new JList<String>(this.displayedNames);
            this.columnList.setLayoutOrientation(2);
            this.columnList.setVisibleRowCount(-1);
            this.columnList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    NumberFormatDialog.this.showNumberFormatAndSample(NumberFormatDialog.this.columnList.getSelectedIndices());
                }
            });
            this.columnScroller.setViewportView(this.columnList);
            this.pack();
            int[] nArray = null;
            if (stringArray2 != null) {
                nArray = new int[stringArray2.length];
                n3 = 0;
                while (n3 < nArray.length) {
                    n = 0;
                    while (n < this.displayedNames.length) {
                        if (this.displayedNames[n].equals(stringArray2[n3])) {
                            nArray[n3] = n;
                            break;
                        }
                        ++n;
                    }
                    ++n3;
                }
                this.columnList.setSelectedIndices(nArray);
            } else {
                this.showNumberFormatAndSample(nArray);
            }
        }
    }

    protected static class PrecisionRenderer
    extends DefaultTableCellRenderer {
        NumberFormat numberFormat = NumberFormat.getInstance();
        String pattern;

        public PrecisionRenderer(int n) {
            this.numberFormat.setMaximumFractionDigits(n);
            this.setHorizontalAlignment(4);
            this.setBackground(Color.WHITE);
        }

        public PrecisionRenderer(String string) {
            if (this.numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)this.numberFormat).applyPattern(string);
                this.pattern = string;
            }
            this.setHorizontalAlignment(4);
        }

        public void setValue(Object object) {
            this.setText(object == null ? "" : this.numberFormat.format(object));
        }

        public void setPrecision(int n) {
            this.numberFormat.setMaximumFractionDigits(n);
        }
    }

    protected static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        JTable table;

        public RowNumberRenderer(JTable jTable) {
            this.table = jTable;
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(PANEL_BACKGROUND);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.isRowSelected(n)) {
                int[] nArray = jTable.getSelectedColumns();
                if (nArray.length == 1 && jTable.convertColumnIndexToModel(nArray[0]) == 0) {
                    this.setBackground(PANEL_BACKGROUND);
                } else {
                    this.setBackground(Color.gray);
                }
            } else {
                this.setBackground(PANEL_BACKGROUND);
            }
            this.setText(object.toString());
            return this;
        }
    }

    protected static class UnitRenderer
    implements TableCellRenderer {
        TableCellRenderer baseRenderer;
        String units;
        String tooltip;

        public UnitRenderer(TableCellRenderer tableCellRenderer, String string, String string2) {
            this.units = string;
            this.tooltip = string2;
            this.setBaseRenderer(tableCellRenderer);
        }

        public void setBaseRenderer(TableCellRenderer tableCellRenderer) {
            this.baseRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.baseRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel && this.units != null) {
                JLabel jLabel = (JLabel)component;
                if (jLabel.getText() != null && !jLabel.getText().equals("")) {
                    jLabel.setText(String.valueOf(jLabel.getText()) + this.units);
                }
                jLabel.setToolTipText(this.tooltip);
            }
            return component;
        }
    }
}

