/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.drawables.ControlDrawable2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display2d.ByteRaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlByteRaster
extends ControlDrawable2D {
    private static final int BYTE_RASTER_ADDED = 8;
    protected ByteRaster raster;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private int nx;
    private int ny;
    private Color[] palette = new Color[1];
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.raster = new ByteRaster(300, 300);
        this.nx = this.raster.getNx();
        this.ny = this.raster.getNy();
        this.minX = -1.0;
        this.maxX = 1.0;
        this.minY = -1.0;
        this.maxY = 1.0;
        this.raster.setMinMax(-1.0, 1.0, -1.0, 1.0);
        this.raster.randomize();
        return this.raster;
    }

    @Override
    public ControlElement setProperty(String string, String string2, boolean bl) {
        string = string.trim();
        return super.setProperty(string, string2, bl);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("data");
            infoList.add("visible");
            infoList.add("colorpalette");
            infoList.add("allowRescale");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("data")) {
            return "int[][]|byte[][]";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        if (string.equals("colorpalette")) {
            return "Object[]";
        }
        if (string.equals("allowRescale")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getDouble() == this.minX) break;
                this.minX = value.getDouble();
                this.raster.setXMin(this.minX);
                break;
            }
            case 1: {
                if (value.getDouble() == this.maxX) break;
                this.maxX = value.getDouble();
                this.raster.setXMax(this.maxX);
                break;
            }
            case 2: {
                if (value.getDouble() == this.minY) break;
                this.minY = value.getDouble();
                this.raster.setYMin(this.minY);
                break;
            }
            case 3: {
                if (value.getDouble() == this.maxY) break;
                this.maxY = value.getDouble();
                this.raster.setYMax(this.maxY);
                break;
            }
            case 4: {
                if (value.getObject() instanceof byte[][]) {
                    byte[][] byArray = (byte[][])value.getObject();
                    if (byArray.length != this.nx || byArray[0].length != this.ny) {
                        this.nx = byArray.length;
                        this.ny = byArray[0].length;
                        this.raster.resizeRaster(this.nx, this.ny);
                    }
                    this.raster.setBlock(0, 0, byArray);
                    break;
                }
                if (!(value.getObject() instanceof int[][])) break;
                int[][] nArray = (int[][])value.getObject();
                if (nArray.length != this.nx || nArray[0].length != this.ny) {
                    this.nx = nArray.length;
                    this.ny = nArray[0].length;
                    this.raster.resizeRaster(this.nx, this.ny);
                }
                this.raster.setBlock(0, 0, nArray);
                break;
            }
            case 5: {
                this.raster.setVisible(value.getBoolean());
                break;
            }
            case 6: {
                if (!(value.getObject() instanceof Object[])) break;
                Object[] objectArray = (Object[])value.getObject();
                if (objectArray.length != this.palette.length) {
                    this.palette = new Color[objectArray.length];
                }
                boolean bl = false;
                int n2 = 0;
                int n3 = this.palette.length;
                while (n2 < n3) {
                    if (this.palette[n2] != (Color)objectArray[n2]) {
                        this.palette[n2] = (Color)objectArray[n2];
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) break;
                this.raster.setColorPalette(this.palette);
                break;
            }
            case 7: {
                this.raster.setAllowRescale(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 8, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.minX = -1.0;
                this.raster.setXMin(-1.0);
                break;
            }
            case 1: {
                this.maxX = 1.0;
                this.raster.setXMax(1.0);
                break;
            }
            case 2: {
                this.minY = -1.0;
                this.raster.setYMin(-1.0);
                break;
            }
            case 3: {
                this.maxY = 1.0;
                this.raster.setYMax(1.0);
                break;
            }
            case 4: {
                this.raster.randomize();
                break;
            }
            case 5: {
                this.raster.setVisible(true);
                break;
            }
            case 6: {
                this.raster.createDefaultColors();
                break;
            }
            case 7: {
                this.raster.setAllowRescale(false);
                break;
            }
            default: {
                super.setDefaultValue(n - 8);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "-1";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "-1";
            }
            case 3: {
                return "1";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "true";
            }
            case 6: {
                return "<none>";
            }
            case 7: {
                return "false";
            }
        }
        return super.getDefaultValueString(n - 8);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
        }
        return super.getValue(n - 8);
    }
}

