/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.display2d.GridPointData;

public class TestData {
    public static double dipole(double d, double d2) {
        double d3 = Math.sqrt((d - 1.0) * (d - 1.0) + d2 * d2);
        double d4 = Math.sqrt((d + 1.0) * (d + 1.0) + d2 * d2);
        if (d3 == 0.0 || d4 == 0.0) {
            return 0.0;
        }
        return 1.0 / d3 - 1.0 / d4;
    }

    public static double gaussian(double d, double d2, double d3) {
        double d4 = d * d + d2 * d2;
        return Math.exp(-d4 / d3 / d3 / 2.0);
    }

    public static double saddle(double d, double d2) {
        double d3 = d * d - d2 * d2;
        return Math.exp(d3);
    }

    public static double[][][] dipoleScalarField(GridPointData gridPointData) {
        double[][][] dArray = gridPointData.getData();
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            int n3 = 0;
            int n4 = dArray[0].length;
            while (n3 < n4) {
                dArray[n][n3][2] = TestData.dipole(dArray[n][n3][0], dArray[n][n3][1]);
                ++n3;
            }
            ++n;
        }
        return dArray;
    }

    public static double[][][] gaussianScalarField(GridPointData gridPointData) {
        double[][][] dArray = gridPointData.getData();
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            int n3 = 0;
            int n4 = dArray[0].length;
            while (n3 < n4) {
                dArray[n][n3][2] = TestData.gaussian(dArray[n][n3][0], dArray[n][n3][1], 1.0);
                ++n3;
            }
            ++n;
        }
        return dArray;
    }

    public static void randomScalarField(GridPointData gridPointData) {
        double[][][] dArray = gridPointData.getData();
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            int n3 = 0;
            int n4 = dArray[0].length;
            while (n3 < n4) {
                dArray[n][n3][2] = Math.random();
                ++n3;
            }
            ++n;
        }
    }

    public static double[] dipoleVector(double d, double d2) {
        double[] dArray = new double[2];
        double d3 = Math.sqrt((d - 1.0) * (d - 1.0) + d2 * d2);
        double d4 = Math.sqrt((d + 1.0) * (d + 1.0) + d2 * d2);
        if (d3 == 0.0 || d4 == 0.0) {
            return dArray;
        }
        dArray[0] = (d - 1.0) / d3 / d3 - (d + 1.0) / d4 / d4;
        dArray[1] = d2 / d3 / d3 - d2 / d4 / d4;
        return dArray;
    }

    public static double[][][] circulatingVectorField(int n, int n2) {
        double[][][] dArray = new double[n][n2][5];
        double d = -10.0;
        double d2 = 10.0;
        double d3 = -10.0;
        double d4 = 10.0;
        double d5 = d;
        double d6 = d3;
        double d7 = (d2 - d) / (double)(n - 1);
        double d8 = (d4 - d3) / (double)(n2 - 1);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3][n4][0] = d5;
                dArray[n3][n4][1] = d6;
                double d9 = Math.sqrt(d5 * d5 + d6 * d6);
                dArray[n3][n4][2] = -d6 / d9;
                dArray[n3][n4][3] = d5 / d9;
                dArray[n3][n4][4] = d9;
                d6 += d8;
                ++n4;
            }
            d6 = d3;
            d5 += d7;
            ++n3;
        }
        return dArray;
    }

    public static double[][][] dipoleVectorField(int n, int n2, double d, double d2, double d3, double d4) {
        double[][][] dArray = new double[n][n2][5];
        double d5 = d;
        double d6 = d3;
        double d7 = (d2 - d) / (double)(n - 1);
        double d8 = (d4 - d3) / (double)(n2 - 1);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3][n4][0] = d5;
                dArray[n3][n4][1] = d6;
                double[] dArray2 = TestData.dipoleVector(d5, d6);
                double d9 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1]);
                dArray[n3][n4][2] = dArray2[0] / d9;
                dArray[n3][n4][3] = dArray2[1] / d9;
                dArray[n3][n4][4] = d9;
                d6 += d8;
                ++n4;
            }
            d6 = d3;
            d5 += d7;
            ++n3;
        }
        return dArray;
    }
}

