/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementCylinder;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementCylinder
extends SimpleAbstractTile {
    public SimpleElementCylinder(ElementCylinder elementCylinder) {
        super(elementCylinder);
    }

    protected double[][][] computeTile() {
        Resolution resolution;
        ElementCylinder elementCylinder = (ElementCylinder)this.element;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d = elementCylinder.getMinimumAngle();
        double d2 = elementCylinder.getMaximumAngle();
        if (Math.abs(d2 - d) > 360.0) {
            d2 = d + 360.0;
        }
        if ((resolution = this.style.getResolution()) != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    double d3 = Math.abs(this.element.getSizeX()) / 2.0;
                    double d4 = Math.abs(this.element.getSizeY()) / 2.0;
                    n = Math.max((int)Math.round(0.49 + Math.max(d3, d4) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d2 - d) * (Math.PI / 180) * (d3 + d4) / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeZ()) / resolution.getMaxLength()), 1);
                }
            }
        }
        return ElementCylinder.createStandardCylinder(n, n2, n3, d, d2, elementCylinder.isClosedTop(), elementCylinder.isClosedBottom(), elementCylinder.isClosedLeft(), elementCylinder.isClosedRight());
    }
}

