/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.Drawable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlComplexDataset
extends ControlDrawable
implements NeedsPreUpdate,
Resetable,
DataCollector {
    private static final int COMPLEXDATASET_ADDED = 14;
    private ComplexDataset dataset;
    protected double x;
    protected double re;
    protected double im;
    protected double[] xArray;
    protected double[] reArray;
    protected double[] imArray;
    protected boolean enabled;
    protected boolean clearAtInput;
    protected Color reColor;
    protected Color imColor;
    protected int isSet = -1;
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.im = 0.0;
        this.re = 0.0;
        this.x = 0.0;
        this.reColor = Color.BLACK;
        this.imColor = Color.BLUE;
        this.enabled = true;
        this.clearAtInput = true;
        this.dataset = new ComplexDataset();
        this.dataset.setLineColor(this.reColor, this.imColor);
        return this.dataset;
    }

    @Override
    public void initialize() {
        this.dataset.clear();
    }

    @Override
    public void reset() {
        this.dataset.clear();
    }

    @Override
    public void onExit() {
        this.dataset.clear();
    }

    @Override
    public void preupdate() {
        if (!this.enabled) {
            return;
        }
        switch (this.isSet) {
            case 0: {
                if (this.clearAtInput) {
                    this.dataset.clear();
                }
                this.dataset.append(this.x, this.re, this.im);
                break;
            }
            case 1: {
                if (this.clearAtInput) {
                    this.dataset.clear();
                }
                this.dataset.append(this.xArray, this.reArray, this.imArray);
            }
        }
        this.isSet = -1;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("x");
            infoList.add("real");
            infoList.add("imag");
            infoList.add("realColor");
            infoList.add("imagColor");
            infoList.add("enabled");
            infoList.add("centered");
            infoList.add("connected");
            infoList.add("markersize");
            infoList.add("markershape");
            infoList.add("sorted");
            infoList.add("visible");
            infoList.add("measured");
            infoList.add("clearAtInput");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("x")) {
            return "int|double|double[]";
        }
        if (string.equals("real")) {
            return "int|double|double[]";
        }
        if (string.equals("imag")) {
            return "int|double|double[]";
        }
        if (string.equals("realColor")) {
            return "Color|Object";
        }
        if (string.equals("imagColor")) {
            return "Color|Object";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        if (string.equals("centered")) {
            return "boolean";
        }
        if (string.equals("connected")) {
            return "boolean";
        }
        if (string.equals("markersize")) {
            return "int";
        }
        if (string.equals("markershape")) {
            return "ComplexMarkerShape|int";
        }
        if (string.equals("sorted")) {
            return "boolean";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        if (string.equals("measured")) {
            return "boolean";
        }
        if (string.equals("clearAtInput")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("ComplexMarkerShape") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("amp_curve")) {
                return new IntegerValue(0);
            }
            if (string2.equals("re_im_curve")) {
                return new IntegerValue(1);
            }
            if (string2.equals("phase_curve")) {
                return new IntegerValue(2);
            }
            if (string2.equals("phase_bar")) {
                return new IntegerValue(3);
            }
            if (string2.equals("phase_post")) {
                return new IntegerValue(4);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof double[]) {
                    this.xArray = (double[])value.getObject();
                    this.isSet = 1;
                    break;
                }
                this.x = value.getDouble();
                this.isSet = 0;
                break;
            }
            case 1: {
                if (value.getObject() instanceof double[]) {
                    this.reArray = (double[])value.getObject();
                    this.isSet = 1;
                    break;
                }
                this.re = value.getDouble();
                this.isSet = 0;
                break;
            }
            case 2: {
                if (value.getObject() instanceof double[]) {
                    this.imArray = (double[])value.getObject();
                    this.isSet = 1;
                    break;
                }
                this.im = value.getDouble();
                this.isSet = 0;
                break;
            }
            case 3: {
                this.reColor = (Color)value.getObject();
                this.dataset.setLineColor(this.reColor, this.imColor);
                break;
            }
            case 4: {
                this.imColor = (Color)value.getObject();
                this.dataset.setLineColor(this.reColor, this.imColor);
                break;
            }
            case 5: {
                this.enabled = value.getBoolean();
                break;
            }
            case 6: {
                this.dataset.setCentered(value.getBoolean());
                break;
            }
            case 7: {
                this.dataset.setConnected(value.getBoolean());
                break;
            }
            case 8: {
                this.dataset.setMarkerSize(value.getInteger());
                break;
            }
            case 9: {
                this.dataset.setMarkerShape(value.getInteger());
                break;
            }
            case 10: {
                this.dataset.setSorted(value.getBoolean());
                break;
            }
            case 11: {
                this.dataset.setVisible(value.getBoolean());
                break;
            }
            case 12: {
                this.dataset.setMeasurable(value.getBoolean());
                break;
            }
            case 13: {
                this.clearAtInput = value.getBoolean();
                break;
            }
            default: {
                super.setValue(n - 14, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.x = 0.0;
                this.isSet = -1;
                break;
            }
            case 1: {
                this.re = 0.0;
                this.isSet = -1;
                break;
            }
            case 2: {
                this.im = 0.0;
                this.isSet = -1;
                break;
            }
            case 3: {
                this.reColor = Color.BLACK;
                this.dataset.setLineColor(this.reColor, this.imColor);
                break;
            }
            case 4: {
                this.imColor = Color.BLUE;
                this.dataset.setLineColor(this.reColor, this.imColor);
                break;
            }
            case 5: {
                this.enabled = true;
                break;
            }
            case 6: {
                this.dataset.setCentered(true);
                break;
            }
            case 7: {
                this.dataset.setConnected(true);
                break;
            }
            case 8: {
                this.dataset.setMarkerSize(5);
                break;
            }
            case 9: {
                this.dataset.setMarkerShape(2);
                break;
            }
            case 10: {
                this.dataset.setSorted(false);
                break;
            }
            case 11: {
                this.dataset.setVisible(true);
                break;
            }
            case 12: {
                this.dataset.setMeasurable(true);
                break;
            }
            case 13: {
                this.clearAtInput = true;
                break;
            }
            default: {
                super.setDefaultValue(n - 14);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return "<none>";
            }
            case 3: {
                return "BLACK";
            }
            case 4: {
                return "BLUE";
            }
            case 5: {
                return "true";
            }
            case 6: {
                return "true";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "5";
            }
            case 9: {
                return "PHASE_CURVE";
            }
            case 10: {
                return "false";
            }
            case 11: {
                return "true";
            }
            case 12: {
                return "true";
            }
            case 13: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 14);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return null;
            }
        }
        return super.getValue(n - 14);
    }
}

