/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.colos.ejs.library.Function;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.GroupVariable;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.NeedsFinalUpdate;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.ControlRootPane;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;
import org.colos.ejs.library.utils.LocaleItem;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjsControl {
    private static String _RETURN_;
    private static GraphicsConfiguration defaultScreenGraphicsConfiguration;
    private static int borderWidthAroundWindows;
    private static Icon borderIconAroundWindows;
    private static Color borderColorAroundWindows;
    private static Color borderTitleColorAroundWindows;
    private static String borderTitleAroundWindows;
    protected String replaceOwnerName = null;
    private Frame ownerFrame = null;
    protected Frame replaceOwnerFrame = null;
    private Component mainRootPane = null;
    private JTextArea messageArea = null;
    private boolean mustUpdateSimulation = true;
    private boolean justCollectingData = false;
    private Simulation mySimulation = null;
    private Hashtable<String, Object> targetTable = new Hashtable();
    private Hashtable<String, ControlElement> elementTable = new Hashtable();
    Hashtable<String, GroupVariable> variableTable = new Hashtable();
    private Vector<ControlElement> elementList = new Vector();
    private Vector<NeedsUpdate> updateList = new Vector();
    private Vector<NeedsFinalUpdate> finalUpdateList = new Vector();
    private URL usercodebase = null;
    private Point displacement = new Point(0, 0);
    private boolean reportingChange = false;
    GroupVariable methodTriggerVariable = null;
    private Hashtable<ControlDrawable, ControlParentOfDrawables> drawablesReparented = new Hashtable();
    private BooleanValue booleanValue = new BooleanValue(false);
    private IntegerValue integerValue = new IntegerValue(0);
    private DoubleValue doubleValue = new DoubleValue(0.0);
    private StringValue stringValue = new StringValue("");
    private ObjectValue objectValue = new ObjectValue(null);
    private static Color[] colorTable;

    static {
        defaultScreenGraphicsConfiguration = EjsControl.getGraphicsConfiguration(0);
        borderWidthAroundWindows = 0;
        borderIconAroundWindows = null;
        borderColorAroundWindows = Color.RED;
        borderTitleColorAroundWindows = Color.BLACK;
        borderTitleAroundWindows = null;
        ResourceLoader.setCacheEnabled(true);
        try {
            _RETURN_ = System.getProperty("line.separator");
        }
        catch (Exception exception) {
            _RETURN_ = "\n";
        }
        colorTable = null;
    }

    public static void setBorderWidthAroundWindows(int n) {
        borderWidthAroundWindows = n;
    }

    public static int getBorderWidthAroundWindows() {
        return borderWidthAroundWindows;
    }

    public static void setBorderIconAroundWindows(Icon icon) {
        borderIconAroundWindows = icon;
    }

    public static Icon getBorderIconAroundWindows() {
        return borderIconAroundWindows;
    }

    public static void setBorderColorAroundWindows(Color color) {
        borderColorAroundWindows = color;
    }

    public static Color getBorderColorAroundWindows() {
        return borderColorAroundWindows;
    }

    public static void setBorderTitleColorAroundWindows(Color color) {
        borderTitleColorAroundWindows = color;
    }

    public static Color getBorderTitleColorAroundWindows() {
        return borderTitleColorAroundWindows;
    }

    public static void setBorderTitleAroundWindows(String string) {
        borderTitleAroundWindows = string;
    }

    public static String getBorderTitleAroundWindows() {
        return borderTitleAroundWindows;
    }

    public static boolean hasJava3D() {
        return OSPRuntime.hasJava3D();
    }

    public EjsControl() {
        this.setValue("_expr_", new BooleanValue(false));
        this.methodTriggerVariable = this.variableTable.get("_expr_");
    }

    public EjsControl(Object object) {
        this();
        this.addTarget("_default_", object);
        if (object instanceof Simulation) {
            this.setSimulation((Simulation)object);
        }
    }

    public EjsControl(Object object, String string, Frame frame) {
        this(object);
        this.replaceOwnerFrame(string, frame);
    }

    public static GraphicsConfiguration getGraphicsConfiguration(int n) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (n >= graphicsDeviceArray.length || n < 0) {
            return graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        }
        return graphicsDeviceArray[n].getDefaultConfiguration();
    }

    public static void setDefaultScreen(int n) {
        defaultScreenGraphicsConfiguration = EjsControl.getGraphicsConfiguration(n);
    }

    public static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        return defaultScreenGraphicsConfiguration;
    }

    public static Rectangle getDefaultScreenBounds() {
        Rectangle rectangle = defaultScreenGraphicsConfiguration.getBounds();
        return rectangle;
    }

    public void setOwnerFrame(Frame frame) {
        this.ownerFrame = frame;
    }

    public Frame getOwnerFrame() {
        return this.ownerFrame;
    }

    public void replaceOwnerFrame(String string, Frame frame) {
        this.replaceOwnerName = string;
        this.replaceOwnerFrame = frame;
    }

    public String getReplaceOwnerName() {
        return this.replaceOwnerName;
    }

    public Frame getReplaceOwnerFrame() {
        return this.replaceOwnerFrame;
    }

    public void setSimulation(Simulation simulation) {
        this.mySimulation = simulation;
    }

    public Simulation getSimulation() {
        return this.mySimulation;
    }

    public Locale getLocale() {
        return this.mySimulation.getLocale();
    }

    public LocaleItem getLocaleItem() {
        return this.mySimulation.getLocaleItem();
    }

    public String getLocaleLanguage() {
        return this.mySimulation.getLocale().getLanguage();
    }

    public void setLocale(String string) {
        this.mySimulation.setLocale(string);
    }

    public void setUpdateSimulation(boolean bl) {
        this.mustUpdateSimulation = bl;
    }

    boolean isUpdatingSimulation() {
        return this.mustUpdateSimulation;
    }

    public void updateSimulationWhenIdle() {
        if (this.mustUpdateSimulation && this.mySimulation != null) {
            this.mySimulation.updateWhenIdle();
        }
    }

    public void addElementsMenuEntries() {
        for (ControlElement controlElement : this.elementList) {
            controlElement.addMenuEntries();
        }
    }

    public final boolean isReportingChange() {
        return this.reportingChange;
    }

    public final void setReportingChange(boolean bl) {
        this.reportingChange = bl;
    }

    public void setDisplacement(int n, int n2) {
        this.setDisplacement(n, n2, null);
    }

    public void setDisplacement(int n, int n2, EjsControl ejsControl) {
        if (ejsControl != null) {
            this.displacement.x = n + ejsControl.displacement.x;
            this.displacement.y = n2 + ejsControl.displacement.y;
        } else {
            this.displacement.x = n;
            this.displacement.y = n2;
        }
        Enumeration<ControlElement> enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ControlElement controlElement = enumeration.nextElement();
            if (!(controlElement instanceof ControlWindow)) continue;
            ((ControlWindow)controlElement).updateLocation();
        }
    }

    public Point getDisplacement() {
        return this.displacement;
    }

    public boolean reparentDrawable(String string, ControlElement controlElement) {
        ControlElement controlElement2 = this.getElement(string);
        if (controlElement2 instanceof ControlDrawable && controlElement instanceof ControlParentOfDrawables) {
            ControlDrawable controlDrawable = (ControlDrawable)controlElement2;
            this.drawablesReparented.put(controlDrawable, controlDrawable.getParent());
            controlDrawable.setParent((ControlParentOfDrawables)((Object)controlElement));
            return true;
        }
        JOptionPane.showMessageDialog(null, "Can't reparent drawable.\nOne of the elements is not of the right type", "Error", 1);
        return false;
    }

    public void undoReparenting() {
        Enumeration<ControlDrawable> enumeration = this.drawablesReparented.keys();
        while (enumeration.hasMoreElements()) {
            ControlDrawable controlDrawable = enumeration.nextElement();
            controlDrawable.setParent(this.drawablesReparented.get(controlDrawable));
        }
        this.drawablesReparented.clear();
    }

    public void dispose() {
        for (ControlElement controlElement : this.elementList) {
            if (!(controlElement instanceof ControlWindow)) continue;
            ((ControlWindow)controlElement).dispose();
        }
    }

    public Vector<ControlElement> getElements() {
        return this.elementList;
    }

    public Object getTarget(String string) {
        return this.targetTable.get(string);
    }

    public void addTarget(String string, Object object) {
        this.targetTable.put(string, object);
    }

    public void removeTarget(String string) {
        this.targetTable.remove(string);
    }

    public void setValue(String string, Value value) {
        this.setValue(string, value, false);
    }

    public void setValue(String string, Value value, boolean bl) {
        GroupVariable groupVariable = this.variableTable.get(string);
        if (groupVariable == null) {
            groupVariable = new GroupVariable(string, value);
            groupVariable.setValueObsolete(false);
            groupVariable.setDefinedInModel(bl);
            this.variableTable.put(string, groupVariable);
        } else {
            groupVariable.setValue(value);
            groupVariable.setValueObsolete(false);
            if (bl) {
                groupVariable.setDefinedInModel(true);
            }
            groupVariable.propagateValue(null, this.justCollectingData);
        }
    }

    public Value getValue(String string) {
        GroupVariable groupVariable = this.variableTable.get(string);
        if (groupVariable == null) {
            return null;
        }
        return groupVariable.getValue();
    }

    public GroupVariable getVariable(String string) {
        return this.variableTable.get(string);
    }

    public GroupVariable registerVariable(String string, ControlElement controlElement, int n, Value value) {
        if (string == null) {
            return null;
        }
        GroupVariable groupVariable = this.variableTable.get(string);
        if (groupVariable == null) {
            groupVariable = new GroupVariable(string, value);
            this.variableTable.put(string, groupVariable);
        }
        groupVariable.addElementListener(controlElement, n);
        groupVariable.propagateValue(null, this.justCollectingData);
        return groupVariable;
    }

    public boolean isVariableRegistered(String string) {
        if (string == null) {
            return false;
        }
        return this.variableTable.get(string) != null;
    }

    public void variableChanged(GroupVariable groupVariable, ControlElement controlElement, Value value) {
        if (groupVariable == null) {
            return;
        }
        groupVariable.setValue(value);
        groupVariable.propagateValue(controlElement, this.justCollectingData);
        groupVariable.invokeListeners(controlElement);
    }

    public void addListener(String string, String string2) {
        this.addListener(string, string2, null);
    }

    public void addListener(String string, String string2, Object object) {
        Object object2;
        if (string == null) {
            return;
        }
        String[] stringArray = MethodWithOneParameter.splitMethodName(string2);
        if (stringArray == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Listener <" + string2 + "> not assigned");
            return;
        }
        if (stringArray[0] == null) {
            stringArray[0] = "_default_";
        }
        if ((object2 = this.getTarget(stringArray[0])) == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Target <" + stringArray[0] + "> not assigned");
            return;
        }
        GroupVariable groupVariable = this.variableTable.get(string);
        if (groupVariable == null) {
            groupVariable = new GroupVariable(string, this.doubleValue);
            this.variableTable.put(string, groupVariable);
        }
        if (stringArray[2] == null) {
            groupVariable.addListener(object2, String.valueOf(stringArray[1]) + "()", object);
        } else {
            groupVariable.addListener(object2, String.valueOf(stringArray[1]) + "(" + stringArray[2] + ")", object);
        }
    }

    public void rename(ControlElement controlElement, String string) {
        String string2 = controlElement.getProperty("name");
        if (string2 != null) {
            this.elementTable.remove(string2);
        }
        if (string != null) {
            this.elementTable.put(string, controlElement);
        }
    }

    public Component getMainComponent() {
        return this.mainRootPane;
    }

    public final ControlElement addElement(ControlElement controlElement, String string) {
        Object object;
        if (this.replaceOwnerName != null && this.replaceOwnerName.equals(string)) {
            if (controlElement.getObject() instanceof Frame) {
                this.setOwnerFrame(this.replaceOwnerFrame);
            }
            controlElement = new ControlRootPane();
            this.mainRootPane = controlElement.getComponent();
        }
        if ((object = controlElement.getObject()) instanceof Frame) {
            this.setOwnerFrame((Frame)object);
        } else if (object instanceof Dialog && this.ownerFrame != null) {
            controlElement.replaceVisual(this.ownerFrame);
        } else if (object instanceof JTextArea) {
            this.messageArea = (JTextArea)object;
        }
        controlElement.setGroup(this);
        controlElement.setProperty("name", string);
        this.elementList.add(controlElement);
        if (controlElement instanceof NeedsUpdate) {
            this.updateList.add((NeedsUpdate)((Object)controlElement));
        }
        if (controlElement instanceof NeedsFinalUpdate) {
            this.finalUpdateList.add((NeedsFinalUpdate)((Object)controlElement));
        }
        if (this.usercodebase != null) {
            controlElement.setProperty("_ejs_codebase", this.usercodebase.toString());
        }
        if (object instanceof Window && controlElement.getProperty("visible") == null) {
            controlElement.setProperty("visible", "true");
        }
        return controlElement;
    }

    public ControlElement getElement(String string) {
        if (string == null) {
            return null;
        }
        return this.elementTable.get(string);
    }

    public ControlElement getControl(String string) {
        return this.getElement(string);
    }

    public Component getVisual(String string) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement.getVisual();
    }

    public Component getComponent(String string) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement.getComponent();
    }

    public Container getContainer(String string) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement instanceof ControlContainer) {
            return ((ControlContainer)controlElement).getContainer();
        }
        return null;
    }

    public Object getObject(String string, String string2) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement.getObject(string2);
    }

    public Function getFunction(String string, String string2) {
        Object object = this.getObject(string, string2);
        if (object instanceof Function) {
            return (Function)object;
        }
        return null;
    }

    public void destroy(String string) {
        this.destroy(this.getElement(string), true);
    }

    public void destroy(ControlElement controlElement) {
        this.destroy(controlElement, true);
    }

    public void reset() {
        this.clearMessages();
        this.undoReparenting();
        for (ControlElement controlElement : this.elementList) {
            controlElement.reset();
        }
    }

    public void initialize() {
        for (ControlElement controlElement : this.elementList) {
            controlElement.initialize();
        }
    }

    public void propagateValues() {
    }

    private void doTheUpdate() {
        this.methodTriggerVariable.propagateValue(null, this.justCollectingData);
        for (NeedsUpdate needsUpdate : this.updateList) {
            needsUpdate.update();
        }
    }

    public void update() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.propagateValues();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public synchronized void run() {
                        EjsControl.this.propagateValues();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        this.doTheUpdate();
    }

    public void collectData() {
        this.justCollectingData = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.propagateValues();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public synchronized void run() {
                        EjsControl.this.propagateValues();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        this.doTheUpdate();
        this.justCollectingData = false;
    }

    public void finalUpdate() {
        for (NeedsFinalUpdate needsFinalUpdate : this.finalUpdateList) {
            needsFinalUpdate.finalUpdate();
        }
    }

    public void updateVariables() {
        this.propagateValues();
        this.methodTriggerVariable.propagateValue(null, this.justCollectingData);
    }

    public void resetTraces() {
        this.clearData();
    }

    public void clearData() {
        for (ControlElement controlElement : this.elementList) {
            if (!(controlElement instanceof Resetable)) continue;
            controlElement.reset();
        }
    }

    public void setUserCodebase(URL uRL) {
        this.usercodebase = uRL;
        for (ControlElement controlElement : this.elementList) {
            controlElement.setProperty("_ejs_codebase", uRL.toString());
        }
    }

    public URL getUserCodebase() {
        return this.usercodebase;
    }

    @Deprecated
    public void flush() {
        for (ControlElement controlElement : this.elementList) {
            controlElement.flush();
        }
    }

    public void setActive(boolean bl) {
        for (ControlElement controlElement : this.elementList) {
            controlElement.setActive(bl);
        }
    }

    public void onExit() {
        for (ControlElement controlElement : this.elementList) {
            controlElement.onExit();
        }
    }

    public void clearVariables() {
        this.variableTable.clear();
    }

    public void clearModelVariables() {
        Hashtable<String, GroupVariable> hashtable = new Hashtable<String, GroupVariable>();
        Enumeration<GroupVariable> enumeration = this.variableTable.elements();
        while (enumeration.hasMoreElements()) {
            GroupVariable groupVariable = enumeration.nextElement();
            if (!groupVariable.isDefinedInModel()) {
                hashtable.put(groupVariable.getName(), groupVariable);
                continue;
            }
            if (!groupVariable.hasElementsRegistered()) continue;
            groupVariable.setValueObsolete(true);
            hashtable.put(groupVariable.getName(), groupVariable);
        }
        this.variableTable = hashtable;
    }

    public Set<String> getVariablesSet() {
        return this.variableTable.keySet();
    }

    public Hashtable<String, GroupVariable> getVariablesTable() {
        return this.variableTable;
    }

    public void clear() {
        this.variableTable.clear();
        ArrayList<ControlElement> arrayList = new ArrayList<ControlElement>();
        ArrayList<ControlElement> arrayList2 = new ArrayList<ControlElement>();
        for (ControlElement controlElement : this.elementList) {
            String string = controlElement.getProperty("parent");
            if (string != null) continue;
            if (controlElement instanceof ControlDialog) {
                arrayList.add(controlElement);
                continue;
            }
            arrayList2.add(controlElement);
        }
        for (ControlElement controlElement : arrayList) {
            this.destroy(controlElement, false);
        }
        for (ControlElement controlElement : arrayList2) {
            this.destroy(controlElement, false);
        }
        this.setOwnerFrame(null);
    }

    private void destroy(ControlElement controlElement, boolean bl) {
        Object object;
        Object object2;
        if (controlElement == null) {
            return;
        }
        if (bl) {
            object2 = this.getElement(controlElement.getProperty("parent"));
            if (object2 != null) {
                if (object2 instanceof ControlContainer) {
                    ((ControlContainer)object2).remove(controlElement);
                }
            } else {
                object = controlElement.getComponent().getParent();
                if (object != null) {
                    ((Container)object).remove(controlElement.getComponent());
                    ((Container)object).validate();
                    ((Component)object).repaint();
                }
            }
        }
        controlElement.variablePropertiesClear();
        object2 = controlElement.getProperty("name");
        if (object2 != null) {
            this.elementTable.remove(object2);
        }
        this.elementList.remove(controlElement);
        if (controlElement instanceof NeedsUpdate) {
            this.updateList.remove(controlElement);
        }
        if (controlElement instanceof NeedsFinalUpdate) {
            this.finalUpdateList.remove(controlElement);
        }
        if (controlElement instanceof ControlContainer) {
            object = ((ControlContainer)controlElement).getChildren().elements();
            while (object.hasMoreElements()) {
                ControlElement controlElement2 = (ControlElement)object.nextElement();
                this.destroy(controlElement2, false);
            }
        }
        if (controlElement instanceof ControlWindow) {
            ((ControlWindow)controlElement).dispose();
        }
    }

    public Container getTopLevelAncestor(String string) {
        if (string != null) {
            ControlElement controlElement = this.getElement(string);
            Component component = controlElement.getComponent();
            if (component instanceof JComponent) {
                return ((JComponent)component).getTopLevelAncestor();
            }
        } else {
            for (ControlElement controlElement : this.elementList) {
                Component component = controlElement.getComponent();
                if (!(component instanceof Window)) continue;
                return (Window)component;
            }
        }
        return null;
    }

    public void setValue(String string, boolean bl) {
        this.booleanValue.value = bl;
        this.setValue(string, this.booleanValue);
    }

    public void setValue(String string, int n) {
        this.integerValue.value = n;
        this.setValue(string, this.integerValue);
    }

    public void setValue(String string, double d) {
        this.doubleValue.value = d;
        this.setValue(string, this.doubleValue);
    }

    public void setValue(String string, String string2) {
        this.stringValue.value = string2;
        this.setValue(string, this.stringValue);
    }

    public void setValue(String string, Object object) {
        if (object instanceof String) {
            this.setValue(string, (String)object);
        } else {
            this.objectValue.value = object;
            this.setValue(string, this.objectValue);
        }
    }

    public boolean getBoolean(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return false;
        }
        return value.getBoolean();
    }

    public int getInt(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return 0;
        }
        return value.getInteger();
    }

    public double getDouble(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return 0.0;
        }
        return value.getDouble();
    }

    public String getString(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return "";
        }
        return value.getString();
    }

    public Object getObject(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return null;
        }
        return value.getObject();
    }

    public static Color[] getPhaseColorTable() {
        if (colorTable == null) {
            colorTable = new Color[256];
            int n = 0;
            while (n < 256) {
                double d = Math.abs(Math.sin(Math.PI * (double)n / 255.0));
                int n2 = (int)(255.0 * d * d);
                d = Math.abs(Math.sin(Math.PI * (double)n / 255.0 + 1.0471975511965976));
                int n3 = (int)(255.0 * d * d * Math.sqrt(d));
                d = Math.abs(Math.sin(Math.PI * (double)n / 255.0 + 2.0943951023931953));
                int n4 = (int)(255.0 * d * d);
                EjsControl.colorTable[n] = new Color(n4, n3, n2);
                ++n;
            }
        }
        return colorTable;
    }

    public static Color phaseToColor(double d) {
        int n = (int)(127.5 * (1.0 + d / Math.PI));
        return EjsControl.getPhaseColorTable()[n %= 255];
    }

    public void alert(String string, String string2, String string3) {
        this.alert(this.getComponent(string), string2, string3);
    }

    public void alert(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 1);
    }

    public void setParentComponent(String string) {
        this.getSimulation().setParentComponent(string);
    }

    public void setUpdateView(boolean bl) {
        this.getSimulation().setUpdateView(bl);
    }

    public void resetElements() {
        this.reset();
        this.initialize();
    }

    public void clearElements() {
        this.initialize();
    }

    public String format(double d, String string) {
        return new DecimalFormat(string).format(d);
    }

    public Object showTable(Component component, Data ... dataArray) {
        return ToolForData.getTool().showTable(component, dataArray);
    }

    public Object showTable(Data ... dataArray) {
        return this.showTable((Component)null, dataArray);
    }

    public Object showDataTool(Component component, Data ... dataArray) {
        return ToolForData.getTool().showDataTool(component, dataArray);
    }

    public Object showDataTool(Data ... dataArray) {
        return this.showDataTool((Component)null, dataArray);
    }

    public Object showFourierTool(Component component, Data ... dataArray) {
        return ToolForData.getTool().showFourierTool(component, dataArray);
    }

    public Object showFourierTool(Data ... dataArray) {
        return this.showFourierTool((Component)null, dataArray);
    }

    public void showDescriptionAtStartUp(boolean bl) {
        this.getSimulation().showDescriptionAtStartUp(bl);
    }

    public void showDescription(boolean bl) {
        this.getSimulation().showDescription(bl);
    }

    public URL getDescriptionPageURL(String string) {
        return this.getSimulation().getDescriptionPageURL(string);
    }

    public JDialog createDescriptionDialog(Component component, String string) {
        return this.createHTMLDialog(component, this.getSimulation().getDescriptionPageURL(string));
    }

    public JDialog createHTMLDialog(Component component, String string) {
        return this.createDialog(component, this.createHTMLPage(string));
    }

    public JDialog createHTMLDialog(Component component, URL uRL) {
        return this.createDialog(component, this.createHTMLPage(uRL));
    }

    public JDialog createDialog(Component component, Component component2) {
        if (component2 == null) {
            return null;
        }
        JDialog jDialog = component instanceof Frame ? new JDialog((Frame)component) : (component instanceof Dialog ? new JDialog((Dialog)component) : new JDialog());
        jDialog.getContentPane().add(component2, "Center");
        jDialog.setSize(600, 400);
        return jDialog;
    }

    public JScrollPane createHTMLPage(String string) {
        Resource resource = ResourceLoader.getResource(string);
        if (resource == null) {
            System.out.println("createHTMLPage: resource not found: " + string);
            return null;
        }
        URL uRL = resource.getURL();
        if (uRL == null) {
            System.out.println("createHTMLPage: resource has a null URL: " + string);
            return null;
        }
        return this.createHTMLPage(uRL);
    }

    public JScrollPane createHTMLPage(URL uRL) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    EjsControl.this.getSimulation().openURL(hyperlinkEvent.getSource(), hyperlinkEvent.getURL(), EjsControl.this.getSimulation().getView().getComponent(EjsControl.this.getSimulation().getMainWindow()), EjsControl.this.getSimulation().getModel()._getApplet() != null);
                }
            }
        });
        try {
            jEditorPane.setPage(uRL);
            return new JScrollPane(jEditorPane);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean showDocument(String string) {
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (Simulation.isDisplayable(string2)) {
                File file = Simulation.getResourceFile(string2);
                if (file != null && OSPDesktop.open(file)) continue;
                bl = false;
                continue;
            }
            if (OSPDesktop.displayURL(string2)) continue;
            bl = false;
        }
        return bl;
    }

    public boolean openDescriptionPagesInBrowser() {
        return this.getSimulation().openDescriptionPagesInBrowser();
    }

    public boolean openDescriptionPageInBrowser(String string) {
        return this.getSimulation().openDescriptionPageInBrowser(string);
    }

    public void setDescriptionPageVisible(String string, boolean bl) {
        this.getSimulation().setDescriptionPageVisible(string, bl);
    }

    public void clearMessages() {
        if (this.messageArea != null) {
            this.messageArea.setText("");
            this.messageArea.setCaretPosition(this.messageArea.getText().length());
        }
    }

    public void println(String string) {
        this.print(String.valueOf(string) + _RETURN_);
    }

    public void println() {
        this.println("");
    }

    public void print(String string) {
        if (this.messageArea != null) {
            this.messageArea.append(string);
            this.messageArea.setCaretPosition(this.messageArea.getText().length());
        } else {
            System.out.print(string);
        }
    }
}

