/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.AbstractExplicitRKSolverInterpolator;

public class RK4
extends AbstractExplicitRKSolverInterpolator {
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;

    public RK4(ODE oDE) {
        this.ode = oDE;
    }

    protected void allocateOtherArrays() {
        this.rate2 = new double[this.dimension];
        this.rate3 = new double[this.dimension];
        this.rate4 = new double[this.dimension];
    }

    protected int getNumberOfEvaluations() {
        return 4;
    }

    protected double[] computeIntermediateStep(double d, double[] dArray) {
        int n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * this.initialRate[n] / 2.0;
            ++n;
        }
        this.ode.getRate(dArray, this.rate2);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * this.rate2[n] / 2.0;
            ++n;
        }
        this.ode.getRate(dArray, this.rate3);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * this.rate3[n];
            ++n;
        }
        this.ode.getRate(dArray, this.rate4);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (this.initialRate[n] + 2.0 * this.rate2[n] + 2.0 * this.rate3[n] + this.rate4[n]) / 6.0;
            ++n;
        }
        return dArray;
    }

    public double[] interpolate(double d, boolean bl, double[] dArray) {
        return super.interpolateBootstrap1(d, dArray);
    }
}

