/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlElement2D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.VectorField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlVectorField2D
extends ControlElement2D {
    protected static final int VECTORFIELD_ADDED = 20;
    protected static final int X_COMPONENT = 4;
    protected static final int Y_COMPONENT = 5;
    protected static final int ANGLE_COMPONENT = 7;
    protected static final int MAGNITUDE = 11;
    protected static final int MY_LINE_WIDTH = 31;
    protected VectorField field;
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.field = new VectorField();
        return this.field;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing2d.VectorField";
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 20;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("xcomponent");
            infoList.add("ycomponent");
            infoList.add("length");
            infoList.add("angles");
            infoList.add("autoscale");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("magnitude");
            infoList.add("levels");
            infoList.add("invisibleLevel");
            infoList.add("mincolor");
            infoList.add("maxcolor");
            infoList.add("style");
            infoList.add("elementposition");
            infoList.add("colormode");
            infoList.add("showLegend");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("xcomponent")) {
            return "int|double|double[][]";
        }
        if (string.equals("ycomponent")) {
            return "int|double|double[][]";
        }
        if (string.equals("length")) {
            return "int|double";
        }
        if (string.equals("angles")) {
            return "int|double|double[][]";
        }
        if (string.equals("autoscale")) {
            return "boolean";
        }
        if (string.equals("minimum")) {
            return "int|double";
        }
        if (string.equals("maximum")) {
            return "int|double";
        }
        if (string.equals("magnitude")) {
            return "int|double|double[][]";
        }
        if (string.equals("levels")) {
            return "int";
        }
        if (string.equals("invisibleLevel")) {
            return "int";
        }
        if (string.equals("mincolor")) {
            return "Color|Object";
        }
        if (string.equals("maxcolor")) {
            return "Color|Object";
        }
        if (string.equals("style")) {
            return "NewArrowStyle|int";
        }
        if (string.equals("elementposition")) {
            return "ArrowPosition|int";
        }
        if (string.equals("colormode")) {
            return "VectorColorMapper|int";
        }
        if (string.equals("showLegend")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("VectorColorMapper") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("spectrum")) {
                return new IntegerValue(0);
            }
            if (string2.equals("grayscale")) {
                return new IntegerValue(4);
            }
            if (string2.equals("red")) {
                return new IntegerValue(1);
            }
            if (string2.equals("green")) {
                return new IntegerValue(3);
            }
            if (string2.equals("blue")) {
                return new IntegerValue(2);
            }
            if (string2.equals("black")) {
                return new IntegerValue(5);
            }
            if (string2.equals("binary")) {
                return new IntegerValue(5);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.field.setMinimumX(value.getDouble());
                break;
            }
            case 1: {
                this.field.setMaximumX(value.getDouble());
                break;
            }
            case 2: {
                this.field.setMinimumY(value.getDouble());
                break;
            }
            case 3: {
                this.field.setMaximumY(value.getDouble());
                break;
            }
            case 4: {
                if (value.getObject() instanceof double[][]) {
                    this.field.setVectorSizeXData((double[][])value.getObject());
                    break;
                }
                this.field.setVectorSizeX(value.getDouble());
                break;
            }
            case 5: {
                if (value.getObject() instanceof double[][]) {
                    this.field.setVectorSizeYData((double[][])value.getObject());
                    break;
                }
                this.field.setVectorSizeY(value.getDouble());
                break;
            }
            case 6: {
                this.field.setConstantLength(value.getDouble());
                break;
            }
            case 7: {
                if (value.getObject() instanceof double[][]) {
                    this.field.setVectorAngleData((double[][])value.getObject());
                    break;
                }
                this.field.setVectorAngle(value.getDouble());
                break;
            }
            case 8: {
                this.field.setAutoscaleMagnitude(value.getBoolean());
                break;
            }
            case 9: {
                this.field.setMagnitudeExtrema(value.getDouble(), this.field.getMagnitudeMaximum());
                break;
            }
            case 10: {
                this.field.setMagnitudeExtrema(this.field.getMagnitudeMinimum(), value.getDouble());
                break;
            }
            case 11: {
                if (value.getObject() instanceof double[][]) {
                    this.field.setMagnitudeData((double[][])value.getObject());
                    break;
                }
                this.field.setMagnitude(value.getDouble());
                break;
            }
            case 12: {
                this.field.setNumberOfLevels(value.getInteger());
                break;
            }
            case 13: {
                this.field.setInvisibleLevel(value.getInteger());
                break;
            }
            case 14: {
                this.field.setMinColor((Color)value.getObject());
                break;
            }
            case 15: {
                this.field.setMaxColor((Color)value.getObject());
                break;
            }
            case 16: {
                this.field.setArrowType(value.getInteger());
                break;
            }
            case 17: {
                this.field.setRelativePosition(value.getInteger());
                break;
            }
            case 18: {
                this.field.setMapperPaletteType(value.getInteger());
                this.field.setUseColorMapper(true);
                break;
            }
            case 19: {
                this.field.setShowLegend(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 20, value);
                break;
            }
            case 31: {
                float f = (float)value.getDouble();
                for (Element element : this.field.getElements()) {
                    element.getStyle().setLineWidth(f);
                }
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.field.setMinimumX(Double.NaN);
                break;
            }
            case 1: {
                this.field.setMaximumX(Double.NaN);
                break;
            }
            case 2: {
                this.field.setMinimumY(Double.NaN);
                break;
            }
            case 3: {
                this.field.setMaximumY(Double.NaN);
                break;
            }
            case 4: {
                this.field.setVectorSizeX(1.0);
                break;
            }
            case 5: {
                this.field.setVectorSizeY(1.0);
                break;
            }
            case 6: {
                this.field.setConstantLength(Double.NaN);
                break;
            }
            case 7: {
                this.field.setVectorAngle(Double.NaN);
                break;
            }
            case 8: {
                this.field.setAutoscaleMagnitude(true);
                break;
            }
            case 9: {
                this.field.setMagnitudeExtrema(0.0, this.field.getMagnitudeMaximum());
                break;
            }
            case 10: {
                this.field.setMagnitudeExtrema(this.field.getMagnitudeMinimum(), 1.0);
                break;
            }
            case 11: {
                this.field.setMagnitude(Double.NaN);
                break;
            }
            case 12: {
                this.field.setNumberOfLevels(16);
                break;
            }
            case 13: {
                this.field.setInvisibleLevel(-1);
                break;
            }
            case 14: {
                this.field.setMinColor(Color.BLUE);
                break;
            }
            case 15: {
                this.field.setMaxColor(Color.RED);
                break;
            }
            case 16: {
                this.field.setArrowType(0);
                break;
            }
            case 17: {
                this.field.setRelativePosition(5);
                break;
            }
            case 18: {
                this.field.setUseColorMapper(false);
                break;
            }
            case 19: {
                this.field.setShowLegend(false);
                break;
            }
            default: {
                super.setDefaultValue(n - 20);
                break;
            }
            case 31: {
                for (Element element : this.field.getElements()) {
                    element.getStyle().setLineWidth(1.0f);
                }
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "<none>";
            }
            case 4: 
            case 5: {
                return "1";
            }
            case 6: {
                return "<none>";
            }
            case 7: {
                return "<none>";
            }
            case 8: {
                return "true";
            }
            case 9: {
                return "0";
            }
            case 10: {
                return "1";
            }
            case 11: {
                return "<none>";
            }
            case 12: {
                return "16";
            }
            case 13: {
                return "-1";
            }
            case 14: {
                return "BLUE";
            }
            case 15: {
                return "RED";
            }
            case 16: {
                return "ARROW";
            }
            case 17: {
                return "NORTH_EAST";
            }
            case 18: {
                return "<none>";
            }
            case 19: {
                return "false";
            }
            default: {
                return super.getDefaultValueString(n - 20);
            }
            case 31: 
        }
        return "1";
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return null;
            }
            default: {
                return super.getValue(n - 20);
            }
            case 31: 
        }
        return null;
    }
}

