/*
 * Decompiled with CFR 0.152.
 */
package RoessMa.Differentialgleichungen_Chaos.Wedge_pkg;

import RoessMa.Differentialgleichungen_Chaos.Wedge_pkg.Wedge;
import RoessMa.Differentialgleichungen_Chaos.Wedge_pkg.WedgeSimulation;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.drawables.ControlDataRaster;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlParsedNumberField;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.display2d.DataRaster;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing2d.PlottingPanel2D;

class WedgeView
extends EjsControl
implements View {
    private WedgeSimulation _simulation = null;
    private Wedge _model = null;
    public Component drawingFrame;
    public DrawingPanel2D drawingPanel;
    public InteractiveTrace trace;
    public InteractiveParticle particle;
    public InteractiveArrow rightWedge;
    public InteractiveArrow right;
    public InteractiveArrow leftWedge;
    public InteractiveArrow left;
    public InteractiveArrow v;
    public InteractiveParticle floor;
    public JPanel controlPanel;
    public JPanel buttonsPanel;
    public JButton startStopButton;
    public JButton resetButton;
    public JPanel paramPanel;
    public JLabel space;
    public JTextField angleField;
    public JCheckBox highSpeedBox;
    public JDialog poincareDialog;
    public PlottingPanel2D poincarePanel;
    public InteractivePoligon analyticCurve;
    public DataRaster points;
    private boolean __x_canBeChanged__ = true;
    private boolean __vx_canBeChanged__ = true;
    private boolean __y_canBeChanged__ = true;
    private boolean __vy_canBeChanged__ = true;
    private boolean __t_canBeChanged__ = true;
    private boolean __dt_canBeChanged__ = true;
    private boolean __angle_canBeChanged__ = true;
    private boolean __g_canBeChanged__ = true;
    private boolean __points_index_canBeChanged__ = true;
    private boolean __high_speed_canBeChanged__ = true;

    public WedgeView(WedgeSimulation wedgeSimulation, String string, Frame frame) {
        super(wedgeSimulation, string, frame);
        this._simulation = wedgeSimulation;
        this._model = (Wedge)wedgeSimulation.getModel();
        this._model._view = this;
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model._resetModel();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        if (SwingUtilities.isEventDispatchThread()) {
            this.createControl();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        WedgeView.this.createControl();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("x", "apply(\"x\")");
        this.addListener("vx", "apply(\"vx\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("vy", "apply(\"vy\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("angle", "apply(\"angle\")");
        this.addListener("g", "apply(\"g\")");
        this.addListener("points_index", "apply(\"points_index\")");
        this.addListener("high_speed", "apply(\"high_speed\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
            this.__x_canBeChanged__ = true;
        }
        if ("vx".equals(string)) {
            this._model.vx = this.getDouble("vx");
            this.__vx_canBeChanged__ = true;
        }
        if ("y".equals(string)) {
            this._model.y = this.getDouble("y");
            this.__y_canBeChanged__ = true;
        }
        if ("vy".equals(string)) {
            this._model.vy = this.getDouble("vy");
            this.__vy_canBeChanged__ = true;
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
            this.__t_canBeChanged__ = true;
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
            this.__dt_canBeChanged__ = true;
        }
        if ("angle".equals(string)) {
            this._model.angle = this.getDouble("angle");
            this.__angle_canBeChanged__ = true;
        }
        if ("g".equals(string)) {
            this._model.g = this.getDouble("g");
            this.__g_canBeChanged__ = true;
        }
        if ("points_index".equals(string)) {
            this._model.points_index = this.getInt("points_index");
            this.__points_index_canBeChanged__ = true;
        }
        if ("high_speed".equals(string)) {
            this._model.high_speed = this.getBoolean("high_speed");
            this.__high_speed_canBeChanged__ = true;
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        if (this.__x_canBeChanged__) {
            this.setValue("x", this._model.x);
        }
        if (this.__vx_canBeChanged__) {
            this.setValue("vx", this._model.vx);
        }
        if (this.__y_canBeChanged__) {
            this.setValue("y", this._model.y);
        }
        if (this.__vy_canBeChanged__) {
            this.setValue("vy", this._model.vy);
        }
        if (this.__t_canBeChanged__) {
            this.setValue("t", this._model.t);
        }
        if (this.__dt_canBeChanged__) {
            this.setValue("dt", this._model.dt);
        }
        if (this.__angle_canBeChanged__) {
            this.setValue("angle", this._model.angle);
        }
        if (this.__g_canBeChanged__) {
            this.setValue("g", this._model.g);
        }
        if (this.__points_index_canBeChanged__) {
            this.setValue("points_index", this._model.points_index);
        }
        if (this.__high_speed_canBeChanged__) {
            this.setValue("high_speed", this._model.high_speed);
        }
    }

    public void blockVariable(String string) {
        if ("x".equals(string)) {
            this.__x_canBeChanged__ = false;
        }
        if ("vx".equals(string)) {
            this.__vx_canBeChanged__ = false;
        }
        if ("y".equals(string)) {
            this.__y_canBeChanged__ = false;
        }
        if ("vy".equals(string)) {
            this.__vy_canBeChanged__ = false;
        }
        if ("t".equals(string)) {
            this.__t_canBeChanged__ = false;
        }
        if ("dt".equals(string)) {
            this.__dt_canBeChanged__ = false;
        }
        if ("angle".equals(string)) {
            this.__angle_canBeChanged__ = false;
        }
        if ("g".equals(string)) {
            this.__g_canBeChanged__ = false;
        }
        if ("points_index".equals(string)) {
            this.__points_index_canBeChanged__ = false;
        }
        if ("high_speed".equals(string)) {
            this.__high_speed_canBeChanged__ = false;
        }
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.drawingFrame = (Component)this.addElement(new ControlFrame(), "drawingFrame").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.drawingFrame.title", "Ball in Wedge")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,0").setProperty("size", this._simulation.translateString("View.drawingFrame.size", "\"380,314\"")).getObject();
        this.drawingPanel = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "drawingPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "drawingFrame").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1").setProperty("maximumX", "1.0").setProperty("minimumY", "0").setProperty("maximumY", "1.1").setProperty("square", "true").setProperty("TRmessage", "%_model._method_for_drawingPanel_TRmessage()%").getObject();
        this.trace = (InteractiveTrace)this.addElement(new ControlTrace(), "trace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "x").setProperty("y", "y").setProperty("maxpoints", "100").setProperty("norepeat", "true").setProperty("connected", "true").getObject();
        this.particle = (InteractiveParticle)this.addElement(new ControlParticle(), "particle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "x").setProperty("y", "y").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_particle_dragaction()").setProperty("action", "_model._method_for_particle_action()").getObject();
        this.rightWedge = (InteractiveArrow)this.addElement(new ControlArrow(), "rightWedge").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "%_model._method_for_rightWedge_x()%").setProperty("y", "%_model._method_for_rightWedge_y()%").setProperty("sizex", "%_model._method_for_rightWedge_sizex()%").setProperty("sizey", "%_model._method_for_rightWedge_sizey()%").setProperty("enabled", "true").setProperty("style", "SEGMENT").getObject();
        this.right = (InteractiveArrow)this.addElement(new ControlArrow(), "right").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "0").setProperty("y", "0").setProperty("sizex", "%_model._method_for_right_sizex()%").setProperty("sizey", "%_model._method_for_right_sizey()%").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_right_dragaction()").setProperty("style", "BOX").setProperty("secondaryColor", "red").getObject();
        this.leftWedge = (InteractiveArrow)this.addElement(new ControlArrow(), "leftWedge").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "%_model._method_for_leftWedge_x()%").setProperty("y", "%_model._method_for_leftWedge_y()%").setProperty("sizex", "%_model._method_for_leftWedge_sizex()%").setProperty("sizey", "%_model._method_for_leftWedge_sizey()%").setProperty("enabled", "true").setProperty("style", "SEGMENT").getObject();
        this.left = (InteractiveArrow)this.addElement(new ControlArrow(), "left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "0").setProperty("y", "0").setProperty("sizex", "%_model._method_for_left_sizex()%").setProperty("sizey", "%_model._method_for_left_sizey()%").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_left_dragaction()").setProperty("style", "BOX").setProperty("secondaryColor", "red").getObject();
        this.v = (InteractiveArrow)this.addElement(new ControlArrow(), "v").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "x").setProperty("y", "y").setProperty("sizex", "vx").setProperty("sizey", "vy").setProperty("scalex", "0.5").setProperty("scaley", "0.5").setProperty("enabled", "true").setProperty("secondaryColor", "green").getObject();
        this.floor = (InteractiveParticle)this.addElement(new ControlParticle(), "floor").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("y", "-0.05").setProperty("sizex", "1").setProperty("sizey", ".1").setProperty("enabled", "true").setProperty("style", "RECTANGLE").setProperty("color", "pink").getObject();
        this.controlPanel = (JPanel)this.addElement(new ControlPanel(), "controlPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "drawingFrame").setProperty("layout", "FLOW:left,0,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.buttonsPanel = (JPanel)this.addElement(new ControlPanel(), "buttonsPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "controlPanel").setProperty("layout", "flow:center,0,0").setProperty("border", "0,0,0,0").getObject();
        this.startStopButton = (JButton)this.addElement(new ControlTwoStateButton(), "startStopButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("variable", "_isPaused").setProperty("imageOn", this._simulation.translateString("View.startStopButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startStopButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startStopButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startStopButton_actionOff()").getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("action", "_model._method_for_resetButton_action()").getObject();
        this.paramPanel = (JPanel)this.addElement(new ControlPanel(), "paramPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "controlPanel").setProperty("layout", "border").getObject();
        this.space = (JLabel)this.addElement(new ControlLabel(), "space").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "paramPanel").setProperty("text", this._simulation.translateString("View.space.text", "\"   angle=\"")).getObject();
        this.angleField = (JTextField)this.addElement(new ControlParsedNumberField(), "angleField").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "paramPanel").setProperty("variable", "angle").setProperty("value", "0.3").setProperty("action", "_model._method_for_angleField_action()").setProperty("size", this._simulation.translateString("View.angleField.size", "\"60,23\"")).getObject();
        this.highSpeedBox = (JCheckBox)this.addElement(new ControlCheckBox(), "highSpeedBox").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "controlPanel").setProperty("variable", "high_speed").setProperty("text", this._simulation.translateString("View.highSpeedBox.text", "high speed")).setProperty("action", "_model._method_for_highSpeedBox_action()").getObject();
        this.poincareDialog = (JDialog)this.addElement(new ControlDialog(), "poincareDialog").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.poincareDialog.title", "Poincare Section")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "395,1").setProperty("size", this._simulation.translateString("View.poincareDialog.size", "\"380,313\"")).getObject();
        this.poincarePanel = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "poincarePanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "poincareDialog").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1").setProperty("maximumX", "1").setProperty("minimumY", "0").setProperty("maximumY", "1.1").setProperty("action", "_model._method_for_poincarePanel_action()").setProperty("titleX", this._simulation.translateString("View.poincarePanel.titleX", "v_r")).setProperty("majorTicksX", "false").setProperty("titleY", this._simulation.translateString("View.poincarePanel.titleY", "v_n^2")).setProperty("majorTicksY", "false").getObject();
        this.analyticCurve = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "analyticCurve").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "poincarePanel").setProperty("points", "200").setProperty("min", "-1").setProperty("max", "1").setProperty("variable", "x").setProperty("functionx", "x").setProperty("functiony", "1-x*x").setProperty("enabled", "false").getObject();
        this.points = (DataRaster)this.addElement(new ControlDataRaster(), "points").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "poincarePanel").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0").getObject();
    }

    public void reset() {
        this.getElement("drawingFrame").setProperty("title", this._simulation.translateString("View.drawingFrame.title", "Ball in Wedge")).setProperty("visible", "true");
        this.getElement("drawingPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1").setProperty("maximumX", "1.0").setProperty("minimumY", "0").setProperty("maximumY", "1.1").setProperty("square", "true");
        this.getElement("trace").setProperty("maxpoints", "100").setProperty("norepeat", "true").setProperty("connected", "true");
        this.getElement("particle").setProperty("enabled", "true");
        this.getElement("rightWedge").setProperty("enabled", "true").setProperty("style", "SEGMENT");
        this.getElement("right").setProperty("x", "0").setProperty("y", "0").setProperty("enabled", "true").setProperty("style", "BOX").setProperty("secondaryColor", "red");
        this.getElement("leftWedge").setProperty("enabled", "true").setProperty("style", "SEGMENT");
        this.getElement("left").setProperty("x", "0").setProperty("y", "0").setProperty("enabled", "true").setProperty("style", "BOX").setProperty("secondaryColor", "red");
        this.getElement("v").setProperty("scalex", "0.5").setProperty("scaley", "0.5").setProperty("enabled", "true").setProperty("secondaryColor", "green");
        this.getElement("floor").setProperty("y", "-0.05").setProperty("sizex", "1").setProperty("sizey", ".1").setProperty("enabled", "true").setProperty("style", "RECTANGLE").setProperty("color", "pink");
        this.getElement("controlPanel").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("buttonsPanel").setProperty("border", "0,0,0,0");
        this.getElement("startStopButton").setProperty("imageOn", this._simulation.translateString("View.startStopButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startStopButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif"));
        this.getElement("paramPanel");
        this.getElement("space").setProperty("text", this._simulation.translateString("View.space.text", "\"   angle=\""));
        this.getElement("angleField").setProperty("value", "0.3").setProperty("size", this._simulation.translateString("View.angleField.size", "\"60,23\""));
        this.getElement("highSpeedBox").setProperty("text", this._simulation.translateString("View.highSpeedBox.text", "high speed"));
        this.getElement("poincareDialog").setProperty("title", this._simulation.translateString("View.poincareDialog.title", "Poincare Section")).setProperty("visible", "true");
        this.getElement("poincarePanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1").setProperty("maximumX", "1").setProperty("minimumY", "0").setProperty("maximumY", "1.1").setProperty("titleX", this._simulation.translateString("View.poincarePanel.titleX", "v_r")).setProperty("majorTicksX", "false").setProperty("titleY", this._simulation.translateString("View.poincarePanel.titleY", "v_n^2")).setProperty("majorTicksY", "false");
        this.getElement("analyticCurve").setProperty("points", "200").setProperty("min", "-1").setProperty("max", "1").setProperty("functiony", "1-x*x").setProperty("enabled", "false");
        this.getElement("points").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0");
        this.__x_canBeChanged__ = true;
        this.__vx_canBeChanged__ = true;
        this.__y_canBeChanged__ = true;
        this.__vy_canBeChanged__ = true;
        this.__t_canBeChanged__ = true;
        this.__dt_canBeChanged__ = true;
        this.__angle_canBeChanged__ = true;
        this.__g_canBeChanged__ = true;
        this.__points_index_canBeChanged__ = true;
        this.__high_speed_canBeChanged__ = true;
        super.reset();
    }
}

