/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;

public class HighlightableDataset
extends Dataset
implements Interactive {
    boolean[] highlighted = new boolean[1];
    boolean[] previous;
    Color highlightColor = new Color(255, 255, 0, 128);
    Shape highlightShape;
    Shape[] hitShapes;
    int hitIndex = -1;

    public HighlightableDataset() {
    }

    public HighlightableDataset(Color color) {
        super(color);
    }

    public HighlightableDataset(Color color, Color color2, boolean bl) {
        super(color, color2, bl);
    }

    public void append(double d, double d2) {
        super.append(d, d2);
        this.adjustCapacity(this.xpoints.length);
    }

    public void append(double[] dArray, double[] dArray2) {
        super.append(dArray, dArray2);
        this.adjustCapacity(this.xpoints.length);
    }

    public void clear() {
        super.clear();
        this.previous = this.highlighted;
        this.highlighted = new boolean[this.xpoints.length];
    }

    public void restoreHighlights() {
        if (this.previous != null && this.previous.length == this.highlighted.length) {
            this.highlighted = this.previous;
        }
    }

    public void clearHighlights() {
        int n = 0;
        while (n < this.highlighted.length) {
            this.highlighted[n] = false;
            ++n;
        }
    }

    public void setHighlighted(int n, boolean bl) {
        if (n >= this.highlighted.length) {
            this.adjustCapacity(n + 1);
        }
        this.highlighted[n] = bl;
    }

    public boolean isHighlighted(int n) {
        if (n >= this.highlighted.length) {
            this.adjustCapacity(n + 1);
        }
        return this.highlighted[n];
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    protected void moveDatum(int n) {
        super.moveDatum(n);
    }

    private synchronized void adjustCapacity(int n) {
        int n2 = Math.max(this.xpoints.length, n);
        if (this.highlighted.length == n2) {
            return;
        }
        boolean[] blArray = this.highlighted;
        this.highlighted = new boolean[n2];
        int n3 = Math.min(blArray.length, n2);
        System.arraycopy(blArray, 0, this.highlighted, 0, n3);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        super.draw(drawingPanel, graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getMarkerSize() + 4;
        int n2 = 2 * n;
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(drawingPanel.leftGutter - n - 1, drawingPanel.topGutter - n - 1, drawingPanel.getWidth() - drawingPanel.leftGutter - drawingPanel.rightGutter + 2 + 2 * n, drawingPanel.getHeight() - drawingPanel.bottomGutter - drawingPanel.topGutter + 2 + 2 * n);
        Rectangle rectangle = drawingPanel.getViewRect();
        if (rectangle != null) {
            graphics2D.clipRect(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
        this.hitShapes = new Shape[this.index];
        int n3 = 0;
        while (n3 < this.index) {
            if (!Double.isNaN(this.ypoints[n3])) {
                double d = drawingPanel.xToPix(this.xpoints[n3]);
                double d2 = drawingPanel.yToPix(this.ypoints[n3]);
                this.hitShapes[n3] = new Rectangle2D.Double(d - (double)n, d2 - (double)n, n2, n2);
                if (this.isHighlighted(n3)) {
                    graphics2D.setColor(this.highlightColor);
                    graphics2D.fill(this.hitShapes[n3]);
                }
            }
            ++n3;
        }
        graphics2D.setClip(shape);
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        int n3 = drawingPanel.getLeftGutter();
        int n4 = drawingPanel.getRightGutter();
        int n5 = drawingPanel.getTopGutter();
        int n6 = drawingPanel.getBottomGutter();
        Dimension dimension = drawingPanel.getSize();
        if (n < n3 || n > dimension.width - n4) {
            return null;
        }
        if (n2 < n5 || n2 > dimension.height - n6) {
            return null;
        }
        this.hitIndex = -1;
        int n7 = 0;
        while (n7 < this.index) {
            if (this.hitShapes != null && n7 < this.hitShapes.length && this.hitShapes[n7] != null && this.hitShapes[n7].contains(n, n2)) {
                this.hitIndex = n7;
                return this;
            }
            ++n7;
        }
        return null;
    }

    public int getHitIndex() {
        return this.hitIndex;
    }

    public void setEnabled(boolean bl) {
    }

    public boolean isEnabled() {
        return true;
    }

    public void setXY(double d, double d2) {
    }

    public void setX(double d) {
    }

    public void setY(double d) {
    }

    public double getX() {
        if (this.hitIndex > -1) {
            return this.xpoints[this.hitIndex];
        }
        return Double.NaN;
    }

    public double getY() {
        if (this.hitIndex > -1) {
            return this.ypoints[this.hitIndex];
        }
        return Double.NaN;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            XML.getLoader(Dataset.class).saveObject(xMLControl, object);
            HighlightableDataset highlightableDataset = (HighlightableDataset)object;
            xMLControl.setValue("highlighted", highlightableDataset.highlighted);
        }

        public Object createObject(XMLControl xMLControl) {
            return new HighlightableDataset();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            XML.getLoader(Dataset.class).loadObject(xMLControl, object);
            HighlightableDataset highlightableDataset = (HighlightableDataset)object;
            boolean[] blArray = (boolean[])xMLControl.getObject("highlighted");
            if (blArray != null) {
                highlightableDataset.highlighted = blArray;
            }
            return highlightableDataset;
        }
    }
}

