/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.display.TextLine;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public class SimpleElementText
extends SimpleElement {
    private double[] coordinates = new double[3];
    private double[] pixel = new double[3];
    private AffineTransform transform = new AffineTransform();

    public SimpleElementText(ElementText elementText) {
        super(elementText);
        this.objects = new Object3D[]{new Object3D(this, 0)};
    }

    public void processChanges(int n, int n2) {
        if ((n2 & 0x136) != 0) {
            this.computePosition();
            this.projectPoint();
        } else if ((n2 & 0x40) != 0) {
            this.projectPoint();
        }
    }

    public void styleChanged(int n) {
        if (n == 5) {
            TextLine textLine = ((ElementText)this.element).getTextLine();
            switch (this.style.getRelativePosition()) {
                default: {
                    textLine.setJustification(0);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    textLine.setJustification(2);
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    textLine.setJustification(1);
                    break;
                }
            }
        } else {
            super.styleChanged(n);
        }
    }

    public void draw(Graphics2D graphics2D, int n) {
        Color color = this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[0].getDistance());
        this.drawIt(graphics2D, color);
    }

    public void drawQuickly(Graphics2D graphics2D) {
        this.drawIt(graphics2D, this.style.getLineColor());
    }

    private void computePosition() {
        System.arraycopy(Element.STD_ORIGIN, 0, this.coordinates, 0, 3);
        this.element.sizeAndToSpaceFrame(this.coordinates);
    }

    private void projectPoint() {
        System.arraycopy(this.coordinates, 0, this.pixel, 0, 3);
        this.element.getPanel().projectPosition(this.pixel);
        this.objects[0].setDistance(this.pixel[2] * this.style.getDepthFactor());
    }

    private void drawIt(Graphics2D graphics2D, Color color) {
        ElementText elementText = (ElementText)this.element;
        TextLine textLine = elementText.getTextLine();
        textLine.setColor(color);
        double d = elementText.getRotationAngle();
        if (d != 0.0) {
            AffineTransform affineTransform = graphics2D.getTransform();
            this.transform.setTransform(affineTransform);
            this.transform.rotate(-d, this.pixel[0], this.pixel[1]);
            graphics2D.setTransform(this.transform);
            textLine.drawText(graphics2D, (int)this.pixel[0], (int)this.pixel[1]);
            graphics2D.setTransform(affineTransform);
        } else {
            textLine.drawText(graphics2D, (int)this.pixel[0], (int)this.pixel[1]);
        }
    }
}

