/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;

public class DataTableFrame
extends OSPFrame {
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenuItem saveAsItem;
    protected DataTable table;

    public DataTableFrame(DataTable dataTable) {
        this(DisplayRes.getString("DataTableFrame.DefaultTitle"), dataTable);
    }

    public DataTableFrame(String string, DataTable dataTable) {
        super(string);
        this.table = dataTable;
        JScrollPane jScrollPane = new JScrollPane(this.table);
        Container container = this.getContentPane();
        container.add((Component)jScrollPane, "Center");
        this.pack();
        if (!OSPRuntime.appletMode) {
            this.createMenuBar();
            this.loadDisplayMenu();
        }
    }

    protected JMenu loadDisplayMenu() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = new JMenu();
        jMenu.setText(DisplayRes.getString("DataTableFrame.Display_menu_title"));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DataTableFrame.NumberFormat_menu_item_title"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTableFrame.this.setNumberFormat();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu(DisplayRes.getString("DataTableFrame.File_menu_item_title"));
        this.editMenu = new JMenu(DisplayRes.getString("DataTableFrame.Edit_menu_item_title"));
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DataTableFrame.SaveAs_menu_item_title"));
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DataTableFrame.Copy_menu_item_title"));
        JMenuItem jMenuItem3 = new JMenuItem(DisplayRes.getString("DataTableFrame.SelectAll_menu_item_title"));
        this.fileMenu.add(jMenuItem);
        this.editMenu.add(jMenuItem2);
        this.editMenu.add(jMenuItem3);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(67, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTableFrame.this.copy();
            }
        });
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(65, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTableFrame.this.table.selectAll();
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTableFrame.this.saveAs();
            }
        });
        this.validate();
    }

    void setNumberFormat() {
        int n = this.table.getMaximumFractionDigits();
        String string = JOptionPane.showInputDialog(this, DisplayRes.getString("DataTableFrame.NumberOfDigits_option_pane_title"), "" + n);
        if (string == null) {
            return;
        }
        n = Integer.parseInt(string);
        n = Math.max(n, 1);
        this.table.setMaximumFractionDigits(Math.min(n, 16));
        this.table.refreshTable();
    }

    public void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        int[] nArray = this.table.getSelectedRows();
        int[] nArray2 = this.table.getSelectedColumns();
        StringBuffer stringBuffer = this.getSelectedData(nArray, nArray2);
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void refreshTable() {
        this.table.refreshTable();
    }

    public StringBuffer getSelectedData(int[] nArray, int[] nArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray2.length) {
                int n3 = n;
                int n4 = this.table.convertColumnIndexToModel(nArray2[n2]);
                if (!this.table.isRowNumberVisible() || n4 != 0) {
                    Object object = this.table.getValueAt(n3, nArray2[n2]);
                    if (object != null) {
                        stringBuffer.append(object);
                    }
                    stringBuffer.append("\t");
                }
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer;
    }

    public void sort(int n) {
        this.table.sort(n);
    }

    public void saveAs() {
        File file = GUIUtils.showSaveDialog(this);
        if (file == null) {
            return;
        }
        int n = 0;
        int n2 = this.table.getRowCount() - 1;
        int n3 = this.table.getColumnCount() - 1;
        int n4 = 0;
        if (this.table.isRowNumberVisible()) {
            ++n4;
        }
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n3 + 1];
        int n5 = n;
        while (n5 <= n2) {
            nArray[n5] = n5;
            ++n5;
        }
        n5 = n4;
        while (n5 <= n3) {
            nArray2[n5] = n5;
            ++n5;
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.print(this.getSelectedData(nArray, nArray2));
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, DisplayRes.getString("DataTableFrame.SaveErrorMessage"), DisplayRes.getString("DataTableFrame.Error"), 0);
        }
    }
}

