/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ToolsRes;

public class Diagnostics {
    static final String JAVA_3D_URL = "http://java3d.java.net/binary-builds.html";
    static final String NEWLINE = System.getProperty("line.separator", "\n");

    public static void aboutJava() {
        String string = System.getProperty("java.version", "unknown version");
        String string2 = System.getProperty("java.runtime.name");
        String string3 = System.getProperty("java.runtime.version");
        String string4 = System.getProperty("java.vm.name");
        String string5 = System.getProperty("java.vm.version");
        String string6 = System.getProperty("java.home");
        String string7 = OSPRuntime.getVMBitness() == 64 ? " (64-bit)" : " (32-bit)";
        String string8 = String.valueOf(ToolsRes.getString("Diagnostics.Java.About.Version")) + " " + string + string7 + NEWLINE + string2 + " (build " + string3 + ")" + NEWLINE + string4 + " (build " + string5 + ")" + NEWLINE + "JRE path " + string6 + NEWLINE + NEWLINE + "Available Processors: " + Runtime.getRuntime().availableProcessors() + NEWLINE + "Total Memory: " + Runtime.getRuntime().totalMemory() / 1000000L + " MB" + NEWLINE + "Free Memory: " + Runtime.getRuntime().freeMemory() / 1000000L + " MB" + NEWLINE;
        JOptionPane.showMessageDialog(null, string8, ToolsRes.getString("Diagnostics.Java.About.Title"), 1);
    }

    public static void aboutQTJava() {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (OSPRuntime.isLinux()) {
            JOptionPane.showMessageDialog(null, ToolsRes.getString("Diagnostics.QTJava.Linux"), ToolsRes.getString("Diagnostics.QTJava.About.Title"), 1);
            return;
        }
        String string2 = null;
        String string3 = null;
        try {
            object3 = Class.forName("quicktime.util.QTBuild");
            object2 = ((Class)object3).getMethod("info", null);
            string2 = (String)((Method)object2).invoke(null, null);
            object3 = Class.forName("org.opensourcephysics.media.quicktime.QT");
            object2 = ((Class)object3).getMethod("start", null);
            ((Method)object2).invoke(null, null);
            object3 = Class.forName("quicktime.QTSession");
            object2 = ((Class)object3).getMethod("getMajorVersion", null);
            string3 = "" + ((Method)object2).invoke(null, null);
            object2 = ((Class)object3).getMethod("getMinorVersion", null);
            string3 = String.valueOf(string3) + "." + ((Method)object2).invoke(null, null);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        object3 = System.getProperty("java.ext.dirs");
        object2 = System.getProperty("path.separator");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = ((String)object3).indexOf((String)object2);
        while (n > -1) {
            arrayList.add(((String)object3).substring(0, n));
            object3 = ((String)object3).substring(n + 1);
            n = ((String)object3).indexOf((String)object2);
        }
        if (!"".equals(object3)) {
            arrayList.add(object3);
        }
        String string4 = System.getProperty("file.separator", "/");
        File file = null;
        for (String string5 : arrayList) {
            file = new File(String.valueOf(string5) + string4 + "QTJava.zip");
            if (file.exists()) continue;
            file = null;
        }
        String string5 = string = file == null ? ToolsRes.getString("Diagnostics.About.Unknown") : file.getAbsolutePath();
        if (string3 != null && string2 != null) {
            object = String.valueOf(ToolsRes.getString("Diagnostics.QuickTime.About.Version")) + " " + string3;
            object = String.valueOf(object) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.Version") + " ";
            object = String.valueOf(object) + string2.substring(string2.indexOf(":") + 1, string2.indexOf("]"));
            if (file != null) {
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                Date date = new Date(file.lastModified());
                object = String.valueOf(object) + " (" + dateFormat.format(date) + ")";
            }
            object = String.valueOf(object) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.JarPath");
            object = String.valueOf(object) + " " + string;
            JOptionPane.showMessageDialog(null, object, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 1);
        } else if (file != null) {
            if (OSPRuntime.getVMBitness() == 64) {
                JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("Diagnostics.QTJava.About.WrongBitness.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.WrongBitness.Message"), ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
                return;
            }
            object = ToolsRes.getString("Diagnostics.QTJava.Error.Message");
            object = String.valueOf(object) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.JarPath");
            object = String.valueOf(object) + " " + string;
            JOptionPane.showMessageDialog(null, object, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
        } else {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("Diagnostics.QTJava.NotFound.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.NotFound.Message2"), ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
        }
    }

    public static void aboutJava3D() {
        Object object;
        Object object2;
        if (OSPRuntime.isMac() && !OSPRuntime.hasJava3D()) {
            return;
        }
        Map map = null;
        try {
            object2 = Class.forName("javax.media.j3d.VirtualUniverse");
            object = ((Class)object2).getMethod("getProperties", null);
            map = (Map)((Method)object).invoke(null, null);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        object2 = System.getProperty("java.ext.dirs");
        object = System.getProperty("path.separator");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = ((String)object2).indexOf((String)object);
        while (n > -1) {
            arrayList.add(((String)object2).substring(0, n));
            object2 = ((String)object2).substring(n + 1);
            n = ((String)object2).indexOf((String)object);
        }
        if (!"".equals(object2)) {
            arrayList.add(object2);
        }
        File file = null;
        String string = System.getProperty("file.separator", "/");
        for (String string2 : arrayList) {
            file = new File(String.valueOf(string2) + string + "j3dcore.jar");
            if (file.exists()) continue;
            file = null;
        }
        if (map != null) {
            String string2 = (String)map.get("j3d.version");
            String string3 = (String)map.get("j3d.vendor");
            String string4 = file == null ? ToolsRes.getString("Diagnostics.About.Unknown") : file.getPath();
            String string5 = String.valueOf(ToolsRes.getString("Diagnostics.Java3D.About.Version")) + " " + string2 + NEWLINE + (String)string3 + NEWLINE + ToolsRes.getString("Diagnostics.Java3D.About.JarPath") + " " + string4;
            JOptionPane.showMessageDialog(null, string5, ToolsRes.getString("Diagnostics.Java3D.About.Title"), 1);
        } else if (file != null) {
            JOptionPane.showMessageDialog(null, ToolsRes.getString("Diagnostics.Java3D.Error.Message"), ToolsRes.getString("Diagnostics.Java3D.About.Title"), 2);
        } else {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("Diagnostics.Java3D.NotFound.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.Download.Message") + NEWLINE + JAVA_3D_URL, ToolsRes.getString("Diagnostics.Java3D.About.Title"), 2);
        }
    }

    public static void aboutJOGL() {
        Object object;
        String string;
        Object object2;
        Object object3;
        String string2 = null;
        try {
            object3 = Class.forName("javax.media.opengl.glu.GLU");
            object2 = ((Class)object3).getField("versionString");
            string2 = (String)((Field)object2).get(null);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        object3 = System.getProperty("java.ext.dirs");
        object2 = System.getProperty("path.separator");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = ((String)object3).indexOf((String)object2);
        while (n > -1) {
            arrayList.add(((String)object3).substring(0, n));
            object3 = ((String)object3).substring(n + 1);
            n = ((String)object3).indexOf((String)object2);
        }
        if (!"".equals(object3)) {
            arrayList.add(object3);
        }
        File file = null;
        String string3 = System.getProperty("file.separator", "/");
        for (String string4 : arrayList) {
            file = new File(String.valueOf(string4) + string3 + "jogl.jar");
            if (file.exists()) continue;
            file = null;
        }
        String string4 = string = file == null ? ToolsRes.getString("Diagnostics.About.Unknown") : file.getPath();
        if (string2 != null) {
            object = String.valueOf(ToolsRes.getString("Diagnostics.JOGL.About.Version")) + " " + string2 + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.About.JarPath") + " " + string;
            JOptionPane.showMessageDialog(null, object, ToolsRes.getString("Diagnostics.JOGL.About.Title"), 1);
        } else if (file != null) {
            object = String.valueOf(ToolsRes.getString("Diagnostics.JOGL.Error.Message")) + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.About.JarPath") + " " + string;
            JOptionPane.showMessageDialog(null, object, ToolsRes.getString("Diagnostics.JOGL.About.Title"), 2);
        } else {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("Diagnostics.JOGL.NotFound.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.NotFound.Message2"), ToolsRes.getString("Diagnostics.JOGL.About.Title"), 2);
        }
    }

    public static void aboutLaunchJar() {
        if (OSPRuntime.getLaunchJarPath() != null) {
            JarFile jarFile = OSPRuntime.getLaunchJar();
            try {
                if (jarFile != null) {
                    String string = String.valueOf(ToolsRes.getString("Diagnostics.Jar.About.Message.JarFile")) + " \"" + XML.getName(OSPRuntime.getLaunchJarPath()) + "\". ";
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        String string2 = jarEntry.getName().toLowerCase();
                        if (!string2.endsWith(".dsa") || !string2.startsWith("meta-inf")) continue;
                        string = String.valueOf(string) + ToolsRes.getString("Diagnostics.Jar.About.Message.Signed");
                        JOptionPane.showMessageDialog(null, string, ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
                        return;
                    }
                    string = String.valueOf(string) + ToolsRes.getString("Diagnostics.Jar.About.Message.NotSigned");
                    JOptionPane.showMessageDialog(null, string, ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(null, ToolsRes.getString("Diagnostics.Jar.About.Message.NoJarFile"), ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
        }
    }

    public static void aboutOS() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        String string3 = String.valueOf(ToolsRes.getString("Diagnostics.OS.About.Name")) + " " + string + NEWLINE;
        string3 = String.valueOf(string3) + ToolsRes.getString("Diagnostics.OS.About.Version") + " " + string2 + NEWLINE;
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String string4;
            String string5 = (String)enumeration.nextElement();
            if (!string5.startsWith("os.") || (string4 = System.getProperty(string5)).equals(string) || string4.equals(string2)) continue;
            string3 = String.valueOf(string3) + string5 + ":  " + string4 + NEWLINE;
        }
        JOptionPane.showMessageDialog(null, string3, ToolsRes.getString("Diagnostics.OS.About.Title"), 1);
    }

    public static void main(String[] stringArray) {
        Diagnostics.aboutJava();
    }
}

