/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Container;
import java.io.File;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ExtensionsManager;
import org.opensourcephysics.tools.XuggleRes;

public class DiagnosticsForXuggle {
    public static final String XUGGLE_URL = "http://www.compadre.org/osp/items/detail.cfm?ID=11606";
    static String newline;
    static String[] xuggleJarNames;
    static boolean is64BitVM;
    static String xuggleHome;
    static String javaExtDirectory;
    static String pathEnvironment;
    static String pathValue;
    static File[] xuggleHomeJars;
    static File[] javaExtensionJars;

    static {
        String string;
        newline = System.getProperty("line.separator", "\n");
        xuggleJarNames = new String[]{"xuggle-xuggler.jar", "logback-core.jar", "logback-classic.jar", "slf4j-api.jar"};
        try {
            string = "org.opensourcephysics.media.xuggle.XuggleIO";
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("registerWithVideoIO", new Class[0]);
            method.invoke(null, null);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        string = System.getProperty("java.vm.name");
        string = String.valueOf(string) + "-" + System.getProperty("os.arch");
        string = String.valueOf(string) + "-" + System.getProperty("sun.arch.data.model");
        is64BitVM = string.indexOf("64") > -1;
        xuggleHome = System.getenv("XUGGLE_HOME");
        xuggleHomeJars = new File[xuggleJarNames.length];
        javaExtensionJars = new File[xuggleJarNames.length];
    }

    private DiagnosticsForXuggle() {
    }

    public static void aboutXuggle() {
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        String[] stringArray2;
        int n = DiagnosticsForXuggle.getStatusCode();
        if (OSPLog.getLevelValue() <= Level.CONFIG.intValue()) {
            stringArray2 = System.getenv("XUGGLE_HOME");
            OSPLog.config("XUGGLE_HOME = " + (String)stringArray2);
            OSPLog.config(String.valueOf(pathEnvironment) + " = " + pathValue);
            object3 = DiagnosticsForXuggle.getXuggleJarFiles(String.valueOf(stringArray2) + "/share/java/jars");
            boolean bl = object3[0] != null;
            int n2 = 1;
            while (n2 < ((Object)object3).length) {
                bl = bl && object3[n2] != null;
                ++n2;
            }
            object2 = new SimpleDateFormat();
            stringArray = new String[xuggleJarNames.length];
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringArray[n3] = object3[n3] == null ? "" : " modified " + ((Format)object2).format(((File)object3[n3]).lastModified());
                ++n3;
            }
            object = new String[xuggleJarNames.length];
            int n4 = 0;
            while (n4 < ((String[])object).length) {
                object[n4] = object3[n4] == null ? "" : " (file size " + ((File)object3[n4]).length() / 1024L + "kB) ";
                ++n4;
            }
            String string = "XUGGLE_HOME Xuggle files: ";
            int n5 = 0;
            while (n5 < ((String[])object).length) {
                if (n5 > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + xuggleJarNames[n5] + " " + object[n5] + object3[n5] + stringArray[n5];
                ++n5;
            }
            OSPLog.config(string);
            String string2 = System.getProperty("java.home");
            String string3 = is64BitVM ? "(64-bit): " : "(32-bit): ";
            OSPLog.config("Java VM " + string3 + string2);
            object3 = DiagnosticsForXuggle.getJavaExtensionJars();
            int n6 = 0;
            while (n6 < stringArray.length) {
                stringArray[n6] = object3[n6] == null ? "" : " modified " + ((Format)object2).format(((File)object3[n6]).lastModified());
                ++n6;
            }
            n6 = 0;
            while (n6 < ((String[])object).length) {
                object[n6] = object3[n6] == null ? "" : " (file size " + ((File)object3[n6]).length() / 1024L + "kB) ";
                ++n6;
            }
            string = "Java extension Xuggle files: ";
            n6 = 0;
            while (n6 < ((String[])object).length) {
                if (n6 > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + xuggleJarNames[n6] + " " + object[n6] + object3[n6] + stringArray[n6];
                ++n6;
            }
            OSPLog.config(string);
            if (OSPRuntime.isWindows()) {
                String string4 = System.getenv("TRACKER_HOME");
                OSPLog.config("TRACKER_HOME = " + string4);
                object3 = DiagnosticsForXuggle.getXuggleJarFiles(string4);
                int n7 = 0;
                while (n7 < stringArray.length) {
                    stringArray[n7] = object3[n7] == null ? "" : " modified " + ((Format)object2).format(((File)object3[n7]).lastModified());
                    ++n7;
                }
                n7 = 0;
                while (n7 < ((String[])object).length) {
                    object[n7] = object3[n7] == null ? "" : " (file size " + ((File)object3[n7]).length() / 1024L + "kB) ";
                    ++n7;
                }
                string = "TRACKER_HOME Xuggle files: ";
                n7 = 0;
                while (n7 < ((String[])object).length) {
                    if (n7 > 0) {
                        string = String.valueOf(string) + ", ";
                    }
                    string = String.valueOf(string) + xuggleJarNames[n7] + " " + object[n7] + object3[n7] + stringArray[n7];
                    ++n7;
                }
                OSPLog.config(string);
            }
        }
        if (n == 0) {
            stringArray2 = XuggleRes.getString("Xuggle.Dialog.Unknown");
            object3 = stringArray2;
            try {
                String string = "com.xuggle.xuggler.Version";
                object2 = Class.forName(string);
                stringArray = ((Class)object2).getMethod("getVersionString", new Class[0]);
                object3 = (String)stringArray.invoke(null, null);
            }
            catch (Exception exception) {
            }
            catch (Error error) {}
            xuggleHome = " " + xuggleHome + newline;
            String string = newline;
            object2 = " " + (String)stringArray2;
            if (javaExtensionJars[0] != null) {
                stringArray = DateFormat.getDateInstance(3);
                object = new Date(javaExtensionJars[0].lastModified());
                string = " (" + stringArray.format((Date)object) + ")" + newline;
                object2 = " " + javaExtensionJars[0].getAbsolutePath();
            }
            JOptionPane.showMessageDialog(null, String.valueOf(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Version")) + " " + (String)object3 + string + XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Home") + xuggleHome + XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Path") + (String)object2, XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Title"), 1);
        } else {
            stringArray2 = DiagnosticsForXuggle.getDiagnosticMessage(n);
            object3 = Box.createVerticalBox();
            ((JComponent)object3).setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            object = stringArray2;
            int n8 = stringArray2.length;
            int n9 = 0;
            while (n9 < n8) {
                String string = object[n9];
                ((Container)object3).add(new JLabel(string));
                ++n9;
            }
            JOptionPane.showMessageDialog(null, object3, XuggleRes.getString("Xuggle.Dialog.BadXuggle.Title"), 2);
        }
    }

    public static File[] getXuggleJarFiles(String string) {
        File[] fileArray = new File[xuggleJarNames.length];
        int n = 0;
        while (n < fileArray.length) {
            String string2 = xuggleJarNames[n];
            File file = new File(string, string2);
            fileArray[n] = file.exists() ? file : null;
            ++n;
        }
        return fileArray;
    }

    public static File[] getJavaExtensionJars() {
        String string;
        File[] fileArray = new File[xuggleJarNames.length];
        String string2 = XML.forwardSlash(System.getProperty("java.ext.dirs"));
        int n = string2.indexOf(string = System.getProperty("path.separator"));
        if (n == -1) {
            javaExtDirectory = string2;
            fileArray = DiagnosticsForXuggle.getXuggleJarFiles(string2);
            if (fileArray[0] != null) {
                return fileArray;
            }
        } else {
            String string3 = string2;
            javaExtDirectory = null;
            while (fileArray[0] == null && n > -1) {
                string3 = string2.substring(0, n);
                if (javaExtDirectory == null) {
                    javaExtDirectory = string3;
                }
                string2 = string2.substring(n + 1);
                fileArray = DiagnosticsForXuggle.getXuggleJarFiles(string3);
                if (fileArray[0] != null) {
                    javaExtDirectory = string3;
                    return fileArray;
                }
                n = string2.indexOf(string);
            }
        }
        return fileArray;
    }

    public static int getStatusCode() {
        boolean bl;
        javaExtensionJars = DiagnosticsForXuggle.getJavaExtensionJars();
        pathEnvironment = OSPRuntime.isWindows() ? "PATH" : (OSPRuntime.isMac() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH");
        pathValue = System.getenv(pathEnvironment);
        if (VideoIO.getVideoType("xuggle", null) != null) {
            return 0;
        }
        boolean bl2 = javaExtensionJars[0] != null;
        int n = 1;
        while (n < javaExtensionJars.length) {
            bl2 = bl2 && javaExtensionJars[n] != null;
            ++n;
        }
        if (xuggleHome == null) {
            return bl2 ? 2 : 1;
        }
        xuggleHomeJars = DiagnosticsForXuggle.getXuggleJarFiles(String.valueOf(xuggleHome) + "/share/java/jars");
        n = xuggleHomeJars[0] != null ? 1 : 0;
        int n2 = 1;
        while (n2 < xuggleHomeJars.length) {
            n = n != 0 && xuggleHomeJars[n2] != null ? 1 : 0;
            ++n2;
        }
        if (n == 0) {
            return 3;
        }
        if (javaExtensionJars[0] == null) {
            return 5;
        }
        long l = xuggleHomeJars[0].length();
        boolean bl3 = bl = l != javaExtensionJars[0].length();
        if (bl) {
            return 6;
        }
        if (!bl2) {
            return 5;
        }
        if (l < 1000000L) {
            String string = OSPRuntime.isWindows() ? "/bin" : "/lib";
            String string2 = XML.forwardSlash(String.valueOf(xuggleHome) + string);
            if (XML.forwardSlash(pathValue).indexOf(string2) == -1) {
                return 4;
            }
            if (is64BitVM && OSPRuntime.isWindows()) {
                return 7;
            }
        }
        if (!is64BitVM && OSPRuntime.isMac()) {
            return 7;
        }
        return -1;
    }

    public static String[] getDiagnosticMessage(int n) {
        if (n == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 1: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoXuggle.Message1"));
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                arrayList.add(XUGGLE_URL);
                break;
            }
            case 2: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message2"));
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                arrayList.add(XUGGLE_URL);
                break;
            }
            case 3: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.IncompleteXuggle.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.IncompleteXuggle.Message2"));
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                arrayList.add(XUGGLE_URL);
                break;
            }
            case 4: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MissingEnvironmentVariable.Message1"));
                arrayList.add("\"" + pathEnvironment + "\" " + XuggleRes.getString("Xuggle.Dialog.MissingEnvironmentVariable.Message2"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MissingEnvironmentVariable.Message3"));
                break;
            }
            case 5: {
                String string = "";
                int n2 = 0;
                while (n2 < xuggleJarNames.length) {
                    if (javaExtensionJars[n2] == null) {
                        if (string.length() > 1) {
                            string = String.valueOf(string) + ", ";
                        }
                        string = String.valueOf(string) + xuggleJarNames[n2];
                    }
                    ++n2;
                }
                String string2 = String.valueOf(XML.forwardSlash(xuggleHome)) + "/share/java/jars";
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MissingJarsInExt.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MissingJarsInExt.Message2"));
                arrayList.add(" ");
                arrayList.add(string);
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MissingJarsInExt.Message3"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MissingJarsInExt.Message4"));
                arrayList.add(" ");
                arrayList.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.SourceDirectory.Message")) + " " + string2);
                arrayList.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.ExtensionDirectory.Message")) + " " + javaExtDirectory);
                break;
            }
            case 6: {
                String string = String.valueOf(XML.forwardSlash(xuggleHome)) + "/share/java/jars";
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MismatchedJar.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MismatchedJar.Message2"));
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MismatchedJar.Message3"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MismatchedJar.Message4"));
                arrayList.add(" ");
                arrayList.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.SourceDirectory.Message")) + " " + string);
                arrayList.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.ExtensionDirectory.Message")) + " " + javaExtDirectory);
                break;
            }
            case 7: {
                if (OSPRuntime.isMac()) {
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message1"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message2"));
                    arrayList.add(" ");
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message3"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message4"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message5"));
                    break;
                }
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMWindows.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMWindows.Message2"));
                arrayList.add(" ");
                Collection<File> collection = new ExtensionsManager().findPublicJREsForXuggle(is64BitVM);
                if (collection.isEmpty()) {
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message1"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message2"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message3"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message4"));
                    break;
                }
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.SetVM.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.SetVM.Message2"));
                arrayList.add(" ");
                for (File file : collection) {
                    arrayList.add(file.getPath());
                }
                break;
            }
            default: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.UnknownProblem.Message"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message2"));
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                arrayList.add(XUGGLE_URL);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        DiagnosticsForXuggle.aboutXuggle();
    }
}

