/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionTool
extends JDialog {
    protected static String[] parserNames = new String[]{"e", "pi", "min", "mod", "sin", "cos", "abs", "log", "acos", "acosh", "ceil", "cosh", "asin", "asinh", "atan", "atanh", "exp", "frac", "floor", "int", "random", "round", "sign", "sinh", "step", "tanh", "atan2", "max", "sqrt", "sqr", "if", "tan"};
    protected static String[] parserOperators = new String[]{"!", ",", ".", "+", "-", "*", "/", "^", "=", ">", "<", "&", "|", "(", ")"};
    protected Set<DatasetCurveFitter> curveFitters = new HashSet<DatasetCurveFitter>();
    protected Map<String, FunctionPanel> panels = new TreeMap<String, FunctionPanel>();
    protected HashSet<String> forbiddenNames = new HashSet();
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected JPanel noData;
    protected JToolBar toolbar;
    protected JToolBar dropdownbar;
    protected JLabel dropdownLabel;
    protected JComboBox dropdown;
    protected JPanel north = new JPanel(new BorderLayout());
    protected FunctionPanel selectedPanel;
    protected JScrollPane selectedPanelScroller;
    protected JButton helpButton;
    protected JButton closeButton;
    protected JButton fontButton;
    protected JButton undoButton;
    protected JButton redoButton;
    protected JPopupMenu popup;
    protected JMenuItem defaultFontSizeItem;
    protected JPanel buttonbar = new JPanel(new FlowLayout());
    protected Component[] toolbarComponents;
    protected String helpPath = "";
    protected String helpBase = "http://www.opensourcephysics.org/online_help/tools/";
    protected TextFrame helpFrame;
    protected JDialog helpDialog;
    protected ActionListener helpAction;
    protected int fontLevel = 0;
    protected boolean refreshing;

    public FunctionTool(Component component) {
        this(component, null);
    }

    public FunctionTool(Component component, Component[] componentArray) {
        super(JOptionPane.getFrameForComponent(component), component == null);
        this.addForbiddenNames(parserNames);
        this.addForbiddenNames(UserFunction.dummyVars);
        this.setName("FunctionTool");
        this.createGUI();
        this.setToolbarComponents(componentArray);
    }

    public void setToolbarComponents(Component[] componentArray) {
        this.toolbarComponents = componentArray;
        this.refreshGUI();
    }

    public Component[] getToolbarComponents() {
        return this.toolbarComponents;
    }

    public FunctionPanel addPanel(String string, FunctionPanel functionPanel) {
        OSPLog.finest("adding panel " + string);
        functionPanel.setFontLevel(this.fontLevel);
        functionPanel.setName(string);
        functionPanel.setFunctionTool(this);
        this.panels.put(string, functionPanel);
        functionPanel.addForbiddenNames(this.forbiddenNames.toArray(new String[0]));
        this.refreshDropdown(string);
        return functionPanel;
    }

    public FunctionPanel removePanel(String string) {
        FunctionPanel functionPanel = this.panels.get(string);
        if (functionPanel != null) {
            OSPLog.finest("removing panel " + string);
            this.panels.remove(string);
            this.refreshDropdown(null);
            this.firePropertyChange("panel", functionPanel, null);
        }
        return functionPanel;
    }

    public FunctionPanel renamePanel(String string, String string2) {
        FunctionPanel functionPanel = this.getPanel(string);
        if (functionPanel == null || string.equals(string2)) {
            return functionPanel;
        }
        OSPLog.finest("renaming panel " + string + " to " + string2);
        this.panels.remove(string);
        this.panels.put(string2, functionPanel);
        functionPanel.prevName = string;
        functionPanel.setName(string2);
        this.refreshDropdown(string2);
        return functionPanel;
    }

    public void setSelectedPanel(String string) {
        Object object = this.getDropdownItem(string);
        if (object != null) {
            this.dropdown.setSelectedItem(object);
        }
    }

    public String getSelectedName() {
        if (this.selectedPanel == null) {
            return null;
        }
        for (String string : this.panels.keySet()) {
            if (this.panels.get(string) != this.selectedPanel) continue;
            return string;
        }
        return null;
    }

    public FunctionPanel getSelectedPanel() {
        return this.getPanel(this.getSelectedName());
    }

    public FunctionPanel getPanel(String string) {
        return string == null ? null : this.panels.get(string);
    }

    public Set<String> getPanelNames() {
        return this.panels.keySet();
    }

    public void clearPanels() {
        OSPLog.finest("clearing panels");
        this.panels.clear();
        this.refreshDropdown(null);
    }

    public void addForbiddenNames(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.forbiddenNames.add(stringArray[n]);
            ++n;
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.contentPane.getTopLevelAncestor() == this) {
            super.setVisible(bl);
        } else {
            this.contentPane.getTopLevelAncestor().setVisible(bl);
        }
        this.firePropertyChange("visible", null, new Boolean(bl));
    }

    @Override
    public boolean isVisible() {
        if (this.contentPane.getTopLevelAncestor() == this) {
            return super.isVisible();
        }
        return this.contentPane.getTopLevelAncestor().isVisible();
    }

    public void setHelpPath(String string) {
        this.helpPath = string;
    }

    public void setHelpAction(ActionListener actionListener) {
        this.helpButton.removeActionListener(this.helpAction);
        this.helpAction = actionListener;
        this.helpButton.addActionListener(this.helpAction);
    }

    public boolean isEmpty() {
        return this.panels.isEmpty();
    }

    public void setFontLevel(int n) {
        Object object;
        if ((n = Math.max(0, n)) == this.fontLevel) {
            return;
        }
        this.fontLevel = n;
        boolean bl = this.isVisible();
        this.setVisible(false);
        FontSizer.setFonts(this, n);
        FontSizer.setFonts(this.contentPane, n);
        FontSizer.setFonts(this.popup, n);
        for (FunctionPanel serializable2 : this.panels.values()) {
            if (serializable2 == this.getSelectedPanel()) continue;
            serializable2.setFontLevel(n);
        }
        if (n < this.popup.getSubElements().length) {
            object = this.popup.getSubElements();
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)object[n];
            jRadioButtonMenuItem.setSelected(true);
        }
        object = this.contentPane.getTopLevelAncestor();
        Dimension dimension = ((Component)object).getSize();
        dimension.width = ((Container)object).getMinimumSize().width;
        ((Component)object).setSize(dimension);
        this.setVisible(bl);
    }

    public int getFontLevel() {
        return this.fontLevel;
    }

    public void setDefaultVariables(String[] stringArray) {
        for (String string : this.getPanelNames()) {
            FunctionPanel functionPanel = this.getPanel(string);
            UserFunctionEditor userFunctionEditor = (UserFunctionEditor)functionPanel.getFunctionEditor();
            userFunctionEditor.setDefaultVariables(stringArray);
            userFunctionEditor.repaint();
        }
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    private void createGUI() {
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FunctionTool.this.refreshGUI();
            }
        });
        this.setDefaultCloseOperation(1);
        this.noData = new JPanel(new BorderLayout());
        this.dropdownbar = new JToolBar();
        this.dropdownbar.setFloatable(false);
        this.dropdownLabel = new JLabel();
        this.dropdownLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        this.dropdownLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                String string = FunctionTool.this.getSelectedName();
                if (string != null) {
                    FunctionPanel functionPanel = FunctionTool.this.panels.get(string);
                    functionPanel.clearSelection();
                }
            }
        });
        this.dropdownbar.add(this.dropdownLabel);
        this.dropdown = new JComboBox(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                if (FunctionTool.this.toolbarComponents != null && FunctionTool.this.toolbarComponents.length > 0 & FunctionTool.this.toolbarComponents[0] instanceof JButton) {
                    JButton jButton = (JButton)FunctionTool.this.toolbarComponents[0];
                    dimension.height = jButton.getHeight();
                }
                return dimension;
            }
        };
        this.dropdown.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.dropdownbar.add(this.dropdown);
        DropdownRenderer dropdownRenderer = new DropdownRenderer();
        this.dropdown.setRenderer(dropdownRenderer);
        this.dropdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = FunctionTool.this.dropdown.getSelectedItem();
                if (object != null) {
                    String string = ((Object[])object)[1].toString();
                    FunctionTool.this.select(string);
                    FunctionPanel functionPanel = FunctionTool.this.panels.get(string);
                    if (functionPanel != null) {
                        functionPanel.getFunctionTable().clearSelection();
                        functionPanel.getFunctionTable().selectOnFocus = false;
                        functionPanel.getParamTable().clearSelection();
                        functionPanel.getParamTable().selectOnFocus = false;
                        functionPanel.refreshGUI();
                    }
                }
                FunctionTool.this.helpButton.requestFocusInWindow();
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.north.add((Component)this.dropdownbar, "South");
        this.north.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.closeButton = new JButton(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionTool.this.setVisible(false);
            }
        });
        this.helpAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FunctionTool.this.helpFrame == null) {
                    Object object;
                    String string = XML.getResolvedPath(FunctionTool.this.helpPath, FunctionTool.this.helpBase);
                    if (ResourceLoader.getResource(string) != null) {
                        FunctionTool.this.helpFrame = new TextFrame(string);
                    } else {
                        object = "/org/opensourcephysics/resources/tools/html/";
                        string = XML.getResolvedPath(FunctionTool.this.helpPath, (String)object);
                        FunctionTool.this.helpFrame = new TextFrame(string);
                    }
                    FunctionTool.this.helpDialog = new JDialog((Dialog)FunctionTool.this, false);
                    FunctionTool.this.helpDialog.setContentPane(FunctionTool.this.helpFrame.getContentPane());
                    FunctionTool.this.helpDialog.setSize(700, 550);
                    object = Toolkit.getDefaultToolkit().getScreenSize();
                    int n = (((Dimension)object).width - FunctionTool.this.helpDialog.getBounds().width) / 2;
                    int n2 = (((Dimension)object).height - FunctionTool.this.helpDialog.getBounds().height) / 2;
                    FunctionTool.this.helpDialog.setLocation(n, n2);
                }
                FunctionTool.this.helpDialog.setVisible(true);
            }
        };
        this.helpButton = new JButton(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.addActionListener(this.helpAction);
        this.undoButton = new JButton(ToolsRes.getString("DataFunctionPanel.Button.Undo"));
        this.redoButton = new JButton(ToolsRes.getString("DataFunctionPanel.Button.Redo"));
        this.fontButton = new JButton(ToolsRes.getString("Tool.Menu.FontSize"));
        this.popup = new JPopupMenu();
        ButtonGroup buttonGroup = new ButtonGroup();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                FunctionTool.this.setFontLevel(n);
            }
        };
        int n = 0;
        while (n < 4) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("+" + n);
            if (n == 0) {
                this.defaultFontSizeItem = jRadioButtonMenuItem;
            }
            jRadioButtonMenuItem.addActionListener(abstractAction);
            jRadioButtonMenuItem.setActionCommand("" + n);
            this.popup.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            if (n == this.fontLevel) {
                jRadioButtonMenuItem.setSelected(true);
            }
            ++n;
        }
        this.fontButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionTool.this.popup.show(FunctionTool.this.fontButton, 0, FunctionTool.this.fontButton.getHeight());
            }
        });
        this.buttonbar.setBorder(BorderFactory.createEtchedBorder());
        this.buttonbar.add(this.helpButton);
        this.buttonbar.add(this.undoButton);
        this.buttonbar.add(this.redoButton);
        this.buttonbar.add(this.fontButton);
        this.buttonbar.add(this.closeButton);
        this.contentPane.add((Component)this.north, "North");
        this.contentPane.add((Component)this.noData, "Center");
        this.contentPane.add((Component)this.buttonbar, "South");
        this.setContentPane(this.contentPane);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = Math.max(360, dimension.height);
        this.setSize(dimension);
        this.buttonbar.remove(this.undoButton);
        this.buttonbar.remove(this.redoButton);
        this.buttonbar.remove(this.fontButton);
        this.dropdown.setEnabled(false);
        this.dropdownLabel.setEnabled(false);
        dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension.width - this.getBounds().width) / 2;
        int n3 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n2, n3);
    }

    protected void refreshGUI() {
        if (this.toolbarComponents == null) {
            this.north.remove(this.toolbar);
        } else {
            this.north.add((Component)this.toolbar, "North");
            this.toolbar.removeAll();
            int n = 0;
            while (n < this.toolbarComponents.length) {
                this.toolbar.add(this.toolbarComponents[n]);
                ++n;
            }
        }
        if (this.selectedPanel != null) {
            String string = this.selectedPanel.getLabel();
            this.dropdownLabel.setText(String.valueOf(string) + ":");
        }
        this.closeButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.setToolTipText(ToolsRes.getString("Tool.Button.Close.ToolTip"));
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.fontButton.setText(ToolsRes.getString("Tool.Menu.FontSize"));
        this.fontButton.setToolTipText(ToolsRes.getString("FunctionTool.Button.Display.Tooltip"));
        this.defaultFontSizeItem.setText(ToolsRes.getString("Tool.MenuItem.DefaultFontSize"));
        for (FunctionPanel serializable2 : this.panels.values()) {
            serializable2.refreshGUI();
        }
        Dimension dimension = this.getSize();
        dimension.width = Math.max(dimension.width, this.getMinimumSize().width);
        this.setSize(dimension);
        this.helpButton.requestFocusInWindow();
    }

    private Object getDropdownItem(String string) {
        int n = 0;
        while (n < this.dropdown.getItemCount()) {
            Object e = this.dropdown.getItemAt(n);
            String string2 = ((Object[])e)[1].toString();
            if (string2.equals(string)) {
                return e;
            }
            ++n;
        }
        return null;
    }

    public void refreshDropdown(String string) {
        Object[] objectArray;
        this.refreshing = true;
        if (string == null && (objectArray = this.dropdown.getSelectedItem()) != null) {
            string = ((Object[])objectArray)[1].toString();
        }
        objectArray = null;
        this.dropdown.removeAllItems();
        for (String object2 : this.panels.keySet()) {
            FunctionPanel functionPanel = this.panels.get(object2);
            String string2 = functionPanel.getDisplayName();
            Object[] objectArray2 = new Object[]{functionPanel.getIcon(), object2, string2};
            this.dropdown.addItem(objectArray2);
            if (objectArray != null && !object2.equals(string)) continue;
            objectArray = objectArray2;
        }
        this.refreshing = false;
        if (objectArray != null) {
            this.dropdown.setSelectedItem(objectArray);
        } else {
            this.select(null);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                FunctionTool.this.helpButton.requestFocusInWindow();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void select(String string) {
        if (this.refreshing) {
            return;
        }
        FunctionPanel functionPanel = string == null ? null : this.panels.get(string);
        FunctionPanel functionPanel2 = this.selectedPanel;
        if (this.selectedPanel != null) {
            this.contentPane.remove(this.selectedPanelScroller);
        } else {
            this.contentPane.remove(this.noData);
        }
        this.selectedPanel = functionPanel;
        this.dropdown.setEnabled(functionPanel != null);
        this.dropdownLabel.setEnabled(functionPanel != null);
        if (functionPanel != null) {
            this.selectedPanelScroller = new JScrollPane(functionPanel);
            this.contentPane.add((Component)this.selectedPanelScroller, "Center");
            functionPanel.refreshGUI();
        } else {
            this.contentPane.add((Component)this.noData, "Center");
            this.buttonbar.removeAll();
            this.buttonbar.add(this.helpButton);
            this.buttonbar.add(this.closeButton);
        }
        Container container = this.contentPane.getTopLevelAncestor();
        container.validate();
        this.refreshGUI();
        container.repaint();
        this.firePropertyChange("panel", functionPanel2, functionPanel);
    }

    protected String getUniqueName(String string) {
        int n = 0;
        String string2 = string;
        if (ToolsRes.getString("DatasetCurveFitter.NewFit.Name").equals(string)) {
            string2 = String.valueOf(string2) + ++n;
        }
        while (this.panels.keySet().contains(string2) || this.forbiddenNames.contains(string2)) {
            string2 = String.valueOf(string) + ++n;
        }
        return string2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class DropdownRenderer
    extends JLabel
    implements ListCellRenderer {
        DropdownRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object != null) {
                Object[] objectArray = (Object[])object;
                this.setIcon((Icon)objectArray[0]);
                if (objectArray.length > 2) {
                    this.setText((String)objectArray[2]);
                } else {
                    this.setText((String)objectArray[1]);
                }
            } else {
                this.setIcon(null);
                this.setText(null);
            }
            return this;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            FunctionTool functionTool = (FunctionTool)object;
            ArrayList<FunctionPanel> arrayList = new ArrayList<FunctionPanel>(functionTool.panels.values());
            xMLControl.setValue("functions", arrayList);
        }

        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            FunctionTool functionTool = (FunctionTool)object;
            ArrayList arrayList = (ArrayList)xMLControl.getObject("functions");
            if (arrayList != null) {
                for (FunctionPanel functionPanel : arrayList) {
                    functionTool.addPanel(functionPanel.getName(), functionPanel);
                }
            }
            return object;
        }
    }
}

