/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.epsgraphics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import org.jibble.epsgraphics.EpsException;
import org.jibble.epsgraphics.EpsGraphics2D;

public class EpsDocument {
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private boolean _isClipSet = false;
    private String _title;
    private StringWriter _stringWriter;
    private BufferedWriter _bufferedWriter = null;
    private EpsGraphics2D _lastG = null;

    public EpsDocument(String string) {
        this._title = string;
        this.minX = Float.POSITIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this._stringWriter = new StringWriter();
        this._bufferedWriter = new BufferedWriter(this._stringWriter);
    }

    public EpsDocument(String string, OutputStream outputStream, int n, int n2, int n3, int n4) throws IOException {
        this._title = string;
        this.minX = n;
        this.minY = n2;
        this.maxX = n3;
        this.maxY = n4;
        this._bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.write(this._bufferedWriter);
    }

    public synchronized String getTitle() {
        return this._title;
    }

    public synchronized void updateBounds(double d, double d2) {
        if (d > (double)this.maxX) {
            this.maxX = (float)d;
        }
        if (d < (double)this.minX) {
            this.minX = (float)d;
        }
        if (d2 > (double)this.maxY) {
            this.maxY = (float)d2;
        }
        if (d2 < (double)this.minY) {
            this.minY = (float)d2;
        }
    }

    public synchronized void append(EpsGraphics2D epsGraphics2D, String string) {
        if (this._lastG == null) {
            this._lastG = epsGraphics2D;
        } else if (epsGraphics2D != this._lastG) {
            EpsGraphics2D epsGraphics2D2 = this._lastG;
            this._lastG = epsGraphics2D;
            if (epsGraphics2D.getClip() != epsGraphics2D2.getClip()) {
                epsGraphics2D.setClip(epsGraphics2D.getClip());
            }
            if (!epsGraphics2D.getColor().equals(epsGraphics2D2.getColor())) {
                epsGraphics2D.setColor(epsGraphics2D.getColor());
            }
            if (!epsGraphics2D.getBackground().equals(epsGraphics2D2.getBackground())) {
                epsGraphics2D.setBackground(epsGraphics2D.getBackground());
            }
            if (!epsGraphics2D.getPaint().equals(epsGraphics2D2.getPaint())) {
                epsGraphics2D.setPaint(epsGraphics2D.getPaint());
            }
            if (!epsGraphics2D.getComposite().equals(epsGraphics2D2.getComposite())) {
                epsGraphics2D.setComposite(epsGraphics2D.getComposite());
            }
            if (!epsGraphics2D.getComposite().equals(epsGraphics2D2.getComposite())) {
                epsGraphics2D.setComposite(epsGraphics2D.getComposite());
            }
            if (!epsGraphics2D.getFont().equals(epsGraphics2D2.getFont())) {
                epsGraphics2D.setFont(epsGraphics2D.getFont());
            }
            if (!epsGraphics2D.getStroke().equals(epsGraphics2D2.getStroke())) {
                epsGraphics2D.setStroke(epsGraphics2D.getStroke());
            }
        }
        this._lastG = epsGraphics2D;
        try {
            this._bufferedWriter.write(String.valueOf(string) + "\n");
        }
        catch (IOException iOException) {
            throw new EpsException("Could not write to the output file: " + iOException);
        }
    }

    public synchronized void write(Writer writer) throws IOException {
        float f = -this.minX;
        float f2 = -this.minY;
        writer.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        writer.write("%%Creator: EpsGraphics2D 0.9.0 by Paul Mutton, http://www.jibble.org/\n");
        writer.write("%%Title: " + this._title + "\n");
        writer.write("%%CreationDate: " + new Date() + "\n");
        writer.write("%%BoundingBox: 0 0 " + (int)Math.ceil(this.maxX + f) + " " + (int)Math.ceil(this.maxY + f2) + "\n");
        writer.write("%%DocumentData: Clean7Bit\n");
        writer.write("%%DocumentProcessColors: Black\n");
        writer.write("%%ColorUsage: Color\n");
        writer.write("%%Origin: 0 0\n");
        writer.write("%%Pages: 1\n");
        writer.write("%%Page: 1 1\n");
        writer.write("%%EndComments\n\n");
        writer.write("gsave\n");
        if (this._stringWriter != null) {
            writer.write(String.valueOf(f) + " " + f2 + " translate\n");
            this._bufferedWriter.flush();
            StringBuffer stringBuffer = this._stringWriter.getBuffer();
            int n = 0;
            while (n < stringBuffer.length()) {
                writer.write(stringBuffer.charAt(n));
                ++n;
            }
            this.writeFooter(writer);
        } else {
            writer.write(String.valueOf(f) + " " + (this.maxY - this.minY - f2) + " translate\n");
        }
        writer.flush();
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write("grestore\n");
        if (this.isClipSet()) {
            writer.write("grestore\n");
        }
        writer.write("showpage\n");
        writer.write("\n");
        writer.write("%%EOF");
        writer.flush();
    }

    public synchronized void flush() throws IOException {
        this._bufferedWriter.flush();
    }

    public synchronized void close() throws IOException {
        if (this._stringWriter == null) {
            this.writeFooter(this._bufferedWriter);
            this._bufferedWriter.flush();
            this._bufferedWriter.close();
        }
    }

    public boolean isClipSet() {
        return this._isClipSet;
    }

    public void setClipSet(boolean bl) {
        this._isClipSet = bl;
    }
}

