/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.ElementArrow;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementSegment;

public class SimpleElementArrow
extends SimpleElementSegment {
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private int headPoints = 0;
    private int[] headA = new int[10];
    private int[] headB = new int[10];

    public SimpleElementArrow(ElementArrow elementArrow) {
        super(elementArrow);
    }

    public void draw(Graphics2D graphics2D, int n) {
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        Color color = drawingPanel3D.projectColor(this.style.getLineColor(), this.objects[n].getDistance());
        if (n < this.div - 1) {
            graphics2D.setStroke(this.style.getLineStroke());
            graphics2D.setColor(color);
            graphics2D.drawLine(this.aCoord[n], this.bCoord[n], this.aCoord[n + 1], this.bCoord[n + 1]);
        } else {
            this.drawHead(graphics2D, this.aCoord[n], this.bCoord[n], color, drawingPanel3D.projectPaint(this.style.getFillColor(), this.objects[n].getDistance()));
        }
    }

    public void drawQuickly(Graphics2D graphics2D) {
        this.drawHead(graphics2D, this.aCoord[0], this.bCoord[0], this.style.getLineColor(), this.style.getFillColor());
    }

    protected void projectPoints() {
        super.projectPoints();
        double d = this.aCoord[this.div] - this.aCoord[0];
        double d2 = this.bCoord[this.div] - this.bCoord[0];
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            this.headPoints = 0;
            return;
        }
        d = 0.35 * d / d3;
        d2 = 0.35 * d2 / d3;
        if (d3 > 25.0) {
            d *= 25.0 / d3;
            d2 *= 25.0 / d3;
        }
        int n = (int)((double)this.aCoord[this.div] - d * d3);
        int n2 = (int)((double)this.bCoord[this.div] - d2 * d3);
        this.headPoints = 6;
        this.headA[0] = n;
        this.headB[0] = n2;
        this.headA[1] = n - (int)(d2 *= d3 / 2.0);
        this.headB[1] = n2 + (int)(d *= d3 / 2.0);
        this.headA[2] = this.aCoord[this.div];
        this.headB[2] = this.bCoord[this.div];
        this.headA[3] = n + (int)d2;
        this.headB[3] = n2 - (int)d;
        this.headA[4] = n;
        this.headB[4] = n2;
    }

    private void drawHead(Graphics2D graphics2D, int n, int n2, Color color, Paint paint) {
        graphics2D.setStroke(this.style.getLineStroke());
        if (this.headPoints == 0) {
            graphics2D.setColor(color);
            graphics2D.drawLine(n, n2, this.aCoord[this.div], this.bCoord[this.div]);
            return;
        }
        int n3 = this.headPoints - 1;
        this.headA[n3] = n;
        this.headB[n3] = n2;
        if (this.style.isDrawingFill()) {
            graphics2D.setPaint(paint);
            graphics2D.fillPolygon(this.headA, this.headB, n3);
        }
        graphics2D.setColor(color);
        graphics2D.drawPolyline(this.headA, this.headB, this.headPoints);
    }
}

