/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ResourceLoader;

public class ImageVideoRecorder
extends ScratchVideoRecorder {
    protected int frameCount;
    private String tempFileBasePath;
    private String tempFileType = "png";
    private String[] savedFilePaths;

    public ImageVideoRecorder() {
        super(new ImageVideoType());
    }

    public ImageVideoRecorder(ImageVideoType imageVideoType) {
        super(imageVideoType);
        String string = imageVideoType.getDefaultExtension();
        if (string != null) {
            this.tempFileType = string;
        }
    }

    public Video getVideo() throws IOException {
        if (this.isSaved && this.saveFile != null) {
            return this.videoType.getVideo(this.saveFile.getAbsolutePath());
        }
        if (this.saveFile != null) {
            this.saveScratch();
            if (this.savedFilePaths != null && this.savedFilePaths.length > 0) {
                return new ImageVideo(this.savedFilePaths[0], this.savedFilePaths.length > 1);
            }
        }
        return null;
    }

    public String saveVideo(String string) throws IOException {
        if (string == null) {
            return this.saveVideoAs();
        }
        this.setFileName(string);
        if (this.saveFile == null) {
            throw new IOException("Read-only file");
        }
        this.saveScratch();
        this.isSaved = true;
        return this.savedFilePaths == null || this.savedFilePaths.length == 0 ? null : this.savedFilePaths[0];
    }

    public void setExpectedFrameCount(int n) {
        this.frameCount = n;
    }

    public void reset() {
        this.frameCount = 0;
        this.deleteTempFiles();
        super.reset();
    }

    protected void finalize() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveScratch() throws IOException {
        FileFilter fileFilter = chooser.getFileFilter();
        if (!this.hasContent || !(fileFilter instanceof VideoFileFilter)) {
            return;
        }
        ArrayList arrayList = this.tempFiles;
        synchronized (arrayList) {
            String string = this.saveFile.getAbsolutePath();
            this.savedFilePaths = ImageVideoRecorder.getFileNames(string, this.tempFiles.size());
            int n = 0;
            while (n < this.tempFiles.size()) {
                Object object;
                String string2 = this.savedFilePaths[n];
                File file = (File)this.tempFiles.get(n);
                if (!file.exists()) {
                    this.savedFilePaths = null;
                    throw new IOException("temp image file not found");
                }
                if (ext == this.tempFileType) {
                    object = new File(string2);
                    VideoIO.copyFile(file, (File)object);
                } else {
                    object = ResourceLoader.getBufferedImage(file.getAbsolutePath());
                    if (object == null) {
                        throw new IOException("unable to load temp image file");
                    }
                    ImageIO.write((RenderedImage)object, ext, new BufferedOutputStream(new FileOutputStream(string2)));
                }
                ++n;
            }
        }
        this.deleteTempFiles();
        this.hasContent = false;
        this.canRecord = false;
    }

    protected boolean startRecording() {
        if (this.dim == null) {
            if (this.frameImage != null) {
                this.dim = new Dimension(this.frameImage.getWidth(null), this.frameImage.getHeight(null));
            } else {
                return false;
            }
        }
        try {
            this.tempFileBasePath = XML.stripExtension(this.scratchFile.getAbsolutePath());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean append(Image image) {
        BufferedImage bufferedImage;
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (this.dim == null) {
            this.dim = new Dimension(n, n2);
        }
        if (this.dim.width != n || this.dim.height != n2) {
            return false;
        }
        if (!(image instanceof BufferedImage)) {
            bufferedImage = new BufferedImage(n, n2, 1);
            bufferedImage.getGraphics().drawImage(image, 0, 0, null);
            image = bufferedImage;
        }
        bufferedImage = (BufferedImage)image;
        String string = String.valueOf(this.tempFileBasePath) + "_" + this.tempFiles.size() + ".tmp";
        try {
            ImageIO.write((RenderedImage)bufferedImage, this.tempFileType, new BufferedOutputStream(new FileOutputStream(string)));
        }
        catch (Exception exception) {
            return false;
        }
        File file = new File(string);
        if (file.exists()) {
            ArrayList arrayList = this.tempFiles;
            synchronized (arrayList) {
                this.tempFiles.add(file);
            }
            file.deleteOnExit();
        }
        return true;
    }

    protected File getFileToBeSaved(File file) {
        int n;
        int n2 = n = this.frameCount > 0 ? this.frameCount : this.tempFiles.size();
        if (n <= 1) {
            return file;
        }
        String string = file.getAbsolutePath();
        int n3 = ImageVideoRecorder.getAppendedNumber(string);
        String string2 = ImageVideoRecorder.getBase(string);
        string = n3 > 0 ? String.valueOf(string2) + (n + n3 < 10 ? String.valueOf(n3) : (n + n3 < 100 && n3 < 10 ? "0" + n3 : (n + n3 < 100 ? String.valueOf(n3) : (n + n3 < 1000 && n3 < 10 ? "00" + n3 : (n + n3 < 1000 && n3 < 100 ? "0" + n3 : (n + n3 < 1000 ? String.valueOf(n3) : (n3 < 10 ? "000" + n3 : (n3 < 100 ? "00" + n3 : (n3 < 1000 ? "0" + n3 : String.valueOf(n3)))))))))) : String.valueOf(string2) + (n < 10 ? "0" : (n < 100 ? "00" : (n < 1000 ? "000" : "0000")));
        if (ext != null) {
            string = String.valueOf(string) + "." + ext;
        }
        return new File(string);
    }

    protected static String[] saveImages(String string, BufferedImage[] bufferedImageArray) throws IOException {
        String[] stringArray = ImageVideoRecorder.getFileNames(string, bufferedImageArray.length);
        int n = 0;
        while (n < bufferedImageArray.length) {
            String string2 = stringArray[n];
            ImageIO.write((RenderedImage)bufferedImageArray[n], ext, new BufferedOutputStream(new FileOutputStream(string2)));
            ++n;
        }
        return stringArray;
    }

    protected static String[] getFileNames(String string, int n) {
        if (n == 1) {
            return new String[]{string};
        }
        int n2 = ImageVideoRecorder.getAppendedNumber(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n + n2 < 10 ? 1 : (n + n2 < 100 ? 2 : (n + n2 < 1000 ? 3 : 4));
        String string2 = ImageVideoRecorder.getBase(string);
        int n4 = 0;
        while (n4 < n) {
            String string3 = String.valueOf(n4 + n2);
            if (n3 == 2 && n4 + n2 < 10) {
                string3 = "0" + string3;
            } else if (n3 == 3 && n4 + n2 < 10) {
                string3 = "00" + string3;
            } else if (n3 == 3 && n4 + n2 < 100) {
                string3 = "0" + string3;
            } else if (n3 == 4 && n4 + n2 < 10) {
                string3 = "000" + string3;
            } else if (n3 == 4 && n4 + n2 < 100) {
                string3 = "00" + string3;
            } else if (n3 == 4 && n4 + n2 < 1000) {
                string3 = "0" + string3;
            }
            string = String.valueOf(string2) + string3 + "." + ext;
            arrayList.add(string);
            ++n4;
        }
        return arrayList.toArray(new String[0]);
    }

    protected static String getBase(String string) {
        String string2 = XML.stripExtension(string);
        int n = string2.length();
        int n2 = 1;
        while (n2 < n) {
            try {
                Integer.parseInt(string2.substring(n - n2));
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            ++n2;
        }
        if (--n2 == 0) {
            return string2;
        }
        return string2.substring(0, n - n2);
    }

    protected static int getAppendedNumber(String string) {
        String string2 = XML.stripExtension(string);
        int n = string2.length();
        int n2 = 1;
        int n3 = 0;
        while (n2 < n) {
            try {
                n3 = Integer.parseInt(string2.substring(n - n2));
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            ++n2;
        }
        return n3;
    }
}

