/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlShape3D
extends ControlElement3D {
    private static final int SHAPE_PROPERTIES_ADDED = 3;
    private ElementShape shape;
    static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementShape";
    }

    @Override
    protected Element createElement() {
        this.shape = new ElementShape();
        return this.shape;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 3;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("style");
            infoList.add("pixelSize");
            infoList.add("rotationAngle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("style")) {
            return "MarkerShape|int";
        }
        if (string.equals("pixelSize")) {
            return "boolean";
        }
        if (string.equals("rotationAngle")) {
            return "int|double";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.shape.setShapeType(value.getInteger());
                break;
            }
            case 1: {
                this.shape.setPixelSize(value.getBoolean());
                break;
            }
            case 2: {
                if (value instanceof IntegerValue) {
                    this.shape.setRotationAngle((double)value.getInteger() * (Math.PI / 180));
                    break;
                }
                this.shape.setRotationAngle(value.getDouble());
                break;
            }
            default: {
                super.setValue(n - 3, value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.shape.setShapeType(1);
                break;
            }
            case 1: {
                this.shape.setPixelSize(false);
                break;
            }
            case 2: {
                this.shape.setRotationAngle(0.0);
                break;
            }
            default: {
                super.setDefaultValue(n - 3);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "ELLIPSE";
            }
            case 1: {
                return "false";
            }
            case 2: {
                return "0.0";
            }
        }
        return super.getDefaultValueString(n - 3);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(n - 3);
    }
}

