/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.drawables.ControlScalarField;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlAnalyticScalarField
extends ControlScalarField {
    protected static final int ANALYTIC_SCALAR_FIELD_ADDED = 8;
    public static final int CARTESIAN = 0;
    public static final int POLAR = 1;
    protected static final int ANALYTIC_DATA = 12;
    protected int nx;
    protected int ny;
    protected int coordinatesMode;
    protected String variableX = "x";
    protected String variableY = "y";
    protected boolean useJavaSyntax;
    protected boolean changedDatafunction;
    protected boolean updateIndexes;
    protected String functionData;
    protected GeneralParser parserData;
    protected String[] varsData;
    protected int indexOfxInDataStr;
    protected int indexOfyInDataStr;
    static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        Drawable drawable = super.createDrawable();
        this.ny = 0;
        this.nx = 0;
        this.updateIndexes = true;
        this.changedDatafunction = true;
        this.parserData = null;
        this.functionData = null;
        this.varsData = new String[0];
        this.indexOfyInDataStr = -1;
        this.indexOfxInDataStr = -1;
        this.useJavaSyntax = false;
        this.coordinatesMode = 0;
        return drawable;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("points1");
            infoList.add("points2");
            infoList.add("variable1");
            infoList.add("variable2");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.add("javaSyntax");
            infoList.add("coordinateSystem");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyCommonName(String string) {
        if (string.equals("minimumX")) {
            return "min1";
        }
        if (string.equals("maximumX")) {
            return "max1";
        }
        if (string.equals("minimumY")) {
            return "min2";
        }
        if (string.equals("maximumY")) {
            return "max2";
        }
        return super.getPropertyCommonName(string);
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("z")) {
            return "String";
        }
        if (string.equals("points1")) {
            return "int";
        }
        if (string.equals("points2")) {
            return "int";
        }
        if (string.equals("variable1")) {
            return "String";
        }
        if (string.equals("variable2")) {
            return "String";
        }
        if (string.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("javaSyntax")) {
            return "boolean";
        }
        if (string.equals("coordinateSystem")) {
            return "CoordinateSystem|int";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("CoordinateSystem") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("polar")) {
                return new IntegerValue(1);
            }
            if (string2.equals("cartesian")) {
                return new IntegerValue(0);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.nx = value.getInteger();
                break;
            }
            case 1: {
                this.ny = value.getInteger();
                break;
            }
            case 2: {
                if (value.getString().equals(this.variableX)) break;
                this.variableX = value.getString();
                this.updateIndexes = true;
                break;
            }
            case 3: {
                if (value.getString().equals(this.variableY)) break;
                this.variableY = value.getString();
                this.updateIndexes = true;
                break;
            }
            case 4: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, value.getString());
                return;
            }
            case 5: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, value.getString());
                return;
            }
            case 6: {
                if (value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = value.getBoolean();
                this.changedDatafunction = true;
                break;
            }
            case 7: {
                if (value.getInteger() == this.coordinatesMode) break;
                this.coordinatesMode = value.getInteger();
                this.changedDatafunction = true;
                break;
            }
            case 12: {
                if (value.getString().equals(this.functionData)) break;
                this.functionData = value.getString();
                this.changedDatafunction = true;
                break;
            }
            default: {
                super.setValue(n - 8, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.nx = 0;
                break;
            }
            case 1: {
                this.ny = 0;
                break;
            }
            case 2: {
                this.variableX = "x";
                this.updateIndexes = true;
                break;
            }
            case 3: {
                this.variableY = "y";
                this.updateIndexes = true;
                break;
            }
            case 4: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                return;
            }
            case 5: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                return;
            }
            case 6: {
                this.useJavaSyntax = false;
                this.changedDatafunction = true;
                break;
            }
            case 7: {
                this.coordinatesMode = 0;
                this.changedDatafunction = true;
                break;
            }
            case 12: {
                this.functionData = null;
                this.changedDatafunction = true;
                break;
            }
            default: {
                super.setDefaultValue(n - 8);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return "0";
            }
            case 2: {
                return "x";
            }
            case 3: {
                return "y";
            }
            case 4: 
            case 5: {
                return "<no_action>";
            }
            case 6: {
                return "false";
            }
            case 7: {
                return "CARTESIAN";
            }
            case 12: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 8);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
        }
        return super.getValue(n - 8);
    }

    boolean isVariableDefined(String string) {
        if (this.variableX.equals(string)) {
            return true;
        }
        if (this.variableY.equals(string)) {
            return true;
        }
        Value value = this.myGroup.getValue(string);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    @Override
    public void preupdate() {
        if (!this.visibility) {
            return;
        }
        if (this.myParent == null) {
            return;
        }
        DrawingPanel drawingPanel = this.myParent.getDrawingPanel();
        int n = this.nx;
        int n2 = this.ny;
        if (n <= 0) {
            n = drawingPanel != null ? Math.max(20, Math.min(60, drawingPanel.getWidth() / 20)) : 20;
        }
        if (n2 <= 0) {
            n2 = drawingPanel != null ? Math.max(20, Math.min(60, drawingPanel.getHeight() / 20)) : 20;
        }
        if (this.nx <= 0 || this.ny <= 0) {
            n = n2 = Math.min(n, n2);
        }
        if (this.dataArray == null || n != this.dataArray.length || n2 != this.dataArray[0].length) {
            this.dataArray = new double[n][n2];
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.changedDatafunction && this.functionData != null) {
            ParserAndVariables parserAndVariables = new ParserAndVariables(this.useJavaSyntax, this.functionData);
            this.varsData = parserAndVariables.getVariables();
            this.parserData = parserAndVariables.getParser();
            int n3 = 0;
            int n4 = this.varsData.length;
            while (n3 < n4) {
                if (!this.isVariableDefined(this.varsData[n3])) {
                    bl2 = true;
                    break;
                }
                this.parserData.defineVariable(n3, this.varsData[n3]);
                ++n3;
            }
            if (!bl2) {
                this.parserData.define(this.functionData);
                this.parserData.parse();
                if (this.parserData.hasError()) {
                    bl2 = true;
                } else {
                    bl = true;
                }
            }
            this.changedDatafunction = false;
            this.updateIndexes = true;
        }
        if (bl2) {
            this.invokeActions(1001);
        } else if (bl) {
            this.invokeActions(1002);
        }
        if (this.isUnderEjs) {
            this.myEjsPropertyEditor.displayErrorOnProperty("z", bl2);
        }
        if (this.updateIndexes) {
            this.indexOfxInDataStr = ControlElement.indexOf(this.variableX, this.varsData);
            this.indexOfyInDataStr = ControlElement.indexOf(this.variableY, this.varsData);
        }
        super.computeMinMax();
        double d = (this.maxAbcise - this.minAbcise) / (double)(n - 1);
        double d2 = (this.maxOrdinate - this.minOrdinate) / (double)(n2 - 1);
        if (this.functionData == null || bl2) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = 0;
                while (n6 < n2) {
                    this.dataArray[n5][n6] = 0.0;
                    ++n6;
                }
                ++n5;
            }
        } else {
            int n7 = 0;
            int n8 = this.varsData.length;
            while (n7 < n8) {
                if (n7 != this.indexOfxInDataStr && n7 != this.indexOfyInDataStr) {
                    this.parserData.setVariable(n7, this.myGroup.getDouble(this.varsData[n7]));
                }
                ++n7;
            }
            double d3 = this.minAbcise;
            switch (this.coordinatesMode) {
                case 1: {
                    int n9 = 0;
                    while (n9 < n) {
                        double d4 = this.minOrdinate;
                        int n10 = 0;
                        while (n10 < n2) {
                            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
                            double d6 = Math.atan2(d4, d3);
                            if (this.indexOfxInDataStr >= 0) {
                                this.parserData.setVariable(this.indexOfxInDataStr, d5);
                            }
                            if (this.indexOfyInDataStr >= 0) {
                                this.parserData.setVariable(this.indexOfyInDataStr, d6);
                            }
                            this.dataArray[n9][n10] = this.parserData.evaluate();
                            ++n10;
                            d4 += d2;
                        }
                        ++n9;
                        d3 += d;
                    }
                    break;
                }
                default: {
                    int n11 = 0;
                    while (n11 < n) {
                        double d7 = this.minOrdinate;
                        int n12 = 0;
                        while (n12 < n2) {
                            if (this.indexOfxInDataStr >= 0) {
                                this.parserData.setVariable(this.indexOfxInDataStr, d3);
                            }
                            if (this.indexOfyInDataStr >= 0) {
                                this.parserData.setVariable(this.indexOfyInDataStr, d7);
                            }
                            this.dataArray[n11][n12] = this.parserData.evaluate();
                            ++n12;
                            d7 += d2;
                        }
                        ++n11;
                        d3 += d;
                    }
                    break block0;
                }
            }
        }
        this.mustUpdate = true;
        this.commonPreupdate();
    }
}

