/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementShape;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public class SimpleElementShape
extends SimpleElement {
    private double[] coordinates = new double[3];
    private double[] size = new double[3];
    private double[] pixel = new double[3];
    private RectangularShape shape;
    private Line2D line1;
    private Line2D line2;
    private Shape trShape;
    private Shape trLine1;
    private Shape trLine2;
    private AffineTransform transform = new AffineTransform();

    public SimpleElementShape(ElementShape elementShape) {
        super(elementShape);
        this.objects = new Object3D[]{new Object3D(this, 0)};
        this.recreateShape();
    }

    public void processChanges(int n, int n2) {
        if ((n2 & 8) != 0) {
            this.recreateShape();
            this.projectPointAndSize();
        } else if ((n2 & 0x136) != 0 || (n2 & 0x40) != 0) {
            this.projectPointAndSize();
        }
    }

    public void styleChanged(int n) {
        if (n == 5) {
            this.element.addChange(8);
        } else {
            super.styleChanged(n);
        }
    }

    void draw(Graphics2D graphics2D, int n) {
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        double d = this.objects[0].getDistance();
        this.drawIt(graphics2D, drawingPanel3D.projectColor(this.style.getLineColor(), d), drawingPanel3D.projectPaint(this.style.getFillColor(), d));
    }

    void drawQuickly(Graphics2D graphics2D) {
        this.drawIt(graphics2D, this.style.getLineColor(), this.style.getFillColor());
    }

    private void projectPointAndSize() {
        ElementShape elementShape = (ElementShape)this.element;
        System.arraycopy(Element.STD_ORIGIN, 0, this.coordinates, 0, 3);
        this.element.sizeAndToSpaceFrame(this.coordinates);
        System.arraycopy(this.coordinates, 0, this.pixel, 0, 3);
        this.element.getPanel().projectPosition(this.pixel);
        this.objects[0].setDistance(this.pixel[2] * this.style.getDepthFactor());
        this.size[0] = this.element.getSizeX();
        this.size[1] = this.element.getSizeY();
        this.size[2] = this.element.getSizeZ();
        if (!elementShape.isPixelSize()) {
            this.element.getPanel().projectSize(this.coordinates, this.size);
        }
        this.transform.setToTranslation(this.pixel[0], this.pixel[1]);
        double d = elementShape.getRotationAngle();
        if (d != 0.0) {
            this.transform.rotate(-d);
        }
        this.transform.scale(this.size[0], this.size[1]);
        this.trShape = this.transform.createTransformedShape(this.shape);
        this.trLine1 = this.transform.createTransformedShape(this.line1);
        this.trLine2 = this.transform.createTransformedShape(this.line2);
    }

    private void drawIt(Graphics2D graphics2D, Color color, Paint paint) {
        graphics2D.setStroke(this.style.getLineStroke());
        if (this.shape == null) {
            graphics2D.setColor(color);
            graphics2D.drawOval((int)this.pixel[0], (int)this.pixel[1], 1, 1);
            return;
        }
        ElementShape elementShape = (ElementShape)this.element;
        if (this.style.isDrawingFill()) {
            graphics2D.setPaint(paint);
            graphics2D.fill(this.trShape);
        }
        if (this.style.isDrawingLines()) {
            graphics2D.setColor(color);
            if (elementShape.getShapeType() == 4) {
                graphics2D.draw(this.trLine1);
                graphics2D.draw(this.trLine2);
            }
            graphics2D.draw(this.trShape);
        }
    }

    private void recreateShape() {
        double d;
        double d2;
        ElementShape elementShape = (ElementShape)this.element;
        int n = elementShape.getShapeType();
        if (n == 0) {
            this.shape = null;
            return;
        }
        switch (this.style.getRelativePosition()) {
            default: {
                d2 = -0.5;
                d = -0.5;
                break;
            }
            case 1: {
                d2 = -0.5;
                d = 0.0;
                break;
            }
            case 2: {
                d2 = -0.5;
                d = -1.0;
                break;
            }
            case 3: {
                d2 = -1.0;
                d = -0.5;
                break;
            }
            case 4: {
                d2 = 0.0;
                d = -0.5;
                break;
            }
            case 5: {
                d2 = -1.0;
                d = 0.0;
                break;
            }
            case 6: {
                d2 = 0.0;
                d = 0.0;
                break;
            }
            case 7: {
                d2 = -1.0;
                d = -1.0;
                break;
            }
            case 8: {
                d2 = 0.0;
                d = -1.0;
            }
        }
        double d3 = d2 + 1.0;
        double d4 = d + 1.0;
        switch (n) {
            case 4: {
                this.line1 = new Line2D.Double(d2 + 0.5, d, d2 + 0.5, d4);
                this.line2 = new Line2D.Double(d2, d + 0.5, d3, d + 0.5);
                this.shape = new Ellipse2D.Double(d2, d, 1.0, 1.0);
                break;
            }
            default: {
                this.shape = new Ellipse2D.Double(d2, d, 1.0, 1.0);
                break;
            }
            case 2: {
                this.shape = new Rectangle2D.Double(d2, d, 1.0, 1.0);
                break;
            }
            case 3: {
                this.shape = new RoundRectangle2D.Double(d2, d, 1.0, 1.0, 0.3, 0.3);
            }
        }
    }
}

