/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ComplexGridPlot;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.ZExpansion;

public class ComplexColorMapper {
    static final double PI2 = Math.PI * 2;
    static final double COLOR_ERR = 1.0E-9;
    private double ceil;
    private Color ceilColor = Color.lightGray;
    private JFrame legendFrame;
    int[] reds = new int[256];
    int[] greens = new int[256];
    int[] blues = new int[256];
    protected ZExpansion zMap = null;

    public ComplexColorMapper(double d) {
        this.ceil = d;
        if (this.zMap != null) {
            this.zMap.setMinMax(0.0, this.ceil);
        }
        this.initColors();
    }

    public static JFrame showPhaseLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setPreferredGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        JFrame jFrame = new JFrame("Complex Phase");
        jFrame.setResizable(false);
        jFrame.setContentPane(interactivePanel);
        int n = 360;
        GridPointData gridPointData = new GridPointData(n, 1, 3);
        double[][][] dArray = gridPointData.getData();
        double d = -Math.PI;
        double d2 = Math.PI * 2 / (double)n;
        int n2 = 0;
        int n3 = dArray.length;
        while (n2 < n3) {
            dArray[n2][0][2] = 0.999;
            dArray[n2][0][3] = Math.cos(d);
            dArray[n2][0][4] = Math.sin(d);
            d += d2;
            ++n2;
        }
        gridPointData.setScale(-Math.PI, Math.PI, 0.0, 1.0);
        ComplexGridPlot complexGridPlot = new ComplexGridPlot(gridPointData);
        complexGridPlot.setShowGridLines(false);
        complexGridPlot.update();
        interactivePanel.addDrawable(complexGridPlot);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        jFrame.pack();
        jFrame.setVisible(true);
        return jFrame;
    }

    public JFrame showLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setPreferredGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame("Complex Phase");
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(interactivePanel);
        int n = 360;
        GridPointData gridPointData = new GridPointData(n, 1, 3);
        double[][][] dArray = gridPointData.getData();
        double d = -Math.PI;
        double d2 = Math.PI * 2 / (double)n;
        int n2 = 0;
        int n3 = dArray.length;
        while (n2 < n3) {
            dArray[n2][0][2] = 0.999;
            dArray[n2][0][3] = Math.cos(d);
            dArray[n2][0][4] = Math.sin(d);
            d += d2;
            ++n2;
        }
        gridPointData.setScale(-Math.PI, Math.PI, 0.0, 1.0);
        ComplexGridPlot complexGridPlot = new ComplexGridPlot(gridPointData);
        complexGridPlot.setShowGridLines(false);
        complexGridPlot.update();
        interactivePanel.addDrawable(complexGridPlot);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    public void setScale(double d) {
        this.ceil = d;
        if (this.zMap != null) {
            this.zMap.setMinMax(0.0, this.ceil);
        }
    }

    public byte[] samplesToComponents(double[] dArray, byte[] byArray) {
        Color color = this.samplesToColor(dArray);
        byArray[0] = (byte)color.getRed();
        byArray[1] = (byte)color.getGreen();
        byArray[2] = (byte)color.getBlue();
        return byArray;
    }

    public Color phaseToColor(double d) {
        float f = 1.0f;
        float f2 = (float)((Math.PI + d) / (Math.PI * 2));
        int n = (int)(255.0f * f2);
        return new Color((int)(f * (float)this.reds[n]), (int)(f * (float)this.greens[n]), (int)(f * (float)this.blues[n]));
    }

    public Color complexToColor(double d, double d2) {
        float f = 1.0f;
        float f2 = (float)((Math.PI + Math.atan2(d2, d)) / (Math.PI * 2));
        int n = (int)(255.0f * f2);
        return new Color((int)(f * (float)this.reds[n]), (int)(f * (float)this.greens[n]), (int)(f * (float)this.blues[n]));
    }

    public Color samplesToColor(double[] dArray) {
        double d = dArray[0];
        if (this.zMap != null) {
            d = this.zMap.evaluate(d);
        }
        if (d <= 0.0) {
            return Color.black;
        }
        if (this.zMap == null && d > this.ceil + 1.0E-9) {
            return this.ceilColor;
        }
        d = Math.min(d, this.ceil);
        float f = (float)(d / this.ceil);
        float f2 = (float)((Math.PI + Math.atan2(dArray[2], dArray[1])) / (Math.PI * 2));
        int n = (int)(255.0f * f2);
        return new Color((int)(f * (float)this.reds[n]), (int)(f * (float)this.greens[n]), (int)(f * (float)this.blues[n]));
    }

    public Color pointToColor(double[] dArray) {
        double d = dArray[2];
        if (this.zMap != null) {
            d = this.zMap.evaluate(d);
        }
        if (d <= 0.0) {
            return Color.black;
        }
        if (d > this.ceil + 1.0E-9) {
            return this.ceilColor;
        }
        float f = (float)(d / this.ceil);
        float f2 = (float)((Math.PI + Math.atan2(dArray[4], dArray[3])) / (Math.PI * 2));
        int n = (int)(255.0f * f2);
        return new Color((int)(f * (float)this.reds[n]), (int)(f * (float)this.greens[n]), (int)(f * (float)this.blues[n]));
    }

    public void setZMap(ZExpansion zExpansion) {
        this.zMap = zExpansion;
        if (this.zMap != null) {
            this.zMap.setMinMax(0.0, this.ceil);
        }
    }

    public double getCeil() {
        return this.ceil;
    }

    public Color getCeilColor() {
        return this.ceilColor;
    }

    public void setCeilColor(Color color) {
        this.ceilColor = color;
    }

    private void initColors() {
        double d = Math.PI;
        int n = 0;
        while (n < 256) {
            double d2 = Math.abs(Math.sin(d * (double)n / 255.0));
            this.blues[n] = (int)(255.0 * d2 * d2);
            d2 = Math.abs(Math.sin(d * (double)n / 255.0 + d / 3.0));
            this.greens[n] = (int)(255.0 * d2 * d2 * Math.sqrt(d2));
            d2 = Math.abs(Math.sin(d * (double)n / 255.0 + 2.0 * d / 3.0));
            this.reds[n] = (int)(255.0 * d2 * d2);
            ++n;
        }
    }
}

