/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementBox;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementBox;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class ElementBox
extends Element {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private double sizeZreduction = 1.0;

    public ElementBox() {
        this.getStyle().setResolution(new Resolution(3, 3, 3));
    }

    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementBox(this);
            }
            case 1: 
        }
        return new Java3dElementBox(this);
    }

    public void setSizeZReduction(double d) {
        if (this.sizeZreduction == d) {
            return;
        }
        this.sizeZreduction = d;
        this.addChange(8);
    }

    public double getSizeZReduction() {
        return this.sizeZreduction;
    }

    public void setClosedBottom(boolean bl) {
        if (this.closedBottom == bl) {
            return;
        }
        this.closedBottom = bl;
        this.addChange(8);
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        if (this.closedTop == bl) {
            return;
        }
        this.closedTop = bl;
        this.addChange(8);
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public static double[][][] createStandardBox(int n, int n2, int n3, boolean bl, boolean bl2, double d) {
        double d2;
        double d3;
        double d4;
        int n4 = 2 * n * n3 + 2 * n2 * n3;
        if (bl2) {
            n4 += n * n2;
        }
        if (bl) {
            n4 += n * n2;
        }
        if (d == 0.0) {
            n4 -= n2 * n3;
        }
        double[][][] dArray = new double[n4][4][3];
        int n5 = 0;
        double d5 = 1.0 / (double)n;
        double d6 = 1.0 / (double)n2;
        int n6 = 0;
        while (n6 < n) {
            d4 = (double)n6 * d5;
            d3 = 1.0 - d4 * (1.0 - d) - 0.5;
            d2 = d3 - d5 * (1.0 - d);
            d4 -= 0.5;
            int n7 = 0;
            while (n7 < n2) {
                double d7 = (double)n7 * d6 - 0.5;
                if (bl2) {
                    dArray[n5][0][0] = d4;
                    dArray[n5][0][1] = d7;
                    dArray[n5][0][2] = -0.5;
                    dArray[n5][1][0] = d4 + d5;
                    dArray[n5][1][1] = d7;
                    dArray[n5][1][2] = -0.5;
                    dArray[n5][2][0] = d4 + d5;
                    dArray[n5][2][1] = d7 + d6;
                    dArray[n5][2][2] = -0.5;
                    dArray[n5][3][0] = d4;
                    dArray[n5][3][1] = d7 + d6;
                    dArray[n5][3][2] = -0.5;
                    ++n5;
                }
                if (bl) {
                    dArray[n5][0][0] = d4;
                    dArray[n5][0][1] = d7;
                    dArray[n5][0][2] = d3;
                    dArray[n5][1][0] = d4 + d5;
                    dArray[n5][1][1] = d7;
                    dArray[n5][1][2] = d2;
                    dArray[n5][2][0] = d4 + d5;
                    dArray[n5][2][1] = d7 + d6;
                    dArray[n5][2][2] = d2;
                    dArray[n5][3][0] = d4;
                    dArray[n5][3][1] = d7 + d6;
                    dArray[n5][3][2] = d3;
                    ++n5;
                }
                ++n7;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n) {
            d4 = (double)n6 * d5;
            d3 = 1.0 - d4 * (1.0 - d);
            d2 = d3 - d5 * (1.0 - d);
            double d8 = d3 / (double)n3;
            double d9 = d2 / (double)n3;
            d4 -= 0.5;
            int n8 = 0;
            while (n8 < n3) {
                double d10 = (double)n8 * d8 - 0.5;
                double d11 = (double)n8 * d9 - 0.5;
                dArray[n5][0][0] = d4;
                dArray[n5][0][2] = d10;
                dArray[n5][0][1] = -0.5;
                dArray[n5][1][0] = d4 + d5;
                dArray[n5][1][2] = d11;
                dArray[n5][1][1] = -0.5;
                dArray[n5][2][0] = d4 + d5;
                dArray[n5][2][2] = d11 + d9;
                dArray[n5][2][1] = -0.5;
                dArray[n5][3][0] = d4;
                dArray[n5][3][2] = d10 + d8;
                dArray[n5][3][1] = -0.5;
                dArray[++n5][0][0] = d4;
                dArray[n5][0][2] = d10;
                dArray[n5][0][1] = 0.5;
                dArray[n5][1][0] = d4 + d5;
                dArray[n5][1][2] = d11;
                dArray[n5][1][1] = 0.5;
                dArray[n5][2][0] = d4 + d5;
                dArray[n5][2][2] = d11 + d9;
                dArray[n5][2][1] = 0.5;
                dArray[n5][3][0] = d4;
                dArray[n5][3][2] = d10 + d8;
                dArray[n5][3][1] = 0.5;
                ++n5;
                ++n8;
            }
            ++n6;
        }
        double d12 = 1.0 / (double)n3;
        double d13 = d / (double)n3;
        int n9 = 0;
        while (n9 < n3) {
            d2 = (double)n9 * d12 - 0.5;
            double d14 = (double)n9 * d13 - 0.5;
            int n10 = 0;
            while (n10 < n2) {
                double d15 = (double)n10 * d6 - 0.5;
                dArray[n5][0][2] = d2;
                dArray[n5][0][1] = d15;
                dArray[n5][0][0] = -0.5;
                dArray[n5][1][2] = d2 + d12;
                dArray[n5][1][1] = d15;
                dArray[n5][1][0] = -0.5;
                dArray[n5][2][2] = d2 + d12;
                dArray[n5][2][1] = d15 + d6;
                dArray[n5][2][0] = -0.5;
                dArray[n5][3][2] = d2;
                dArray[n5][3][1] = d15 + d6;
                dArray[n5][3][0] = -0.5;
                ++n5;
                if (d != 0.0) {
                    dArray[n5][0][2] = d14;
                    dArray[n5][0][1] = d15;
                    dArray[n5][0][0] = 0.5;
                    dArray[n5][1][2] = d14 + d13;
                    dArray[n5][1][1] = d15;
                    dArray[n5][1][0] = 0.5;
                    dArray[n5][2][2] = d14 + d13;
                    dArray[n5][2][1] = d15 + d6;
                    dArray[n5][2][0] = 0.5;
                    dArray[n5][3][2] = d14;
                    dArray[n5][3][1] = d15 + d6;
                    dArray[n5][3][0] = 0.5;
                    ++n5;
                }
                ++n10;
            }
            ++n9;
        }
        return dArray;
    }
}

