/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTrail
extends Element
implements Data {
    public static final int NO_CONNECTION = 0;
    public static final int LINE_CONNECTION = 1;
    private static TrailPoint nullPoint = new TrailPoint(Double.NaN, Double.NaN, 1);
    private int maximum = 0;
    private int connectionType = 1;
    private boolean active = true;
    private boolean noRepeat = false;
    private boolean clearAtInput = false;
    private int skip = 0;
    private String[] inputLabels = new String[]{"x", "y"};
    private List<TrailPoint> currentList = new ArrayList<TrailPoint>();
    private GeneralPath currentPath = new GeneralPath();
    private PathAndStyle currentSegment = new PathAndStyle(this, null, 0, this.currentList);
    private List<PathAndStyle> segmentList = new ArrayList<PathAndStyle>();
    private TrailPoint flushPoint = nullPoint;
    private boolean isEmpty = true;
    private int counter = 0;
    private double lastX = Double.NaN;
    private double lastY = Double.NaN;
    private int dataID = this.hashCode();

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setNoRepeat(boolean bl) {
        this.noRepeat = bl;
    }

    public boolean isNoRepeat() {
        return this.noRepeat;
    }

    public void setClearAtInput(boolean bl) {
        this.clearAtInput = bl;
    }

    public boolean isClearAtInput() {
        return this.clearAtInput;
    }

    public void setSkipPoints(int n) {
        if (this.skip != n) {
            this.skip = n;
            this.counter = 0;
        }
    }

    public int getSkipPoints() {
        return this.skip;
    }

    public void setXLabel(String string) {
        this.inputLabels[0] = string;
    }

    public void setYLabel(String string) {
        this.inputLabels[1] = string;
    }

    public void addPoint(double d, double d2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(d, d2, this.connectionType);
    }

    public void addPoint(double[] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(dArray[0], dArray[1], this.connectionType);
    }

    public void moveToPoint(double d, double d2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(d, d2, 0);
    }

    public void moveToPoint(double[] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(dArray[0], dArray[1], 0);
    }

    public void addPoints(double[][] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            this.addPoint(dArray[n][0], dArray[n][1], this.connectionType);
            ++n;
        }
    }

    public void addPoints(double[] dArray, double[] dArray2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            this.addPoint(dArray[n2], dArray2[n2], this.connectionType);
            ++n2;
        }
    }

    public void setMaximumPoints(int n) {
        this.maximum = Math.max(n, 2);
    }

    public int getMaximumPoints() {
        return this.maximum;
    }

    public void setConnectionType(int n) {
        this.connectionType = n;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<PathAndStyle> list = this.segmentList;
        synchronized (list) {
            this.segmentList.clear();
        }
        this.currentSegment.index = 0;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        List<TrailPoint> list = this.currentList;
        synchronized (list) {
            this.currentList.clear();
            this.currentPath.reset();
            this.flushPoint = nullPoint;
            this.isEmpty = true;
            this.counter = 0;
            this.lastX = Double.NaN;
            this.lastY = Double.NaN;
            this.setNeedToProject(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSegment() {
        TrailPoint trailPoint = null;
        TrailPoint trailPoint2 = this.flushPoint;
        synchronized (trailPoint2) {
            if (this.flushPoint != nullPoint) {
                trailPoint = new TrailPoint(this.flushPoint.x, this.flushPoint.y, this.flushPoint.type);
            }
        }
        if (trailPoint != null) {
            this.currentList.add(trailPoint);
            int n = this.isEmpty ? 0 : trailPoint.type;
            switch (n) {
                default: {
                    this.currentPath.lineTo((float)trailPoint.x, (float)trailPoint.y);
                    break;
                }
                case 0: {
                    this.currentPath.moveTo((float)trailPoint.x, (float)trailPoint.y);
                    this.currentPath.lineTo((float)trailPoint.x, (float)trailPoint.y);
                }
            }
        }
        List<TrailPoint> list = this.currentList;
        synchronized (list) {
            this.segmentList.add(new PathAndStyle(this, this.currentPath, this.segmentList.size(), this.currentList));
            this.currentList = new ArrayList<TrailPoint>();
            this.currentPath = new GeneralPath();
            this.currentSegment.pointsList = this.currentList;
            this.currentSegment.path = this.currentPath;
            PathAndStyle pathAndStyle = this.currentSegment;
            pathAndStyle.index = pathAndStyle.index + 1;
            this.flushPoint = nullPoint;
            this.isEmpty = true;
            this.counter = 0;
            this.lastX = Double.NaN;
            this.lastY = Double.NaN;
        }
    }

    @Override
    public void setID(int n) {
        this.dataID = n;
    }

    @Override
    public int getID() {
        return this.dataID;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return this.inputLabels;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, this.getStyle().getLineColor()};
    }

    @Override
    public Color[] getFillColors() {
        Paint paint = this.getStyle().getFillColor();
        if (paint instanceof Color) {
            return new Color[]{Color.BLACK, (Color)paint};
        }
        return new Color[]{Color.BLACK, Color.BLUE};
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> arrayList = new ArrayList<Data>();
        arrayList.addAll(this.segmentList);
        int n = this.segmentList.size();
        this.currentSegment.update(this.getCurrentSegmentPath(), n > 0 ? n + 1 : -1);
        arrayList.add(this.currentSegment);
        return arrayList;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeneralPath getCurrentSegmentPath() {
        TrailPoint trailPoint = null;
        Object object = this.flushPoint;
        synchronized (object) {
            if (this.flushPoint != nullPoint) {
                trailPoint = new TrailPoint(this.flushPoint.x, this.flushPoint.y, this.flushPoint.type);
            }
        }
        if (trailPoint == null) {
            return this.currentPath;
        }
        object = new GeneralPath(this.currentPath);
        int n = this.isEmpty ? 0 : trailPoint.type;
        switch (n) {
            default: {
                ((Path2D.Float)object).lineTo((float)trailPoint.x, (float)trailPoint.y);
                break;
            }
            case 0: {
                ((Path2D.Float)object).moveTo((float)trailPoint.x, (float)trailPoint.y);
                ((Path2D.Float)object).lineTo((float)trailPoint.x, (float)trailPoint.y);
            }
        }
        return object;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.isReallyVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (PathAndStyle object2 : this.segmentList) {
            Color color = object2.style.getLineColor();
            if (color == null) continue;
            graphics2D.setStroke(object2.style.getLineStroke());
            graphics2D.setColor(color);
            Shape shape = this.getPixelTransform(drawingPanel).createTransformedShape(object2.path);
            graphics2D.draw(shape);
        }
        Color color = this.getStyle().getLineColor();
        if (color == null) {
            return;
        }
        graphics2D.setStroke(this.getStyle().getLineStroke());
        graphics2D.setColor(color);
        Shape shape = this.getPixelTransform(drawingPanel).createTransformedShape(this.getCurrentSegmentPath());
        graphics2D.draw(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints(drawingPanel);
        }
        int n3 = this.getStyle().getSensitivity();
        if (this.targetPosition.isEnabled()) {
            for (PathAndStyle object2 : this.segmentList) {
                for (TrailPoint trailPoint : object2.pointsList) {
                    if (!(Math.abs(trailPoint.pixel[0] - (double)n) < (double)n3) || !(Math.abs(trailPoint.pixel[1] - (double)n2) < (double)n3)) continue;
                    return this.targetPosition;
                }
            }
            for (TrailPoint trailPoint : this.currentList) {
                if (!(Math.abs(trailPoint.pixel[0] - (double)n) < (double)n3) || !(Math.abs(trailPoint.pixel[1] - (double)n2) < (double)n3)) continue;
                return this.targetPosition;
            }
            TrailPoint trailPoint = this.flushPoint;
            synchronized (trailPoint) {
                if (this.flushPoint != nullPoint && Math.abs(this.flushPoint.pixel[0] - (double)n) < (double)n3 && Math.abs(this.flushPoint.pixel[1] - (double)n2) < (double)n3) {
                    return this.targetPosition;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isMeasured() {
        return (!this.currentList.isEmpty() || !this.segmentList.isEmpty()) && super.getCanBeMeasured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateExtrema() {
        boolean bl;
        if (!this.hasChanged()) {
            return;
        }
        this.initExtrema();
        double[] dArray = new double[2];
        for (PathAndStyle object : this.segmentList) {
            for (TrailPoint trailPoint : object.pointsList) {
                dArray[0] = trailPoint.x;
                dArray[1] = trailPoint.y;
                this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
                if (Double.isNaN(dArray[0]) || Double.isNaN(dArray[1])) continue;
                this.compareToAllExtrema(dArray[0], dArray[1]);
            }
        }
        for (TrailPoint trailPoint : this.currentList) {
            dArray[0] = trailPoint.x;
            dArray[1] = trailPoint.y;
            this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
            if (Double.isNaN(dArray[0]) || Double.isNaN(dArray[1])) continue;
            this.compareToAllExtrema(dArray[0], dArray[1]);
        }
        boolean bl2 = false;
        TrailPoint trailPoint = this.flushPoint;
        synchronized (trailPoint) {
            if (this.flushPoint != nullPoint) {
                dArray[0] = this.flushPoint.x;
                dArray[1] = this.flushPoint.y;
                bl = true;
            }
        }
        if (bl) {
            this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
            if (!Double.isNaN(dArray[0]) && !Double.isNaN(dArray[1])) {
                this.compareToAllExtrema(dArray[0], dArray[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectPoints(DrawingPanel drawingPanel) {
        AffineTransform affineTransform = this.getPixelTransform(drawingPanel);
        for (PathAndStyle object2 : this.segmentList) {
            for (TrailPoint trailPoint : object2.pointsList) {
                trailPoint.project(affineTransform);
            }
        }
        for (TrailPoint trailPoint : this.currentList) {
            trailPoint.project(affineTransform);
        }
        TrailPoint trailPoint = this.flushPoint;
        synchronized (trailPoint) {
            if (this.flushPoint != nullPoint) {
                this.flushPoint.project(affineTransform);
            }
        }
        this.setNeedToProject(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPoint(double d, double d2, int n) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            this.isEmpty = true;
            return;
        }
        if (this.noRepeat && this.lastX == d && this.lastY == d2) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.flushPoint = new TrailPoint(d, d2, n);
                this.lastX = d;
                this.lastY = d2;
                return;
            }
            ++this.counter;
        }
        this.flushPoint = nullPoint;
        List<TrailPoint> list = this.currentList;
        synchronized (list) {
            Object object;
            Object object2;
            this.lastX = d;
            this.lastY = d2;
            int n2 = this.currentList.size();
            if (this.maximum > 2 && n2 >= this.maximum) {
                this.currentList.remove(0);
                object2 = this.currentPath;
                synchronized (object2) {
                    this.currentPath.reset();
                    object = this.currentList.get(0);
                    this.currentPath.moveTo((float)((TrailPoint)object).x, (float)((TrailPoint)object).y);
                    this.currentPath.lineTo((float)((TrailPoint)object).x, (float)((TrailPoint)object).y);
                    for (TrailPoint trailPoint : this.currentList) {
                        switch (trailPoint.type) {
                            default: {
                                this.currentPath.lineTo((float)trailPoint.x, (float)trailPoint.y);
                                break;
                            }
                            case 0: {
                                this.currentPath.moveTo((float)trailPoint.x, (float)trailPoint.y);
                                this.currentPath.lineTo((float)trailPoint.x, (float)trailPoint.y);
                            }
                        }
                    }
                }
            }
            object2 = new TrailPoint(d, d2, n);
            this.currentList.add((TrailPoint)object2);
            object = this.currentPath;
            synchronized (object) {
                if (this.isEmpty) {
                    this.currentPath.moveTo((float)d, (float)d2);
                    this.currentPath.lineTo((float)d, (float)d2);
                } else {
                    switch (((TrailPoint)object2).type) {
                        default: {
                            this.currentPath.lineTo((float)d, (float)d2);
                            break;
                        }
                        case 0: {
                            this.currentPath.moveTo((float)d, (float)d2);
                            this.currentPath.lineTo((float)d, (float)d2);
                        }
                    }
                }
            }
            this.isEmpty = false;
            this.setElementChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathAndStyle
    implements Data {
        private ElementTrail trail;
        private GeneralPath path;
        private Style style;
        private List<TrailPoint> pointsList;
        private int index;
        private int id = this.hashCode();

        PathAndStyle(ElementTrail elementTrail, GeneralPath generalPath, int n, List<TrailPoint> list) {
            this.trail = elementTrail;
            this.path = generalPath;
            this.style = elementTrail.getStyle().clone();
            this.index = n;
            this.pointsList = list;
        }

        void update(GeneralPath generalPath, int n) {
            this.path = generalPath;
            this.style = this.trail.getStyle().clone();
        }

        @Override
        public String getName() {
            return this.trail.getName();
        }

        @Override
        public void setID(int n) {
            this.id = n;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public double[][] getData2D() {
            int n = this.pointsList.size();
            double[][] dArray = new double[2][n];
            int n2 = 0;
            while (n2 < n) {
                TrailPoint trailPoint = this.pointsList.get(n2);
                dArray[0][n2] = trailPoint.x;
                dArray[1][n2] = trailPoint.y;
                ++n2;
            }
            return dArray;
        }

        @Override
        public double[][][] getData3D() {
            return null;
        }

        @Override
        public String[] getColumnNames() {
            return this.trail.inputLabels;
        }

        @Override
        public Color[] getLineColors() {
            return new Color[]{Color.BLACK, this.style.getLineColor()};
        }

        @Override
        public Color[] getFillColors() {
            Paint paint = this.style.getFillColor();
            if (paint instanceof Color) {
                return new Color[]{Color.BLACK, (Color)paint};
            }
            return new Color[]{Color.BLACK, Color.BLUE};
        }

        @Override
        public List<Data> getDataList() {
            return null;
        }

        @Override
        public ArrayList<Dataset> getDatasets() {
            return null;
        }
    }

    private static class TrailPoint {
        private int type;
        private double x;
        private double y;
        private double[] pixel = new double[2];

        TrailPoint(double d, double d2, int n) {
            this.x = d;
            this.y = d2;
            this.type = n;
        }

        void project(AffineTransform affineTransform) {
            this.pixel[0] = this.x;
            this.pixel[1] = this.y;
            affineTransform.transform(this.pixel, 0, this.pixel, 0, 1);
        }
    }
}

