/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementBox;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementBox
extends SimpleAbstractTile {
    public SimpleElementBox(ElementBox elementBox) {
        super(elementBox);
    }

    protected double[][][] computeTile() {
        ElementBox elementBox = (ElementBox)this.element;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        Resolution resolution = this.style.getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    n = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeX()) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeY()) / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeZ()) / resolution.getMaxLength()), 1);
                }
            }
        }
        return ElementBox.createStandardBox(n, n2, n3, elementBox.isClosedTop(), elementBox.isClosedBottom(), elementBox.getSizeZReduction());
    }
}

