/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ArrayLib;
import org.opensourcephysics.numerics.HessianMinimize;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.MultiVarFunction;

public class LevenbergMarquardt {
    int Iterations;
    double[][] H;
    private double rmsd_tmp;
    private double rmsd_tmp1;
    private double rmsd;
    private double[] xtmp;
    private double[] xtmp1;
    HessianMinimize hessianMinimize = new HessianMinimize();

    public double minimize(MultiVarFunction multiVarFunction, double[] dArray, int n, double d) {
        int n2 = dArray.length;
        this.H = new double[n2][n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        this.xtmp = new double[n2];
        this.xtmp1 = new double[n2];
        this.rmsd_tmp1 = this.rmsd_tmp = multiVarFunction.evaluate(dArray);
        System.arraycopy(dArray, 0, this.xtmp, 0, n2);
        System.arraycopy(dArray, 0, this.xtmp1, 0, n2);
        int n3 = 0;
        while (n3 < n2) {
            dArray4[n3] = (Math.abs(dArray[n3]) + 1.0) / 100000.0;
            ++n3;
        }
        double d2 = 0.001;
        double d3 = 9999.0;
        double d4 = 9999.0;
        this.Iterations = 0;
        while (d3 > d * 1.0E-6 && d4 > d * 1.0E-6 && this.Iterations < n && d2 > 1.0E-6) {
            ++this.Iterations;
            this.H = this.hessianMinimize.getHessian(multiVarFunction, dArray, dArray3, dArray4);
            int n4 = 0;
            while (n4 < n2) {
                this.H[n4][n4] = this.H[n4][n4] + d2;
                ++n4;
            }
            LUPDecomposition lUPDecomposition = new LUPDecomposition(this.H);
            dArray2 = lUPDecomposition.solve(dArray3);
            int n5 = 0;
            while (n5 < n2) {
                dArray2[n5] = dArray2[n5] + dArray[n5];
                ++n5;
            }
            d3 = (dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]);
            d4 = dArray[0] * dArray[0];
            dArray[0] = dArray2[0];
            n5 = 1;
            while (n5 < n2) {
                d3 += (dArray[n5] - dArray2[n5]) * (dArray[n5] - dArray2[n5]);
                d4 += dArray[n5] * dArray[n5];
                dArray[n5] = dArray2[n5];
                ++n5;
            }
            this.rmsd = multiVarFunction.evaluate(dArray);
            if (this.rmsd < this.rmsd_tmp1) {
                d2 /= 10.0;
                this.rmsd_tmp1 = this.rmsd;
                System.arraycopy(dArray, 0, this.xtmp1, 0, n2);
            } else {
                System.arraycopy(this.xtmp1, 0, dArray, 0, n2);
                d2 *= 10.0;
            }
            d3 = Math.sqrt(d3);
            d4 = d3 / (d4 + d);
        }
        this.check_rmsd(multiVarFunction, this.xtmp, dArray, n2);
        return d3;
    }

    void check_rmsd(MultiVarFunction multiVarFunction, double[] dArray, double[] dArray2, int n) {
        if (Double.isNaN(ArrayLib.sum(dArray2))) {
            this.rmsd = this.rmsd_tmp;
            System.arraycopy(dArray, 0, dArray2, 0, n);
        } else {
            this.rmsd = multiVarFunction.evaluate(dArray2);
            if (this.rmsd <= this.rmsd_tmp) {
                this.rmsd_tmp = this.rmsd;
                System.arraycopy(dArray2, 0, dArray, 0, n);
            } else {
                this.rmsd = this.rmsd_tmp;
                System.arraycopy(dArray, 0, dArray2, 0, n);
            }
        }
    }

    public int getIterations() {
        return this.Iterations;
    }
}

