/*
 * Decompiled with CFR 0.152.
 */
package RoessMa.Plotter_Raumkurven.Raumkurven_pkg;

import RoessMa.Plotter_Raumkurven.Raumkurven_pkg.RaumkurvenSimulation;
import RoessMa.Plotter_Raumkurven.Raumkurven_pkg.RaumkurvenView;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorResourceUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Raumkurven
extends Model {
    public RaumkurvenSimulation _simulation = null;
    public RaumkurvenView _view = null;
    public Raumkurven _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    public double t = 0.0;
    public double u;
    public double v;
    public double w;
    public double a;
    public double b;
    public double c;
    public double p = 0.95745;
    public int Ga = 50;
    public int Gb = 50;
    public int Gc = 50;
    public boolean zeigen = true;
    public double[][][] data;
    public int n = 100;
    public int m = 50;
    public String fTyp = "";
    public String x_functions = "";
    public String y_functions = "";
    public String z_functions = "";
    public String description = "";
    public ArrayList<String> x_functionList;
    public ArrayList<String> y_functionList;
    public ArrayList<String> z_functionList;
    public ArrayList<String> descriptionList;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_initialization2 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return Raumkurven._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/RoessMa/Plotter_Raumkurven/Raumkurven.xml";
    }

    public static String _getModelDirectory() {
        return "RoessMa/Plotter_Raumkurven/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(605, 700);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("RoessMa/Plotter_Raumkurven/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("E:/EJS_Versionen/EJS_4.3.7_17.5.2012/EJS_4.3.7/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("E:/EJS_Versionen/EJS_4.3.7_17.5.2012/EJS_4.3.7/bin/config/");
        }
        Raumkurven._addHtmlPageInfo("Beschreibung", "_default_", "Beschreibung", "./Raumkurven_Intro 1.html");
        Raumkurven._addHtmlPageInfo("Visualisierung", "_default_", "Visualisierung", "./Raumkurven_Intro 2.html");
        Raumkurven._addHtmlPageInfo("Funktionen", "_default_", "Funktionen", "./Raumkurven_Intro 3.html");
        Raumkurven._addHtmlPageInfo("Experimente", "_default_", "Experimente", "./Raumkurven_Intro 4.html");
        Raumkurven._addHtmlPageInfo("Authors", "_default_", "Authors", "./Raumkurven_Intro 5.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!Raumkurven._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        Raumkurven raumkurven = new Raumkurven(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!Raumkurven._common_initialization(stringArray)) {
            return null;
        }
        Raumkurven raumkurven = new Raumkurven("drawingFrame", jFrame, null, null, stringArray, true);
        return (JComponent)raumkurven._getView().getComponent("drawingFrame");
    }

    public Raumkurven() {
        this(null, null, null, null, null, false);
    }

    public Raumkurven(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Raumkurven(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new RaumkurvenSimulation(this, string, frame, uRL, bl);
        this._view = (RaumkurvenView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public String _getClassEjsModel() {
        return Raumkurven._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return Raumkurven._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return Raumkurven._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_initialization2 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.t = 0.0;
        this.p = 0.95745;
        this.Ga = 50;
        this.Gb = 50;
        this.Gc = 50;
        this.zeigen = true;
        this.data = new double[this.n][this.m][3];
        this.n = 100;
        this.m = 50;
        this.fTyp = "";
        this.x_functions = "";
        this.y_functions = "";
        this.z_functions = "";
        this.description = "";
    }

    public void _initializeSolvers() {
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (this._isEnabled_initialization2) {
            this._initialization2();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
    }

    @Override
    public void _resetSolvers() {
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_evolution1) {
            this._evolution1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _freeMemory() {
        this.data = null;
        System.gc();
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("html-start".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization2 = bl;
        }
        if ("Zeitverlauf".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
        }
        if ("Zuordnungen".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.Ga = 50;
        this.Gb = 50;
        this.Gc = 50;
        this.Listen();
        this.initFunctions();
    }

    public void _initialization2() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Raumkurven.this._view.showDescription(true);
            }
        });
        thread.start();
    }

    public void _evolution1() {
        this.t += this.p * 0.1;
        if (this.u > 2.0 || this.v > 2.0 || this.w > 2.0) {
            this._pause();
        }
    }

    public void _constraints1() {
        this.a = (double)this.Ga * 0.01;
        this.b = (double)this.Gb * 0.01;
        this.c = (double)this.Gc * 0.01;
        if (this.t > 0.0) {
            this.u = this._view.getFunction("xFunction", "function").eval(this.t);
            this.v = this._view.getFunction("yFunction", "function").eval(this.t);
            this.w = this._view.getFunction("zFunction", "function").eval(this.t);
        }
    }

    public void Listen() {
        this.descriptionList = new ArrayList();
        this.x_functionList = new ArrayList();
        this.y_functionList = new ArrayList();
        this.z_functionList = new ArrayList();
        this.x_functionList.add("a*t/20*cos(t)");
        this.y_functionList.add("b*t/20*sin(t)");
        this.z_functionList.add(" -1+c*t/20");
        this.descriptionList.add("linear-lineare arithmetische Spirale");
        this.x_functionList.add("a*t/20*cos(t)");
        this.y_functionList.add("b*t/20*sin(t)");
        this.z_functionList.add(" -2+exp(c*t/20)");
        this.descriptionList.add("exponentiell- arithmetische Spirale");
        this.x_functionList.add("a*(exp(t/50)-1)*cos(t)");
        this.y_functionList.add("b*(exp(t/50)-1)*sin(t)");
        this.z_functionList.add(" -2+exp(c*t/20)");
        this.descriptionList.add("exponentiell- exponentielle Spirale");
        this.x_functionList.add("a*cos(t)");
        this.y_functionList.add("b*sin(c*t)");
        this.z_functionList.add("0");
        this.descriptionList.add("ebene Lissajou- Bahn");
        this.x_functionList.add("a*cos(t)");
        this.y_functionList.add("b*sin((c+sqrt(2))*t)");
        this.z_functionList.add("0");
        this.descriptionList.add("nichtgeschlossene, ebene Lissajou- Bahn");
        this.x_functionList.add("a*cos(t)");
        this.y_functionList.add("c*sin(t)");
        this.z_functionList.add("sin(b*t)");
        this.descriptionList.add("Lissajou auf Zylinder");
        this.x_functionList.add("a*(1-cos(b*t))*cos(c*t)");
        this.y_functionList.add("a*(1-cos(b*t))*sin(c*t)");
        this.z_functionList.add("cos(b*t)");
        this.descriptionList.add("Lissajou auf Kegel");
        this.x_functionList.add("a*cos(b*t)*cos(c*t)");
        this.y_functionList.add("a*cos(b*t)*sin(c*t)");
        this.z_functionList.add("cos(b*t)");
        this.descriptionList.add("Lissajou auf Doppelkegel");
        this.x_functionList.add("a*(1+(cos(b*t))^2)*cos(c*t)");
        this.y_functionList.add("a*(1+(cos(b*t))^2)*sin(c*t)");
        this.z_functionList.add("cos(b*t)");
        this.descriptionList.add("Lissajou auf Hohlkoerper");
        this.x_functionList.add("a*(1-(cos(b*t))^2)*cos(c*t)");
        this.y_functionList.add("a*(1-(cos(b*t))^2)*sin(c*t)");
        this.z_functionList.add("cos(b*t)");
        this.descriptionList.add("Lissajou auf Spindel");
        this.x_functionList.add("a*cos(b*t)*cos(c*t)");
        this.y_functionList.add("a*cos(b*t)*sin(c*t)");
        this.z_functionList.add("a*sin(b*t)");
        this.descriptionList.add("Lissajou auf Kugel");
        this.x_functionList.add("(a+0.25*cos(b*t))*cos(c*t)");
        this.y_functionList.add("(a+0.25*cos(b*t))*sin(c*t)");
        this.z_functionList.add("0.25*sin(b*t)");
        this.descriptionList.add("Lissajou auf Torus");
        this.x_functionList.add("");
        this.y_functionList.add("");
        this.z_functionList.add("");
        this.descriptionList.add("");
    }

    public void initFunctions() {
        this.ParamReset();
        String string = this.descriptionList.get(0);
        for (int i = 1; i < this.descriptionList.size(); ++i) {
            String string2 = this.descriptionList.get(i).trim();
            string = string + "; " + string2;
        }
        this.description = string;
        this.x_functions = this.x_functionList.get(0);
        this.y_functions = this.y_functionList.get(0);
        this.z_functions = this.z_functionList.get(0);
    }

    public void changeFunction() {
        this.ParamReset();
        if (this.descriptionList != null) {
            int n = this.descriptionList.indexOf(this.fTyp.trim());
            this.x_functions = this.x_functionList.get(n);
            this.y_functions = this.y_functionList.get(n);
            this.z_functions = this.z_functionList.get(n);
        }
    }

    public void ParamReset() {
        this.Ga = 50;
        this.Gb = 50;
        this.Gc = 50;
        this.t = 0.0;
        this.p = 1.0;
    }

    public void Anistart() {
        this.u = 0.0;
        this.v = 0.0;
        this.w = 0.0;
        this.t = 0.0;
        this._play();
        if (this.t > 0.5) {
            this._pause();
        }
        this._view.resetTraces();
        this._play();
    }

    public void _method_for_Auswahlliste_action() {
        this.changeFunction();
    }

    public void _method_for_SliderA_pressaction() {
        this._pause();
    }

    public void _method_for_SliderA_dragaction() {
        this._pause();
    }

    public void _method_for_SliderA_action() {
        this._pause();
    }

    public void _method_for_SliderB_dragaction() {
        this._pause();
    }

    public void _method_for_SliderC_dragaction() {
        this._pause();
    }

    public void _method_for_Start_action() {
        this.Anistart();
    }

    public void _method_for_PlayStop_actionOn() {
        this._play();
    }

    public void _method_for_PlayStop_actionOff() {
        this._pause();
    }

    public void _method_for_clear_action() {
        this._view.resetTraces();
    }

    public void _method_for_Reset_action() {
        this.ParamReset();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
        __translatorUtil = new TranslatorResourceUtil("RoessMa.Plotter_Raumkurven.Raumkurven_pkg.Raumkurven");
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }
}

