/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Font;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.TextLine;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementText;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementText;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class ElementText
extends Element {
    private String text = "";
    private Font font;
    private boolean trueSize = false;
    private double rotationAngle = 0.0;
    private TextLine textLine = new TextLine();

    public ElementText() {
        this.setSizeXYZ(0.2, 0.2, 0.2);
        this.setFont(new Font("dialog", 0, 12));
        this.getStyle().setRelativePosition(0);
        this.getStyle().setFillColor(this.getStyle().getLineColor());
    }

    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementText(this);
            }
            case 1: 
        }
        return new Java3dElementText(this);
    }

    public void setText(String string) {
        if (this.text != null && this.text.equals(string)) {
            return;
        }
        this.text = TeXParser.parseTeX(string);
        this.textLine.setText(this.text);
        this.addChange(8);
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        this.font = font;
        this.textLine.setFont(font);
        this.addChange(8);
    }

    public Font getFont() {
        return this.font;
    }

    public void setRotationAngle(double d) {
        this.rotationAngle = d;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setTrueSize(boolean bl) {
        this.trueSize = bl;
        this.addChange(64);
        this.addChange(8);
    }

    public boolean isTrueSize() {
        return this.trueSize;
    }

    public void setSizeX(double d) {
        if (!this.isTrueSize()) {
            d = 0.4;
        }
        super.setSizeX(d);
    }

    public void setSizeY(double d) {
        if (!this.isTrueSize()) {
            d = 0.4;
        }
        super.setSizeY(d);
    }

    public void setSizeZ(double d) {
        if (!this.isTrueSize()) {
            d = 0.4;
        }
        super.setSizeZ(d);
    }

    public TextLine getTextLine() {
        return this.textLine;
    }

    public double getDiagonalSize() {
        if (this.trueSize) {
            return 0.0;
        }
        return super.getDiagonalSize();
    }

    protected void getExtrema(double[] dArray, double[] dArray2) {
        if (this.trueSize) {
            System.arraycopy(Element.STD_ORIGIN, 0, dArray, 0, 3);
            System.arraycopy(Element.STD_ORIGIN, 0, dArray2, 0, 3);
            this.sizeAndToSpaceFrame(dArray);
            this.sizeAndToSpaceFrame(dArray2);
        } else {
            super.getExtrema(dArray, dArray2);
        }
    }
}

