/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.utils.mapping.Mapping;
import org.opensourcephysics.drawing3d.utils.mapping.MappingXYZ;
import org.opensourcephysics.drawing3d.utils.mapping.MappingXZY;
import org.opensourcephysics.drawing3d.utils.mapping.MappingYXZ;
import org.opensourcephysics.drawing3d.utils.mapping.MappingYZX;
import org.opensourcephysics.drawing3d.utils.mapping.MappingZXY;
import org.opensourcephysics.drawing3d.utils.mapping.MappingZYX;
import org.opensourcephysics.numerics.Quaternion;
import org.opensourcephysics.numerics.Transformation;
import org.opensourcephysics.numerics.VectorMath;

public class Camera {
    public static final int MODE_PLANAR_XY = 0;
    public static final int MODE_PLANAR_XZ = 1;
    public static final int MODE_PLANAR_YZ = 2;
    public static final int MODE_PERSPECTIVE_OFF = 3;
    public static final int MODE_PERSPECTIVE_ON = 4;
    public static final int MODE_NO_PERSPECTIVE = 10;
    public static final int MODE_PERSPECTIVE = 11;
    private static final double RATIO_TO_SCREEN = 2.5;
    private static final double RATIO_TO_FOCUS = 2.0;
    private static final double[] VERTICAL_AXIS = new double[]{0.0, 0.0, 1.0};
    public static final int CHANGE_ANY = 0;
    public static final int CHANGE_MODE = 1;
    public static final int CHANGE_POSITION = 2;
    public static final int CHANGE_FOCUS = 3;
    public static final int CHANGE_ROTATION = 4;
    public static final int CHANGE_SCREEN = 5;
    public static final int CHANGE_ANGLES = 6;
    public static final int CHANGE_MAPPING = 7;
    private int projectionMode = 4;
    private double posX = 4.0;
    private double posY = 0.0;
    private double posZ = 0.0;
    private double focusX = 0.0;
    private double focusY = 0.0;
    private double focusZ = 0.0;
    private double distanceToScreen;
    private double rotationAngle = 0.0;
    private double alpha = 0.0;
    private double beta = 0.0;
    private int mapType = 0;
    private double distanceToFocus;
    private double panelMaxSizeConstant;
    private double planarRatio;
    double cosAlpha = 1.0;
    double sinAlpha = 0.0;
    double cosBeta = 1.0;
    double sinBeta = 0.0;
    private double cosRot = 1.0;
    private double sinRot = 0.0;
    private double[] e1 = new double[]{-1.0, 0.0, 0.0};
    private double[] e2 = new double[]{0.0, 1.0, 0.0};
    private double[] e3 = new double[]{0.0, 0.0, 1.0};
    private Projection projection = new Projection();
    private Quaternion rotation = new Quaternion(1.0, 0.0, 0.0, 0.0);
    private Mapping mapping = new MappingXYZ();
    private DrawingPanel3D panel;

    public Camera(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
    }

    public void setProjectionMode(int n) {
        this.projectionMode = n;
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize() * 0.01;
        this.panel.cameraChanged(1);
    }

    public final int getProjectionMode() {
        return this.projectionMode;
    }

    public void reset() {
        double[] dArray = this.panel.getCenter();
        if (this.is3dMode()) {
            this.mapping.map(dArray);
        }
        this.focusX = dArray[0];
        this.focusY = dArray[1];
        this.focusZ = dArray[2];
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize();
        this.rotationAngle = 0.0;
        this.cosRot = 1.0;
        this.sinRot = 0.0;
        this.distanceToScreen = 2.5 * this.panelMaxSizeConstant;
        this.distanceToFocus = 2.0 * this.panelMaxSizeConstant;
        this.planarRatio = this.distanceToScreen / this.distanceToFocus;
        this.posX = dArray[0] + this.distanceToFocus;
        this.posY = dArray[1];
        this.posZ = dArray[2];
        this.alpha = 0.0;
        this.cosAlpha = 1.0;
        this.sinAlpha = 0.0;
        this.beta = 0.0;
        this.cosBeta = 1.0;
        this.sinBeta = 0.0;
        this.e1 = new double[]{-1.0, 0.0, 0.0};
        this.e2 = new double[]{0.0, 1.0, 0.0};
        this.e3 = new double[]{0.0, 0.0, 1.0};
        this.panelMaxSizeConstant *= 0.01;
        this.panel.cameraChanged(0);
    }

    public void adjust() {
        double[] dArray = this.panel.getCenter();
        if (this.is3dMode()) {
            this.mapping.map(dArray);
        }
        this.focusX = dArray[0];
        this.focusY = dArray[1];
        this.focusZ = dArray[2];
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize();
        this.distanceToScreen = 2.5 * this.panelMaxSizeConstant;
        this.distanceToFocus = 2.0 * this.panelMaxSizeConstant;
        this.planarRatio = this.distanceToScreen / this.distanceToFocus;
        this.panelMaxSizeConstant *= 0.01;
        this.updateCamera(6);
    }

    public void setMapping(int n) {
        if (this.mapType == n) {
            return;
        }
        this.mapType = n;
        switch (n) {
            default: {
                this.mapping = new MappingXYZ();
                break;
            }
            case 1: {
                this.mapping = new MappingXZY();
                break;
            }
            case 2: {
                this.mapping = new MappingYXZ();
                break;
            }
            case 3: {
                this.mapping = new MappingYZX();
                break;
            }
            case 4: {
                this.mapping = new MappingZXY();
                break;
            }
            case 5: {
                this.mapping = new MappingZYX();
            }
        }
        if (this.panel.getResetCameraOnChanges()) {
            this.adjust();
        }
        this.panel.cameraChanged(7);
    }

    public double[] map(double[] dArray) {
        return this.mapping.map(dArray);
    }

    public double[] inverseMapping(double[] dArray) {
        return this.mapping.inverse(dArray);
    }

    public double[] getQuatMapping() {
        return this.mapping.quatForPrimitives();
    }

    public void setXYZ(double d, double d2, double d3) {
        this.posX = d;
        this.posY = d2;
        this.posZ = d3;
        this.updateCamera(2);
    }

    public void setXYZ(double[] dArray) {
        this.setXYZ(dArray[0], dArray[1], dArray[2]);
    }

    public final double getX() {
        return this.posX;
    }

    public final double getY() {
        return this.posY;
    }

    public final double getZ() {
        return this.posZ;
    }

    public void setFocusXYZ(double d, double d2, double d3) {
        this.focusX = d;
        this.focusY = d2;
        this.focusZ = d3;
        this.updateCamera(3);
    }

    public void setFocusXYZ(double[] dArray) {
        this.setFocusXYZ(dArray[0], dArray[1], dArray[2]);
    }

    public final double getFocusX() {
        return this.focusX;
    }

    public final double getFocusY() {
        return this.focusY;
    }

    public final double getFocusZ() {
        return this.focusZ;
    }

    public final double getDistanceToFocus() {
        return this.distanceToFocus;
    }

    public void setRotation(double d) {
        this.rotationAngle = d;
        this.cosRot = Math.cos(this.rotationAngle / 2.0);
        this.sinRot = Math.sin(this.rotationAngle / 2.0);
        this.updateCamera(4);
    }

    public final double getRotation() {
        return this.rotationAngle;
    }

    public void setDistanceToScreen(double d) {
        this.distanceToScreen = d;
        this.planarRatio = this.distanceToScreen / this.distanceToFocus;
        this.panel.cameraChanged(5);
    }

    public final double getDistanceToScreen() {
        return this.distanceToScreen;
    }

    public void setAzimuth(double d) {
        this.alpha = d;
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.updateCamera(6);
    }

    public final double getAzimuth() {
        return this.alpha;
    }

    public void setAltitude(double d) {
        this.beta = d;
        if (this.beta < -1.5707963267948966) {
            this.beta = -1.5707963267948966;
        } else if (this.beta > 1.5707963267948966) {
            this.beta = 1.5707963267948966;
        }
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.updateCamera(6);
    }

    public final double getAltitude() {
        return this.beta;
    }

    public void setAzimuthAndAltitude(double d, double d2) {
        this.alpha = d;
        this.beta = d2;
        if (this.beta < -1.5707963267948966) {
            this.beta = -1.5707963267948966;
        } else if (this.beta > 1.5707963267948966) {
            this.beta = 1.5707963267948966;
        }
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.updateCamera(6);
    }

    public void copyFrom(Camera camera) {
        this.projectionMode = camera.getProjectionMode();
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize() * 0.01;
        this.posX = camera.getX();
        this.posY = camera.getY();
        this.posZ = camera.getZ();
        this.focusX = camera.getFocusX();
        this.focusY = camera.getFocusY();
        this.focusZ = camera.getFocusZ();
        this.rotationAngle = camera.getRotation();
        this.cosRot = Math.cos(this.rotationAngle / 2.0);
        this.sinRot = Math.sin(this.rotationAngle / 2.0);
        this.distanceToScreen = camera.getDistanceToScreen();
        this.planarRatio = this.distanceToScreen / this.distanceToFocus;
        this.updateCamera(0);
    }

    public final double getCosAlpha() {
        return this.cosAlpha;
    }

    public final double getSinAlpha() {
        return this.sinAlpha;
    }

    public final double getCosBeta() {
        return this.cosBeta;
    }

    public final double getSinBeta() {
        return this.sinBeta;
    }

    private void updateCamera(int n) {
        switch (n) {
            case 2: 
            case 3: {
                this.distanceToFocus = this.computeCameraVectors();
                this.planarRatio = this.distanceToScreen / this.distanceToFocus;
                this.alpha = Math.atan2(-this.e1[1], -this.e1[0]);
                this.beta = Math.atan2(-this.e1[2], Math.abs(this.e1[0]));
                this.cosAlpha = Math.cos(this.alpha);
                this.sinAlpha = Math.sin(this.alpha);
                this.cosBeta = Math.cos(this.beta);
                this.sinBeta = Math.sin(this.beta);
                break;
            }
            case 4: {
                this.computeCameraVectors();
                break;
            }
            case 6: {
                this.posX = this.focusX + this.distanceToFocus * this.cosBeta * this.cosAlpha;
                this.posY = this.focusY + this.distanceToFocus * this.cosBeta * this.sinAlpha;
                this.posZ = this.focusZ + this.distanceToFocus * this.sinBeta;
                this.computeCameraVectors();
                break;
            }
            case 0: {
                this.distanceToFocus = this.computeCameraVectors();
                this.planarRatio = this.distanceToScreen / this.distanceToFocus;
                this.alpha = Math.atan2(-this.e1[1], -this.e1[0]);
                this.beta = Math.atan2(-this.e1[2], Math.abs(this.e1[0]));
                this.cosAlpha = Math.cos(this.alpha);
                this.sinAlpha = Math.sin(this.alpha);
                this.cosBeta = Math.cos(this.beta);
                this.sinBeta = Math.sin(this.beta);
                this.computeCameraVectors();
            }
        }
        this.panel.cameraChanged(n);
    }

    private double computeCameraVectors() {
        this.e1 = new double[]{this.focusX - this.posX, this.focusY - this.posY, this.focusZ - this.posZ};
        double d = VectorMath.magnitude(this.e1);
        int n = 0;
        while (n < this.e1.length) {
            int n2 = n++;
            this.e1[n2] = this.e1[n2] / d;
        }
        this.e2 = VectorMath.cross3D(this.e1, VERTICAL_AXIS);
        double d2 = VectorMath.magnitude(this.e2);
        int n3 = 0;
        while (n3 < this.e2.length) {
            int n4 = n3++;
            this.e2[n4] = this.e2[n4] / d2;
        }
        this.e3 = VectorMath.cross3D(this.e2, this.e1);
        d2 = VectorMath.magnitude(this.e3);
        n3 = 0;
        while (n3 < this.e3.length) {
            int n5 = n3++;
            this.e3[n5] = this.e3[n5] / d2;
        }
        this.rotation.setCoordinates(this.cosRot, this.e1[0] * this.sinRot, this.e1[1] * this.sinRot, this.e1[2] * this.sinRot);
        this.rotation.direct(this.e2);
        this.rotation.direct(this.e3);
        return d;
    }

    public boolean is3dMode() {
        switch (this.projectionMode) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    public double[] projectPosition(double[] dArray) {
        return this.projection.direct(dArray);
    }

    public double[] projectSize(double[] dArray, double[] dArray2) {
        switch (this.projectionMode) {
            case 0: {
                dArray2[0] = dArray2[0] * this.planarRatio;
                return dArray2;
            }
            case 1: {
                dArray2[0] = dArray2[0] * this.planarRatio;
                dArray2[1] = dArray2[2] * this.planarRatio;
                return dArray2;
            }
            case 2: {
                dArray2[0] = dArray2[1] * this.planarRatio;
                dArray2[1] = dArray2[2] * this.planarRatio;
                return dArray2;
            }
            case 3: 
            case 10: {
                this.mapping.map(dArray2);
                dArray2[0] = Math.max(dArray2[0], dArray2[1]);
                dArray2[1] = dArray2[2];
                return dArray2;
            }
        }
        this.mapping.map(dArray);
        this.mapping.map(dArray2);
        double d = (dArray[0] - this.posX) * this.e1[0] + (dArray[1] - this.posY) * this.e1[1] + (dArray[2] - this.posZ) * this.e1[2];
        if (Math.abs(d) < this.panelMaxSizeConstant) {
            d = this.panelMaxSizeConstant;
        }
        d = this.distanceToScreen / d;
        dArray2[0] = Math.max(dArray2[0], dArray2[1]) * d;
        dArray2[1] = dArray2[2] * d;
        return dArray2;
    }

    private class Projection
    implements Transformation {
        private Projection() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }

        public double[] direct(double[] dArray) {
            double d;
            switch (Camera.this.projectionMode) {
                case 0: {
                    dArray[0] = (dArray[0] - Camera.this.focusX) * Camera.this.planarRatio;
                    dArray[1] = (dArray[1] - Camera.this.focusY) * Camera.this.planarRatio;
                    dArray[2] = 1.0 - (dArray[2] - Camera.this.focusZ) / Camera.this.distanceToFocus;
                    return dArray;
                }
                case 1: {
                    double d2 = dArray[1];
                    dArray[0] = (dArray[0] - Camera.this.focusX) * Camera.this.planarRatio;
                    dArray[1] = (dArray[2] - Camera.this.focusZ) * Camera.this.planarRatio;
                    dArray[2] = 1.0 - (d2 - Camera.this.focusY) / Camera.this.distanceToFocus;
                    return dArray;
                }
                case 2: {
                    double d3 = dArray[0];
                    dArray[0] = (dArray[1] - Camera.this.focusY) * Camera.this.planarRatio;
                    dArray[1] = (dArray[2] - Camera.this.focusZ) * Camera.this.planarRatio;
                    dArray[2] = 1.0 - (d3 - Camera.this.focusX) / Camera.this.distanceToFocus;
                    return dArray;
                }
                case 3: 
                case 10: {
                    Camera.this.mapping.map(dArray);
                    dArray[0] = dArray[0] - Camera.this.posX;
                    dArray[1] = dArray[1] - Camera.this.posY;
                    dArray[2] = dArray[2] - Camera.this.posZ;
                    double d4 = VectorMath.dot(dArray, Camera.this.e1);
                    double d5 = VectorMath.dot(dArray, Camera.this.e2);
                    dArray[1] = VectorMath.dot(dArray, Camera.this.e3);
                    dArray[0] = d5;
                    dArray[2] = d4 / Camera.this.distanceToFocus;
                    return dArray;
                }
            }
            Camera.this.mapping.map(dArray);
            dArray[0] = dArray[0] - Camera.this.posX;
            dArray[1] = dArray[1] - Camera.this.posY;
            dArray[2] = dArray[2] - Camera.this.posZ;
            double d6 = d = VectorMath.dot(dArray, Camera.this.e1);
            if (Math.abs(d) < Camera.this.panelMaxSizeConstant) {
                d = Camera.this.panelMaxSizeConstant;
            }
            d = Camera.this.distanceToScreen / d;
            double d7 = VectorMath.dot(dArray, Camera.this.e2) * d;
            dArray[1] = VectorMath.dot(dArray, Camera.this.e3) * d;
            dArray[0] = d7;
            dArray[2] = d6 / Camera.this.distanceToFocus;
            return dArray;
        }

        public double[] inverse(double[] dArray) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

