/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.quantum;

import JSci.maths.Complex;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.MathVector;
import JSci.maths.ModuleMember;
import JSci.maths.RingMember;
import JSci.maths.VectorDimensionException;
import JSci.maths.groups.AbelianGroupMember;
import JSci.physics.quantum.BraVector;
import JSci.physics.quantum.Operator;

public final class KetVector
extends MathVector {
    private ComplexVector representation;

    public KetVector(ComplexVector complexVector) {
        this.representation = complexVector;
    }

    public boolean equals(Object object) {
        return this.representation.equals((Object)((KetVector)((Object)object)).representation);
    }

    public String toString() {
        return this.representation.toString();
    }

    public int hashCode() {
        return this.representation.hashCode();
    }

    public BraVector toBraVector() {
        return new BraVector(this.representation.conjugate());
    }

    public ComplexVector getRepresentation() {
        return this.representation;
    }

    public int dimension() {
        return this.representation.dimension();
    }

    public double norm() {
        return this.representation.norm();
    }

    public AbelianGroupMember negate() {
        return this.representation.negate();
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof KetVector) {
            return this.add((KetVector)abelianGroupMember);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public KetVector add(KetVector ketVector) {
        return new KetVector(this.representation.add(ketVector.representation));
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof KetVector) {
            return this.subtract((KetVector)abelianGroupMember);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public KetVector subtract(KetVector ketVector) {
        return new KetVector(this.representation.subtract(ketVector.representation));
    }

    public ModuleMember scalarMultiply(RingMember ringMember) {
        return this.representation.scalarMultiply(ringMember);
    }

    public Operator multiply(BraVector braVector) {
        int n = this.dimension();
        if (n == braVector.dimension()) {
            ComplexVector complexVector = braVector.getRepresentation();
            Complex[][] complexArray = new Complex[n][n];
            int n2 = 0;
            while (n2 < n) {
                complexArray[n2][0] = this.representation.getComponent(n2).multiply(complexVector.getComponent(0));
                int n3 = 1;
                while (n3 < n) {
                    complexArray[n2][n3] = this.representation.getComponent(n2).multiply(complexVector.getComponent(n3));
                    ++n3;
                }
                ++n2;
            }
            return new Operator(new ComplexSquareMatrix(complexArray));
        }
        throw new VectorDimensionException("Vectors have different dimensions.");
    }
}

