/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.quantum;

import JSci.maths.Complex;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.Member;
import JSci.physics.quantum.KetVector;
import java.io.Serializable;

public class Operator
implements Member,
Serializable {
    protected ComplexSquareMatrix representation;

    public Operator(ComplexSquareMatrix complexSquareMatrix) {
        this.representation = complexSquareMatrix;
    }

    public boolean equals(Object object) {
        return this.representation.equals((Object)((Operator)object).representation);
    }

    public String toString() {
        return this.representation.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.trace().mod());
    }

    public ComplexSquareMatrix getRepresentation() {
        return this.representation;
    }

    public boolean isSelfAdjoint() {
        return this.representation.isHermitian();
    }

    public boolean isUnitary() {
        return this.representation.isUnitary();
    }

    public Complex trace() {
        return this.representation.trace();
    }

    public int dimension() {
        return this.representation.columns();
    }

    public Operator add(Operator operator) {
        return new Operator(this.representation.add(operator.representation));
    }

    public Operator subtract(Operator operator) {
        return new Operator(this.representation.subtract(operator.representation));
    }

    public Operator multiply(Operator operator) {
        return new Operator(this.representation.multiply(operator.representation));
    }

    public KetVector multiply(KetVector ketVector) {
        int n = this.dimension();
        if (n == ketVector.dimension()) {
            ComplexVector complexVector = ketVector.getRepresentation();
            Complex[] complexArray = new Complex[n];
            int n2 = 0;
            while (n2 < n) {
                Complex complex = this.representation.getElement(n2, 0).multiply(complexVector.getComponent(0));
                int n3 = 1;
                while (n3 < n) {
                    complex = complex.add(this.representation.getElement(n2, n3).multiply(complexVector.getComponent(n3)));
                    ++n3;
                }
                complexArray[n2] = complex;
                ++n2;
            }
            return new KetVector(new ComplexVector(complexArray));
        }
        throw new DimensionException("Operator and vector have different dimensions.");
    }
}

