/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.AbstractGraphModel;
import JSci.awt.DataSeries;
import JSci.awt.Graph3DModel;
import java.util.Vector;

public final class DefaultGraph3DModel
extends AbstractGraphModel
implements Graph3DModel {
    private float[] xAxis;
    private float[] yAxis;
    private final Vector series = new Vector();
    private int pos;
    private DataSeries curSeries;

    public void setXAxis(float[] fArray) {
        this.xAxis = fArray;
        this.fireDataChanged();
    }

    public float[] getXAxis() {
        return this.xAxis;
    }

    public void setYAxis(float[] fArray) {
        this.yAxis = fArray;
        this.fireDataChanged();
    }

    public float[] getYAxis() {
        return this.yAxis;
    }

    public void addSeries(float[] fArray) {
        this.series.addElement(new DataSeries(fArray));
        this.fireDataChanged();
    }

    public void changeSeries(int n, float[] fArray) {
        this.series.setElementAt(new DataSeries(fArray), n);
        this.fireDataChanged();
    }

    public void removeSeries(int n) {
        this.series.removeElementAt(n);
        this.fireDataChanged();
    }

    public float[] getSeries(int n) {
        return ((DataSeries)this.series.elementAt(n)).getData();
    }

    public void setSeriesVisible(int n, boolean bl) {
        ((DataSeries)this.series.elementAt(n)).setVisible(bl);
        this.fireDataChanged();
    }

    public float getXCoord(int n) {
        return this.xAxis[n];
    }

    public float getYCoord(int n) {
        return this.yAxis[n];
    }

    public float getZCoord(int n) {
        return this.curSeries.getValueAt(n);
    }

    public int seriesLength() {
        return this.curSeries.length();
    }

    public void firstSeries() {
        this.curSeries = (DataSeries)this.series.elementAt(0);
        this.pos = 0;
        while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1) {
            this.curSeries = (DataSeries)this.series.elementAt(++this.pos);
        }
    }

    public boolean nextSeries() {
        if (this.pos == this.series.size() - 1) {
            return false;
        }
        do {
            this.curSeries = (DataSeries)this.series.elementAt(++this.pos);
        } while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1);
        return this.curSeries.isVisible();
    }
}

