/*
 * Decompiled with CFR 0.152.
 */
package JSci.io;

import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DiscreteSet;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerVector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public final class MathMLDocument
extends DocumentImpl {
    public MathMLDocument() {
        super(null);
        this.appendChild(this.createElement("math"));
    }

    public Element createNumber(double d) {
        Element element = this.createElement("cn");
        element.appendChild(this.createTextNode(String.valueOf(d)));
        return element;
    }

    public Element createNumber(int n) {
        Element element = this.createElement("cn");
        element.setAttribute("type", "integer");
        element.appendChild(this.createTextNode(String.valueOf(n)));
        return element;
    }

    public Element createNumber(Complex complex) {
        Element element = this.createElement("cn");
        element.setAttribute("type", "complex-cartesian");
        element.appendChild(this.createTextNode(String.valueOf(complex.real())));
        element.appendChild(this.createElement("sep"));
        element.appendChild(this.createTextNode(String.valueOf(complex.imag())));
        return element;
    }

    public Element createSymbol(Object object) {
        Element element = this.createElement("ci");
        element.appendChild(this.createTextNode(object.toString()));
        return element;
    }

    public Element createVector(DoubleVector doubleVector) {
        Element element = this.createElement("vector");
        int n = 0;
        while (n < doubleVector.dimension()) {
            element.appendChild(this.createNumber(doubleVector.getComponent(n)));
            ++n;
        }
        return element;
    }

    public Element createVector(IntegerVector integerVector) {
        Element element = this.createElement("vector");
        int n = 0;
        while (n < integerVector.dimension()) {
            element.appendChild(this.createNumber(integerVector.getComponent(n)));
            ++n;
        }
        return element;
    }

    public Element createVector(ComplexVector complexVector) {
        Element element = this.createElement("vector");
        int n = 0;
        while (n < complexVector.dimension()) {
            element.appendChild(this.createNumber(complexVector.getComponent(n)));
            ++n;
        }
        return element;
    }

    public Element createMatrix(DoubleMatrix doubleMatrix) {
        Element element = this.createElement("matrix");
        int n = 0;
        while (n < doubleMatrix.rows()) {
            Element element2 = this.createElement("matrixrow");
            int n2 = 0;
            while (n2 < doubleMatrix.columns()) {
                element2.appendChild(this.createNumber(doubleMatrix.getElement(n, n2)));
                ++n2;
            }
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public Element createMatrix(IntegerMatrix integerMatrix) {
        Element element = this.createElement("matrix");
        int n = 0;
        while (n < integerMatrix.rows()) {
            Element element2 = this.createElement("matrixrow");
            int n2 = 0;
            while (n2 < integerMatrix.columns()) {
                element2.appendChild(this.createNumber(integerMatrix.getElement(n, n2)));
                ++n2;
            }
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public Element createMatrix(ComplexMatrix complexMatrix) {
        Element element = this.createElement("matrix");
        int n = 0;
        while (n < complexMatrix.rows()) {
            Element element2 = this.createElement("matrixrow");
            int n2 = 0;
            while (n2 < complexMatrix.columns()) {
                element2.appendChild(this.createNumber(complexMatrix.getElement(n, n2)));
                ++n2;
            }
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public Element createSet(DiscreteSet discreteSet) {
        Element element = this.createElement("set");
        int n = 0;
        while (n < discreteSet.size()) {
            element.appendChild(this.createSymbol(discreteSet.getElement(n)));
            ++n;
        }
        return element;
    }

    public Element createApply(String string, DocumentFragment documentFragment) {
        Element element = this.createElement("apply");
        element.appendChild(this.createElement(string));
        element.appendChild(documentFragment);
        return element;
    }

    public Element createReln(String string, DocumentFragment documentFragment) {
        Element element = this.createElement("reln");
        element.appendChild(this.createElement(string));
        element.appendChild(documentFragment);
        return element;
    }
}

