/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.Graph3DModel;
import JSci.awt.GraphDataEvent;
import JSci.awt.GraphDataListener;
import JSci.swing.JDoubleBufferedComponent;
import JSci.swing.Matrix3D;
import JSci.swing.Model3D;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public final class JLineGraph3D
extends JDoubleBufferedComponent
implements Runnable,
MouseListener,
MouseMotionListener,
GraphDataListener {
    protected Graph3DModel model;
    private Model3D md;
    private boolean painted = true;
    private float xfac;
    private int prevx;
    private int prevy;
    private float xtheta;
    private float ytheta;
    private float scalefudge = 1.0f;
    private Matrix3D amat = new Matrix3D();
    private Matrix3D tmat = new Matrix3D();
    private String mdname;
    private String message;

    public JLineGraph3D(Graph3DModel graph3DModel) {
        this.amat.yrot(20.0);
        this.amat.xrot(20.0);
        this.setSize(this.getWidth() <= 20 ? 400 : this.getWidth(), this.getHeight() <= 20 ? 400 : this.getHeight());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setModel(graph3DModel);
    }

    public void setModel(Graph3DModel graph3DModel) {
        if (this.model != null) {
            this.model.removeGraphDataListener(this);
        }
        this.model = graph3DModel;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        this.md = new Model3D();
        this.model.firstSeries();
        int n = 0;
        while (n < this.model.seriesLength()) {
            this.md.addVert(this.model.getXCoord(n), this.model.getYCoord(n), this.model.getZCoord(n));
            ++n;
        }
        int n2 = 1;
        while (n2 < this.model.seriesLength()) {
            this.md.add(n2 - 1, n2);
            ++n2;
        }
        this.redraw();
        new Thread(this).start();
    }

    public void run() {
        try {
            float f;
            float f2;
            this.md.findBB();
            this.md.compress();
            float f3 = this.md.xmax - this.md.xmin;
            float f4 = this.md.ymax - this.md.ymin;
            float f5 = this.md.zmax - this.md.zmin;
            if (f4 > f3) {
                f3 = f4;
            }
            if (f5 > f3) {
                f3 = f5;
            }
            this.xfac = 0.7f * ((f2 = (float)this.getWidth() / f3) < (f = (float)this.getHeight() / f3) ? f2 : f) * this.scalefudge;
        }
        catch (Exception exception) {
            this.md = null;
            this.message = exception.toString();
            exception.printStackTrace();
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.prevx = mouseEvent.getX();
        this.prevy = mouseEvent.getY();
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        float f;
        float f2;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 4) != 0) {
            float f3;
            float f4;
            if (this.prevy == n2) {
                return;
            }
            this.scalefudge += (float)(this.prevy - n2) / (float)this.getWidth();
            if (this.scalefudge == 0.0f) {
                this.scalefudge = 0.1f;
            }
            f2 = this.md.xmax - this.md.xmin;
            f = this.md.ymax - this.md.ymin;
            float f5 = this.md.zmax - this.md.zmin;
            if (f > f2) {
                f2 = f;
            }
            if (f5 > f2) {
                f2 = f5;
            }
            this.xfac = 0.7f * ((f4 = (float)this.getWidth() / f2) < (f3 = (float)this.getHeight() / f2) ? f4 : f3) * this.scalefudge;
        }
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.tmat.unit();
            f2 = (float)(this.prevy - n2) * 360.0f / (float)this.getWidth();
            f = (float)(n - this.prevx) * 360.0f / (float)this.getHeight();
            this.tmat.xrot(f2);
            this.tmat.yrot(f);
            this.amat.mult(this.tmat);
        }
        if (this.painted) {
            this.painted = false;
            this.redraw();
        }
        this.prevx = n;
        this.prevy = n2;
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected void offscreenPaint(Graphics graphics) {
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.translate(-(this.md.xmin + this.md.xmax) / 2.0f, -(this.md.ymin + this.md.ymax) / 2.0f, -(this.md.zmin + this.md.zmax) / 2.0f);
            this.md.mat.mult(this.amat);
            this.md.mat.scale(this.xfac, -this.xfac, 16.0f * this.xfac / (float)this.getWidth());
            this.md.mat.translate(this.getWidth() / 2, this.getHeight() / 2, 8.0f);
            this.md.transformed = false;
            this.md.paint(graphics);
            this.setPainted();
            return;
        }
        if (this.message != null) {
            graphics.drawString("Error in model:", 3, 20);
            graphics.drawString(this.message, 10, 40);
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(400, 400);
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }
}

