/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.DoubleBufferedCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public final class ContourPlot
extends DoubleBufferedCanvas {
    private float[][] data;
    private double min;
    private double max;
    private int deltay;
    private int[] deltax;
    private float c1 = 1.0f;
    private float c2 = 1.0f;
    private float c3 = 1.0f;
    private int Contourx = 1;
    private int Contoury = 1;
    private int largeurMax;
    private int hauteurMax;

    public ContourPlot(double[][] dArray) {
        this.setBackground(Color.white);
        this.setData(dArray);
        this.setContourX(1);
        this.setContourY(1);
    }

    public void setData(double[][] dArray) {
        int n;
        double[][] dArray2 = new double[dArray.length][];
        int n2 = 0;
        while (n2 < dArray2.length) {
            dArray2[n2] = dArray[dArray2.length - n2 - 1];
            ++n2;
        }
        this.min = dArray2[0][0];
        this.max = dArray2[0][0];
        this.data = new float[dArray2.length][];
        int n3 = 0;
        while (n3 < dArray2.length) {
            this.data[n3] = new float[dArray2[n3].length];
            n = 0;
            while (n < dArray2[n3].length) {
                if (dArray2[n3][n] > this.max) {
                    this.max = dArray2[n3][n];
                }
                if (dArray2[n3][n] < this.min) {
                    this.min = dArray2[n3][n];
                }
                ++n;
            }
            ++n3;
        }
        if (this.max == this.min) {
            n = 0;
            while (n < dArray2.length) {
                int n4 = 0;
                while (n4 < dArray2[n].length) {
                    this.data[n][n4] = 1.0f;
                    ++n4;
                }
                ++n;
            }
        } else {
            int n5 = 0;
            while (n5 < dArray2.length) {
                int n6 = 0;
                while (n6 < dArray2[n5].length) {
                    Double d = new Double(1.0 - (dArray2[n5][n6] - this.min) / (this.max - this.min));
                    this.data[n5][n6] = d.floatValue();
                    ++n6;
                }
                ++n5;
            }
        }
        this.rescale();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n = this.data[0].length;
        int n2 = 1;
        while (n2 < this.data.length) {
            if (this.data[n2].length > n) {
                n = this.data[n2].length;
            }
            ++n2;
        }
        return new Dimension(n + 2 * this.Contourx, this.data.length + 2 * this.Contoury);
    }

    public void setContourX(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be greater than 1 : " + n + " < 1");
        }
        this.Contourx = n;
    }

    public void setContourY(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be greater than 1 : " + n + " < 1");
        }
        this.Contoury = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    private void rescale() {
        Dimension dimension = this.getSize();
        int n = dimension.width - 2 * this.Contourx;
        int n2 = dimension.height - 2 * this.Contoury;
        this.deltay = (int)Math.floor(n2 / this.data.length);
        this.hauteurMax = this.deltay * this.data.length;
        this.deltax = new int[this.data.length];
        this.largeurMax = 0;
        int n3 = 0;
        while (n3 < this.data.length) {
            this.deltax[n3] = (int)Math.floor(n / this.data[n3].length);
            if (this.data[n3].length * this.deltax[n3] > this.largeurMax) {
                this.largeurMax = this.data[n3].length * this.deltax[n3];
            }
            ++n3;
        }
        this.redraw();
    }

    public void setColor(float f, float f2, float f3) {
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f) {
            throw new IllegalArgumentException("Incorrect parameters : " + f + ", " + f2 + ", " + f3);
        }
        if (f + f2 + f3 == 0.0f) {
            throw new IllegalArgumentException("You have chosen black at the specified color. This would generate a completly black graph. Please choose another color.");
        }
        this.c1 = f;
        this.c2 = f2;
        this.c3 = f3;
    }

    protected void offscreenPaint(Graphics graphics) {
        graphics.setColor(new Color(1.0f - this.c1, 1.0f - this.c2, 1.0f - this.c3));
        graphics.drawRect(this.Contourx - 1, this.Contoury - 1, this.largeurMax, this.hauteurMax);
        graphics.setClip(this.Contourx, this.Contoury, this.largeurMax - 1, this.hauteurMax - 1);
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (n2 < this.data[n].length) {
                graphics.setColor(Color.getHSBColor(this.data[n][n2], 1.0f, 1.0f));
                graphics.fillRect(n2 * this.deltax[n] + this.Contourx, n * this.deltay + this.Contoury, (n2 + 1) * this.deltax[n] + this.Contourx, (n + 1) * this.deltay + this.Contoury);
                ++n2;
            }
            ++n;
        }
    }
}

