/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.Graph2D;
import JSci.awt.Graph2DModel;
import JSci.awt.GraphDataEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public class LineGraph
extends Graph2D {
    private Color[] lineColor = new Color[]{Color.black, Color.blue, Color.green, Color.red, Color.yellow, Color.cyan, Color.lightGray, Color.magenta, Color.orange, Color.pink};

    public LineGraph(Graph2DModel graph2DModel) {
        super(graph2DModel);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        float f;
        this.maxY = 0.0f;
        this.minY = 0.0f;
        this.maxX = 0.0f;
        this.minX = 0.0f;
        this.model.firstSeries();
        int n = 0;
        while (n < this.model.seriesLength()) {
            float f2 = this.model.getXCoord(n);
            if (f2 > this.maxX) {
                this.maxX = f2;
            } else if (f2 < this.minX) {
                this.minX = f2;
            }
            f = this.model.getYCoord(n);
            if (f > this.maxY) {
                this.maxY = f;
            } else if (f < this.minY) {
                this.minY = f;
            }
            ++n;
        }
        int n2 = 1;
        while (this.model.nextSeries()) {
            n = 0;
            while (n < this.model.seriesLength()) {
                f = this.model.getYCoord(n);
                if (f > this.maxY) {
                    this.maxY = f;
                } else if (f < this.minY) {
                    this.minY = f;
                }
                ++n;
            }
            ++n2;
        }
        if (this.maxY == this.minY) {
            this.maxY = 1.0f;
        }
        if (n2 > this.lineColor.length) {
            Color[] colorArray = this.lineColor;
            this.lineColor = new Color[n2];
            System.arraycopy(colorArray, 0, this.lineColor, 0, colorArray.length);
            n = colorArray.length;
            while (n < n2) {
                this.lineColor[n] = this.lineColor[n - colorArray.length];
                ++n;
            }
        }
        this.rescale();
    }

    public void setColor(int n, Color color) {
        this.lineColor[n] = color;
    }

    public void setYExtrema(float f, float f2) {
        if (f2 < f) {
            throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + f2 + " and min = " + f);
        }
        this.minY = f;
        this.maxY = f2;
        this.rescale();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(250, 250);
    }

    protected void offscreenPaint(Graphics graphics) {
        Point point;
        this.drawAxes(graphics);
        this.model.firstSeries();
        graphics.setColor(this.lineColor[0]);
        Point point2 = this.dataToScreen(this.model.getXCoord(0), this.model.getYCoord(0));
        int n = 1;
        while (n < this.model.seriesLength()) {
            point = this.dataToScreen(this.model.getXCoord(n), this.model.getYCoord(n));
            graphics.drawLine(point2.x, point2.y, point.x, point.y);
            point2 = point;
            ++n;
        }
        int n2 = 1;
        while (this.model.nextSeries()) {
            graphics.setColor(this.lineColor[n2]);
            point2 = this.dataToScreen(this.model.getXCoord(0), this.model.getYCoord(0));
            n = 1;
            while (n < this.model.seriesLength()) {
                point = this.dataToScreen(this.model.getXCoord(n), this.model.getYCoord(n));
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
                point2 = point;
                ++n;
            }
            ++n2;
        }
    }
}

