/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.CategoryGraph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.swing.JCategoryGraph2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class JPieChart
extends JCategoryGraph2D {
    private float pieTotal;
    private Color[] sliceColor = new Color[]{Color.blue, Color.green, Color.red, Color.yellow, Color.cyan, Color.lightGray, Color.magenta, Color.orange, Color.pink};
    private final int borderPad = 30;

    public JPieChart(CategoryGraph2DModel categoryGraph2DModel) {
        super(categoryGraph2DModel);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        this.model.firstSeries();
        int n = this.model.seriesLength();
        this.pieTotal = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            this.pieTotal += this.model.getValue(n2);
            ++n2;
        }
        if (n > this.sliceColor.length) {
            Color[] colorArray = this.sliceColor;
            this.sliceColor = new Color[n];
            System.arraycopy(colorArray, 0, this.sliceColor, 0, colorArray.length);
            int n3 = colorArray.length;
            while (n3 < this.sliceColor.length) {
                this.sliceColor[n3] = this.sliceColor[n3 - colorArray.length];
                ++n3;
            }
        }
        this.rescale();
    }

    public void setColor(int n, Color color) {
        this.sliceColor[n] = color;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(250, 250);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    private void rescale() {
        this.redraw();
    }

    protected void offscreenPaint(Graphics graphics) {
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        int n3 = 2 * (n - 30);
        int n4 = 2 * (n2 - 30);
        double d = 0.4 * (double)n3;
        double d2 = 0.4 * (double)n4;
        int n5 = 0;
        this.model.firstSeries();
        int n6 = 0;
        while (n6 < this.model.seriesLength() - 1) {
            graphics.setColor(this.sliceColor[n6]);
            int n7 = Math.round(this.model.getValue(n6) * 360.0f / this.pieTotal);
            graphics.fillArc(30, 30, n3, n4, n5, n7);
            n5 += n7;
            ++n6;
        }
        graphics.setColor(this.sliceColor[n6]);
        graphics.fillArc(30, 30, n3, n4, n5, 360 - n5);
        int n8 = graphics.getFontMetrics().getHeight() / 2;
        double d3 = 0.0;
        graphics.setColor(Color.black);
        n6 = 0;
        while (n6 < this.model.seriesLength()) {
            double d4 = (double)this.model.getValue(n6) * Math.PI / (double)this.pieTotal;
            int n9 = graphics.getFontMetrics().stringWidth(this.model.getCategory(n6)) / 2;
            graphics.drawString(this.model.getCategory(n6), n - n9 + (int)(d * Math.cos(d3 += d4)), n2 + n8 - (int)(d2 * Math.sin(d3)));
            d3 += d4;
            ++n6;
        }
    }
}

