/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.AbstractMath;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;

public final class Cascades
extends AbstractMath {
    private Cascades() {
    }

    public static int previousDimension(int n, int n2) {
        int n3 = (int)Math.round((double)(n2 + n) / 2.0);
        if (2 * n3 - n == n2) {
            return n3;
        }
        if (2L * Math.round((double)n2 / 2.0) == (long)n2) {
            throw new IllegalScalingException("Odd number of values into an even filter! Change the number of values/iterations: " + n2);
        }
        throw new IllegalScalingException("Even number of values into an odd filter! Change the number of values/iterations: " + n2);
    }

    public static double[] evalScaling(Filter filter, int n, int n2, int n3) {
        if (n2 > 20) {
            throw new IllegalArgumentException("Too many iterations : " + n2);
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Must have a positive number of scaling functions : " + n + " < 0.");
        }
        double[] dArray = new double[n];
        if (n3 >= dArray.length || n3 < 0) {
            throw new IllegalArgumentException("There are " + dArray.length + " scaling functions going from 0 to " + (dArray.length - 1) + " and you are trying to get the " + n3 + "th function.");
        }
        dArray[n3] = 1.0;
        return Cascades.evaluation(filter, n2, dArray);
    }

    public static double[] evalWavelet(Filter filter, int n, int n2, int n3, int n4) {
        if (n3 > 20) {
            throw new IllegalArgumentException("Too many iterations : " + n3);
        }
        if (n2 - n <= 0) {
            throw new IllegalArgumentException("With " + n2 + " scaling functions and a filter of type " + n + ", you are left with no wavelets. Please change the number of scaling functions, the multiresolution or the number of iterations");
        }
        double[] dArray = new double[n2 - n];
        if (n4 >= dArray.length || n4 < 0) {
            throw new IllegalArgumentException("There are " + dArray.length + " wavelets going from 0 to " + (dArray.length - 1) + " and you are trying to get to the " + n4 + "th wavelet.");
        }
        dArray[n4] = 1.0;
        double[] dArray2 = filter.highpass(dArray);
        return Cascades.evaluation(filter, n3, dArray2);
    }

    public static double[] evalWavelet(Filter filter, int n, int n2, int n3) {
        return Cascades.evalWavelet(filter, 1, n, n2, n3);
    }

    public static double[] evalWaveletHaar(Filter filter, int n, int n2, int n3) {
        return Cascades.evalWavelet(filter, 0, n, n2, n3);
    }

    public static double[] evalWaveletQuadratic(Filter filter, int n, int n2, int n3) {
        return Cascades.evalWavelet(filter, 2, n, n2, n3);
    }

    public static int PowerOf2(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("This parametre must be positive : " + n + " < 0");
        }
        int n2 = 1;
        int n3 = n;
        while (n3 > 0) {
            n2 *= 2;
            --n3;
        }
        return n2;
    }

    public static double[] oversample(double[] dArray) {
        double[] dArray2 = new double[2 * dArray.length - 1];
        int n = 0;
        while (n < dArray.length - 1) {
            dArray2[2 * n] = dArray[n];
            ++n;
        }
        dArray2[2 * dArray.length - 2] = dArray[dArray.length - 1];
        return dArray2;
    }

    public static double[] doublesample(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[2 * n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[2 * n2 + 1] = dArray[n2];
            ++n2;
        }
        return dArray2;
    }

    public static double[] supersample(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[2 * n + 1];
        int n2 = 0;
        while (n2 < n) {
            dArray2[2 * n2 + 1] = dArray[n2];
            ++n2;
        }
        return dArray2;
    }

    public static double[] quadraticOversample(double[] dArray) {
        double[] dArray2 = new double[2 * dArray.length - 2];
        dArray2[0] = dArray[0];
        dArray2[dArray2.length - 1] = dArray[dArray.length - 1];
        int n = 1;
        while (n < dArray.length - 1) {
            dArray2[2 * n - 1] = dArray[n];
            ++n;
        }
        return dArray2;
    }

    public static int dimension(int n, int n2, int n3) {
        return Cascades.PowerOf2(n2) * (n - n3) + n3;
    }

    public static int dimension(int n, int n2) {
        return Cascades.PowerOf2(n2) * (n - 1) + 1;
    }

    public static int dimensionHaar(int n, int n2) {
        return Cascades.PowerOf2(n2) * n;
    }

    public static double[] evaluation(Filter filter, int n, double[] dArray) {
        if (n < 0) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + " < 0 ");
        }
        if (n > 20) {
            throw new IllegalArgumentException("Excessive number of iterations: " + n);
        }
        double[] dArray2 = dArray;
        int n2 = 0;
        while (n2 < n) {
            dArray2 = filter.lowpass(dArray2);
            ++n2;
        }
        return dArray2;
    }
}

