/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.DoubleSparseVector;
import JSci.maths.DoubleVector;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Cosine;
import JSci.maths.wavelet.DiscreteFunction;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.Sine;
import JSci.maths.wavelet.SparseDiscreteFunction;
import JSci.maths.wavelet.splines.LinearSpline;
import JSci.maths.wavelet.splines.PiecewiseConstant;
import JSci.maths.wavelet.splines.SumOfDiracs;

public final class DiscreteHilbertSpace {
    public static int maxiter = 20;

    private DiscreteHilbertSpace() {
    }

    public static double[] add(MultiscaleFunction multiscaleFunction, double d, MultiscaleFunction multiscaleFunction2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(multiscaleFunction, multiscaleFunction2, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        double[] dArray = ArrayMath.scalarMultiply((double)Cascades.PowerOf2(n2 + n), (double[])multiscaleFunction.evaluate(n3 + n));
        double[] dArray2 = ArrayMath.scalarMultiply((double)Cascades.PowerOf2(n3 + n), (double[])multiscaleFunction2.evaluate(n2 + n));
        double[] dArray3 = ArrayMath.scalarMultiply((double)d, (double[])dArray2);
        return ArrayMath.add((double[])dArray, (double[])dArray3);
    }

    public static DoubleSparseVector add(SparseDiscreteFunction sparseDiscreteFunction, double d, MultiscaleFunction multiscaleFunction, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(sparseDiscreteFunction, multiscaleFunction, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        DoubleSparseVector doubleSparseVector = (DoubleSparseVector)sparseDiscreteFunction.Data.scalarMultiply((double)Cascades.PowerOf2(n2 + n));
        double[] dArray = ArrayMath.scalarMultiply((double)Cascades.PowerOf2(n3 + n), (double[])multiscaleFunction.evaluate(n2 + n));
        double[] dArray2 = ArrayMath.scalarMultiply((double)d, (double[])dArray);
        return doubleSparseVector.add(new DoubleSparseVector(dArray2));
    }

    public static DoubleSparseVector add(MultiscaleFunction multiscaleFunction, double d, SparseDiscreteFunction sparseDiscreteFunction, int n) {
        return DiscreteHilbertSpace.add(sparseDiscreteFunction, d, multiscaleFunction, n);
    }

    public static double[] add(DiscreteFunction discreteFunction, double d, DiscreteFunction discreteFunction2) {
        Object object;
        Object object2;
        if (discreteFunction2 instanceof SparseDiscreteFunction && discreteFunction instanceof SparseDiscreteFunction) {
            object2 = (SparseDiscreteFunction)discreteFunction;
            object = (SparseDiscreteFunction)discreteFunction2;
            ((SparseDiscreteFunction)object).Data.scalarProduct(new DoubleVector(((SparseDiscreteFunction)object2).evaluate()));
        }
        if (discreteFunction2 instanceof SparseDiscreteFunction) {
            object2 = (SparseDiscreteFunction)discreteFunction2;
            if (discreteFunction instanceof SparseDiscreteFunction) {
                object = (SparseDiscreteFunction)discreteFunction;
                ((SparseDiscreteFunction)object2).Data.scalarProduct(new DoubleVector(((SparseDiscreteFunction)object).evaluate()));
            }
            ((SparseDiscreteFunction)object2).Data.scalarProduct(new DoubleVector(discreteFunction.evaluate()));
        }
        if (discreteFunction instanceof SparseDiscreteFunction) {
            object2 = (SparseDiscreteFunction)discreteFunction;
            if (discreteFunction2 instanceof SparseDiscreteFunction) {
                object = (SparseDiscreteFunction)discreteFunction2;
                ((SparseDiscreteFunction)object).Data.scalarProduct(new DoubleVector(((SparseDiscreteFunction)object2).evaluate()));
            }
            ((SparseDiscreteFunction)object2).Data.scalarProduct(new DoubleVector(discreteFunction2.evaluate()));
        }
        object2 = discreteFunction.evaluate();
        object = discreteFunction2.evaluate(0);
        double[] dArray = ArrayMath.scalarMultiply((double)d, (double[])object);
        return ArrayMath.add((double[])object2, (double[])dArray);
    }

    public static DoubleSparseVector add(SparseDiscreteFunction sparseDiscreteFunction, double d, SparseDiscreteFunction sparseDiscreteFunction2) {
        DoubleSparseVector doubleSparseVector = (DoubleSparseVector)sparseDiscreteFunction2.Data.scalarMultiply(d);
        return doubleSparseVector.add(sparseDiscreteFunction.Data);
    }

    public static DoubleSparseVector add(DiscreteFunction discreteFunction, double d, SparseDiscreteFunction sparseDiscreteFunction) {
        SparseDiscreteFunction sparseDiscreteFunction2;
        if (discreteFunction instanceof SparseDiscreteFunction) {
            sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
            sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
        }
        sparseDiscreteFunction2 = (DoubleSparseVector)sparseDiscreteFunction.Data.scalarMultiply(d);
        return sparseDiscreteFunction2.add(new DoubleSparseVector(discreteFunction.evaluate()));
    }

    public static DoubleSparseVector add(SparseDiscreteFunction sparseDiscreteFunction, double d, DiscreteFunction discreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction.evaluate()));
        }
        return DiscreteHilbertSpace.add(discreteFunction, d, sparseDiscreteFunction);
    }

    public static double integrate(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2, int n, double d, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(multiscaleFunction, multiscaleFunction2, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        double d3 = DiscreteHilbertSpace.integrate(multiscaleFunction, multiscaleFunction2, n, n2, n3);
        double d4 = d3 * Math.abs(d2 - d);
        return d4;
    }

    public static double integrate(DiscreteFunction discreteFunction, DiscreteFunction discreteFunction2) {
        SparseDiscreteFunction sparseDiscreteFunction;
        SparseDiscreteFunction sparseDiscreteFunction2;
        if (discreteFunction instanceof SparseDiscreteFunction && discreteFunction2 instanceof SparseDiscreteFunction) {
            sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
            sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction2;
            sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
        }
        if (discreteFunction instanceof SparseDiscreteFunction) {
            sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
            if (discreteFunction2 instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction2;
                sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
            }
            sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(discreteFunction2.evaluate()));
        }
        if (discreteFunction2 instanceof SparseDiscreteFunction) {
            sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction2;
            if (discreteFunction instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction;
                sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction.evaluate()));
            }
            sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(discreteFunction.evaluate()));
        }
        return ArrayMath.scalarProduct((double[])discreteFunction.evaluate(), (double[])discreteFunction2.evaluate());
    }

    public static double integrate(SparseDiscreteFunction sparseDiscreteFunction, DiscreteFunction discreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            SparseDiscreteFunction sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
            sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction.evaluate()));
        }
        return sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(discreteFunction.evaluate()));
    }

    public static double integrate(DiscreteFunction discreteFunction, SparseDiscreteFunction sparseDiscreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            SparseDiscreteFunction sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
            sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
        }
        return sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(discreteFunction.evaluate()));
    }

    public static double integrate(SparseDiscreteFunction sparseDiscreteFunction, SparseDiscreteFunction sparseDiscreteFunction2) {
        return sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction.evaluate()));
    }

    public static double integrate(Cosine cosine, DiscreteFunction discreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            SparseDiscreteFunction sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction;
            sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(cosine.evaluate()));
        }
        return ArrayMath.scalarProduct((double[])cosine.evaluate(), (double[])discreteFunction.evaluate());
    }

    public static double integrate(Sine sine, DiscreteFunction discreteFunction) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            SparseDiscreteFunction sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction;
            sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sine.evaluate()));
        }
        return ArrayMath.scalarProduct((double[])sine.evaluate(), (double[])discreteFunction.evaluate());
    }

    public static double integrate(DiscreteFunction discreteFunction, Sine sine) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            SparseDiscreteFunction sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction;
            sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sine.evaluate()));
        }
        return ArrayMath.scalarProduct((double[])discreteFunction.evaluate(), (double[])sine.evaluate());
    }

    public static double integrate(DiscreteFunction discreteFunction, Cosine cosine) {
        if (discreteFunction instanceof SparseDiscreteFunction) {
            SparseDiscreteFunction sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction;
            sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(cosine.evaluate()));
        }
        return ArrayMath.scalarProduct((double[])discreteFunction.evaluate(), (double[])cosine.evaluate());
    }

    public static double integrate(Cosine cosine, SparseDiscreteFunction sparseDiscreteFunction) {
        return sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(cosine.evaluate()));
    }

    public static double integrate(Sine sine, SparseDiscreteFunction sparseDiscreteFunction) {
        return sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sine.evaluate()));
    }

    public static double integrate(SparseDiscreteFunction sparseDiscreteFunction, Sine sine) {
        return sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sine.evaluate()));
    }

    public static double integrate(SparseDiscreteFunction sparseDiscreteFunction, Cosine cosine) {
        return sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(cosine.evaluate()));
    }

    public static double integrate(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(multiscaleFunction, multiscaleFunction2, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        return DiscreteHilbertSpace.integrate(multiscaleFunction, multiscaleFunction2, n, n2, n3);
    }

    private static double integrate(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2, int n, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        double d = ArrayMath.scalarProduct((double[])multiscaleFunction.evaluate(n3 + n), (double[])multiscaleFunction2.evaluate(n2 + n));
        int n4 = Cascades.PowerOf2(Math.min(n3, n2) + n);
        return d / (double)n4;
    }

    public static double integrate(PiecewiseConstant piecewiseConstant, MultiscaleFunction multiscaleFunction, int n, double d, double d2) {
        double d3;
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        LinearSpline linearSpline = new LinearSpline(new double[piecewiseConstant.dimension(0) + 1]);
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(linearSpline, multiscaleFunction, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        double[] dArray = piecewiseConstant.evaluate(n2);
        double[] dArray2 = multiscaleFunction.evaluate(n3 + n);
        int n4 = (int)Math.round((double)(dArray2.length - 1) / (double)dArray.length);
        double d4 = 0.0;
        int n5 = 0;
        while (n5 < dArray.length) {
            d3 = 0.0;
            int n6 = n4 * n5;
            while (n6 <= n4 * (n5 + 1)) {
                d3 += dArray2[n6] / (double)(n4 + 1);
                ++n6;
            }
            d4 += d3 * dArray[n5];
            ++n5;
        }
        d3 = d4 * Math.abs(d2 - d);
        return d3;
    }

    public static double integrate(PiecewiseConstant piecewiseConstant, MultiscaleFunction multiscaleFunction, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        return DiscreteHilbertSpace.integrate(piecewiseConstant, multiscaleFunction, n, 0.0, 1.0);
    }

    public static double integrate(SumOfDiracs sumOfDiracs, MultiscaleFunction multiscaleFunction, int n, double d, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        return DiscreteHilbertSpace.integrate(sumOfDiracs, multiscaleFunction, n);
    }

    public static double integrate(SumOfDiracs sumOfDiracs, MultiscaleFunction multiscaleFunction, int n) {
        double[] dArray;
        if (n < 0) {
            throw new IllegalArgumentException("The precision parameter must be positive : " + n);
        }
        if (n > maxiter) {
            throw new IllegalArgumentException("Too many iterations : " + n);
        }
        int[] nArray = DiscreteHilbertSpace.getScalingCoefficients(sumOfDiracs, multiscaleFunction, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        double[] dArray2 = sumOfDiracs.evaluate(n3 + n);
        if (dArray2.length == (dArray = multiscaleFunction.evaluate(n2 + n)).length) {
            return ArrayMath.scalarProduct((double[])dArray2, (double[])dArray);
        }
        throw new IllegalArgumentException("This type of integration is not handled by this class. Please use 0 as the precision parameter: " + n + " != 0");
    }

    public static double integrate(SumOfDiracs sumOfDiracs, double[] dArray) {
        if (sumOfDiracs.dimension() != dArray.length) {
            throw new IllegalArgumentException("Can only integrate if the number of knots is the same: " + sumOfDiracs.dimension() + ", " + dArray.length);
        }
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += sumOfDiracs.getValue(n) * dArray[n];
            ++n;
        }
        return d;
    }

    public static int[] getScalingCoefficients(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2, int n) {
        int[] nArray = new int[2];
        nArray[0] = 0;
        while (multiscaleFunction.dimension(n) > multiscaleFunction2.dimension(nArray[0] + n)) {
            if (multiscaleFunction.dimension(n) < multiscaleFunction2.dimension(nArray[0] + n) || nArray[0] > maxiter) {
                throw new IllegalArgumentException("The objects are incompatible and cannot be integrated according to this class (1) : " + multiscaleFunction.dimension(n) + ", " + multiscaleFunction2.dimension(n) + " : " + nArray[0] + "\nYou might have to write you own method.");
            }
            nArray[0] = nArray[0] + 1;
        }
        nArray[1] = 0;
        while (multiscaleFunction.dimension(nArray[1] + n) < multiscaleFunction2.dimension(n + nArray[0])) {
            if (multiscaleFunction.dimension(n + nArray[1]) > multiscaleFunction2.dimension(nArray[0] + n) || nArray[1] > maxiter) {
                throw new IllegalArgumentException("The objects are incompatible and cannot be integrated according to this class (2)  : " + multiscaleFunction.dimension(n) + ", " + multiscaleFunction2.dimension(n) + " : " + nArray[1] + "\nYou might have to write you own method.");
            }
            nArray[1] = nArray[1] + 1;
        }
        if (multiscaleFunction.dimension(nArray[1] + n) != multiscaleFunction2.dimension(nArray[0] + n)) {
            throw new IllegalArgumentException("The objects are incompatible and cannot be integrated according to this class (?) :" + multiscaleFunction.dimension(n) + ", " + multiscaleFunction2.dimension(n) + " : " + nArray[0] + " " + nArray[1] + "\nYou might have to write you own method.");
        }
        return nArray;
    }
}

